;#############################
;#MOVEPLAYER
;#Advance player through the board
;#############################
movePlayer:
    call randomNumber
    push hl
    ld a,l
    add a,h
    ld l,a
    ld h,0
    call dispNumber
    pop hl
    ld a,l
    add a,h
    ld b,a
mP_loop:
    push bc
    call retrievePlayerBrush
    inc hl                  ;first byte is the sprite# byte
    ld a,(hl)
    rra                     ;check if bit 0=1 (%00000001)
    jr nc,mP_skip
    inc hl
    ld a,(hl)
    ld (playerDir),a
mP_skip:
playerDir = $+1
    ld a,0
    ld hl,mP_return
    push hl
    or a
    jr z,movePlayerLeft
    dec a
    jr z,movePlayerUp
    dec a
    jr z,movePlayerRight
    dec a
    jp z,movePlayerDown
mP_return:
    pop bc
    djnz mP_loop
    ret

movePlayerLeft:
    ld a,HRZ_SCROLL         ;when to scroll the map with the player
    ld (mPL_adjustCP),a     ;really ugly way to solve the problem, but it'll have to do for now
    ld hl,playerX
    dec (hl)
    ld b,8
mPL_loop:
    ld hl,playerXOff
    ld a,(hl)
    sub 2
    and $0F
    ld (hl),a

    ld hl,xCoord
    ld a,(playerX)
    sub (hl)
mPL_adjustCP = $+1
    cp HRZ_SCROLL
    push bc
        call c,mapLeft

        call drawMap
        call drawPlayer
        call drawGBuf
    pop bc
    djnz mPL_loop
    ret

movePlayerUp:
    ld a,VERT_SCROLL
    ld (mPU_adjustCP),a     ;really ugly way to solve the problem, but it'll have to do for now
    ld hl,playerY
    dec (hl)
    ld b,8
mPU_loop:
    ld hl,playerYOff
    ld a,(hl)
    sub 2
    and $0F
    ld (hl),a

    ld hl,yCoord
    ld a,(playerY)
    sub (hl)
mPU_adjustCP = $+1
    cp VERT_SCROLL
    push bc
        call c,mapUp

        call drawMap
        call drawPlayer
        call drawGBuf
    pop bc
    djnz mPU_loop
    ret

movePlayerRight:
    ld b,8
mPR_loop:
    ld hl,xCoord
    ld a,(playerX)
    sub (hl)
    cp (COLUMNS_TO_DRAW-2)-HRZ_SCROLL
    push bc
        call nc,mapRight
        ld hl,playerXOff
        ld a,(hl)
        add a,2
        and $0F
        ld (hl),a
        jr nz,$+6
            ld hl,playerX
            inc (hl)
        call drawMap
        call drawPlayer
        call drawGBuf
    pop bc
    djnz mPR_loop
    ret

movePlayerDown:
    ld b,8
mPD_loop:
    ld hl,yCoord
    ld a,(playerY)
    sub (hl)
    cp 3-VERT_SCROLL
    push bc
        call nc,mapDown
    ld hl,playerYOff
    ld a,(hl)
    add a,2
    and $0F
    ld (hl),a
    jr nz,$+6
        ld hl,playerY
        inc (hl)

        call drawMap
        call drawPlayer
        call drawGBuf
    pop bc
    djnz mPD_loop
    ret

;##################
;#RANDOMNUMBER
;#Returns a random number between
;# 1 and 6
;#input: none
;#output: b = "random" number
;##################
randomNumber:
    ld l,2
rN_loop:
    ld h,b
seed = $+1
    ld  b,0         ;the "seed"
    ld  a,r         ;our random number base
    add a,b
    inc a           ;just playing with the number
    ld  (seed),a  ;update the seed
    ld b,0          ;255/6 = 42.xx, so we round up.
    sub 43          ;Basically, we are dividing the number by 6 and storing the result in b.
    inc b           ;inc e every time we subtract 43 from a. (0-42=1, 43-85=2, 85-127=3, etc.)
    jr nc,$-3       ;repeat until
    dec l
    jr nz,rN_loop
    ld l,b
    ret
