;hl = text pointer
rotateLetter:
.db %11110000,5 \ .dw rotateLeft
.db %11110000,5 \ .dw rotateRight
.db %11111000,6 \ .dw rotateLeft
.db %11100000,4 \ .dw rotateRight+1
.db %11000000,3 \ .dw rotateLeft
.db %11000000,3 \ .dw rotateLeft+2
.db %11000000,3 \ .dw rotateRight
.db %11000000,3 \ .dw rotateRight+2
.db %11100000,4 \ .dw rotateLeft
.db %11100000,4 \ .dw rotateLeft+3
.db %11000000,3 \ .dw rotateRight+2

dibCuadro:
    ld hl,saferam1
    ld (hl),%01111111
    inc hl
    ld a,$FF
    ld b,10
lineLoop:
    ld (hl),a
    inc hl
    djnz lineLoop
    ld (hl),%11111110
    ret 
        
;#############################
;#DRAWTEXT
;#Display text to the screen
;# surrounded by a box
;#input: hl - address to text
;#############################
drawText:
    push hl             ;hl points to text string
    call dibCuadro
    pop hl
    ld a,1
    ld de,letRow
    ld (de),a
    ld a,1
    ld de,letCol
    ld (de),a
    ld a,(hl)
dT_loop:
    push hl
    call sacarLetra
    ex af,af'
        ld a,(hl)       ;mask
        ld (mascLet),a
        inc hl
        ld a,(hl)
        ld (addSpace),a ;tamaño de letra (pixeles)
    ex af,af'
    inc hl
    ld c,(hl)           ;rotate address pointer
    inc hl
    ld h,(hl)
    ld l,c
    ld de,letRotate
    ldi
    ldi
    ldi
    ldi
    ld e,a
    ld d,0
    ld hl,alfabeto
    add hl,de
    add hl,de
    add hl,de
    add hl,de
    add hl,de       ;x5
    call dibLetra
    pop hl
    ld a,(letCol)
addSpace = $+1
    add a,5
    ld (letCol),a
    inc hl
    ld a,(hl)
    cp $FF
    jp z,wait2nd
    cp $FE
    jr nz,dT_loop
    inc hl
    exx
        ld hl,letCol
        inc (hl)
    exx
    call contarLetras
    ld a,(hl)
    jr dT_loop

;read from table until reach FE/FF then check if passes for example 94
contarLetras:
    push hl
    ld a,(letCol)
contarBucle:
    ld b,a
    ld a,(hl)
    cp $FE              ;cual letra tenemos
    jr nc,exitLetras    ;palabra cabe
    exx
        call sacarLetra
        inc hl              ;anchura de la letra
        ld a,(hl)
    exx
    inc hl
    add a,b
    cp 94
    jr c,contarBucle
    ld hl,letRow
    ld a,(hl)
    add a,6
    ld (hl),a
    ld hl,letCol
    ld (hl),1
exitLetras:
    pop hl
    ret

;recibir: a = letra
sacarLetra:
    or a            ;reset carry flag
    rra             ;/2
    ld hl,rotateLetter
    ld de,4
    jr nc,letPar    ;si letra es par/impar
    add hl,de
letPar:
    ld e,8
    cp 22
    ret c
    add hl,de
saltarlo:
    cp 31
    ret c
    add hl,de
    cp 32
    ret c
    dec a
    add hl,de
    cp 32
    ret c
    add hl,de
    cp 33
    ret c
    dec a
    add hl,de
    ret

dibLetra:
    exx
        ld hl,0
letRow = $+1
        ld e,0
        ld d,l
        ld b,l
        add hl,de
        add hl,hl       ;y*2
        add hl,de       ;y*3
        add hl,hl       ;y*6
        add hl,de       ;y*7
        add hl,hl       ;y*14
        
        ld de,saferam1
        add hl,de
letCol = $+1
        ld a,0
        ld c,a
        and $7          ;offset
        srl c
        srl c
        srl c           ;/8
        add hl,bc       ;hl = starting point in gbuf
        ld b,a
    exx
   ld c,5
letBucle:
    ld a,(hl)           ;sprite
letRotate:              ;we need to rotate the sprite
    nop
    nop
    nop
    nop
mascLet = $+1           ;a mask to ensure the bits underneath our sprite are empty
    and $F0
    exx
        ld e,b                  ;guardar b
        ld d,0
        dec b \ inc b           ;offset = 0?
        jr z,skipClip
        rra \ rr d \ djnz $-3   ;rotate sprite
        ld b,e
skipClip:
        or (hl)
        ld (hl),a
        inc hl
        ld a,d
        or (hl)
        ld (hl),a
        ld de,13
        add hl,de
    exx
    inc hl
    dec c
    jp nz, letBucle
    ret

wait2nd:
    call drawgbuf
    ld b,2
    jr w2_loop2
w2_loop:
    ld b,0
w2_loop2:
    inc b
    ld a,$BF        ;group 7
    out (1),a
    in a,(1)
    cp 223          ;2nd
    jr nz,w2_loop   ;if 2nd isn't pressed, repeat loop
    djnz w2_loop2
    ret


;#######################
;#DISPNUMBER
;#Display the number stored in HL
;#input: hl = number to display
;#######################
dispNumber:
    exx
        ld de,numberText2
    exx
    ld de,-10000
    call dN_b2d
    ld de,-1000
    call dN_b2d
    ld de,-100
    call dN_b2d
    ld de,-10
    call dN_b2d
    ld de,-1
    call dN_b2d

    ld hl,numberText2
    call drawText
    ret

dN_b2d:
    ld a,-1
dN_b2dloop:
    inc a
    add hl,de
    jr c,dN_b2dloop
    or a
    sbc hl,de
    exx
        ld hl,numberTable
        ld b,0
        ld c,a
        add hl,bc       ;hl=numberTable, bc = number of units
        ldi
    exx
    ret

numberTable:
.db 10,57,36,37,38,39,40,41,42,43
numberText2:
.db 0,0,0,0,0,$FF














