﻿;#######################
;#DRAWMAP
;# draw the map to the screen
;# no inputs, everything taken care of in the other routines
;#######################
drawMap:
xCoord = $+1        ;directly load coordinates (thanks to SMC)
    ld de,$00   ;  to save time and space
    ld hl,mapData-MAP_WIDTH
    add hl,de   ;map X offset, simple math :)
yCoord = $+1
    ld b,0      ;SMC
    inc b
    ld e,MAP_WIDTH  ;here, e = 11 because our map has 11 columns (the define)
    add hl,de
    djnz $-1    ;11*ycoord
;ok, so maybe that was a little confusing. Basically, if b=0
; it'll run $100 times, which is way too much. Rather than
; write in a conditional check (cp), as i'm lazy i just
; loaded the address of mapData - the width of the map.
; Now in the djnz loop we'll need to add in the map width
; one more time to make up for that. As b will now = 1 instead
; of 0, we're a-ok.

    exx
        ld hl,saferam1  ;donde guardar el mapa antes de dibujarlo a la pantalla, es decir, el gbuf
        ld de,13    ;numero de columnas en gbuf menos uno (por el inc hl')
        ld bc,COLUMNS_TO_DRAW*256+5 ;dibujar 7 columnas y 5 filas de sprites (en la pantalla caben 6x4))
dM_drawRow:
        push hl ;save gbuf
    exx
    push hl     ;save map loc   
    call retrieveBrush  ;returns hl pointing to brush data
    ld l,(hl)
    ld h,0
    ld bc,tileData
    add hl,hl   ;x2
    add hl,hl   ;x4
    add hl,hl   ;x8
    add hl,hl   ;x16
    add hl,hl   ;x32
    add hl,bc   ;points to first byte in sprite
    ld b,16     ;16 filas en sprite

;copies the sprite to the gbuf
dM_drawSprite:
    ld a,(hl)   ;sprite pixels to draw
    inc hl      ;next set of pixels
    exx     ;change to shadow vars
        ld (hl),a
        inc hl  ;proximo byte en gbuf
    exx
    ld a,(hl)
    inc hl      ;2nd set (pixels are 16x16: 2 bytes wide)
    exx
        ld (hl),a
        add hl,de   ;bajar a la proxima fila
    exx
    djnz dM_drawSprite

    pop hl      ;posicion en el mapa
    inc hl
    exx
        pop hl  ;gbuf anterior
        inc hl
        inc hl  ;saltar dos bytes porque los sprites son de 16x16
        djnz dM_drawRow
    
    exx
    ld e,MAP_WIDTH-COLUMNS_TO_DRAW
    ld d,0
    add hl,de
    exx
        ld e,14*15
        add hl,de
        ld e,13
        ld b,COLUMNS_TO_DRAW
        dec c
        jp nz,dM_drawRow
    ret

;#######################
;#RETRIEVEPLAYERBRUSH
;# Check the player the tile is on and return
;#  pointer to first byte in the brush
;# 
;# input: NONE
;# output: hl = pointer to first byte in brush
;#######################
retrievePlayerBrush:
    ld a,(playerY)
    inc a
    ld hl,mapData-MAP_WIDTH
    ld de,MAP_WIDTH
    ld b,a
    add hl,de
    djnz $-1
    ld de,(playerX)
    ld d,b
    add hl,de
;...continues into...
;#######################
;#RETRIEVEBRUSH
;# Takes a pointer to a location in the map and
;#  spits out a pointer to the first byte in the
;#  brush
;# input: hl = map location
;# output: hl = pointer to first byte in brush
;#######################
retrieveBrush:
    ld de,brushes   ;pointer to brushes
    ld l,(hl)   ;load the brush number into hl
    ld h,0
    add hl,hl   ;x2
    add hl,de   ;pointer to brush
    ld a,(hl)
    inc hl
    ld h,(hl)
    ld l,a
    ret