/*
 JetForce 2012 - LYNX - kit BLL (newcc65)
 
 14/08/2012

	//TextOut(24, 2, 2, 0, "... present"); // lettre grise 32,32,32 
 */
#include <stdlib.h>
#include <lynx.h>
#include <lynxlib.h>

//{
extern void silence();
extern void abcmusic();
extern void update_music();



char abcpause[];
char abczap1[];
char abczap2[];
char abcbric[];
char sbriq[];
char abcboum[];
char boing[];
char abcr[];

#asm
	xref _abcpause
	xref _abczap1
	xref _abczap2
	xref _abcbric
	xref _sbriq
	xref _abcboum
	xref _boing
	xref _abcr
;
_abcpause
	dc.b "O2X15I1V32T1R14H6K30"
	dc.b "|:C4D4C4E4D4C4D4"
	dc.b 0
_abczap1
	dc.b "O4X3I1V70T20R32H2K1"
	dc.b "|:C4"
	dc.b 0
_abczap2
	dc.b "O4X3I1V70T20R32H2K1"
	dc.b "|:D4"
	dc.b 0
_abcbric
	dc.b "O4X7I1V16T20R54H7K12"
	dc.b "|:C1"
	dc.b 0
_sbriq
	dc.b "O3X4I1V127T8R40H2K2"
	dc.b "|:E2"
	dc.b 0
_abcboum
	dc.b "O1X248I1V48T50R80H2K1"
	dc.b "|:C4"
	dc.b 0
_boing
	dc.b "O3X6I1V76T6R48H2K1"
	dc.b "|:E2B2D2B2C2B2"
	dc.b 0
_abcr
	dc.b "O2X7I0V32T20R80H8K1"
	dc.b "|:B4EDC2DEF2FDB2CDE2EDC2B2D2F2F2"
	dc.b 0
#endasm
//}

/* LYNX-specific #defines: */
#define JOY_RIGHT		0x10
#define JOY_LEFT		0x20
#define JOY_DOWN		0x40
#define JOY_UP			0x80

#define BUTTON_OPTION1	0x08
#define BUTTON_OPTION2	0x04
#define BUTTON_LEFT		0x02
#define BUTTON_RIGHT	0x01

#define BUTTON_PAUSE	0x01

#define SC BSTRETC H(a) (*(uint *)((a)+15)) // dformation, macro
#define SC BTILT(a) (*(uint *)((a)+17)) // dformation, macro

char SCREEN[8160]       at (MEMTOP-16320);
char RENDER[8160]       at (MEMTOP-8160);

char pali[]={
	0x00,0x02,0x06,0x0F,0x0F,0x0F,0x0A,0x0E,0x0C,0x0A,0x08,0x04,0x00,0x00,0x0A,0x04,
	0x00,0x22,0x66,0xFF,0x8A,0x40,0x00,0x0F,0x4F,0x0F,0x4F,0x0E,0x0A,0x0F,0xCF,0xF0};
//char palg[]={
//	0x00,0x00,0x04,0x02,0x09,0x01,0x05,0x07,0x05,0x09,0x0A,0x0F,0x08,0x0D,0x09,0x0F,
//	0x10,0x51,0xD2,0x73,0xF4,0x25,0x96,0xB9,0x7A,0xDA,0xFB,0xFB,0x7C,0xFE,0xBF,0xFF};


// ------------------------------------ taille de l'image titre: 158x60
/*
set image01=titre.bmp

SPRPCK -t6 -S158060 -a079030 -p0 %image01%
cmd
*/
extern char titre[]; // titre du jeu
// ------------------------------------

// ------------------------------------ taille de l'image intro: 160x102
/*
set image01=intro.bmp

SPRPCK -t6 -S160102 -p0 %image01%
cmd
*/
extern char intro[]; // intro du jeu
// ------------------------------------

// ------------------------------------ taille de l'image ipilot: 74x102
/*
set image01=ipilot.bmp

SPRPCK -t6 -S074102 -a037051 -p0 %image01%
cmd
*/
extern char ipilot[]; // pilote de jetski de l'intro du jeu
// ------------------------------------

char SCB[]; // intro
char SCBtt[]; // titre
char SCBpl[]; // pilote
#asm         
_SCB      dc.b $c0,$10,$20
          dc.w 0,0
          dc.w 0,0,$100,$100
          dc.b $01,$23,$45,$67,$89,$ab,$cd,$ef
_SCBtt      dc.b $c7,$10,$20
          dc.w 0,0
          dc.w 0,0,$100,$100
          dc.b $01,$23,$45,$67,$89,$ab,$cd,$ef
_SCBpl      dc.b $c7,$10,$20
          dc.w 0,0
          dc.w 0,0,$100,$100
          dc.b $01,$23,$45,$67,$89,$ab,$cd,$ef
#endasm

 
int etape, posx, posy, xpl, ypl, scaelv, scaelp, scrollx, scrolly, xlimit, ylimit;

int tempa,tempb,tempc,tempd,bspeed,comptx;

char drap1,drap2,zap,relach,relaci,gspause;



// assembler vertical retrace syncronisation routine
void Vsync() 
{
#asm
vretrace:
	lda $fd0a
	bne vretrace
#endasm
}


 
/**************************************************************************
**                                                                       **
**                                                                       **
**************************************************************************/
char main()
{
  InitIRQ();
  CLI;

  SetBuffers(SCREEN, RENDER ,0);

  /* set the palette */
	SetRGB(pali); // palette intro du jeu
	
	DrawFBox(0,0,160,102,15);

	posx=80;posy=42; // cordonne du titre
	xpl=300;ypl=0; // cordonne du pilote
	
	tempa=0;tempb=0;tempc=0;tempd=0;drap1=0;bspeed=0;
	
	etape=0;


	SCBX(SCB) = 300;
	SCBY(SCB) = 0;
	SCBDATA(SCB) = intro;
	
	SCBNEXT(SCB) = SCBtt;
	SCBX(SCBtt) = posx;
	SCBY(SCBtt) = posy;
	SCBDATA(SCBtt) = titre;

	SCBNEXT(SCBtt) = SCBpl;
	SCBX(SCBpl) = xpl;
	SCBY(SCBpl) = ypl;
	SCBDATA(SCBpl) = ipilot;


/**************************************************************************
**                       BOUCLE PRINCIPALE                               ** | 
**************************************************************************/    

while(1)
{
	Vsync();
	SwapBuffers();
	update_music(); // petite subtilit de la gestion sonore

// if (joystick & JOY_RIGHT) // direction Droite
// if (joystick & JOY_LEFT) // direction Gauche
// if (joystick & JOY_UP) // direction Haut
// if (joystick & JOY_DOWN) // direction Bas

	if (switches & BUTTON_PAUSE)
		{
		if (gspause==0)
			{
			gspause=1;
			silence();
			abcmusic(0,abcpause);
			} 
		} 
	if (!(switches & BUTTON_PAUSE))
		{
		if (gspause==1) gspause=2;
		}

	if (switches & BUTTON_PAUSE)
		{
		if (gspause==2) gspause=3;
		}

	if (!(switches & BUTTON_PAUSE))
		{
		if (gspause==3) gspause=0;
		}
// *********************************************************************************************

//extern char croix[]; // logo studio
//extern char redac[]; // titre du jeu

	if (gspause==0 & etape<2)
		{
		if (relach==0)
			{
			if (joystick & (BUTTON_LEFT))
				{
				silence();
				abcmusic(1,abczap1);		// bruitage menu :
				zap=2;relach=1;
				}
			}
		if (relach==1)
			{
			if (!(joystick & (BUTTON_LEFT)))	{relach=0;}
			}

		if (relaci==0)
			{
			if (joystick & (BUTTON_RIGHT))
				{
				silence();
				abcmusic(2,abczap2);		// bruitage menu :
				zap=1;relaci=1;
				}
			}
		if (relaci==1)
			{
			if (!(joystick & (BUTTON_RIGHT)))	{relaci=0;}
			}
		}
		
// *********************************************************************************************
	if (etape==0) // image intro
		{
		posx=80;posy=42; // cordonne du titre
		xpl=300;ypl=0; // cordonne du pilote
		tempa=0;tempb=0;tempc=0;tempd=0;drap1=0;bspeed=0;
		etape=1;
		
		scaelv=512; // taille image originelle = 256
		SCBHS(SCBtt) = scaelv;SCBVS(SCBtt) = scaelv; // taille image originelle = 256
		
		scaelp=128; // taille image originelle = 256
		SCBHS(SCBpl) = scaelp;SCBVS(SCBpl) = scaelp; // taille image originelle = 256
		
		}
// *********************************************************************************************
	if (etape==1) // image intro
		{
		DrawFBox(0,0,160,102,0);
		if (gspause==0)
			{
			if (drap1==0) // zoom arrrire
				{
				if (scaelv>64)
					{
					scaelv-=8;
					if (scaelv<65)		{scaelv=64;drap1=1;}
					}
				}
			if (drap1==1) // zoom avant
				{
				if (scaelv<320)
					{
					scaelv+=6;
					if (scaelv>319)		{scaelv=320;drap1=2;}
					}
				}
			if (drap1==2) // zoom arrrire
				{
				if (scaelv>256)
					{
					scaelv-=4;
					if (scaelv<257)		{scaelv=256;drap1=3;}
					}
				}
			if (drap1==3) // attendre appui
				{
				if (joystick & (BUTTON_RIGHT))
					{
					etape=2;drap1=0;
					SCBX(SCB) = 0;posx=300; // titre
					
					// pilote de jetski de l'intro du jeu
					xpl = 0;xpl -=50;ypl=90; // cordonne du pilote
					}
				}
			SCBX(SCBtt) = posx;SCBY(SCBtt) = posy;
			SCBHS(SCBtt) = scaelv;SCBVS(SCBtt) = scaelv; // taille image originelle = 256
			}


		}




// *********************************************************************************************
			//tempa


	if (etape==2) // menu
		{
		if (gspause==0)
			{
			if (drap1==0) // 
				{
				xpl+=1;
				if (xpl>12)
					{
					drap1=1;
					}
				}
			if (drap1==1) // zoom avant
				{
				xpl+=1;

				if (scaelp<256)
					{
					tempa+=1;
					if (tempa>4)
						{
						tempa=0;scaelp+=4;
						if (ypl>70)
							{
							ypl-=1;
							}
						}
					if (scaelp>255)
						{
						scaelp=256;drap1=2;
						//SCBCTL0(SCBpl)=SCBCTL0(SCBpl) | 0x10; // pour VFLIP  1
						//SCBCTL0(SCBpl)=SCBCTL0(SCBpl) & 0xEF; // pour VFLIP  0
				
						SCBCTL0(SCBpl)=SCBCTL0(SCBpl) | 0x20; // pour HFLIP  1
						//SCBCTL0(SCBpl)=SCBCTL0(SCBpl) & 0xDF; // pour HFLIP  0
						}
						SCBHS(SCBpl) = scaelp;SCBVS(SCBpl) = scaelp; // taille image originelle = 256
					}
				}
			if (drap1==2) // 
				{
				xpl-=1;
				if (xpl<32)
					{
					drap1=3;
					posx=80;posy=42-12; // cordonne du titre
					SCBX(SCBtt) = posx;SCBY(SCBtt) = posy;
					}
				}
			}
		SCBX(SCBpl) = xpl;SCBY(SCBpl) = ypl;
		}
		
// *********************************************************************************************

	if (etape==3) // 
		{

		}

  DrawSprite(SCB); // ordre d'affichage de tout les sprites lis  SCB

}
  
/**************************************************************************
**                     FIN de la BOUCLE PRINCIPALE                       **
**************************************************************************/   
  
 }
