/*
 Megadrive/Genesis - SGDK - 15/07/2012 - Toulouse
 Test affichage de tiles sur le Scroll/Plan A et B,
 tableau multidimensionnel pour scrolling,
 et affichages de sprites... et il me manque plus que l'affichage tile sur Window
*/

#include <genesis.h>
//#include <testdata.h>

#include "ciel01.h"
#include "ciel02.h"
#include "ciel03.h"
#include "ciel04.h"
#include "ciel05.h"
#include "ciel06.h"
#include "ciel07.h"
#include "ciel08.h"
#include "ciel09.h"
#include "ciel10.h"

#include "sapf01.h"
#include "sapf02.h"
#include "sapf03.h"
#include "sapf04.h"
#include "sapf05.h"
#include "sapf06.h"
#include "sapf07.h"
#include "sapf08.h"
#include "sapf09.h"
#include "sapf10.h"
#include "sapf11.h"
#include "sapf12.h"


// position sprite en Vram:
#define chif0   21  //8x8 pixels soit 1 tile
#define chif1   22
#define chif2   23
#define chif3   24
#define chif4   25
#define chif5   26
#define chif6   27
#define chif7   28
#define chif8   29
#define chif9   30
#define schti   31  // 24x32 pixels soit 3x4 tiles = 12 tiles
#define TILE1	43  // 16x16 pixels soit 2x2 tiles = 4 tiles

#define SPR_NBTILES	4	//tiles needed for our sprite


#define pcolor1   0x0EEE

#define fifa 0x0020 // 32
#define fifb 0x0040 // 64
#define fifc 0x0080 // 128
#define fifd 0x0100 // 256
#define fife 0x0200 // 512
//#define fife 0x0200 // 512//


const u16 chti_palette[16] = {
	0x0E0E,0x0000,0x0A00,0x0E44,0x0EAA,0x004A,0x04AE,0x0EEE,
	0x006E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};


const u32 spriteTiles[SPR_NBTILES*8]=
{
		0x00001111, //Tile Top Left
		0x00001111,
		0x00111144,
		0x00111144,
		0x11112244,
		0x11112244,
		0x11112244,
		0x11112244,

		0x11112222, //Tile Bottom Left
		0x11112222,
		0x11112222,
		0x11112222,
		0x00111122,
		0x00111122,
		0x00001111,
		0x00001111,

		0x11110000, //Tile Top Right
		0x11110000,
		0x44111100,
		0x44111100,
		0x44221111,
		0x44221111,
		0x44221111,
		0x44221111,

		0x22221111, //Tile Bottom Right
		0x22221111,
		0x22221111,
		0x22221111,
		0x22111100,
		0x22111100,
		0x11110000,
		0x11110000
};
//chiffre0:
const u32 spchiffre0[8]=
{
	0x00222200,	//' Tile #0
	0x02777720,
	0x27722772,
	0x27722772,
	0x27722772,
	0x27722772,
	0x02777720,
	0x00222200
};

//chiffre1:
const u32 spchiffre1[8]=
{
	0x00222000,	//' Tile #1
	0x02777200,
	0x00277200,
	0x00277200,
	0x00277200,
	0x00277200,
	0x00277200,
	0x00022000
};

//chiffre2:
const u32 spchiffre2[8]=
{
	0x02222200, //	' Tile #2
	0x27777720,
	0x02222772,
	0x02777772,
	0x27777220,
	0x27722220,
	0x27777772,
	0x02222220
};

//chiffre3:
const u32 spchiffre3[8]=
{
	0x02222200, //	' Tile #3
	0x27777720,
	0x02222772,
	0x02777720,
	0x02222772,
	0x02222772,
	0x27777720,
	0x02222200
};

//chiffre4:
const u32 spchiffre4[8]=
{
	0x02222200,   //	' Tile #4
	0x22777720,
	0x27727720,
	0x27727720,
	0x27727720,
	0x27777772,
	0x02227720,
	0x00002200
};

//chiffre5:
const u32 spchiffre5[8]=
{
	0x02222200,  //	' Tile #5
	0x27777720,
	0x27722200,
	0x27777720,
	0x02227720,
	0x02227720,
	0x27777200,
	0x02222000
};

//chiffre6:
const u32 spchiffre6[8]=
{
	0x00222220,  //	' Tile #6
	0x02777772,
	0x27722220,
	0x27777722,
	0x27722772,
	0x27722772,
	0x02777722,
	0x00222220
};

//chiffre7:
const u32 spchiffre7[8]=
{
	0x02222220,  //	' Tile #7
	0x27777772,
	0x02222772,
	0x00027720,
	0x00027720,
	0x00277200,
	0x00277200,
	0x00022000
};

//chiffre8:
const u32 spchiffre8[8]=
{
	0x00222200,  //	' Tile #8
	0x02777720,
	0x27722772,
	0x02777720,
	0x27722772,
	0x27722772,
	0x02777720,
	0x00222200
};

//chiffre9:
const u32 spchiffre9[8]=
{
	0x02222200,  //	' Tile #9
	0x22777720,
	0x27722772,
	0x27722772,
	0x22777772,
	0x02222772,
	0x27777720,
	0x02222200
};

// 24x32 pixels soit 3x4 tiles
const u32 chti[12*8]=
{
	0x00000000,//	' Tile #0
	0x00000000,
	0x00011111,
	0x00123233,
	0x01232333,
	0x01223233,
	0x01232333,
	0x01223233,
	0x01232333,//	' Tile #1
	0x01223233,
	0x01231111,
	0x01111111,
	0x01555155,
	0x01555166,
	0x01555166,
	0x01555166,
	0x01555166,//	' Tile #2
	0x00155166,
	0x00011111,
	0x00000122,
	0x00000122,
	0x00000122,
	0x00000122,
	0x00000122,
	0x00000122,//	' Tile #3
	0x00000122,
	0x00000122,
	0x00000111,
	0x00000155,
	0x00000155,
	0x00000111,
	0x00000000,
	0x00000000,//	' Tile #4
	0x00000000,
	0x11111111,
	0x33344444,
	0x33333333,
	0x33333333,
	0x33333333,
	0x33333333,
	0x33331111,//	' Tile #5
	0x11112333,
	0x22222223,
	0x11111111,
	0x55555555,
	0x66666666,
	0x77116677,
	0x77116677,
	0x66666666,//	' Tile #6
	0x66111166,
	0x11111111,
	0x22222222,
	0x32333333,
	0x23333333,
	0x32333333,
	0x23333333,
	0x32333333,//	' Tile #7
	0x23333333,
	0x32333333,
	0x11111111,
	0x85888881,
	0x58588881,
	0x11111111,
	0x00000000,
	0x00000000,//	' Tile #8
	0x00000000,
	0x10000000,
	0x41000000,
	0x34100000,
	0x33410000,
	0x33410000,
	0x31110000,
	0x13441000,//	' Tile #9
	0x34333100,
	0x33333310,
	0x11111110,
	0x55551000,
	0x66661000,
	0x11661000,
	0x11661000,
	0x66661000,//	' Tile #10
	0x66661000,
	0x11111000,
	0x23100000,
	0x34100000,
	0x34100000,
	0x34100000,
	0x34100000,
	0x34100000,//	' Tile #11
	0x34100000,
	0x34100000,
	0x11100000,
	0x58100000,
	0x58100000,
	0x11100000,
	0x00000000
};

    // Scroll B: tableau pour les tiles: tcl01[lignes][colonnes]
    const u32 tcl01[12][16]=
    {
	{0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01},
	{0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02},
	{0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03},
	{0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04},
	{0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05},
	{0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06},
	{0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07},
	{0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08},
	{0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09},
	{0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A},
	{0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A},
	{0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A}
    };
    //const fix16 atcl01[7][10]=
    const fix16 atcl01[70]=
    {
	1,1,1,1,1,1,1,1,1,1,
	2,2,2,2,2,2,2,2,2,2,
	3,3,3,3,3,3,3,3,3,3,
	4,4,4,4,4,4,4,4,4,4,
	5,5,5,5,5,5,5,5,5,5,
	6,6,6,6,6,6,6,6,6,6,
	7,7,7,7,7,7,7,7,7,7
    };

    // Scroll A: tableau pour les tiles: tbr01[lignes][colonnes] // 16 (0  15) ; 48 (0  47)
    const u32 tbr01[16][48]=
    {
	{0x01,0x01,0x01,0x01,0x02,0x02,0x02,0x02,0x03,0x03,0x03,0x03,0x04,0x04,0x04,0x04,0x05,0x05,0x05,0x05,0x06,0x06,0x06,0x06,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x09,0x09,0x09,0x09,0x0A,0x0A,0x0A,0x0A,0x0B,0x0B,0x0B,0x0B,0x0C,0x0C,0x0C,0x0C},
	{0x01,0x00,0x00,0x01,0x02,0x00,0x00,0x02,0x03,0x00,0x00,0x02,0x0B,0x00,0x00,0x04,0x05,0x00,0x00,0x05,0x06,0x00,0x00,0x06,0x07,0x00,0x00,0x07,0x08,0x00,0x00,0x08,0x09,0x00,0x00,0x09,0x0A,0x00,0x00,0x0A,0x0B,0x00,0x00,0x0B,0x0C,0x00,0x00,0x0C},
	{0x01,0x00,0x00,0x01,0x02,0x00,0x00,0x02,0x03,0x00,0x00,0x03,0x0A,0x00,0x00,0x04,0x05,0x00,0x00,0x05,0x06,0x00,0x00,0x06,0x07,0x00,0x00,0x07,0x08,0x00,0x00,0x08,0x09,0x00,0x00,0x09,0x0A,0x00,0x00,0x0A,0x0B,0x00,0x00,0x0B,0x0C,0x00,0x00,0x0C},
	{0x01,0x00,0x00,0x01,0x02,0x00,0x00,0x02,0x03,0x00,0x00,0x04,0x09,0x00,0x00,0x04,0x05,0x00,0x00,0x05,0x06,0x00,0x00,0x06,0x07,0x00,0x00,0x07,0x08,0x00,0x00,0x08,0x09,0x00,0x00,0x09,0x0A,0x00,0x00,0x0A,0x0B,0x00,0x00,0x0B,0x0C,0x00,0x00,0x0C},
	{0x01,0x00,0x00,0x01,0x02,0x00,0x00,0x02,0x03,0x00,0x00,0x05,0x08,0x00,0x00,0x04,0x05,0x00,0x00,0x05,0x06,0x00,0x00,0x06,0x07,0x00,0x00,0x07,0x08,0x00,0x00,0x08,0x09,0x00,0x00,0x09,0x0A,0x00,0x00,0x0A,0x0B,0x00,0x00,0x0B,0x0C,0x00,0x00,0x0C},
	{0x01,0x00,0x00,0x01,0x02,0x00,0x00,0x02,0x03,0x00,0x00,0x06,0x07,0x00,0x00,0x04,0x05,0x00,0x00,0x05,0x06,0x00,0x00,0x06,0x07,0x00,0x00,0x07,0x08,0x00,0x00,0x08,0x09,0x00,0x00,0x09,0x0A,0x00,0x00,0x0A,0x0B,0x00,0x00,0x0B,0x0C,0x00,0x00,0x0C},
	{0x01,0x00,0x00,0x01,0x02,0x00,0x00,0x02,0x03,0x00,0x00,0x07,0x06,0x00,0x00,0x04,0x05,0x00,0x00,0x05,0x06,0x00,0x00,0x06,0x07,0x00,0x00,0x07,0x08,0x00,0x00,0x08,0x09,0x00,0x00,0x09,0x0A,0x00,0x00,0x0A,0x0B,0x00,0x00,0x0B,0x0C,0x00,0x00,0x0C},

	{0x01,0x01,0x01,0x01,0x02,0x02,0x02,0x02,0x03,0x03,0x00,0x08,0x05,0x04,0x04,0x04,0x05,0x05,0x05,0x05,0x06,0x06,0x06,0x06,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x09,0x09,0x09,0x09,0x0A,0x0A,0x0A,0x0A,0x0B,0x0B,0x0B,0x0B,0x0C,0x0C,0x0C,0x0C},
	{0x01,0x00,0x00,0x01,0x02,0x00,0x00,0x02,0x03,0x00,0x00,0x08,0x04,0x00,0x00,0x04,0x05,0x00,0x00,0x05,0x06,0x00,0x00,0x06,0x07,0x00,0x00,0x07,0x08,0x00,0x00,0x08,0x09,0x00,0x00,0x09,0x0A,0x00,0x00,0x0A,0x0B,0x00,0x00,0x0B,0x0C,0x00,0x00,0x0C},
	{0x01,0x00,0x00,0x01,0x02,0x00,0x00,0x02,0x03,0x00,0x00,0x07,0x03,0x00,0x00,0x04,0x05,0x00,0x00,0x05,0x06,0x00,0x00,0x06,0x07,0x00,0x00,0x07,0x08,0x00,0x00,0x08,0x09,0x00,0x00,0x09,0x0A,0x00,0x00,0x0A,0x0B,0x00,0x00,0x0B,0x0C,0x00,0x00,0x0C},
	{0x01,0x00,0x00,0x01,0x02,0x00,0x00,0x02,0x03,0x00,0x00,0x06,0x02,0x00,0x00,0x04,0x05,0x00,0x00,0x05,0x06,0x00,0x00,0x06,0x07,0x00,0x00,0x07,0x08,0x00,0x00,0x08,0x09,0x00,0x00,0x09,0x0A,0x00,0x00,0x0A,0x0B,0x00,0x00,0x0B,0x0C,0x00,0x00,0x0C},
	{0x01,0x00,0x00,0x01,0x02,0x00,0x00,0x02,0x03,0x00,0x00,0x05,0x01,0x00,0x00,0x04,0x05,0x00,0x00,0x05,0x06,0x00,0x00,0x06,0x07,0x00,0x00,0x07,0x08,0x00,0x00,0x08,0x09,0x00,0x00,0x09,0x0A,0x00,0x00,0x0A,0x0B,0x00,0x00,0x0B,0x0C,0x00,0x00,0x0C},
	{0x01,0x00,0x00,0x01,0x02,0x00,0x00,0x02,0x03,0x00,0x00,0x04,0x00,0x00,0x00,0x04,0x05,0x00,0x00,0x05,0x06,0x00,0x00,0x06,0x07,0x00,0x00,0x07,0x08,0x00,0x00,0x08,0x09,0x00,0x00,0x09,0x0A,0x00,0x00,0x0A,0x0B,0x00,0x00,0x0B,0x0C,0x00,0x00,0x0C},
	{0x01,0x00,0x00,0x01,0x02,0x00,0x00,0x02,0x03,0x00,0x00,0x03,0x01,0x00,0x00,0x04,0x05,0x00,0x00,0x05,0x06,0x00,0x00,0x06,0x07,0x00,0x00,0x07,0x08,0x00,0x00,0x08,0x09,0x00,0x00,0x09,0x0A,0x00,0x00,0x0A,0x0B,0x00,0x00,0x0B,0x0C,0x00,0x00,0x0C},

	{0x01,0x00,0x00,0x01,0x02,0x00,0x00,0x02,0x03,0x00,0x00,0x02,0x02,0x00,0x00,0x04,0x05,0x00,0x00,0x05,0x06,0x00,0x00,0x06,0x07,0x00,0x00,0x07,0x08,0x00,0x00,0x08,0x09,0x00,0x00,0x09,0x0A,0x00,0x00,0x0A,0x0B,0x00,0x00,0x0B,0x0C,0x00,0x00,0x0C},
	{0x01,0x01,0x01,0x01,0x02,0x02,0x02,0x02,0x03,0x03,0x03,0x01,0x03,0x04,0x04,0x04,0x05,0x05,0x05,0x05,0x06,0x06,0x06,0x06,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x09,0x09,0x09,0x09,0x0A,0x0A,0x0A,0x0A,0x0B,0x0B,0x0B,0x0B,0x0C,0x0C,0x0C,0x0C}
    };



int main( )
{



// *******************************************************************************************************************************************
// sprites:

    VDP_setPalette(2, (u16 *) chti_palette);
    //VDP_setPaletteColor(2, 3, pcolor1); // changement couleur (vaut mieux utiliser les constantes)
    //VDP_setPaletteColor(2, 4, pcolor1);
    //VDP_setPaletteColor(2, 5, pcolor1);
    //VDP_setPaletteColor(2, 6, pcolor1);
//spritedef

	SpriteDef mySprite1;
	SpriteDef mySprite2;
	SpriteDef mySprite3;
	SpriteDef mySprite4;

	SpriteDef myhero;

	SpriteDef mySprite5;

	//load the tile in VRAM (check it using GensKMod CPU>Debug>Genesis>VDP)
    VDP_loadTileData( (const u32 *)spchiffre0, chif0, 1, 0);
    VDP_loadTileData( (const u32 *)spchiffre1, chif1, 1, 0);
    VDP_loadTileData( (const u32 *)spchiffre2, chif2, 1, 0);
    VDP_loadTileData( (const u32 *)spchiffre3, chif3, 1, 0);
    VDP_loadTileData( (const u32 *)spchiffre4, chif4, 1, 0);
    VDP_loadTileData( (const u32 *)spchiffre5, chif5, 1, 0);
    VDP_loadTileData( (const u32 *)spchiffre6, chif6, 1, 0);
    VDP_loadTileData( (const u32 *)spchiffre7, chif7, 1, 0);
    VDP_loadTileData( (const u32 *)spchiffre8, chif8, 1, 0);
    VDP_loadTileData( (const u32 *)spchiffre9, chif9, 1, 0);

    VDP_loadTileData( (const u32 *)chti, schti, 12, 0);

	VDP_loadTileData( (const u32 *)spriteTiles, TILE1, 4, 0);


	VDP_resetSprites(); //optional, but take the use to

    // Sprite score unit
	mySprite1.posx = 0;mySprite1.posy = 0;
	mySprite1.size = SPRITE_SIZE(1,1);  //  a sprite 1x1 using 1 tile (8x8 pixels)
	mySprite1.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0, 1);//chif0);
	mySprite1.link  = 1;
	VDP_setSpriteP(0, &mySprite1);
    // Sprite score dizaine
	mySprite2.posx = 0;mySprite2.posy = 0;
	mySprite2.size = SPRITE_SIZE(1,1);  //  a sprite 1x1 using 1 tile (8x8 pixels)
	mySprite2.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0, 1);
	mySprite2.link  = 2;
	VDP_setSpriteP(1, &mySprite2);
    // Sprite score centaine
	mySprite3.posx = 0;mySprite3.posy = 0;
	mySprite3.size = SPRITE_SIZE(1,1);  //  a sprite 1x1 using 1 tile (8x8 pixels)
	mySprite3.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0, 1);
	mySprite3.link  = 3;
	VDP_setSpriteP(2, &mySprite3);
    // Sprite score millier
	mySprite4.posx = 0;mySprite4.posy = 0;
	mySprite4.size = SPRITE_SIZE(1,1);  //  a sprite 1x1 using 1 tile (8x8 pixels)
	mySprite4.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0, 1);
	mySprite4.link  = 4;
	VDP_setSpriteP(3, &mySprite4);

	// Sprite hero 24*32 pixels
	myhero.posx = 0;myhero.posy = 0;
	myhero.size = SPRITE_SIZE(3,4);
	myhero.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0,schti);
	myhero.link  = 5;
	VDP_setSpriteP(4, &myhero);

	// Sprite test 16*16 pixels
	mySprite5.posx = 0;mySprite5.posy = 0;
	mySprite5.size = SPRITE_SIZE(2,2);
	mySprite5.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0,TILE1);
	mySprite5.link  = 6;
	VDP_setSpriteP(5, &mySprite5);

	VDP_updateSprites();


// *******************************************************************************************************************************************
// variables globales
//#define u8      unsigned char
//#define u16     unsigned short
//#define u32     unsigned long

    u8 gsblip;
    u16 hspa;u16 hspb;

    u16 xscrolla;u8 col_x;u16 xaccg;u16 sdroit;u16 sgauch;u8 xami;u8 xamj;
    u16 yscrolla;u16 yaccu;u16 lecty;

    u16 vspa;u16 vspb; // scroll A et B

    u16 comptx;u16 compty;u16 compti; // variables pour lecture de data ci-dessus

    u16 planB[11]; // (0  10) variable utilise pour stocker la position en Vram des Tiles du Plan/Scroll B
    u16 planA[13]; // (0  12) variable utilise pour stocker la position en Vram des Tiles du Plan/Scroll A



    u16 value; // pour le joypad
    u16 unite;u16 dizaine;u16 centaine;u16 millier;

    u16 datest;u16 dbtest; // variable de test debug

    u16 wt;u16 ht;u16 num_tiles; // variables importantes pour les tiles/Vram
    u16 tile_ind = 64;//TILE_USERINDEX; // initialize tile index where to transfert tile data

    u8 laright;u8 laleft;
    u16 zxt;


// *****************************************************************************************************************************************
// Scroll B

    // load next image: ciel01
    wt = ciel01[0] / 8;
    ht = ciel01[1] / 8;
    num_tiles = wt * ht;
        VDP_setPalette(PAL0, (u16 *) &ciel01[2]); // get the palette
// void VDP_loadBMPTileData(const u32 *data, u16 index, u16 w, u16 h, u16 bmp_w);
        VDP_loadBMPTileData((u32*) &ciel01[18], tile_ind, wt, ht, wt);
    //VDP_fillTileMapRectInc(BPLAN, TILE_ATTR_FULL(PAL0, 0, 0, 0, tile_ind), 0, 0, wt, ht); // Test: draw the sapf01 at (0, 0)
    planB[1] = tile_ind; // planB[1] stocke la position en Vram de ciel01
    tile_ind += num_tiles; //dbtest=ht;//wt;//num_tiles;//

    // load next image: ciel02
    wt = ciel02[0] / 8;
    ht = ciel02[1] / 8;
    num_tiles = wt * ht;
    VDP_loadBMPTileData((u32*) &ciel02[18], tile_ind, wt, ht, wt);

    planB[2] = tile_ind; // planB[2] stocke la position en Vram de ciel02
    tile_ind += num_tiles;

    // load next image: ciel03
    wt = ciel03[0] / 8;
    ht = ciel03[1] / 8;
    num_tiles = wt * ht;
    VDP_loadBMPTileData((u32*) &ciel03[18], tile_ind, wt, ht, wt);

    planB[3] = tile_ind; // planB[3] stocke la position en Vram de ciel03
    tile_ind += num_tiles;

    // load next image: ciel04
    wt = ciel04[0] / 8;
    ht = ciel04[1] / 8;
    num_tiles = wt * ht;
    VDP_loadBMPTileData((u32*) &ciel04[18], tile_ind, wt, ht, wt);

    planB[4] = tile_ind; // planB[4] stocke la position en Vram de ciel04
    tile_ind += num_tiles;

    // load next image: ciel05
    wt = ciel05[0] / 8;
    ht = ciel05[1] / 8;
    num_tiles = wt * ht;
    VDP_loadBMPTileData((u32*) &ciel05[18], tile_ind, wt, ht, wt);

    planB[5] = tile_ind; // planB[5] stocke la position en Vram de ciel05
    tile_ind += num_tiles;

    // load next image: ciel06
    wt = ciel06[0] / 8;
    ht = ciel06[1] / 8;
    num_tiles = wt * ht;
    VDP_loadBMPTileData((u32*) &ciel06[18], tile_ind, wt, ht, wt);

    planB[6] = tile_ind; // planB[6] stocke la position en Vram de ciel06
    tile_ind += num_tiles;

    // load next image: ciel07
    wt = ciel07[0] / 8;
    ht = ciel07[1] / 8;
    num_tiles = wt * ht;
    VDP_loadBMPTileData((u32*) &ciel07[18], tile_ind, wt, ht, wt);

    planB[7] = tile_ind; // planB[7] stocke la position en Vram de ciel07
    tile_ind += num_tiles;

    // load next image: ciel08
    wt = ciel08[0] / 8;
    ht = ciel08[1] / 8;
    num_tiles = wt * ht;
    VDP_loadBMPTileData((u32*) &ciel08[18], tile_ind, wt, ht, wt);

    planB[8] = tile_ind; // planB[8] stocke la position en Vram de ciel08
    tile_ind += num_tiles;

    // load next image: ciel09
    wt = ciel09[0] / 8;
    ht = ciel09[1] / 8;
    num_tiles = wt * ht;
    VDP_loadBMPTileData((u32*) &ciel09[18], tile_ind, wt, ht, wt);

    planB[9] = tile_ind; // planB[9] stocke la position en Vram de ciel09
    tile_ind += num_tiles;

    // load next image: ciel10
    wt = ciel10[0] / 8;
    ht = ciel10[1] / 8;
    num_tiles = wt * ht;
    VDP_loadBMPTileData((u32*) &ciel10[18], tile_ind, wt, ht, wt);

    planB[10] = tile_ind; // planB[10] stocke la position en Vram de ciel10
    tile_ind += num_tiles;
// *******************************************************************************************************************************************
// Scroll A

    // load next image: Tile01
    wt = sapf01[0] / 8;
    ht = sapf01[1] / 8;
    num_tiles = wt * ht;
        VDP_setPalette(PAL1, (u16 *) &sapf01[2]); // get the palette
    VDP_loadBMPTileData((u32*) &sapf01[18], tile_ind, wt, ht, wt);
//    VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, tile_ind), 0, 0, wt, ht); // Test: draw the sapf01 at (0, 0)

    planA[1] = tile_ind; // planA[1] stocke la position en Vram de Tile 01
    tile_ind += num_tiles;

    // load next image: Tile02
    wt = sapf02[0] / 8;
    ht = sapf02[1] / 8;
    num_tiles = wt * ht;
    VDP_loadBMPTileData((u32*) &sapf02[18], tile_ind, wt, ht, wt);
//    VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, tile_ind), 4, 0, wt, ht); // Test: draw the sapf02 at (4, 0)

    planA[2] = tile_ind; // planA[2] stocke la position en Vram de Tile 02
    tile_ind += num_tiles;

    // load next image: Tile03
    wt = sapf03[0] / 8;
    ht = sapf03[1] / 8;
    num_tiles = wt * ht;
    VDP_loadBMPTileData((u32*) &sapf03[18], tile_ind, wt, ht, wt);
//    VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, tile_ind), 8, 0, wt, ht); // Test: draw the sapf03 at (8, 0)

    planA[3] = tile_ind; // planA[3] stocke la position en Vram de Tile 03
    tile_ind += num_tiles;

    // load next image: Tile04
    wt = sapf04[0] / 8;
    ht = sapf04[1] / 8;
    num_tiles = wt * ht;
    VDP_loadBMPTileData((u32*) &sapf04[18], tile_ind, wt, ht, wt);
//    VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, tile_ind), 12, 0, wt, ht); // Test: draw the sapf04 at (12, 0)

    planA[4] = tile_ind; // planA[4] stocke la position en Vram de Tile 04
    tile_ind += num_tiles;

    // load next image: Tile05
    wt = sapf05[0] / 8;
    ht = sapf05[1] / 8;
    num_tiles = wt * ht;
    VDP_loadBMPTileData((u32*) &sapf05[18], tile_ind, wt, ht, wt);
//    VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, tile_ind), 16, 0, wt, ht); // Test: draw the sapf05 at (16, 0)


    planA[5] = tile_ind; // planA[5] stocke la position en Vram de Tile 05
    tile_ind += num_tiles;

    // load next image: Tile06
    wt = sapf06[0] / 8;
    ht = sapf06[1] / 8;
    num_tiles = wt * ht;
    VDP_loadBMPTileData((u32*) &sapf06[18], tile_ind, wt, ht, wt);
//    VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, tile_ind), 20, 0, wt, ht); // Test: draw the sapf06 at (20, 0)

    planA[6] = tile_ind; // planA[6] stocke la position en Vram de Tile 06
    tile_ind += num_tiles;

    // load next image: Tile07
    wt = sapf07[0] / 8;
    ht = sapf07[1] / 8;
    num_tiles = wt * ht;
    VDP_loadBMPTileData((u32*) &sapf07[18], tile_ind, wt, ht, wt);
//    VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, tile_ind), 20, 0, wt, ht); // Test: draw the sapf06 at (20, 0)

    planA[7] = tile_ind; // planA[7] stocke la position en Vram de Tile 07
    tile_ind += num_tiles;

    // load next image: Tile08
    wt = sapf08[0] / 8;
    ht = sapf08[1] / 8;
    num_tiles = wt * ht;
    VDP_loadBMPTileData((u32*) &sapf08[18], tile_ind, wt, ht, wt);
//    VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, tile_ind), 20, 0, wt, ht); // Test: draw the sapf06 at (20, 0)

    planA[8] = tile_ind; // planA[8] stocke la position en Vram de Tile 08
    tile_ind += num_tiles;

    // load next image: Tile09
    wt = sapf09[0] / 8;
    ht = sapf09[1] / 8;
    num_tiles = wt * ht;
    VDP_loadBMPTileData((u32*) &sapf09[18], tile_ind, wt, ht, wt);
//    VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, tile_ind), 20, 0, wt, ht); // Test: draw the sapf06 at (20, 0)

    planA[9] = tile_ind; // planA[9] stocke la position en Vram de Tile 09
    tile_ind += num_tiles;

    // load next image: Tile10
    wt = sapf10[0] / 8;
    ht = sapf10[1] / 8;
    num_tiles = wt * ht;
    VDP_loadBMPTileData((u32*) &sapf10[18], tile_ind, wt, ht, wt);
//    VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, tile_ind), 20, 0, wt, ht); // Test: draw the sapf06 at (20, 0)

    planA[10] = tile_ind; // planA[10] stocke la position en Vram de Tile 10
    tile_ind += num_tiles;

    // load next image: Tile11
    wt = sapf11[0] / 8;
    ht = sapf11[1] / 8;
    num_tiles = wt * ht;
    VDP_loadBMPTileData((u32*) &sapf11[18], tile_ind, wt, ht, wt);
//    VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, tile_ind), 20, 0, wt, ht); // Test: draw the sapf06 at (20, 0)

    planA[11] = tile_ind; // planA[11] stocke la position en Vram de Tile 11
    tile_ind += num_tiles;

    // load next image: Tile12
    wt = sapf12[0] / 8;
    ht = sapf12[1] / 8;
    num_tiles = wt * ht;
    VDP_loadBMPTileData((u32*) &sapf12[18], tile_ind, wt, ht, wt);
//    VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, tile_ind), 20, 0, wt, ht); // Test: draw the sapf06 at (20, 0)

    planA[12] = tile_ind; // planA[12] stocke la position en Vram de Tile 12
    //tile_ind += num_tiles;
// *******************************************************************************************************************************************

    // Affichage d'une tranche sur Scroll/Plan B    u8 ou u16 ou u32 exemple: void PSG_setTone(u8 channel, u16 value)
    static void renderb(u16 xt1, u16 xt2, u16 yt1, u16 yt2, u16 zt)
    {

                zt=0; // problem: dcalage Y (rsolu temporairement par l'utilisation de la variable zt)
                if (xt1>15)    {zt++;}
                if (xt1>31)    {zt++;}
//
	for(compty=yt1 ; compty<yt2; compty++) // lignes
		{
        //comptx=xt2;
        for(comptx=xt1 ; comptx<xt2; comptx++)  // colonnes
            {
            compti = tcl01[compty][comptx]; // tbr01[lignes][colonnes] //
            //compti = atcl01[compty,comptx];
            if (compti == 0)
                {
                VDP_clearTileMapRect(BPLAN, comptx*4, compty*4-zt, wt, ht);
                }
            else
                {
                VDP_fillTileMapRectInc(BPLAN, TILE_ATTR_FULL(PAL0, 0, 0, 0, planB[compti]), comptx*4, compty*4-zt, wt, ht); // lecture du tableau tbr01
                }
            }
        }
    }

    // Affichage fond level
    renderb(0,16, 0,13, 0); // remplissage 352*512: X de 0  10 (32*11=352) et Y de 0  15 (16*32=512).

//









// ************************************************************************************************************************************
u16 rxt;u16 ryt;u16 ztl;
u16 cty[16]; // pour optimiser, dfinir  l'avance valeur variable ryt

        ryt = 0;
        for(compty=0 ; compty<16; compty++) // lignes
            {
            ryt = compty*4; //
            cty[compty] = ryt;
            }
        ryt=0;
    // Affichage d'une tranche sur Scroll/Plan A
    static void rendera(u16 xtl, u16 yt1, u16 yt2)
    {
        ztl=0; // problem: dcalage Y (rsolu temporairement par l'utilisation de la variable zt)
        if (xtl>15)    {ztl++;}
        if (xtl>31)    {ztl++;}
        rxt = xtl<<2; // *4;

        for(compty=yt1 ; compty<yt2; compty++) // lignes
            {

            compti = tbr01[compty][xtl]; // tbr01[lignes][colonnes]
            //ryt = compty*4-ztl;
            //ryt = compty<<2; // 	//atest=1<<2; //               <<2  = *4
            ryt = cty[compty];
            ryt -= ztl;

            if (compti == 0)
                {
                //VDP_clearTileMapRect(APLAN, comptx*4, compty*4-zt, wt, ht);
                VDP_clearTileMapRect(APLAN, rxt, ryt, wt, ht);
                }
            else
                {
                //VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, planA[compti]), comptx*4, compty*4-zt, wt, ht); // lecture du tableau tbr01
                //VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, planA[compti]), rxt, ryt, wt, ht); // lecture du tableau tbr01
                VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, planA[compti]), rxt, ryt, wt, ht); // lecture du tableau tbr01
                }

            }
    }


// *******************************************************************************************************************************************
    // Un seul Affichage d'une tranche sur Scroll/Plan A
    static void runaff(u16 xt1, u16 xt2, u16 yt1, u16 yt2, u16 zt)
    {

                zt=0; // problem: dcalage Y (rsolu temporairement par l'utilisation de la variable zt)
                if (xt1>15)    {zt++;}
                if (xt1>31)    {zt++;}

	for(compty=yt1 ; compty<yt2; compty++) // lignes
		{
        for(comptx=xt1 ; comptx<xt2; comptx++)  // colonnes
            {
            compti = tbr01[compty][comptx]; // tbr01[lignes][colonnes]
            if (compti == 0)
                {
                VDP_clearTileMapRect(APLAN, comptx*4, compty*4-zt, wt, ht);
                }
            else
                {
                VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, planA[compti]), comptx*4, compty*4-zt, wt, ht); // lecture du tableau tbr01
                }
            }
        }
    }
    runaff(0,12, 0,16, 0); // remplissage 352*512: X de 0  10 (32*11=352) et Y de 0  15 (16*32=512).
// *******************************************************************************************************************************************





    gsblip=0;
    dbtest=0; // test de l'appui sur le bouton start: affichage d'un tile.
    hspa=0;hspb=0;hspa=0;xscrolla=0;xaccg=1;xami=0;xamj=0;yaccu=1;
    sdroit=11;sgauch=0;
    yscrolla=0;yaccu=0;lecty=0;
    vspa=0;vspb=0;
    col_x=32;xaccg=0;
    laright=0;laleft=0;

    datest=0;
    zxt=0;

// *******************************************************************************************************************************************

// *******************************************************************************************************************************************

// *******************************************************************************************************************************************


    // *****************************
    // **** Boucle principale ****** |
    // *****************************


	while(1)
	{
    // Test manuel avec votre belle joypad ergonomique...
    value = JOY_readJoypad(JOY_1); // valeur du joypad joueur 1

    //if (value & BUTTON_UP)
    //if (value & BUTTON_DOWN)
    //if (value & BUTTON_LEFT)
    //if (value & BUTTON_RIGHT)
    //if (value & BUTTON_A)
    //if (value & BUTTON_B)
    //if (value & BUTTON_C)//


    if (value & BUTTON_A)
        {
        VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, planA[1]), 24, 16, wt, ht); // l j'affiche
        //VDP_fillTileMapRectInc(WPLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, planA[1]), 24, 16, wt, ht); // l j'affiche... Ah ! marche pas.
        }
    if (value & BUTTON_B)
        {
        VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 1, planA[1]), 24, 16, wt, ht); // l je flipe (le tile) ;)
        }
    if (value & BUTTON_C)
        {
        VDP_clearTileMapRect(APLAN, 24, 16, wt, ht); // nettoyage de printemps.
        }


/*
void VDP_setPalette  ( u16  num, const u16 *  pal)

VDP_setPalette(2, (u16 *) chti_palette);
*/

/* texte, score, hi-score, timme...
#define VDP_PLAN_WINDOW   WPLAN

VDP window plan tilemap address in VRAM.



*/









                /*
                        Attention: avec une valeure ngative, une variable peut poser de sreux problmes...
                        ...et un dpassement de lecture de DATA plante la console, alors vitons les tourderies !
                */





// ********************************************************************** scroll droite
    if (value & BUTTON_RIGHT)
        {
        if (xscrolla<607)
            {
            xscrolla++;
            col_x+=2;
			if (col_x>63) // 32  64
				{
				col_x=32; // Rappel: avant la boucle principale, la valeur de la variable col_x = 32
				if ((sdroit<47) && (xscrolla>31))
                    {
                    sdroit+=1;sgauch+=1;
                    rendera(0+sdroit, 0,16); // Rappel: avant la boucle principale, la valeur de la variable sdroit = 11
                    }
				}

            hspb-=1;VDP_setHorizontalScroll(BPLAN, fife, hspb);

            hspa-=2;VDP_setHorizontalScroll(APLAN, fife, hspa);

            myhero.tile_attr = TILE_ATTR_FULL(PAL2,0,0,0,schti); // sprite personnage joueur droite
            //VDP_updateSprites();
            }
        }

// ********************************************************************** scroll gauche
    if (value & BUTTON_LEFT)
        {
        if (xscrolla>0)
            {
            xscrolla--;
            col_x-=2;
			if (col_x<1) // 0  31
				{
				col_x=32;

				if (sgauch>0)
                    {
                    sdroit-=1;sgauch-=1;
                    rendera(0+sgauch, 0,16);
                    }
				}

            hspb+=1;VDP_setHorizontalScroll(BPLAN, fife, hspb);
            hspa+=2;VDP_setHorizontalScroll(APLAN, fife, hspa);

            myhero.tile_attr = TILE_ATTR_FULL(PAL2,0,0,1,schti); // sprite personnage joueur gauche
            }
        }



// ********************************************************************** scroll bas
    if (value & BUTTON_DOWN)
        {
        //if (yscrolla<48)//(yscrolla<144)
        if (yscrolla<144)//(yscrolla<112)//(yscrolla<80)//(yscrolla<144)
            {
            //yaccu++;
            if (yaccu==17) // 1  16 donc si yaccu=17 alors yaccu = 1
                {
                yaccu=1;lecty+=1;

                }

            vspb+=1;VDP_setVerticalScroll(BPLAN, fife, vspb);

            vspa+=2;VDP_setVerticalScroll(APLAN, fife, vspa);
            yscrolla++;
            }
        }

// ********************************************************************** scroll haut
    if (value & BUTTON_UP)
        {
        if (yscrolla>0)
            {

            //yaccu--;
            if (yaccu==0) // 1  16 donc si yaccu=0 alors yaccu = 16
                {
                yaccu=16;lecty-=1;
                }

            vspb-=1;VDP_setVerticalScroll(BPLAN, fife, vspb);

            vspa-=2;VDP_setVerticalScroll(APLAN, fife, vspa);
            yscrolla--;
            }
        }

    // wt = width in tiles we want to load
    // ht = height in tile we want to load
    // wt = width in tiles of the bitmap

	gsblip+=1; // economie ressource machine --> certaines des conditions n'ont pas besoin d'tre lu  chaque boucle.
	if (gsblip>5)
		{
        gsblip=0;
    //dbtest = sgauch;//accuA;//xscrolla;//xaccu;//hspa;//accuA;//xscrolla;
        dbtest = sdroit;//yscrolla;//lecty;//xscrolla;//fife;//VDP_getReg(0x02); //VDP_getScanlineNumber(); //VDP_getScreenHeight(); //VDP_getScreenWidth(); //VDP_getPlanHeight(); //VDP_getPlanWidth();


        unite = dbtest % 10;//:propsprite chiffre0,828+unite,2;// ' unit
        dizaine = dbtest / 10 % 10;//:propsprite chiffre1,828+dizaine,2;// ' dizaine
        centaine = dbtest / 100 % 10;//:propsprite chiffre2,828+centaine,2;// ' centaine
        millier = dbtest / 1000 % 10;//:propsprite chiffre3,828+millier,2;// ' millier

// 	unite = dbtest % 10;//:propsprite chiffre0,828+unite,2;// ' unit
//	dizaine = dbtest / 10 % 10;//:propsprite chiffre1,828+dizaine,2;// ' dizaine

//	centaine = sdroit % 10;//:propsprite chiffre2,828+centaine,2;// ' centaine
//	millier = sdroit / 10 % 10;//:propsprite chiffre3,828+millier,2;// ' millier

		VDP_resetSprites();

		mySprite1.posx = 56;//mySprite.posx++;
		mySprite1.posy = 60;//mySprite.posy++;
		mySprite1.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0, 21+unite);//chif0);
		VDP_setSpriteP(0, &mySprite1);

		mySprite2.posx = 48;//mySprite2.posx+=2;
		mySprite2.posy = 60;//mySprite2.posy++;
		mySprite2.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0, 21+dizaine);//chif0);
		VDP_setSpriteP(1, &mySprite2);

		mySprite3.posx = 40-8;//mySprite3.posx++;
		mySprite3.posy = 60;//mySprite3.posy+=2;
		mySprite3.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0, 21+centaine);//chif0);
		VDP_setSpriteP(2, &mySprite3);

		mySprite4.posx = 32-8;//mySprite3.posx++;
		mySprite4.posy = 60;//mySprite3.posy+=2;
		mySprite4.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0, 21+millier);//chif0);
		VDP_setSpriteP(3, &mySprite4);

		myhero.posx = 144;//mySprite3.posx++;
		myhero.posy = 106;//mySprite3.posy+=2;
		VDP_setSpriteP(4, &myhero);

		mySprite5.posx = 24;//mySprite3.posx++;
		mySprite5.posy = 24;//mySprite3.posy+=2;
		VDP_setSpriteP(5, &mySprite5);


        }



	VDP_updateSprites();
	VDP_waitVSync();
	}
	return 0;
}

