#include <stdio.h>
#include <stdlib.h>
#include <task.h>
#include <input.h>
#include <DATlib.h>
#include "externs.h"

#define FRONT_START_X 157
#define FRONT_START_Y 24
#define FRONT_MIN_X 8
#define FRONT_MAX_X 307
#define FRONT_MIN_Y 16
#define FRONT_MAX_Y 24

#define BACK_MIN_X 8
#define BACK_MAX_X 149
#define BACK_MIN_Y 5
#define BACK_MAX_Y 8

typedef struct bkp_ram_info {
	WORD debug_dips;
	BYTE stuff[254];
	//256 bytes backup block
} bkp_ram_info;
bkp_ram_info bkp_data;

BYTE p1,p2,ps,p1e,p2e;

//extern spriteInfo bmary_spr;
//extern paletteInfo bmary_spr_Palettes;

//extern spriteInfo toki_spr;
//extern paletteInfo toki_spr_Palettes;

void aSpriteDemo() {
	int x=87;
	int y=136;
	int i,relX,relY;
	short showdebug=false;
	aSprite demoSpr;
	Picture ptr,tleft,bright;

	clearFixLayer();
	volMEMWORD(0x401ffe)=0x7bbb; //BG color
	initGfx();

	aSpriteInit(&demoSpr,&toki_spr,1,16,x,y,0,FLIP_NONE);
	palJobPut(16,toki_spr_Palettes.palCount,&toki_spr_Palettes.data);

	//pictureInit(&ptr,&pointer,200,200,0,224,FLIP_NONE);
	//palJobPut(200,pointer_Palettes.palCount,&pointer_Palettes.data);

	//pictureInit(&tleft,&topleft,201,201,0,224,FLIP_NONE);
	//pictureInit(&bright,&topleft,202,201,0,224,FLIP_XY);
	//palJobPut(201,topleft_Palettes.palCount,&topleft_Palettes.data);

	SCClose();
	while(1) {
		wait_vblank();

		p1=volMEMBYTE(P1_CURRENT);
		p1e=volMEMBYTE(P1_EDGE);
		p2=volMEMBYTE(P2_EDGE);
		ps=volMEMBYTE(PS_CURRENT);
		
		if((ps&P1_START)&&(ps&P2_START)) {
			clearSprites(1, 4);
			clearSprites(200, 3);
			SCClose();
			wait_vblank();
			return;
		}

		if(p1&JOY_UP)	y--;
		if(p1&JOY_DOWN)	y++;
		if(p1&JOY_LEFT)	x--;
		if(p1&JOY_RIGHT)	x++;

		for(i=0;i<4000;i++);
		jobMeterColor(JOB_BLUE);

//#define BMARY_SPR_ANIM_IDLE 0
//#define BMARY_SPR_ANIM_WALK 1

//#define TOKI_SPR_ANIM_IDLE 0
//#define TOKI_SPR_ANIM_WALK 1
//#define TOKI_SPR_ANIM_TIRIDLE 2
//#define TOKI_SPR_ANIM_SITTING 3
//#define TOKI_SPR_ANIM_TIRSITTING 4
//#define TOKI_SPR_ANIM_SAUT 5
//#define TOKI_SPR_ANIM_AIE 6
		
		// test des 4 premires animations :
		if(p1e&JOY_A)	aSpriteSetAnim(&demoSpr,TOKI_SPR_ANIM_IDLE);
		if(p1e&JOY_B)	aSpriteSetAnim(&demoSpr,TOKI_SPR_ANIM_WALK);
		if(p1e&JOY_C)	aSpriteSetAnim(&demoSpr,TOKI_SPR_ANIM_TIRIDLE);
		if(p1e&JOY_D)	aSpriteSetAnim(&demoSpr,TOKI_SPR_ANIM_SITTING);
		
//		if(p1e&JOY_C) {
//			if(showdebug) {
//				showdebug=false;
				//move debug stuff offscreen
//				pictureSetPos(&ptr,0,224);
//				pictureSetPos(&tleft,0,224);
//				pictureSetPos(&bright,0,224);
//			} else showdebug=true;
//		}
		if(p2&JOY_A)	aSpriteFlip(&demoSpr,FLIP_NONE);
		if(p2&JOY_B)	aSpriteFlip(&demoSpr,FLIP_X);
		if(p2&JOY_C)	aSpriteFlip(&demoSpr,FLIP_Y);
		if(p2&JOY_D)	aSpriteFlip(&demoSpr,FLIP_XY);

		aSpriteSetPos(&demoSpr,x,y);
		aSpriteAnimate(&demoSpr);
		
		//aSprite debug info
		if(showdebug) {
			pictureSetPos(&ptr,x,y);
			if(demoSpr.currentFlip&0x0001) relX=x-((demoSpr.currentFrame->tileWidth<<4)+demoSpr.currentStep->shiftX);
				else relX=x+demoSpr.currentStep->shiftX;
			if(demoSpr.currentFlip&0x0002) relY=y-((demoSpr.currentFrame->tileHeight<<4)+demoSpr.currentStep->shiftY);
				else relY=y+demoSpr.currentStep->shiftY;
			pictureSetPos(&tleft,relX,relY);
			pictureSetPos(&bright,relX+((demoSpr.currentFrame->tileWidth-1)<<4),relY+((demoSpr.currentFrame->tileHeight-1)<<4));
		}

		jobMeterColor(JOB_GREEN);
		SCClose();
	}
}

const char sinTable[] = {32,34,35,37,38,40,41,43,44,46,47,48,50,51,52,53,
								55,56,57,58,59,59,60,61,62,62,63,63,63,64,64,64,
								64,64,64,64,63,63,63,62,62,61,60,59,59,58,57,56,
								55,53,52,51,50,48,47,46,44,43,41,40,38,37,35,34,
								32,30,29,27,26,24,23,21,20,18,17,16,14,13,12,11,
								9,8,7,6,5,5,4,3,2,2,1,1,1,0,0,0,
								0,0,0,0,1,1,1,2,2,3,4,5,5,6,7,8,
								9,11,12,13,14,16,17,18,20,21,23,24,26,27,29,30};



void tempTests() {
	int x=0;
	int y=0;
	int i;

	Scroller scroll;

	volMEMWORD(0x401ffe)=0x7bbb; //BG color
	clearFixLayer();
	initGfx();

	scrollerInit(&scroll, &wohd, 1, 16, x, y);
	palJobPut(16, wohd_Palettes.palCount, wohd_Palettes.data);

	SCClose();
	while(1) {
		wait_vblank();

		p1=volMEMBYTE(P1_CURRENT);
		p1e=volMEMBYTE(P1_EDGE);
		ps=volMEMBYTE(PS_CURRENT);
		
		if((ps&P1_START)&&(ps&P2_START)) {
			clearSprites(1, 21);
			SCClose();
			wait_vblank();
			return;
		}
		
		if(p1&JOY_UP)	y--;
		if(p1&JOY_DOWN)	y++;
		if(p1&JOY_LEFT)	x--;
		if(p1&JOY_RIGHT)	x++;

		for(i=0;i<4000;i++);
		jobMeterColor(JOB_BLUE);
		
		if(p1e&JOY_C) scrollerInit(&scroll, &wohd, 1, 16, x, y);
			else	scrollerSetPos(&scroll, x, y);
		
		jobMeterColor(JOB_GREEN);
		fixPrintf(2,4,0,0,"%04d\xff%04d\xff\xff",x,y);
		SCClose();
	}
}


int main(void) {
	while(1) {
		clearFixLayer();

		wait_vblank();
//		if(setup4P())
//			fixPrintf(8,20,0,0,"4P! :)");
//		else fixPrintf(8,20,0,0,"no 4P :(");

		initGfx();
		volMEMWORD(0x400002)=0xffff; //debug text white
		volMEMWORD(0x401ffe)=0x7bbb; //BG color
		
//		fixPrintf(8,10,0,0,"A - Picture demo");
//		fixPrintf(8,12,0,0,"B - Scroller demo");
		fixPrintf(8,14,0,0,"C - Animated sprite demo");
		fixPrintf(8,16,0,0,"P1&P2 START - Return to menu");
		fixPrintf(8,28,0,0,"DATlib tests - {2014 Hpman");

		while(1) {
			p1=volMEMBYTE(P1_EDGE);
			

			if(p1&JOY_C) {
				aSpriteDemo();
				break;
			}
			if(p1&JOY_D) {
				tempTests();
				break;
			}
		}
	}
}
