#include <genesis.h>

//sapf01.h is generated from sapf01.bmp
//just be sure to put your 16colors bitmap on 'res' folder
// file logo-blue-sapf01-25024.jpg is here for reference : it's the original picture I used
#include "sapf01.h"
#include "sapf02.h"

#define TILE1	1
#define TILE2	2

int main( )
{
	// get the image width (in pixel) ==> should be 8pix aligned
	u16 w = sapf01[0];

	// get the image height (in pixel)  ==> should be 8px aligned
	u16 h = sapf01[1];


	// get the palette at sapf01[2 to 17]
	VDP_setPalette(PAL1, (u16 *) &sapf01[2]);


	// load bitmap data at sapf01[18....] in VRAM
	// w/8 = width in tiles we want to load
	// h/8 = height in tile we want to load
	// w/8 = width in tiles of the bitamp
	// the 3rd arg is needed because you could load only a part of the bitmap if you want but SGDK needs the width as reference
	VDP_loadBMPTileData((u32*) &sapf01[18], TILE1, w/8, h/8, w/8);


	// draw the sapf01 at (12,12)
	VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, TILE1), 0, 0, w/8, h/8);

// problem load bitmap data at sapf02[..?..] in VRAM
    w = sapf02[0];
    h = sapf02[1];
    VDP_loadBMPTileData((u32*) &sapf02[34], TILE2, w/8, h/8, w/8); // 18+16 = 34
    VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, TILE2), 4, 0, w/8, h/8);

	while(1)
	{
		VDP_waitVSync();
	}
	return 0;
}

