#ifndef _AUDIO_H_
#define _AUDIO_H_


#define AUDIO_CHANNEL1      0x00
#define AUDIO_CHANNEL2      0x01
#define AUDIO_CHANNELAUTO   0xFF

#define AUDIO_PAN_LEFT      0x80
#define AUDIO_PAN_RIGHT     0x40
#define AUDIO_PAN_CENTER    0xC0

#define AUDIO_MVS_SILENCE   0x00
#define AUDIO_MVS_ONCE      0x01
#define AUDIO_MVS_LOOP      0x02


u8   isPlayingSample();
void startPlaySample(const u8 *sample, const u32 len, const u16 rate, const u8 pan);
void stopPlaySample();

u8   isPlayingSample2C(const u16 channel);
void startPlaySample2C(const u16 *sample, const u32 len, const u16 channel);
void stopPlaySample2C(const u16 channel);
void stopPlayAllSample2C();

u8   isPlayingMVSTracker();
void stopPlayMVSTracker();
void startPlayMVSTracker(const u8 *song, const u8 cmd);


#endif // _AUDIO_H_
