/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
FVR_LIB (fvrlib.c, fvrlib.h) by Fonzie Voltonov (2003).
Release 2.
---------------------------------------------------------------------
Functions with (K) are based on the "genesis.c" from Kaneda.
Functions with (F) are completely news.
---------------------------------------------------------------------
Special release for ChuChu rocket MD.
---------------------------------------------------------------------
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

#include "fvrlib.h"




int cos_180_int[181]={
10000,9998,9993,9986,
9975,9961,9945,9925,
9902,9876,9848,9816,
9781,9743,9702,9659,
9612,9563,9510,9455,
9396,9335,9271,9205,
9135,9063,8987,8910,
8829,8746,8660,8571,
8480,8386,8290,8191,
8090,7986,7880,7771,
7660,7547,7431,7313,
7193,7071,6946,6819,
6691,6560,6427,6293,
6156,6018,5877,5735,
5591,5446,5299,5150,
5000,4848,4694,4539,
4383,4226,4067,3907,
3746,3583,3420,3255,
3090,2923,2756,2588,
2419,2249,2079,1908,
1736,1564,1391,1218,
1045,871,697,523,
348,174,0,-174,
-348,-523,-697,-871,
-1045,-1218,-1391,-1564,
-1736,-1908,-2079,-2249,
-2419,-2588,-2756,-2923,
-3090,-3255,-3420,-3583,
-3746,-3907,-4067,-4226,
-4383,-4539,-4694,-4848,
-5000,-5150,-5299,-5446,
-5591,-5735,-5877,-6018,
-6156,-6293,-6427,-6560,
-6691,-6819,-6946,-7071,
-7193,-7313,-7431,-7547,
-7660,-7771,-7880,-7986,
-8090,-8191,-8290,-8386,
-8480,-8571,-8660,-8746,
-8829,-8910,-8987,-9063,
-9135,-9205,-9271,-9335,
-9396,-9455,-9510,-9563,
-9612,-9659,-9702,-9743,
-9781,-9816,-9848,-9876,
-9902,-9925,-9945,-9961,
-9975,-9986,-9993,-9998,
-10000};

void fvr_wait_sync(wait);
uchar *fvr_w_music;
uchar *fvr_music;
uchar fvr_music_l;



uchar *fvr_w_sfx;
uchar *fvr_sfx;
uchar fvr_sfx_l;


uchar fvr_joypad_result[6];



/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
xx- fvr_load_tiles
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
void fvr_load_tiles(from, to,decal,source)
ulong source[];
uint  to,from,decal;
  {
    register ulong *pl,from2;
    register uint i,tile_dif;
    tile_dif=to-from;
    from2=from*32;
    pl = (ulong *) GFXCNTL;
    *pl = GFX_WRITE_ADDR(from2);
    pl = (ulong *) GFXDATA;
      for (i = 0; i < tile_dif * 8; i++)
        {*pl =  source[i+decal*8];}
  }


/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
xx- fvr_show_tiles_64
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

void fvr_show_tiles_64(from, to, pal, width, adr, sh, mode)
uint  to,from,pal,width,adr,sh,mode;
  {
    register ulong *pl,adr2;
    register uint nboftiles,j,i,*pw; 
    nboftiles=0;
    adr2=adr;
    pl = (ulong *) GFXCNTL;
    *pl = GFX_WRITE_ADDR(adr2);
    pw = (uint *) GFXDATA;
      for (i = from; i < to; i++)
        {
          if (nboftiles==width)
            {
              nboftiles=0;
	i--;
              adr2=adr2+128;
              *pl = GFX_WRITE_ADDR(adr2);
	}
            else
	{
	  nboftiles++;
                *pw = sh  + i + (pal << 13);
              }
            }
  }

/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
xx- fvr_show_map_64
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

void fvr_show_map_64(from, to, width, pal,dec,adr, sh, mode, source) /*Mode 0: simple. Mode 1: auto reverse*/
uint  to,from,dec,pal,width,adr,sh,mode;
uint source[];
  {
    register ulong *pl,adr2;
    register uint nboftiles,j,i,*pw; 
    nboftiles=0;
    adr2=adr;
    pl = (ulong *) GFXCNTL;
    *pl = GFX_WRITE_ADDR(adr2);
    pw = (uint *) GFXDATA;
      if(mode)/*Mode1: reverse auto*/
        {

        }
      else
       {
          for (i = from; i < to; i++)
            {
              if (nboftiles==width)
                {
                  nboftiles=0;
                  i--;
                  adr2=adr2+128;
                  *pl = GFX_WRITE_ADDR(adr2);
                }
              else/*Mode0: no reverse*/
               {
                  nboftiles++;
                  *pw = sh  + source[i]+dec + (pal << 13);
               }
             }
       }
  }


/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
xx- fvr_show_map2_64 , this show map include a reverse tile mode
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

void fvr_show_map2_64(from, to, width, pal,dec,adr, sh, mode, source) /*Mode 0: simple. Mode 1: auto reverse*/
uint  to,from,dec,pal,width,adr,sh,mode;
uint source[];
  {
    register ulong *pl,adr2;
    register uint nboftiles,j,i,*pw; 
    nboftiles=0;
    adr2=adr;
    pl = (ulong *) GFXCNTL;
    *pl = GFX_WRITE_ADDR(adr2);
    pw = (uint *) GFXDATA;
      if(mode)/*Mode1: reverse auto*/
        {

        }
      else
       {
          for (i = from; i < to; i++)
            {
              if (nboftiles==width)
                {
                  nboftiles=0;
                  i--;
                  adr2=adr2+128;
                  *pl = GFX_WRITE_ADDR(adr2);
                }
              else/*Mode0: no reverse*/
               {
                  nboftiles++;
                  *pw = sh  + source[i*2+1]+dec + (pal << 13) + source[i*2]; /*0x800 to reverse verticaly, 0x1800 to reverse double, 0x1000 to reverse horizontaly*/
               }
             }
       }
  }

/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
02- fvr_clone_tile_64
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

void fvr_clone_tile_64(id, nb, pal, width, adr, sh)
uint  nb,id,pal,width,adr,sh;
  {
    register ulong *pl,adr2;
    register uint nboftiles,j,i,*pw; 
    nboftiles=0;
    adr2=adr;
    pl = (ulong *) GFXCNTL;
    *pl = GFX_WRITE_ADDR(adr2);
    pw = (uint *) GFXDATA;
      for (i = 0; i < nb; i++)
        {
          if (nboftiles==width)
            {
              nboftiles=0;
	i--;
              adr2=adr2+128;
              *pl = GFX_WRITE_ADDR(adr2);
	}
            else
	{
	  nboftiles++;
                *pw = sh  + id + (pal << 13);
              }
            }
  }
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
xx- fvr_set_pal
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
void fvr_set_pal(id, pal)
uint  id,*pal;
  {
    register ulong *pl,decal;
    register uint *pw,x;
    decal = id * 32;
    pl = (ulong *) GFXCNTL;
    *pl = GFX_COLOR_WRITE_ADDR(decal);
    pw = (uint *) GFXDATA;
      for (x = 0; x < 16; x++)
        {*pw=pal[x];}
  }


/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
xx- fvr_set_pal
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
void fvr_fade_pal(palSrc, palDest, palNum,time,nb)
uint *palSrc,*palDest;
uint palNum, time,nb;
{
    uint tmp_pal[16], i, j,*pw,step;
    char signe_1[16];
    register ulong *pl,decal;
    step=0;

    /* see set_colors() */
    decal = (32 * palNum);

    /* Initialize a temporary palette */
    for (i = 0; i < 16; i++)
    {
        tmp_pal[i] = palSrc[i];
        if (tmp_pal[i] >palDest[i])
          {
         	signe_1[i]=-1;
          }
        else
          {
        	signe_1[i]=1;
          }
    }

    /* Fade in loop */
    for (i = 0; i < nb; i++)
    {
        /* Setup GFX to save colors */
        pl = (ulong *) GFXCNTL;
        *pl = GFX_COLOR_WRITE_ADDR(decal);

        /* Setup GFX data register */
        pw = (uint *) GFXDATA;
        
        /* Increment one color B,G,R at a time */
        for (j = 0; j < 16; j++)
        {
            /* increment BLUE till reaching target color */
            if ( (tmp_pal[j] & 0xf00) != (palDest[j] & 0xf00)) tmp_pal[j] += signe_1[j]*0x100;
            /* check GREEN */
            if ( (tmp_pal[j] & 0xf0) != (palDest[j] & 0xf0))	tmp_pal[j] += signe_1[j]*0x10;
            /* check RED */
            if ( (tmp_pal[j] & 0xf) != (palDest[j] & 0xf) )	tmp_pal[j] += signe_1[j]*0x1;

            /* Store color */
            *pw = tmp_pal[j];
        }
     fvr_wait_sync(time);        
    }
}
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
xx- fvr_joypad_read
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/


fvr_joypad_read()
  {
    register uint w4p=0;
    register uchar *pb,*pb2,k,k2;
    register uint i, j;
    /*Test multitap*/
/*
    pb = (uchar *) 0xa10009;
    *pb = 0x40;
    pb = (uchar *) 0xa1000B;
    *pb = 0x7F;
    pb = (uchar *) 0xa10005;
    *pb = 0x7C;     
    
    pb = (uchar *) 0xa10003;*/
    k=1/**pb*/;

      if(k)
        {
          fvr_joypad_result[0]=0; /*nom*/
          pb = (uchar *) 0xa10003;
          *pb = 0x40;        
          asm("nop");
          asm("nop");
           i = *pb & 0x3f;
          *pb = 0;          
          asm("nop");
          asm("nop");
          j = (*pb & 0x30) << 2;
          fvr_joypad_result[1]=(~(i|j)); /*p1*/ 

          pb = (uchar *) 0xa10005;
          *pb = 0x40;       
          asm("nop");
          asm("nop");
          i = *pb & 0x3f;
          *pb = 0;          
          asm("nop");
          asm("nop");
          j = (*pb & 0x30) << 2;
          fvr_joypad_result[2]=(~(i|j)); /*p2*/ 

          fvr_joypad_result[3]=0; /*Multitap p3*/
          fvr_joypad_result[4]=0; /*Multitap p4*/
        }
       else
        {
          fvr_joypad_result[0]=1; /*Multitap*/

          pb= (uchar *) 0xA10005;
          pb2= (uchar *)0xA10003;

          *pb=0x0C;
          asm("nop");
          asm("nop");
          *pb2=0x40;
          asm("nop");
          asm("nop");
          k=*pb2;
          k=k&0x3F;
          *pb2=0;
          asm("nop");
          asm("nop");
          k2=*pb2;
          k2=k2<<2;
          k2=k2&0xC0;
       
          fvr_joypad_result[1]=k2|k; /*Multitap p1*/
          fvr_joypad_result[2]=k2|k; /*Multitap p2*/
          fvr_joypad_result[3]=0; /*Multitap p3*/
          fvr_joypad_result[4]=0; /*Multitap p4*/
        }
  }



/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
xx- fvr_wait_sync
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
void fvr_wait_sync(wait)
int wait;
  {
    register ulong x;
    x = vtimer+1;
     while(wait>=0)
     {wait--;
      while (x > vtimer)
        {/*1+1=2*/}
     }
  }





/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
12- fvr_scroll_vert
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
void fvr_scroll_vert(sa,sb)
int  sa,sb;
  {
    register uint *pw,i;
    register ulong *pl;
    pl = (ulong *) GFXCNTL;
    *pl = GFX_VERT_SCROLL(0);
    pw = (uint *) GFXDATA;
      for(i=0;i<20;i++)
        {
        *pw =sa;
        *pw =sb;
        }
  }

void fvr_scroll_vert2(sa,sb)
int  sa,sb;
  {
    register uint *pw,i;
    register ulong *pl;
    pl = (ulong *) GFXCNTL;
    *pl = GFX_VERT_SCROLL(0);
    pw = (uint *) GFXDATA;
      for(i=0;i<20;i++)
        {
        *pw =sa;
        *pw =sb+(sb*i)/20;
        }
  }
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
13- fvr_scroll_horz
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
void fvr_scroll_horz(sa,sb)
int  sa,sb;
  {
    register uint *pw,i;
    register ulong *pl;
    pl = (ulong *) GFXCNTL;
    *pl = GFX_WRITE_ADDR(0xD000);
    pw = (uint *) GFXDATA;
      for(i=0;i<224;i++)
        {
        *pw =sa;
        *pw =sb;
        }
  }

void fvr_scroll_horz2(sa,sb)
int  sa,sb;
  {
    register uint *pw,i,k=0;
    register ulong *pl;
    pl = (ulong *) GFXCNTL;
    *pl = GFX_WRITE_ADDR(0xD000);
    pw = (uint *) GFXDATA;
      for(i=0;i<224;i++)
        {

        *pw =sa+(sa*i)/300;
        *pw =sb+(sb*i)/300;
        }
  }

