*;-------------------------------------------------------
*;
*;       Sega startup code for the Sozobon C compiler
*;       Written by Paul W. Lee
*;       Modified from Charles Coty's code
*;
*;-------------------------------------------------------

	org	$0
	dc.l	$0,$200
	dc.l	INT,INT,INT,INT,INT,INT,INT
	dc.l	INT,INT,INT,INT,INT,INT,INT,INT
	dc.l	INT,INT,INT,INT,INT,INT,INT,INT
	dc.l	INT,INT,INT,HBL,INT,VBL,INT,INT
	dc.l	INT,INT,INT,INT,INT,INT,INT,INT
	dc.l	INT,INT,INT,INT,INT,INT,INT,INT
	dc.l	INT,INT,INT,INT,INT,INT,INT,INT
	dc.l	INT,INT,INT,INT,INT,INT,INT

	dc.b	'SEGA MEGA DRIVE '						; Console name. 16 bytes long
	dc.b	'(C)SEGA 2005.APR'						; Copyright notice. 16 bytes long
	dc.b	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	dc.b	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	dc.b	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00	; Domestic game name. 48 bytes long
	dc.b	'ob',$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	dc.b	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	dc.b	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00	; Overseas game name. 48 bytes long
	dc.b	'GM'								; Type of product. 2 bytes long
	dc.b	' 00000000-00'							; Product code, version number. 12 bytes long
	dc.w	$FDDB								; Checksum. 2 bytes long
	dc.b	'J               '						; I/O support. 16 bytes
	dc.l	$00000000,$00020000						; ROM capacity (start, end). 4 bytes long each.
	dc.l	$00FF0000,$FFFFFFFF						; RAM (start, end). 4 bytes long each
	dc.b	'            '							; Padder. 12 bytes long
	dc.b	'            '							; Modem. 12 bytes long
	dc.b	'                                        '			; Memo. 40 bytes long
	dc.b	'E               '						; Country game. 16 bytes long

	tst.l	$a10008
	bne	SkipJoyDetect                             
	tst.w	$a1000c
SkipJoyDetect:
	bne	SkipSetup
	lea	Table,a5
	movem.w	(a5)+,d5-d7
	movem.l	(a5)+,a0-a4
	move.b	-$10ff(a1),d0          ; Check Version Number                      
	andi.b	#$0f,d0
	beq	WrongVersion
	move.l	#$53454741,$2f00(a1)   ; Sega Security Code (SEGA)   
WrongVersion:
	move.w	(a4),d0
	moveq	#$00,d0
	movea.l	d0,a6
	move	a6,usp
	moveq	#$17,d1                ; Set VDP registers
FillLoop:
	move.b	(a5)+,d5
	move.w	d5,(a4)
	add.w	d7,d5
	dbra	d1,FillLoop
	move.l	(a5)+,(a4)
	move.w	d0,(a3)
	move.w	d7,(a1)
	move.w	d7,(a2)
L0250:
	btst	d0,(a1)
	bne	L0250
	moveq	#$25,d2                ; Put initial vaules into a00000                
Filla:
	move.b	(a5)+,(a0)+
	dbra	d2,Filla
	move.w	d0,(a2)
	move.w	d0,(a1)
	move.w	d7,(a2)
L0262:
	move.l	d0,-(a6)
	dbra	d6,L0262
	move.l	(a5)+,(a4)
	move.l	(a5)+,(a4)
	moveq	#$1f,d3                ; Put initial values into c00000                  
Filc0:
	move.l	d0,(a3)
	dbra	d3,Filc0
	move.l	(a5)+,(a4)
	moveq	#$13,d4                ; Put initial values into c00000                 
Fillc1:
	move.l	d0,(a3)
	dbra	d4,Fillc1
	moveq	#$03,d5                ; Put initial values into c00011                 
Fillc2:
	move.b	(a5)+,$0011(a3)
	dbra	d5,Fillc2
	move.w	d0,(a2)
	movem.l	(a6),d0-d7/a0-a6
	move	#$2700,sr
SkipSetup:
	bra	Continue
Table:
	dc.w	$8000,$3fff,$0100,$00a0,$0000,$00a1,$1100,$00a1
	dc.w	$1200,$00c0,$0000,$00c0,$0004,$0414,$302c,$0754
	dc.w	$0000,$0000,$0000,$812b,$0001,$0100,$00ff,$ff00
	dc.w	$0080,$4000,$0080,$af01,$d91f,$1127,$0021,$2600
	dc.w	$f977,$edb0,$dde1,$fde1,$ed47,$ed4f,$d1e1,$f108
	dc.w	$d9c1,$d1e1,$f1f9,$f3ed,$5636,$e9e9,$8104,$8f01
	dc.w	$c000,$0000,$4000,$0010,$9fbf,$dfff

Continue:
	tst.w    $00C00004

	move.l   #$0,a7              ; set stack pointer

	move.w  #$2300,sr       ; user mode

	lea     $ff0000,a0      ; clear Genesis RAM
	moveq   #0,d0
clrram: move.w  #0,(a0)+
	subq.w  #2,d0
	bne     clrram

*;----------------------------------------------------------        
*;
*;       Load driver into the Z80 memory
*;
*;----------------------------------------------------------        

	move.w  #$100,$a11100     ; halt the Z80
	move.w  #$100,$a11200     ; reset it

	lea     Z80Driver,a0
	lea     $a00000,a1
	move.l  #Z80DriverEnd,d0
	move.l  #Z80Driver,d1
	sub.l   d1,d0
Z80loop:
	move.b  (a0)+,(a1)+
	subq.w  #1,d0
	bne     Z80loop

	move.w  #$0,$a11100       ; enable the Z80

*;----------------------------------------------------------        

	jmp	main

INT:    
	rte

*; --- Do nothing for this demo ---
HBL:
	rte

VBL:
	addq.l	#1,vtimer
	rte

*;----------------------------------------------------------
*;
*;       Z80 Sound Driver
*;
*;----------------------------------------------------------
Z80Driver:
	dc.b	$c3,$46,$00,$00,$00,$00,$00,$00
	dc.b	$00,$00,$00,$00,$00,$00,$00,$00
	dc.b	$00,$00,$00,$00,$00,$00,$00,$00
	dc.b	$00,$00,$00,$00,$00,$00,$00,$00
	dc.b	$00,$00,$00,$00,$00,$00,$00,$00
	dc.b	$00,$00,$00,$00,$00,$00,$00,$00
	dc.b	$00,$00,$00,$00,$00,$00,$00,$00
	dc.b	$00,$00,$00,$00,$00,$00,$00,$00
	dc.b	$00,$00,$00,$00,$00,$00,$f3,$ed
	dc.b	$56,$31,$00,$20,$3a,$39,$00,$b7
	dc.b	$ca,$4c,$00,$21,$3a,$00,$11,$40
	dc.b	$00,$01,$06,$00,$ed,$b0,$3e,$00
	dc.b	$32,$39,$00,$3e,$b4,$32,$02,$40
	dc.b	$3e,$c0,$32,$03,$40,$3e,$2b,$32
	dc.b	$00,$40,$3e,$80,$32,$01,$40,$3a
	dc.b	$43,$00,$4f,$3a,$44,$00,$47,$3e
	dc.b	$06,$3d,$c2,$81,$00,$21,$00,$60
	dc.b	$3a,$41,$00,$07,$77,$3a,$42,$00
	dc.b	$77,$0f,$77,$0f,$77,$0f,$77,$0f
	dc.b	$77,$0f,$77,$0f,$77,$0f,$77,$3a
	dc.b	$40,$00,$6f,$3a,$41,$00,$f6,$80
	dc.b	$67,$3e,$2a,$32,$00,$40,$7e,$32
	dc.b	$01,$40,$21,$40,$00,$7e,$c6,$01
	dc.b	$77,$23,$7e,$ce,$00,$77,$23,$7e
	dc.b	$ce,$00,$77,$3a,$39,$00,$b7,$c2
	dc.b	$4c,$00,$0b,$78,$b1,$c2,$7f,$00
	dc.b	$3a,$45,$00,$b7,$ca,$4c,$00,$3d
	dc.b	$3a,$45,$00,$06,$ff,$0e,$ff,$c3
	dc.b	$7f,$00
Z80DriverEnd:


******************************************************************************************
*********************                  PROGRAMME                  ************************
******************************************************************************************

main:

GFX_CTRL	equ	$C00004
GFX_DATA	equ	$C00000

vtimer	equ	$FF0000		; LONG
a____	equ	$FF0004		; WORD		; Scrolling horizontal du plan B
Xship	equ	$FF0006		; WORD		; Abscisse du vaisseau
Yship	equ	$FF0008		; WORD		; Ordonne du vaisseau
pVaccX	equ	$FF000A		; BYTE		; Pointeur sur l'acclration horizontale du vaisseau
pVaccY	equ	$FF000B		; BYTE		; Pointeur sur l'acclration verticale du vaisseau
Tacc	equ	$FF000C		; LONG		; Pointeur sur le tableau d'acclration
Vacc	equ	$FF0010		; BYTE[]	; Acclration du vaisseau
Vacc2	equ	$FF0030		; BYTE[]	; Acclration 2 du vaisseau
YBpos	equ	$FF0050		; BYTE		; Position verticale du plan B
YApos	equ	$FF0051		; BYTE		; Position verticale du plan A
XBscrl	equ	$FF0052		; WORD		; Scrolling horizontal du plan B
YBscrl	equ	$FF0054		; WORD		; Scrolling vertical du plan B
XAscrl	equ	$FF0056		; WORD		; Scrolling horizontal du plan A
YAscrl	equ	$FF0058		; WORD		; Scrolling vertical du plan A

Vacc_l	equ	$20				; Taille du tableau
Vinert	equ	8				; Inertie : quand je change brusquement de direction, de combien ma vitesse est inverse
XdrawS	equ	128				; Les sprites sont dessins horizontalement  partir de 128
XdrawE	equ	384				; Les sprites sont dessins horizontalement jusqu' 384 (32 cell mode)
YdrawS	equ	128				; Les sprites sont dessins verticalement  partir de 128
YdrawE	equ	384				; Les sprites sont dessins verticalement jusqu' 368 (PAL)

SR9asc	equ	1				; Adresse des sprites du R9
SR92asc	equ	9
SR9	equ	17
SR92desc	equ	25
SR9desc	equ	33


	move.l	#GFX_CTRL,a0
	move.l	#GFX_DATA,a1

	move.w	#$8016,GFX_CTRL	; H int
	move.w	#$817C,GFX_CTRL	; Genesis disp mode, Disp enabled, V int, DMA, PAL
	move.w	#$8228,GFX_CTRL	; A plane = $A000	$60000002
	move.w	#$8338,GFX_CTRL	; W plane = $E000	$60000003
	move.w	#$8406,GFX_CTRL	; B plane = $C000	$40000003
	move.w	#$857A,GFX_CTRL	; sprites = $F400	$74000003
	move.w	#$8701,GFX_CTRL	; Background color 0
	move.w	#$8A01,GFX_CTRL	; H int register
	move.w	#$8B00,GFX_CTRL	; full screen V scroll, full screen H scroll
	move.w	#$8C00,GFX_CTRL	; Display 32 cell mode
	move.w	#$8D3C,GFX_CTRL	; H scroll = $F000	$70000003	(V scroll $40000010)
	move.w	#$8F02,GFX_CTRL	; Auto-increment 2
	move.w	#$9000,GFX_CTRL	; 32x32 scroll size

	jsr	port_setup	; initialize the joypad port

init:
	move.l	#Vacc,(Tacc)
	move	#240,Yship
	move	#240,Xship

	move.w	#Vacc_l,d0
	lsr	#1,d0
	subq	#1,d0		; d0 = t.length/2-1
	move.b	d0,pVaccY
	move.b	d0,pVaccX

	move.l	#Vacc,a2
	lea 	acceleration,a3
	move.w	#Vacc_l,d0
	subq	#1,d0
load_acc:
	move.b	(a3)+,(a2)+
	dbra	d0,load_acc

	move.l	#Vacc2,a2
	lea 	acceleration2,a3
	move.w	#Vacc_l,d0
	subq	#1,d0
load_acc2:
	move.b	(a3)+,(a2)+
	dbra	d0,load_acc2


* LOAD PALETTE
	lea	palette,a2
	move.l	#$C0000000,GFX_CTRL
	move.w	#2,d0			; 2 palette
	muls	#16,d0
	subq.w	#1,d0
load_palette:
	move.w	(a2)+,(a1)
	dbra	d0,load_palette

* LOAD TILES
	move.l	#$40000000,GFX_CTRL
	lea	tiles,a2
	move.w	#54,d0			; 54 tiles
	muls	#8,d0
	subq.w	#1,d0
load_tiles:
	move.l	(a2)+,(a1)
	dbra	d0,load_tiles

* DEF SPRITES
	move.l	#$74000003,GFX_CTRL	; Sprites
	move.w	Yship,GFX_DATA		; Yship
	move.w	#$0D00,GFX_DATA		; 4x2 tiles, no linked sprite
	move.w	#$0001,GFX_DATA		; priority = 0, no Hflip, no Vflip, Pal 1, Tile 1
	move.w	Xship,GFX_DATA		; Xship



main_loop:
	nop

	move	#1023,d0
	move.l	#$40000003,GFX_CTRL
loop_B:
	move.w	#41,(a1)
	dbra	d0,loop_B

	move.l	#$40020010,GFX_CTRL
	move.w	XBscrl,GFX_DATA
	subq	#1,XBscrl

* int m = t.length/2-1;		// Milieu du tableau
* if (JOY_UP) {
*	if (pVaccY>0) {
*		if (pVaccY>m) {
*		// Je suis en train de descendre, et je remonte.
*		// Il faut que la remonte se fasse plus vite que si je lchais simplement la manette
*			pVaccY--;
*		}
*		pVaccY--;
*	}
* } else {
*	if (JOY_DOWN) {
*		if (pVaccY<t.length-1) {
*			if (pVaccY<m) {
*				pVaccY++;
*			}
*			pVaccY++;
*		}
*	} else {
*		// Inertie
*		if (pVaccY>m) {
*			pVaccY--;
*		} else {
*			if (pVaccY<m) {
*				pVaccY++;
*			}
*		}
*	}
* }

* JOYSTICK
	bsr	porta

	moveq	#0,d2
	move.b	(pVaccY),d2
	move.w	#Vacc_l,d3
	lsr	#1,d3
	subq	#1,d3		; d3 = t.length/2-1

IF_JOY_UP:
	moveq	#$1,d1
	and	d0,d1
	beq	ELSE_JOY_UP

IF_V_MIN:
	cmpi.b	#0,d2
	ble	ENDIF_V_MIN
IF_V_BRAKE:
	cmp	d3,d2
	blt	ENDIF_V_BRAKE
	subq	#Vinert,d2
ENDIF_V_BRAKE:
	subq	#1,d2
ENDIF_V_MIN:	

	bra	ENDIF_JOY_UP
ELSE_JOY_UP:

IF_JOY_DOWN:
	moveq	#$2,d1
	and	d0,d1
	beq	ELSE_JOY_DOWN

IF_V_MAX:
	move	#Vacc_l,d4
	subq	#1,d4
	cmp.w	d4,d2
	bge	ENDIF_V_MAX
IF_V_ACC:
	cmp.w	d3,d2
	bge	ENDIF_V_ACC
	addq	#Vinert,d2
ENDIF_V_ACC:
	addq	#1,d2	
ENDIF_V_MAX:

	bra	ENDIF_JOY_DOWN
ELSE_JOY_DOWN:

IF_V_INERTIE:
	cmp	d3,d2
	ble	ELSE_V_INERTIE
	subq	#1,d2
	bra	ENDIF_V_INERTIE
ELSE_V_INERTIE:
	bge	ENDIF_V_INERTIE
	addq	#1,d2
ENDIF_V_INERTIE:

ENDIF_JOY_DOWN:

ENDIF_JOY_UP:

	move.b	d2,(pVaccY)	; Pointeur d'acclration

	move.l	(Tacc),a2
	add	d2,a2
	move.b	(a2),d2
	ext.w	d2		; On tend d2 pour prendre en compte les valeurs ngatives. d2 = Acclration

* CHOIX DU SPRITE
	move.l	#$74040003,GFX_CTRL	; Sprites
IF_R9_ASC:
	cmp.w	#-4,d2
	bgt	ELSE_R9_ASC
	move.w	#SR9asc,GFX_DATA
	bra	ENDIF_R9_ASC
ELSE_R9_ASC:

IF_R9_2ASC:
	cmp.w	#-2,d2
	bge	ELSE_R9_2ASC
	move.w	#SR92asc,GFX_DATA
	bra	ENDIF_R9_2ASC
ELSE_R9_2ASC:

IF_R9_2DESC:
	cmp.w	#2,d2
	bge	ELSE_R9_2DESC
	move.w	#SR9,GFX_DATA
	bra	ENDIF_R9_2DESC
ELSE_R9_2DESC:

IF_R9_DESC:
	cmp.w	#4,d2
	bge	ELSE_R9_DESC
	move	#SR92desc,GFX_DATA
	bra	ENDIF_R9_DESC
ELSE_R9_DESC:
	move	#SR9desc,GFX_DATA
ENDIF_R9_DESC:

ENDIF_R9_2DESC:

ENDIF_R9_2ASC:

ENDIF_R9_ASC:





	add.w	d2,(Yship)	; Dplacement

	move.l	#$74000003,GFX_CTRL	; Sprite 1 ypos
	move	Yship,GFX_DATA

	moveq	#0,d2
	move.b	(pVaccX),d2
	move.w	#Vacc_l,d3
	lsr	#1,d3
	subq	#1,d3		; d3 = t.length/2-1

IF_JOY_LEFT:
	moveq	#$4,d1
	and	d0,d1
	beq	ELSE_JOY_LEFT

IF_H_MIN:
	cmpi.b	#0,d2
	ble	ENDIF_H_MIN
IF_H_BRAKE:
	cmp	d3,d2
	blt	ENDIF_H_BRAKE
	subq	#Vinert,d2
ENDIF_H_BRAKE:
	subq	#1,d2
ENDIF_H_MIN:	

	bra	ENDIF_JOY_LEFT
ELSE_JOY_LEFT:

IF_JOY_RIGHT:
	moveq	#$8,d1
	and	d0,d1
	beq	ELSE_JOY_RIGHT

IF_H_MAX:
	move	#Vacc_l,d4
	subq	#1,d4
	cmp.w	d4,d2
	bge	ENDIF_H_MAX
IF_H_ACC:
	cmp.w	d3,d2
	bge	ENDIF_H_ACC
	addq	#Vinert,d2
ENDIF_H_ACC:
	addq	#1,d2	
ENDIF_H_MAX:

	bra	ENDIF_JOY_RIGHT
ELSE_JOY_RIGHT:

IF_H_INERTIE:
	cmp	d3,d2
	ble	ELSE_H_INERTIE
	subq	#1,d2
	bra	ENDIF_H_INERTIE
ELSE_H_INERTIE:
	bge	ENDIF_H_INERTIE
	addq	#1,d2
ENDIF_H_INERTIE:

ENDIF_JOY_RIGHT:

ENDIF_JOY_LEFT:

	move.b	d2,(pVaccX)	; Pointeur d'acclration

	move.l	(Tacc),a2
	add	d2,a2
	move.b	(a2),d2
	ext.w	d2		; On tend pour prendre en compte les valeurs ngatives. d2 = Acclration

* Limites  gauche et limite  droite
	add	(Xship),d2	; Nouvelle position potentielle
IF_LEFT:
	cmp	#XdrawS,d2
	bge	ELSE_LEFT
	move	#XdrawS,(Xship)
	bra	END_LEFT
ELSE_LEFT:
	move	#XdrawE,d3
	sub	#32,d3		; Le sprite fait 32 de large
IF_RIGHT:
	cmp	d3,d2
	ble	ELSE_RIGHT
	move	#352,(Xship)
	bra	END_RIGHT
ELSE_RIGHT:
	move	d2,(Xship)
END_RIGHT:

END_LEFT:

	move.l	#$74060003,GFX_CTRL	; Sprite 1 ypos
	move	Xship,GFX_DATA

	moveq	#$40,d1		; BUTTON_A
	and	d0,d1
	beq	E_BUT_A
	move.l	#Vacc,(Tacc)
E_BUT_A:
	moveq	#$10,d1		; BUTTON_B
	and	d0,d1
	beq	E_BUT_B
	move.l	#Vacc2,(Tacc)
E_BUT_B:
	moveq	#$20,d1		; BUTTON_C
	and	d0,d1
	beq	E_BUT_C
E_BUT_C:
	moveq	#$80,d1		; BUTTON_START	; Warning --- Value not in range: [-128,-1]
	and	d0,d1
	beq	E_BUT_S
E_BUT_S:

	bsr vsync		; wait for vsync 
	bra main_loop		; infinite loop


******************************************************************************************
*********************              FIN DU PROGRAMME               ************************
******************************************************************************************

* Wait for vsync by Paul Lee
vsync:
	move.l	vtimer,d0
	moveq	#0,d6
vsloop:
	addq	#1,d6
	cmp.l	vtimer,d0
	beq	vsloop
	move	d6,d7
	rts

*-------------------------------------------------------------------------
*
*       Setup the port registers to read joysticks.
*
*       Joypad support functions by Paul Lee
*
*-------------------------------------------------------------------------

port_setup:
	moveq	#$40,d0
	move.b	d0,$a10009
	move.b	d0,$a1000b
	move.b	d0,$a1000d
	rts

*-------------------------------------------------------------------------
*
*       Check for input from Joypad
*       Output:
*               d0 : Status of Joypad 1
*		d2 : Status of Joypad 2
*       Registers used:
*               d0, d1, d2, d3
*	Details:
*		On travaille sur des bytes. Donc, s'il y a des donnes 
*		WORD ou LONG dans les registres, on garde ces valeurs.
*		Pour la gestion, ceci peut tre problmatique. J'initialise
*		les registres d1 et d0 avec moveq. Ceci prend 4 cycles, donc
*		le mme temps qu'un nop. Je le remplace.
*
*-------------------------------------------------------------------------

porta:
	move.b	#$40,$a10003
	nop
*	nop
	moveq	#$0,d1		; Rajout OB
	move.b	$a10003,d1
	andi.b	#$3f,d1
	move.b	#0,$a10003
	nop
*	nop
	moveq	#$0,d0		; Rajout OB
	move.b	$a10003,d0
	andi.b	#$30,d0
	lsl.b	#2,d0
	or.b	d1,d0
	not.b	d0
	rts

portb:
	move.b	#$40,$a10005
	nop
	nop
	move.b	$a10005,d3
	andi.b	#$3f,d3
	move.b	#$00,$a10005
	nop
	nop
	move.b	$a10005,d2
	andi.b	#$30,d2
	lsl.b	#2,d2
	or.b	d3,d2
	not.b	d2
	rts


******************************************************************************************
*********************                  DONNEES                    ************************
******************************************************************************************

acceleration:
	dc.b	-4,-3,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,0
	dc.b	1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,4

acceleration2:
	dc.b	-5,-4,-4,-4,-3,-3,-3,-3,-2,-2,-2,-2,-1,-1,-1,0
	dc.b	1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,5

palette:
* PALETTE SPRITE
	dc.w	$000	; 0
	dc.w	$000	; 1 = Noir
	dc.w	$460	; 2 = Vert de gris
	dc.w	$EEE	; 3 = Blanc
	dc.w	$CCC	; 4 = Gris clair
	dc.w	$444	; 5 = Gris fonc
	dc.w	$00E	; 6 = Rouge
	dc.w	$88E	; 7 = Saumon
	dc.w	$EE0	; 8 = Cyan
	dc.w	$C80	; 9 = Turquoise
	dc.w	$840	; A = Marine
	dc.w	$0EE	; B = Jaune
	dc.w	$0CC	; C = Jaune fonc
	dc.w	$036	; D = Marron
	dc.w	$000	; E
	dc.w	$000	; F

* PALETTE DECOR
	dc.w	$000	;
	dc.w	$000	; 1 = Noir
	dc.w	$CEE	; 2 = Sable clair
	dc.w	$ACC	; 3 = Sable
	dc.w	$CCC	; 4 = Sable fonc
	dc.w	$044	; 5 = Vert marron
	dc.w	$024	; 6 = Marron


tiles:
* La tile 0 est la tile applique au background. Elle devrait toujours tre vide.
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000

* R9 montant			; TILE 1
	dc.l	$00000000
	dc.l	$00666000
	dc.l	$00006670
	dc.l	$30020664
	dc.l	$03322044
	dc.l	$00544454
	dc.l	$04055245
	dc.l	$53400544

	dc.l	$02344555
	dc.l	$02511555
	dc.l	$04511555
	dc.l	$02344555
	dc.l	$02500555
	dc.l	$05000005
	dc.l	$00000000
	dc.l	$00000000

	dc.l	$00000000
	dc.l	$00000000
	dc.l	$33333333
	dc.l	$00222222
	dc.l	$5544BBBB
	dc.l	$44425CCC
	dc.l	$44255511
	dc.l	$22555555

	dc.l	$55544445
	dc.l	$55422224
	dc.l	$55222222
	dc.l	$55222222
	dc.l	$5552222B
	dc.l	$500200CC
	dc.l	$02255555
	dc.l	$00000000

	dc.l	$00000000
	dc.l	$00000000
	dc.l	$33330000
	dc.l	$2223D000
	dc.l	$BB54DDD9
	dc.l	$CCCDD244
	dc.l	$11155552
	dc.l	$55555555

	dc.l	$55555555
	dc.l	$55555555
	dc.l	$55555555
	dc.l	$11155555
	dc.l	$BBBBDDD0
	dc.l	$CCCDD000
	dc.l	$22230000
	dc.l	$00000000

	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$90000000
	dc.l	$49AAA000
	dc.l	$244483A0
	dc.l	$5524483A

	dc.l	$5555248A
	dc.l	$5555524A
	dc.l	$55555548
	dc.l	$55555520
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000

* R9 1/2 montant		; TILE 9
	dc.l	$00000000
	dc.l	$00666700
	dc.l	$00026673
	dc.l	$30032667
	dc.l	$03353555
	dc.l	$40233224
	dc.l	$05024344
	dc.l	$04502244

	dc.l	$03450254
	dc.l	$02344005
	dc.l	$02515550
	dc.l	$05344555
	dc.l	$02500555
	dc.l	$05000000
	dc.l	$00000000
	dc.l	$00000000

	dc.l	$00000000
	dc.l	$00000000
	dc.l	$33333000
	dc.l	$44443333
	dc.l	$55554555
	dc.l	$33333333
	dc.l	$51422222
	dc.l	$4444BBBB

	dc.l	$44421CCC
	dc.l	$44244415
	dc.l	$22455445
	dc.l	$0555555B
	dc.l	$50055BBB
	dc.l	$22000000
	dc.l	$00000000
	dc.l	$00000000

	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$000A9990
	dc.l	$44449889
	dc.l	$33334488
	dc.l	$2223D244
	dc.l	$B154DDD2

	dc.l	$CCCCC555
	dc.l	$55555555
	dc.l	$51BBB000
	dc.l	$BBCCDDD0
	dc.l	$CCCDD000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000

	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$90000000
	dc.l	$899A0000
	dc.l	$88838A00
	dc.l	$448833A0

	dc.l	$5544833A
	dc.l	$5555489A
	dc.l	$5555544A
	dc.l	$00555520
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000

*R9 normal			; TILE 17
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00021000
	dc.l	$00032444
	dc.l	$00666677
	dc.l	$30051222
	dc.l	$03311111
	dc.l	$00233111

	dc.l	$00025332
	dc.l	$04002524
	dc.l	$03400424
	dc.l	$02343352
	dc.l	$02500335
	dc.l	$05000000
	dc.l	$00000000
	dc.l	$00000000

	dc.l	$00000000
	dc.l	$00000000
	dc.l	$33333000
	dc.l	$44443333
	dc.l	$55554555
	dc.l	$22224111
	dc.l	$15333333
	dc.l	$44544111

	dc.l	$33333333
	dc.l	$12222222
	dc.l	$51455555
	dc.l	$4441BBBB
	dc.l	$22421DCC
	dc.l	$03425530
	dc.l	$00000000
	dc.l	$00000000

	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$330AAA00
	dc.l	$21A989AA
	dc.l	$33488889
	dc.l	$52348888

	dc.l	$33323388
	dc.l	$22442433
	dc.l	$5554D244
	dc.l	$B154DDD0
	dc.l	$CCCDD000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000

	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$A0000000
	dc.l	$9AAA0000
	dc.l	$8993AA00

	dc.l	$888933A0
	dc.l	$8888933A
	dc.l	$3389999A
	dc.l	$043399AA
	dc.l	$00003330
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000

* R9 1/2 descendant		; TILE 25
	dc.l	$00000000
	dc.l	$00666700
	dc.l	$00026333
	dc.l	$21132444
	dc.l	$02456667
	dc.l	$00666722
	dc.l	$24024135
	dc.l	$02402455

	dc.l	$00244155
	dc.l	$04025442
	dc.l	$03402425
	dc.l	$02342255
	dc.l	$02500445
	dc.l	$05000000
	dc.l	$00000000
	dc.l	$00000000

	dc.l	$00000000
	dc.l	$00000000
	dc.l	$33333000
	dc.l	$44443333
	dc.l	$55553555
	dc.l	$22223222
	dc.l	$55555533
	dc.l	$55544444

	dc.l	$44222111
	dc.l	$55451111
	dc.l	$33333333
	dc.l	$12222222
	dc.l	$55055555
	dc.l	$55000000
	dc.l	$00000000
	dc.l	$00000000

	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$000AAAA0
	dc.l	$33A9999A
	dc.l	$54998899
	dc.l	$33888888
	dc.l	$44488888

	dc.l	$12224488
	dc.l	$11444255
	dc.l	$3333CD11
	dc.l	$22233DDD
	dc.l	$55554C00
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000

	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$A0000000
	dc.l	$9AAA0000
	dc.l	$8993AA00
	dc.l	$888833A0

	dc.l	$8888893A
	dc.l	$8888893A
	dc.l	$448899AA
	dc.l	$0044AAA0
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000

* R9 descendant			; TILE 33
	dc.l	$00000000
	dc.l	$00666000
	dc.l	$00006660
	dc.l	$20026333
	dc.l	$02432444
	dc.l	$03254555
	dc.l	$05356667
	dc.l	$23566775

	dc.l	$02667111
	dc.l	$00224455
	dc.l	$03512455
	dc.l	$02344322
	dc.l	$02500355
	dc.l	$05000055
	dc.l	$00000000
	dc.l	$00000000

	dc.l	$00000000
	dc.l	$00000000
	dc.l	$55554444
	dc.l	$33333CCC
	dc.l	$44443444
	dc.l	$55553555
	dc.l	$55553222
	dc.l	$22223553

	dc.l	$11555444
	dc.l	$55552111
	dc.l	$44551111
	dc.l	$5522DDDD
	dc.l	$33333333
	dc.l	$12222222
	dc.l	$55055555
	dc.l	$00000000

	dc.l	$00000000
	dc.l	$00000000
	dc.l	$44320000
	dc.l	$CCCDD000
	dc.l	$33BAAAAA
	dc.l	$44AA9999
	dc.l	$53A98888
	dc.l	$33A88888

	dc.l	$44A88888
	dc.l	$22488888
	dc.l	$1CC24488
	dc.l	$DDDDD244
	dc.l	$333BDCC0
	dc.l	$2233C000
	dc.l	$55540000
	dc.l	$00000000

	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$A0000000
	dc.l	$9AAAA000
	dc.l	$99333AA0
	dc.l	$8888339A

	dc.l	$8888833A
	dc.l	$8888893A
	dc.l	$888899AA
	dc.l	$44AAAAA0
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000

*				; TILE 41
	dc.l	$00000000
	dc.l	$04000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000500
	dc.l	$00005A50
	dc.l	$00000500
	dc.l	$00000000

* DECOR 1a			; TILE 42
	dc.l	$00000001
	dc.l	$00022222
	dc.l	$00111111
	dc.l	$02222222
	dc.l	$02222333
	dc.l	$22223334
	dc.l	$22333344
	dc.l	$33334445

	dc.l	$22223333
	dc.l	$22222222
	dc.l	$11111111
	dc.l	$22222222
	dc.l	$33333333
	dc.l	$44444444
	dc.l	$55555554
	dc.l	$66666666

	dc.l	$33300000
	dc.l	$22222222
	dc.l	$11111111
	dc.l	$22222222
	dc.l	$33333333
	dc.l	$33333333
	dc.l	$43333333
	dc.l	$44333333

	dc.l	$00000000
	dc.l	$22222222
	dc.l	$11111111
	dc.l	$22222222
	dc.l	$33333333
	dc.l	$33333332
	dc.l	$33333222
	dc.l	$33322233

	dc.l	$22222222
	dc.l	$22222222
	dc.l	$11111111
	dc.l	$22222222
	dc.l	$33333333
	dc.l	$22222222
	dc.l	$33333333
	dc.l	$33333333

	dc.l	$22222222
	dc.l	$22222222
	dc.l	$11111111
	dc.l	$22222222
	dc.l	$33333333
	dc.l	$22222222
	dc.l	$33333333
	dc.l	$33333333

	dc.l	$33300000
	dc.l	$22222222
	dc.l	$11111111
	dc.l	$22222222
	dc.l	$33333333
	dc.l	$33333333
	dc.l	$43333333
	dc.l	$44333333

	dc.l	$00000000
	dc.l	$22222000
	dc.l	$11111100
	dc.l	$12121221
	dc.l	$12121221
	dc.l	$33222222
	dc.l	$33333222
	dc.l	$33333322

	org $20000		* Je padde jusqu' 128Ko
