#include "types.h"

#include "vdp.h"
#include "vdp_bg.h"


void VDP_setHorizontalScroll(u16 plan, u16 line, u16 value)
{
    volatile u16 *pw;
    volatile u32 *pl;
    u16 addr;

    /* Point to vdp port */
    pw = (u16 *) GFX_DATA_PORT;
    pl = (u32 *) GFX_CTRL_PORT;

    addr = HSCRL + ((line & 0xFF) * 4);
    if (plan == BPLAN) addr += 2;

    *pl = GFX_WRITE_VRAM_ADDR(addr);
    *pw = value;
}

void VDP_setVerticalScroll(u16 plan, u16 cell, u16 value)
{
    volatile u16 *pw;
    volatile u32 *pl;
    u16 addr;

    /* Point to vdp port */
    pw = (u16 *) GFX_DATA_PORT;
    pl = (u32 *) GFX_CTRL_PORT;

    addr = (cell & 0x1F) * 4;
    if (plan == BPLAN) addr += 2;

    *pl = GFX_WRITE_VSRAM_ADDR(addr);
    *pw = value;
}

