/*
 Gestion des fichiers  2012 - LYNX - kit BLL (newcc65)
 problem : limit 11 
 philippe toulouse
 26/01/2013
 */
#include <stdlib.h>
#include <lynx.h>
#include <lynxlib.h>
//#include "fond1.pal"


/* LYNX-specific #defines: */
#define JOY_RIGHT		0x10
#define JOY_LEFT		0x20
#define JOY_DOWN		0x40
#define JOY_UP			0x80

#define BUTTON_OPTION1	0x08
#define BUTTON_OPTION2	0x04
#define BUTB		0x02
#define BUTA	0x01

#define BUTTON_PAUSE	0x01


char SCREEN[8160]       at (MEMTOP-16320);
char RENDER[8160]       at (MEMTOP-8160);

char pal[]={
	0x00,0x0F,0x0D,0x0A,0x08,0x05,0x03,0x01,0x00,0x00,0x00,0x00,0x06,0x0B,0x0A,0x07,
	0x00,0xFF,0xCA,0xA8,0x86,0x53,0x63,0x41,0x36,0x5A,0x6F,0x0F,0x0F,0x0F,0xF0,0xC0};


extern char FileEntry[8];
/*_FileEntry : struct of 8 bytes
FileStartBlock ds 1
FileBlockOffset ds 2
FileExecFlag ds 1
FileDestAddr ds 2
FileFileLen ds 2
*/

char mtil01[512];
char mtil02[512];
char mtil03[512];
char mtil04[512];
char mtil05[512];
char mtil06[512];
char mtil07[512];
char mtil08[512];
char mtil09[512];
char mtil10[512];
char mtil11[512];
char mtil12[512];

uchar *tatab[12] = {	mtil01, mtil02, mtil03, mtil04, mtil05, mtil06, mtil07, mtil08, mtil09, mtil10, mtil11, mtil12};

/*
set image01=spta.bmp

SPRPCK -t6 -S024020 -r010001 -i240020 %image01% ta
cmd
*/


extern char SCB1[];
#asm
_SCB1	dc.b $c7,$10,$20
			dc.w 0,0
			dc.w 0,0,$100,$100
			; Because we didn't use -C when calling SPRPCK we can
			; use the same colour palette indexes for all tiles
			dc.b $01,$23,$45,$67,$89,$Ab,$cd,$ef
#endasm






extern char SCM[122][11] at (0xfff8-20400-122*11);
//extern char SCM[122][11] at (0xfff8-24480-122*11);



// spr0 est le "modle" de sprite de 11 octet pour initialiser une occurence de SCB2[]
extern char spr0[11];

// init_scm est le premier sprite  afficher, en fait, il pointe sur un sprite vide
// j'aurais aussi pu le faire pointer vers le background
// l'important dans le _init_scm, c'est dc.w _SCB2
// qui fait pointer le sprite suivant vers le premier du tableau SCM
extern char init_scm[23];

#asm
; init_scm est utilis pour initialiser les registres du SpriteEngine
; avec les paramtres adquats (palette...)
; Using this trick, the 8*11 spr[]-SCMs only need 11 Bytes each!
_init_scm:
		dc.b $c1, $10, $20
		dc.w _SCM ; PTR_NEXT pointe vers le 1 sprite visible (SCM[0])
		dc.w dummy ; PTR_DATA pointe vers un sprite "inexistant"
		dc.w 200, 200 ; x,y -> on affiche en dehors de l'cran
		dc.w $100, $100 ; pas de zoom
		dc.b $01, $23, $45, $67, $89, $ab, $cd, $ef

dummy: dc.b 0,0,0 ; le sprite "inexistant"

; spr0 sert de modle au sprites du tableau SCM
_spr0: dc.b $c4, $08, $02 ; CTL0, CTL1 = rutilise la palette, COLL
		dc.w 0, 0
		dc.w 0, 0
#endasm









/*********************/
/* wait for a button */
/*********************/
char WaitButton()
{
char key;
while (joystick);
while ( (key = joystick) != BUTA) ;
/* wait for the button to be released */
while ( joystick ) ;
return key;
}

// ------------------------------------
// clip du sprite chiffres, chacun d'une taille de 8*8: 0123456789.LEV
/*****************************************************************************
**  Ci-dessous, le contenu du fichier batchfile pour l'image bchiffres.bmp   **

set image01=bchiffres.bmp
SPRPCK -t6 -S008008 -r014001 -o000000 -i112008 -p0 %image01% bc
cmd

*****************************************************************************/
extern uchar bc000000[];
extern uchar bc000001[];
extern uchar bc000002[];
extern uchar bc000003[];
extern uchar bc000004[];
extern uchar bc000005[];
extern uchar bc000006[];
extern uchar bc000007[];
extern uchar bc000008[];
extern uchar bc000009[];

uchar *chiffrestab[10] = {bc000000, bc000001, bc000002, bc000003, bc000004, bc000005, bc000006, bc000007, bc000008, bc000009};
// ------------------------------------
	
int etp, brnbr, posx,posy,gbfrx,gbfry,briqy,scnum,stopy,scaelv,scrollx,scrolly,xlimit,ylimit;
int tempa,tempb,tempc,tempd,bspeed,comptx;
char drap1,drap2,zap,relach,relaci,gspause,gsbl, level;
int cptx, cpty, cpti, atest, unit, diza, cent, mill, dmil, scor;
// assembler vertical retrace syncronisation routine
void Vsync() 
{
#asm
vretrace:
	lda $fd0a
	bne vretrace
#endasm
}


/*************** for VSYNC handling*******************/
uchar frames, lines;

extern uchar VBLflag;
#asm
_VBLflag = $a0
#endasm

#define VSYNC {++VBLflag;while( VBLflag );}

VBL() interrupt
{
   VBLflag = 0; /* indicates that a VBL has ocurred */
}

HBL() interrupt
{
}
/*****************************************************/
void Fmx(mlx,vlx) // coordonnes X
int mlx,vlx;
	{
	SCBX(&SCM[mlx][0]) = vlx;
	};

void Fmy(mly,vly) // coordonnes Y
int mly,vly;
	{
	SCBY(&SCM[mly][0]) = vly;
	};
void init_sprites()
{
	char i1;
	for (i1 = 0; i1 < 122; i1++) // 0  121 = 122
		{
		bcopy(&spr0[0], &SCM[i1][0], 11);
		SCBX(&SCM[i1][0]) = 0;
		SCBY(&SCM[i1][0]) = 300;
		SCBDATA(&SCM[i1][0])  = chiffrestab[0%10];
		SCBNEXT(&SCM[i1][0]) = &SCM[i1+1][0];
		}
	SCBNEXT(&SCM[121][0]) = 0;
};

/**************************************************************************
**                                                                       **
**                                                                       **
**************************************************************************/
char main()
{
	char i;
	InitIRQ();
	CLI;
	SetBuffers(SCREEN, RENDER ,0);
	InstallIRQ(2,VBL);
//	InstallIRQ(0,HBL);
	EnableIRQ(2);


  /* set the palette */
	SetRGB(pal); // 
	init_sprites();
	SCBNEXT(&SCM[121][0])= SCB1; // lier sprite mascote  tout les sprites dj chains... a marche !
	
Fmx(106,150);Fmx(107,142);Fmx(108,134);Fmx(109,126);Fmx(110,118);

							for(cpty=106 ; cpty<111; cpty++) // de 98  103 (score et vie)
								{
								SCBY(&SCM[cpty][0]) = 90;
								}
	
	posx=63;
	posy=43;//-236;//posy=-73;//-236;//-236;
	tempa=0;tempb=0;tempc=0;tempd=0;drap1=0;bspeed=0;
	
	etp=0;
	gsbl=5;


/**************************************************************************
**                       BOUCLE PRINCIPALE                               ** | 
**************************************************************************/    

while(1)
{
	Vsync();
	SwapBuffers();
	DrawFBox(0,0,160,102,0);
	
	--gsbl; // economie ressource machine --> certaines des conditions n'ont pas besoin d'tre lu par la LYNX  chaque boucle.
	if (gsbl==1) 
		{
		gsbl=5;
		
		scor = etp;//atest;
		
		/** affichage du score et nombre de vie:**/
			unit = scor % 10;
			diza = scor / 10 % 10;
			cent = scor / 100 % 10;
			mill = scor / 1000 % 10;
			dmil = scor / 10000 % 10;
			
		// unit:  
			//SCBDATA(SCBscore1) 
			SCBDATA(&SCM[106][0]) = chiffrestab[unit%10];
		// dizaine:  
			//SCBDATA(SCBscore2) 
			SCBDATA(&SCM[107][0]) = chiffrestab[diza%10];
		// centaine:  
			//SCBDATA(SCBscore3) 
			SCBDATA(&SCM[108][0]) = chiffrestab[cent%10];
		// millier:  
			//SCBDATA(SCBscore4) 
			SCBDATA(&SCM[109][0]) = chiffrestab[mill%10];
			SCBDATA(&SCM[110][0]) = chiffrestab[dmil%10];
			
		}
			
			
	if (etp==0)
		{
		// 11 objets externes maximum, it's not cool !
		for(cpti=0 ; cpti<12; cpti++) // de 0  11 doit 12 tests
			{
			LoadCartDir(2+cpti);LoadCartBlock(FileEntry[0], tatab[cpti%12]);
			}
		for(cpti=0 ; cpti<6; cpti++) // de 0  5 soit 6 tests
			{
			SCBDATA(&SCM[cpti][0]) = tatab[cpti%12];SCBX(&SCM[cpti][0]) = cpti*24;SCBY(&SCM[cpti][0]) = 0;
			}
		SCBDATA(&SCM[6][0]) = tatab[6%12];SCBX(&SCM[6][0]) = 0;SCBY(&SCM[6][0]) = 20;
		SCBDATA(&SCM[7][0]) = tatab[7%12];SCBX(&SCM[7][0]) = 24;SCBY(&SCM[7][0]) = 20;
		SCBDATA(&SCM[8][0]) = tatab[8%12];SCBX(&SCM[8][0]) = 48;SCBY(&SCM[8][0]) = 20;
		SCBDATA(&SCM[9][0]) = tatab[9%12];SCBX(&SCM[9][0]) = 72;SCBY(&SCM[9][0]) = 20;
		SCBDATA(&SCM[10][0]) = tatab[10%12];SCBX(&SCM[10][0]) = 96;SCBY(&SCM[10][0]) = 20;
		SCBDATA(&SCM[11][0]) = tatab[11%12];SCBX(&SCM[11][0]) = 120;SCBY(&SCM[11][0]) = 20; // problem with lynxer !
		
		etp=1;level=1;
		}

// *********************************************************************************************

	DrawSprite(init_scm);
}
  
/**************************************************************************
**                     FIN de la BOUCLE PRINCIPALE                       **
**************************************************************************/   
  
 }
