#include "ti83plus.inc"
#include "ion.inc"

.org progstart-2
.db t2ByteTok, tAsmCmp

;###############_CONSTANTS_##############
#DEFINE MAP_WIDTH 11        ;width of the map
#DEFINE MAP_HEIGHT 11       ;
#DEFINE COLUMNS_TO_DRAW (6+1)   ;columns to draw
#DEFINE HRZ_SCROLL 2       ;with 2 tiles between the player and the edge, scroll map
#DEFINE VERT_SCROLL 1

;###############_VARIABLES_################
numberText = safeRAM4
initialize:
    di
    ld hl,$89EC     ;byte after saferam1 (savesscreen) (creando nuestro "saferam")
    ld de,saferam3  ;guardar los valores aqui para no estropear todo
    ld bc,78
    ldir            ;guardarlo
    
    ld hl,playerDir
    ld (hl),0
    ld hl,yCoord
    ld (hl),7
    ld hl,xCoord
    ld (hl),5

;main program loop
start:
    call drawMap
    call drawPlayer
    call drawGbuf
#include "monoKeyLoop.asm"
    jr start

;IMPORTANT! WE NEED TO RESTORE THE VALUES FROM BEFORE THE PROGRAM
quit:
    ld hl,saferam3  ;guardar los valores aqu? para no joderlo todo
    ld de,$89EC     ;byte after saferam1 (savesscreen)
    ld bc,78
    ldir            ;save it all
    ret

;########################
;#MAP MOVEMENT ROUTINES
;# displace the map
;########################
mapRight:
    ld hl,xCoord
    ld a,MAP_WIDTH-6
    cp (hl)
    ret z
    ld de,xOff
    ld a,(de)
    inc a
    inc a
    and $0F
    ld (de),a
    jp nz,updateRotation    ;if we have no overflow, we're all good.
    inc (hl)
    jp updateRotation

mapLeft:
    ld hl,xCoord
    xor a
    cp (hl)
    ld de,xOff
    ld a,(de)
    jr nz,mL_notLeft
    or a
    ret z
mL_notLeft:
    dec a
    dec a
    and $0F
    ld (de),a
    cp 14
    jp c,updateRotation ;if we have no overflow, we're all good.
    dec (hl)
    ld hl,mPL_adjustCP
    inc (hl)
    jp updateRotation

mapUp:
    ld hl,yCoord
    xor a
    cp (hl)
    ld de,yOff
    ld a,(de)
    jr nz,mU_notTop
    or a
    ret z
mU_notTop:
    dec a
    dec a
    and $0F
    ld (de),a
    cp 14
    ret c       ;if we have no overflow, we're all good.
    dec (hl)
    ld hl,mPU_adjustCP
    inc (hl)
    ret

mapDown:
    ld hl,yCoord
    ld a,MAP_HEIGHT-4
    cp (hl)
    ret z
    ld de,yOff
    ld a,(de)
    inc a
    inc a
    and $0F
    ld (de),a
    ret nz      ;if we have no overflow, we're all good.
    inc (hl)
    ret

updateRotation:
    ld a,(xOff)
    and 7
    ld hl,gbufMask
    ld e,a
    ld d,0
    add hl,de
    ex af,af'
    ld a,(hl)
    ld hl,maskLeft
    ld (hl),a
    ld hl,maskRight
    xor $FF
    ld (hl),a
    ex af,af'

    ld hl,rotateRight
    cp 4
    jr nc,rotarDer
    ld hl,rotateLeft
rotarDer:
    and %00000011
    ld e,a
    ld d,0
    add hl,de
    push hl
    ld de,rotLeft
    ldi
    ldi
    ldi
    ldi
    pop hl
    ld de,rotRight
    ldi
    ldi
    ldi
    ldi
    ret

rotateRight:       ;if offset greater than or equal to 4, rotate the gbuf right up to four times
    rrca
    rrca
    rrca
    rrca
rotateLeft:       ;the nops keep it smoother (same delay as rlca)
    nop          ; so whether we shift or not, it will take the same amount of cycles
    nop
    nop
    nop
    rlca
    rlca
    rlca
    rlca
gbufMask:
.db %11111111   ;0
.db %11111110   ;1
.db %11111100   ;2
.db %11111000   ;3
.db %11110000   ;4
.db %11100000   ;5
.db %11000000   ;6
.db %10000000   ;7

drawGbuf:
    ld a,$80
    out ($10),a     ;set row ($80: 0, to $BF:63)
    ld hl,saferam1-14+(14*64)-14    ;
                                    ;
    
xOff = $+1
    ld a,0          ;if xOff > 8, skip the first byte (it's offscreen)
    cp 8
    jr c,$+3
    inc hl
noSkip:
yOff = $+1
    ld b,0
    inc b
    ld de,14
    add hl,de
    djnz $-4
noSkip2:
    ld a,$20        ;$20: col 0, $2E: col 14
    ld c,a
    ld b,64         ;64 filas
fastCopyAgain:
    inc c           ;avanzar a proxima fila
    push bc
    ld de,-(14*64)
    out ($10),a     ;actualizar columna
    add hl,de
    ld de,13
    inc hl
fastCopyLoop:
    add hl,de
    ld a,(hl)       ;cargar valor en gbuf a a
rotLeft:
 .db 0,0,0,0            ;rotate the values we need
maskLeft = $+1
    and $FF         ;necesitamos los valores de la izquierda
    ld c,a
    inc hl
    ld a,(hl)       ;el proximo byte que llena el resto del primero
rotRight:
 .db 0,0,0,0
maskRight = $+1
    and 0
    or c
    out ($11),a
    djnz fastCopyLoop
    pop bc
    ld a,c
    cp $2B+1
    jr nz,fastCopyAgain
    ret

#include "monoMap.asm"
#include "monoSpriteRoutines.asm"
#include "monoMove.asm"
#include "monoText.asm"

community_chest_text:
.db "Advance to Go (Collect $200)",0
.db "Bank error in your favor - collect $75",0
.db "Doctor's fees - Pay $50",0
.db "Get out of jail free - this card may be kept until needed, or sold",0
.db "Go to jail - go directly to jail - Do not pass Go, do not collect $200",0
.db "It is your birthday - collect $10 from each player",0
.db "Grand Opera Night - collect $50 from every player for opening night seats",0
.db "Income Tax refund - collect $20",0
.db "Life Insurance Matures - collect $100",0
.db "Pay Hospital Fees of $100",0
.db "Pay School Fees of $50",0
.db "Receive $25 Consultancy Fee",0
.db "You are assessed for street repairs - $40 per house, $115 per hotel",0
.db "You have won second prize in a beauty contest - collect $10",0
.db "You inherit $100",0
.db "From sale of stock you get $50",0
.db "Holiday Fund matures - Receive $100",0

chance_text:
.db "Advance to Go (Collect $200)",0
.db "Advance to Illinois Ave - if you pass Go, collect $200",0
.db "You owned the bank.Roll the dice ten times and add your result to pay the bank.",0
.db "Advance token to the nearest Railroad and pay owner twice the rental to which he/she is otherwise entitled. If Railroad is unowned, you may buy it from the Bank. (There are two of these.)",0
.db "Advance to St. Charles Place - if you pass Go, collect $200",0
.db "Bank pays you dividend of $50",0
.db "Get out of Jail free - this card may be kept until needed, or traded/sold",0
.db "Go back 3 spaces",0
.db "Go directly to Jail - do not pass Go, do not collect $200",0
.db "Make general repairs on all your property - for each house pay $25 - for each hotel $100",0
.db "Pay poor tax of $15",0
.db "Take a trip to Reading Railroad - if you pass Go collect $200",0
.db "Take a walk on the Boardwalk - advance token to Boardwalk",0
.db "You have been elected chairman of the board - pay each player $50",0
.db "Your building loan matures - collect $150",0
.db "You have won a crossword competition - collect $100",0

#include "monopoly_map.asm"
#include "monopoly_map_tiles.asm"
#include "monopoly_sprites.asm"
#include "monopoly_alphabet.inc"



testtext:
;Hello, testing 1234 testing testing
.db 7,23,53,53,28,63,$FE,55,23,65,55,51,27,25,$FE,57,36,37,38,$FE,55,23,65,55,51,27,25,$FE,55,23,65,55,51,27,25,$FF    

textGO:
;You have passed GO, please collect $200.
.db 17,28,32,$FE,26,19,52,23,$FE,29,19,65,65,23,22,$FE,6,10,63,$FE,29,53,23,19,65,23,$FE,21,28,53,53,23,21,55,$FE,60,36,10,10,62,$FF