program animatch;

const
	// GP32 Keys
	__A = _control;
	__B = _alt;
	__SELECT = _space;
	__START = _enter;
	__R = _tab;
	__L = _backspace;
  _x = _control;

global

///music
title_song;
game_song[3];
goal_song;
gameover_song;
hiscore_song;
///

/*
////sounds
match[7];
levelup_sound;
special_sound;
hint_sound; 
swap_sound;
blip_sound;
blip2_sound;
fall_sound;
win_sound;
keyboard_sound;
no_moves_sound; 
select_sound;
back_sound;
///// 
*/

kb_image[2];
kb_map[2]; 
kb_cursor[4];
tiny_font;

keypressed;
no_graph;
cursor;
dusty10;
dusty14;
dusty21;
score_font; 
square8;
square10;
no_click;
busy;
falling;
available_moves;
board; 
max_animals;
lucky_animal;
special_odds;
hints;
timebar;
message_board; 
 
stage;
score;
target;
quota[8];
time_score;
 
tile_map; 
struct tiles[8][8];
number;
anim;
wait;
gravity;
yoffset;
available;
scale;
direction;
end


struct hiscores[3][2][10];  /// mode,dificulty,position
name[6];
score;
time;
end

struct options;
music_volume;
sfx_volume;
cursor_speed;
name_entry;
last_name[6];
default_name[6];
end

end

local
action;
tile_number;
tile1x;
tile1y; 
tile2x;
tile2y;
lines;
no_swap;
anim_frame; 
string input;

begin 
rand(0,100);

set_mode(320,240,16);
set_fps(30,0);  
//repeat
//frame;
//until(key(_space))

/*
title_song=load_song("title.ogg");
ggame_song[0]=load_song("game1.ogg"); 
game_song[1]=load_song("game2.ogg");
game_song[2]=load_song("game3.ogg");
goal_song=load_song("goal.ogg");
gameover_song=load_song("gameover.ogg");
hiscore_song=load_song("hiscore.ogg"); 
*/

/*
match[1]=load_wav("MATCH1.WAV"); 
match[2]=load_wav("MATCH2.WAV"); 
match[3]=load_wav("MATCH3.WAV"); 
match[4]=load_wav("MATCH4.WAV");
match[5]=load_wav("MATCH5.WAV"); 
match[6]=load_wav("MATCH6.WAV");
levelup_sound=load_wav("LEVELUP.WAV"); 
special_sound=load_wav("SPECIAL.WAV");  
hint_sound=load_wav("HINT.WAV"); 
swap_sound=load_wav("SWAP.WAV"); 
blip_sound=load_wav("BLIP1.WAV"); 
blip2_sound=load_wav("BLIP2.WAV");
fall_sound=load_wav("FALL.WAV");
win_sound=load_wav("WIN.WAV");  
keyboard_sound=load_wav("KEYBOARD.WAV"); 
no_moves_sound=load_wav("NMRMOVES.WAV");  
select_sound=load_wav("SELECT.WAV");  
back_sound=load_wav("BACK.WAV");
*/

kb_image[0]=901;
kb_map[0]=load_png("KBDMAP.PNG");
kb_cursor[0]=902;
kb_cursor[1]=903; 
kb_cursor[2]=904;
kb_cursor[3]=905;
tiny_font = load_bdf("TINY.BDF");



 
//write_int(0,10,10,0,offset fps); 

define_region(1,46,0,214,240);


load_fpg("ANIMATCH.FPG");
dusty10=load_fnt("DUSTY10.FNT");  
dusty14=load_fnt("DUSTY14.FNT");
dusty21=load_fnt("DUSTY21.FNT");
score_font=load_fnt("SCORE.FNT");
square8=load_fnt("SQUARE8.FNT"); 
square10=load_fnt("SQUARE10.FNT");
load_pal("DUSTY14.FNT");

message_board=new_map(158,158,16);
no_graph=new_map(0,0,16);
tile_map=new_map(224,224,16);

		if(file_exists("HISCORES"))
			load("HISCORES",hiscores);
			else
			
			for(y=0;y<3;y++)
				for(x=0;x<10;x++)
					for(z=0;z<2;z++)
					hiscores[y][z][x].score=18000-(x*990);
					hiscores[y][z][x].score=18000-(x*990); 
	
					if(y==0)hiscores[y][z][x].name[0]=84;hiscores[y][z][x].name[1]=73;hiscores[y][z][x].name[2]=71;hiscores[y][z][x].name[3]=69;hiscores[y][z][x].name[4]=82;end
					if(y==1)hiscores[y][z][x].name[0]=72;hiscores[y][z][x].name[1]=73;hiscores[y][z][x].name[2]=80;hiscores[y][z][x].name[3]=80;hiscores[y][z][x].name[4]=79;end
					if(y==2)hiscores[y][z][x].name[0]=80;hiscores[y][z][x].name[1]=73;hiscores[y][z][x].name[2]=71;hiscores[y][z][x].name[3]=71;hiscores[y][z][x].name[4]=89;end 
					end
				end 
			end
			
			for(x=0;x<10;x++)
			   hiscores[1][0][x].time=60000+(x*6000); 
			   hiscores[1][1][x].time=60000+(x*6000);
			end
		
		end 
		
		if(file_exists("OPTIONS"))
			load("OPTIONS",options);
			else
			options.music_volume=6;
			options.sfx_volume=6;
			options.cursor_speed=8; 
			options.name_entry=0;
		end
		
		set_song_volume(options.music_volume*12.8);
		set_wav_volume(-1, options.sfx_volume * 12.8);

title(0);
//game(0,0); 
//time_bar(0);
//virtual_keyboard("","WAYNE",8);

//mouse.graph=999;

loop
if(mouse.left==0 and key(_up)==0 and key(_down)==0 and key(_left)==0 and key(_right)==0 and key(_alt)==0 and key(_z)==0 and key(_x)==0 and key(_enter)==0 and key(_control)==0 and key(_tab)==0 and key(_backspace)==0)keypressed=0;end


//if(key(_esc))exit();end

frame;

end





end 





Process title(skip)

private
  option[5]; 
  selection;
  flash;
  button_touched;
  a;
  tempmap;
  spd; 
  string desc[5];

begin 
  delete_text(all_text);

  desc[0]="REACH ANIMAL QUOTA TO ADVANCE THROUGH THE STAGES";
  desc[1]="SCORE 20000 POINTS AS QUICKLY AS POSSIBLE"; 
  desc[2]="5 MINUTES TO SCORE AS MANY POINTS AS POSSIBLE"; 
  desc[3]="ADJUST VARIOUS GAME OPTIONS";  
  desc[4]="VIEW HI-SCORES";
  desc[5]="EXIT THE GAME";

  if (skip==0)
    tempmap = new_map(320,240,16);
    map_put(0, tempmap, 802, 159, -20); 
    map_put(0, tempmap, 801, 159, 50);
    map_put(0, tempmap, 800, 159, 440); 
        
    transition(tempmap,0);
    
    repeat
    frame;
    until(exists(type transition)==0)
    
    //graph=tempmap;
    //x=160;y=120;
    
    //for(alpha=0;alpha<255;alpha+=16)
    //frame;
    //end
    put_screen(0,tempmap);
    graph=no_graph; 
    unload_map(0,tempmap);
    
    // alpha=0;
    graph=803;
    // alpha=255;
    x=160;y=100;
    
    for (y=-35; y<75; y+=5)
      frame;
    end
    
    // Attendre un peu avant que le logo s'efface
    for (a=0; a<40; a++)
      frame;
    end 
   
    
    /*
    repeat
      alpha -= 8;
      frame;
    until(alpha<=0);
    */
    
    graph = no_graph; 
    
    // alpha = 255;
    
    spd=0;
    
    for(y=1;y<200;y+=spd)
      if (spd<5)
        spd++;
      end
      put(0, 802, 159, -20 - (y/3)); 
      put(0, 801, 159, 50 + (y/4));
      put(0, 800, 159, 440 - y);
      frame;
    end
    
    tempmap = get_screen();
  end

  //put_screen(0,1);
 
  title_letters(2,26); 
  title_letters(3,69); 
  title_letters(4,103); 
  title_letters(5,138); 
  title_letters(6,183);
  title_letters(7,219);
  title_letters(8,254); 
  title_letters(9,296); 

/*
  if (is_playing_song()==0)
    play_song(title_song,-1);
  end
*/

  x=160;
  y=74;
  a=0;

  if (skip==0)
    repeat
      if(a<9)
        graph=804;
        else
        graph=no_graph;
      end 
      
      a++;
      
      if (a>17)
        a=0;
      end
      frame;
    until(keypressed==0 and (mouse.left or key(_alt) or key(_z)))
  end 
  
	// Attention, tempmap est afficher avec le bit flag 4,
  // soit semi transparent (opacité 50%) pour qu'il soit
  // plus sombre. Mais apparemment ça fait planter la GP32

  if (skip==1)
    tempmap = new_map(320, 240, 16);			
    map_put(0, tempmap, 802, 159, -20-(66)); 
    map_put(0, tempmap, 801, 159, 50+(50));
    map_put(0, tempmap, 800, 159, 440-200);
    transition(tempmap, 0);
    repeat
      frame;
    until(exists(type transition)==0)     
  end

  graph = no_graph;
  keypressed = 1;
  
  clear_screen();
  xput(0, tempmap, 160, 120, 0, 100, 0, 0);
  //xput(0, tempmap, 160, 120, 0, 100, 4, 0);
  unload_map(0, tempmap);
  frame;

  option[0] = title_button(10, -40, -40,  60,  95);
  option[1] = title_button(11, 160, -40, 160,  95);
  option[2] = title_button(12, 360, -40, 260,  95);
  option[3] = title_button(13, -40, 280,  60, 185);
  option[4] = title_button(14, 160, 280, 160, 185); 
  option[5] = title_button(17, 360, 280, 260, 185);

//option[3]=title_button(13,15,280,115,180);
//option[4]=title_button(14,310,280,210,180); 

  for (a=0; a<10; a++)
    frame;
  end

  graph = 16;
  z = -200; 
  flash = 16;
  // alpha = 0;
                    
  repeat
    x = option[selection].x;
    y = option[selection].y; 
    // alpha += flash;
    
    // if(alpha<=64)alpha=64;flash=-flash;end 
    // if(alpha>=255)alpha=255;flash=-flash;end

		if (key(_right) and keypressed==0)
			selection++;
      keypressed = 1;
      // alpha=255;
			if (selection>2 and selection<4)
        selection=0;
      end
			if (selection>5)
        selection=3;
      end 
			// play_wav(blip2_sound, 0);
		end 
		
		if( key(_left) and keypressed==0)
			selection--;
      keypressed=1;
      // alpha=255;
			if (selection<3 and selection>1)
        selection=5;
      end
			if (selection<0)
        selection=2;
      end
			// play_wav(blip2_sound, 0);
		end

		if (key(_up) and keypressed==0)
			selection-=3;
      keypressed=1;
      // alpha=255;
			if (selection<0)
        selection = selection+6;
      end
			// play_wav(blip2_sound, 0);
		end 

		if (key(_down) and keypressed==0)
			selection+=3;
      keypressed=1;
      // alpha=255;
		  if (selection>5)
        selection=selection-6;
      end
		  // play_wav(blip2_sound, 0);
		end

    set_text_color(rgb(255,255,128));
    delete_text(all_text);
    write(square8, 160, 235, 4, desc[selection]);

    // Hey ! Pas de souris ni stylet ssur GP32 ! :)
    /*
    for (a=0; a<6; a++)
      if(mouse.left and mouse.x>option[a].x-40 and mouse.x<option[a].x+40 and mouse.y>option[a].y-40 and mouse.y<option[a].y+40)
        selection = a;
        button_touched=1;
       end	
    end
    */

    frame;
  until (button_touched>0 or ((key(_alt) or key(_z)) and keypressed==0))
  
  // play_wav(select_sound, 0); 
/*
  if (selection<1)
    fade_music_off(1000);
  end
*/

  set_text_color(rgb(255,255,128));
  delete_text(all_text);
  write(square8, 160, 235, 4,desc[selection]);

  x = option[selection].x;
  y = option[selection].y;
  // alpha=0;
  graph = 16; 
  flash = 64;

  /*
  for (a=0; a<20; a++)
    alpha += flash;
    // if(alpha<=64)alpha=64;flash=-flash;end 
    // if(alpha>=255)alpha=255;flash=-flash;end	
    frame;
  end 
  //alpha=0;
  */
  
  frame;

  for (a=0;a<6;a++)
    if (a<>selection)
      option[a].action = 1;
    end
  end

  /*
  for (a=0; a<10; a++)
    frame;
  end 
  */

  tempmap = get_screen();

  signal(type title_letters, s_kill); 
  signal(type title_button, s_kill);
  signal(type button_bg, s_kill);
  put_screen(0, tempmap);
  unload_map(0, tempmap);
  frame;  

  if (selection==0)
    /*
    repeat
      frame;
    until (is_playing_song()==0)
    */
    
    if (selection==0)
      game(0,0);
    end
  end  

  if (selection>0 and selection<3)
    difficulty_select(selection);
  end
  
  if (selection==3)
    option_screen();
  end 
  
  if (selection==4)
    high_scores(0);
  end
  
  if (selection==5)
    credits();
  end

  delete_text(all_text);

end 


//-----------------------------------------------------------------------------

process title_letters(graph, x)

private
  wave;
  wave2;
  xpos;
  delay;

begin
  //alpha = 0;
  size = 0; 
  wave = x;
  wave2 = x; 
  xpos = x;
  delay = graph * 2; 
  loop
    if (delay>0)
      delay--;
     end
    if (size<100 and delay<=0)
      size+=20;
    end
    y = 27 + (sin(wave*1000)*5);
    x = xpos + (sin(wave2*1000)*5);
    wave += 15;
    wave2 += 10;
    frame;
  end
end 

//-----------------------------------------------------------------------------

process difficulty_select(mode)

private
  option[2]; 
  selection;
  flash;
  button_touched;
  a;
  tempmap;
  spd; 

begin
  transition(mode+929,0); 
  repeat
    frame;
  until(exists(type transition)==0)

  option[0] = title_button(932,-80,93,160,93);
  option[1] = title_button(933,400,174,160,174);

  for(a=0;a<10;a++)
    frame;
  end

  graph = 935;
  z = -200; 
  flash = 16;
  // alpha=0;
                    
  repeat
    x=option[selection].x;
    y=option[selection].y; 
    /*
    alpha+=flash;
    if(alpha<=64)alpha=64;flash=-flash;end 
    if(alpha>=255)alpha=255;flash=-flash;end
    */
		if (key(_up) and keypressed==0)
			selection--;
			keypressed=1;
			//alpha=255;
			if(selection<0)
        selection=1;
      end
			// play_wav(blip2_sound, 0);
		end 

		if(key(_down) and keypressed==0)
			selection++;
			keypressed=1;
			//alpha=255;
		  if(selection>1)
        selection=0;
      end
		  // play_wav(blip2_sound, 0);
		end

    for(a=0; a<2; a++)
    	if (mouse.left and mouse.x>option[a].x-40 and mouse.x<option[a].x+40 and mouse.y>option[a].y-40 and mouse.y<option[a].y+40)
        selection = a;
        button_touched = 1;
      end
    end

    if((mouse.left and mouse.x>282 and mouse.y<40) or key(_x))
      selection=2;
      button_touched=1;
    end

    frame;
  until(button_touched>0 or ((key(_alt) or key(_z)) and keypressed==0)) 

  // play_wav(select_sound, 0); 

  if(selection<=1)
    fade_music_off(1000);
    
    x = option[selection].x;
    y = option[selection].y;
    
    // alpha=0;
    graph=935; 
    flash=64;
    
    /*
    for(a=0;a<20;a++)
      alpha+=flash;
      if(alpha<=64)alpha=64;flash=-flash;end 
      if(alpha>=255)alpha=255;flash=-flash;end	
      frame;
    end 
    alpha=0;
    frame;
    */
    
    for (a=0; a<2; a++)
      if (a<>selection)
        option[a].action = 1;
      end
    end
    
    /*
    for(a=0; a<10; a++)
      frame;
    end 
    */
  end   

  tempmap = get_screen();

  signal(type title_button,s_kill);
  signal(type button_bg,s_kill);
  put_screen(0,tempmap);
  unload_map(0,tempmap);
  frame;  

  if (selection=<1)
  	repeat
  	frame;
  	until(is_playing_song()==0)
  	game(mode, selection); 
  end                       

  if (selection==2)
    title(1);
  end

end

//-----------------------------------------------------------------------------

process title_button (graph, start_x, start_y, target_X, target_y)

private
  xmove;
  ymove;
  a;

begin
  z = 200;
  x = start_x;
  y = start_y;

  if (start_x<>target_x)
    xmove = (target_x - start_x) / 10;
   end
   
  if (start_y<>target_y)
    ymove = (target_y - start_y) / 10;
   end

  if (graph>900)
  	button_bg(934);
  else  
  	button_bg(15);
  end

  for (a=0; a<10; a++)
    x = x + xmove;
    y = y + ymove;
    frame;
  end 
  
  x = target_x;
  y = target_y;

  repeat
    frame;
  until (action>0)

  for(a=0; a<10; a++)
    x = x - xmove;
    y = y - ymove;
    frame;
    signal(son, s_kill);
  end
end 

//-----------------------------------------------------------------------------

process button_bg(graph)

begin
  //graph=15;
  z = 255; 
  //alpha=128; 
  loop
    x = father.x;
    y = father.y;
    frame;
  end
end 




process option_screen();

private
  delay;
  selection;
  value;
  a;
  string name;
  int save_txt; // Objects d'alert pendant sauvegarde

begin

  transition(906,0); 

  repeat
    frame;
  until(exists(type transition)==0)

  graph=921;
  x=180;

  repeat
    delete_text(all_text);
    put(0,910+options.music_volume,260,60);
    put(0,910+options.sfx_volume,260,100);
    put(0,910+(13-options.cursor_speed),260,140);
    if(options.name_entry==0)write(dusty10,260,182,4,"BLANK");end
    if(options.name_entry==1)write(dusty10,260,182,4,"LAST NAME");end 
    if(options.name_entry==2)write(dusty10,260,182,4,"DEFAULT");end  
	
    name="";
    for(a=0;a<6;a++)
      name+=chr(options.default_name[a]);
    end 

    write(dusty10,63,225,4,name);

    /*
    if(mouse.left)
      value=(((mouse.x-208)*10)/90);
   
      if(mouse.x>204 and mouse.x<304)
        if (mouse.y>=40 and mouse.y<=77)
         options.music_volume=value;
        end 
         
        if (mouse.y>=80 and mouse.y<117)
          options.sfx_volume=value;
        end  
        
        if (mouse.y>=120 and mouse.y<157)
          options.cursor_speed=13-value;
          if(options.cursor_speed>12)options.cursor_speed=12;end
        end
               
        if(mouse.y>160 and mouse.y<197 and keypressed==0)
          options.name_entry++;
          if(options.name_entry>2)options.name_entry=0;end
          keypressed=1;
        end
      end
     
      if(mouse.x>195 and mouse.x<302 and mouse.y>198 and mouse.y<236 and keypressed==0)
        options.music_volume=6;
        options.sfx_volume=6;
        options.cursor_speed=8;
        // play_wav(select_sound, 0);  
        keypressed=1;
      end
    end 
    */

        
    if(key(_up) and selection>0 and keypressed==0)selection-=1;keypressed=1;
      // play_wav(blip2_sound, 0);
    end  
    if(key(_down) and selection<4 and keypressed==0)selection+=1;keypressed=1;
      // play_wav(blip2_sound, 0);
    end

    if(selection==0)y=62;end  
    if(selection==1)y=102;end
    if(selection==2)y=142;end 
    if(selection==3)y=182;end 
    if(selection==4)y=220;end 

    if(key(_right) and selection==0 and keypressed==0 and options.music_volume<10)keypressed=1;options.music_volume++;
      // play_wav(blip2_sound, 0);
    end  
    if(key(_left) and selection==0 and keypressed==0 and options.music_volume>0)keypressed=1;options.music_volume--;
      // play_wav(blip2_sound, 0);
    end  

    if(key(_right) and selection==1 and keypressed==0 and options.sfx_volume<10)keypressed=1;options.sfx_volume++;
      // play_wav(blip2_sound, 0);
    end 
    if(key(_left) and selection==1 and keypressed==0 and options.sfx_volume>0)keypressed=1;options.sfx_volume--;
      // play_wav(blip2_sound, 0);
    end

    if(key(_right) and selection==2 and keypressed==0 and options.cursor_speed>3)keypressed=1;options.cursor_speed--;
      // play_wav(blip2_sound, 0);
    end      
    if(key(_left) and selection==2 and keypressed==0 and options.cursor_speed<12)keypressed=1;options.cursor_speed++;
      // play_wav(blip2_sound, 0);
    end

    if(key(_right) and selection==3 and keypressed==0)keypressed=1;options.name_entry++;
      // play_wav(blip2_sound, 0);
    end  
    if(key(_left) and selection==3 and keypressed==0)keypressed=1;options.name_entry--;
      // play_wav(blip2_sound, 0);
    end
    
    if(options.name_entry>2)options.name_entry=0;end
    if(options.name_entry<0)options.name_entry=2;end 

    if(((key(_alt) or key(_z))and selection==3 and options.name_entry==2) or (mouse.left and mouse.x<121 and mouse.y>203))
      z=virtual_keyboard("","",6);
      
      repeat
        frame;
      until(exists(z)==0) 
      
      for(a=0;a<6;a++)
        options.default_name[a]=0;
      end
       
      for (a=0;a<len(input);a++)
          options.default_name[a]=asc(substr(input,a,1)); 
      end  
 
    end

    if((key(_alt) or key(_z)) and selection==4 and keypressed==0)
      options.music_volume=6;
      options.sfx_volume=6;
      options.cursor_speed=8;
      keypressed=1;
      // play_wav(select_sound, 0);
    end

    set_song_volume(options.music_volume*12.8); 
    set_wav_volume(-1,options.sfx_volume*12.8);

    frame;
  until(key(_x) or (mouse.left and mouse.x>282 and mouse.y<40) or key(__A))

  save_txt = write(dusty10, 160, 120, 4, "Saving options, please wait...");
  frame;
  save("OPTIONS", options);
  // play_wav(back_sound, 0);
  delete_text(save_txt);

  title(1);

end 



process credits()

private
tempmap;
text[20];
font;

begin 

tempmap=new_map(320,240,16);
map_xput(0,tempmap,900,160,120,0,100,5);

transition(tempmap,0); 

repeat
frame;
until(exists(type transition)==0) 

word_drop("THANKS",20,169);
word_drop("FOR PLAYING",40,169);

unload_map(0,tempmap);

font=0;

set_text_color(rgb(255,255,200));

text[0]=write(font,160,70,4,"GRAPHICS AND PROGRAMMING");
text[1]=write(font,160,84,4,"Wayne Price (Ruckage)");
text[2]=write(font,160,98,4,"www.muddymonkey.co.uk"); 
text[3]=write(font,160,125,4,"MUSIC BY");
text[4]=write(font,160,139,4,"Pat Ferguson");
text[5]=write(font,160,153,4,"www.obstacledelusions.com/music/");
text[6]=write(tiny_font,160,204,4,"IF YOU ENJOY THE GAME AND WOULD LIKE TO DONATE SOME MONEY");
text[7]=write(tiny_font,160,218,4,"TO EITHER MYSELF OR PAT YOU CAN DO SO ON OUR WEBSITES."); 
text[8]=write(tiny_font,160,232,4,"ANY AMMOUNT IS GREATLY APPRECIATED AND WILL HELP FUTURE PROJECTS.");

text[9]=write(font, 160, 180, 4, "GP32 port by rZool");

fade_music_off(5000);

for(x=0;x<210;x++)
frame;
end

tempmap=get_screen();
delete_text(all_text);
put_screen(0,tempmap);
unload_map(0,tempmap);

tempmap=new_map(320,240,16);
map_clear(0,tempmap,rgb(0,0,0));

transition(tempmap,0); 

repeat
frame;
until(exists(type transition)==0)

exit();



end

//-----------------------------------------------------------------------------

process high_scores(table)

private
  difficulty;
  textmap;
  scoremap[10];
  pos; 
  name_pos;
  xpos[10];
  ypos[10]; 
  string text;
  string name;

begin 

  transition(20,0); 
  repeat
    frame;
  until(exists(type transition)==0)
  
/*
  graph=20;
  x=160;y=120;
  for(alpha=0;alpha<255;alpha+=16)
  frame;
  end

  put_screen(0,20);
*/

  x=239;
  y=11; 

	for (pos=0;pos<10;pos++)
    scoremap[pos] = map_clone(0,29);
	end

  loop
    //graph=table+21;
    if (table==0)
      graph=21;
    end 
    
    if (table==1 and difficulty==0)
      graph=22;
    end 
    
    if (table==1 and difficulty==1)
      graph=23;
    end  
    
    if (table==2 and difficulty==0)
      graph=24;
    end
    
    if (table==2 and difficulty==1)
      graph=25;
    end
    
    action=0;

    for (pos=0; pos<10; pos++)
    	name = "";
    	map_put(0, scoremap[pos], 29, 121, 10);
	
    	for (name_pos=0; name_pos<6; name_pos++)
    		name = name+chr(hiscores[table][difficulty][pos].name[name_pos]);
     	end
  	
      textmap = write_in_map(dusty10, pos+1+":", 5);
    	map_put (0, scoremap[pos], textmap, 26, 9);
    	unload_map (0, textmap);  
    	
    	textmap = write_in_map(dusty10, name, 3);
    	map_put(0, scoremap[pos], textmap, 40, 9);
    	unload_map(0, textmap); 
	
    	if (table<>1)
    		textmap = write_in_map (dusty10, hiscores[table][difficulty][pos].score, 5);
    		map_put(0, scoremap[pos], textmap, 230, 9);
    		unload_map(0, textmap);
    	end  
	
    	if (table==1)
    		text = (hiscores[1][difficulty][pos].time / 100) / 60;
    		text = text + ":";
    		text = text + ((hiscores[1][difficulty][pos].time/100)%60);
    		text = text + ".";
    		if (hiscores[1][difficulty][pos].time%100<10)
          text = text + "0";
        end
    		text = text + (hiscores[1][difficulty][pos].time%100);

    		textmap = write_in_map(dusty10, text, 5);
    		map_put(0, scoremap[pos], textmap, 230, 9);
    		unload_map(0, textmap);
    	end
    end	

    for (pos=0; pos<10; pos++)
    	xpos[pos] = 440 + (pos * 32);
      ypos[pos] = 37 + (pos * 21);
    end 

    repeat
      put_screen(0, 20);

      for (pos=0; pos<10; pos++)
        xpos[pos] = xpos[pos]-50;
        if (xpos[pos]<=161)
          xpos[pos]=161;
        end
        put(0, scoremap[pos], xpos[pos], ypos[pos]);
      end

      frame;
    until (xpos[9]==161)

    repeat
      if (key(_right))
        action=1;
      end 
      if (key(_x) or key(__A))
        action=2;
      end
      /*
      if (mouse.left and mouse.x>=282 and mouse.x<=317 and mouse.y>=28 and mouse.y<=63)
        action=1;
      end
      if (mouse.left and mouse.x>=2 and mouse.x<=37 and mouse.y>=28 and mouse.y<=63)
        action=2;
      end
      */
      frame;
    until (action>0)

    if(action==1)
      // play_wav(swap_sound, 0);
      repeat
        put_screen(0,20);
        for (pos=0;pos<10;pos++)

          if (pos==0)xpos[0]=xpos[0]-50;end
          if (pos>0 and xpos[0]<=xpos[pos]-(pos*32))
            xpos[pos]=xpos[0]+(pos*32);
          end

          put(0,scoremap[pos],xpos[pos],ypos[pos]);
        end
        frame;
      until (xpos[9]<-120) 

      difficulty++;
    
      if (difficulty>1 or table==0)
        table++;
        difficulty=0;
      end
      
      if (table>2)
        table=0;
        difficulty=0;
      end
    end

    if (action==2)
      break;
    end

    frame;
  end 

  for (pos=0; pos<10; pos++)
  	unload_map(0,scoremap[pos]);
  end
  	
  // play_wav(back_sound, 0);
  title(1);
  keypressed = 1; 
end








process game(mode,difficulty);

private
	gameover;
	levelcomplete;
	bg;
	int minutes;
	int tenseconds;
	int seconds;
	delay; 
	tempmap;
	timer_store;
	a;
	target_reached;
	xpos;
	ypos;
	gravity;
	lucky;
	quota2[8];
	mask[8]; 
	string text;


begin 
	z = -512;

	special_odds = 150;
	bg = rand(200,203); // Nombre de décors réduit
	//bg = rand(200,209); 

	transition(bg, 0);

	repeat
		frame;
	until(exists(type transition)==0)


/*graph=bg;
	x=160;y=120;z=-512;
	for(alpha=0;alpha<255;alpha+=16)
	frame;
	end

	put_screen(0,bg); 
	graph=no_graph;
*/

	max_animals = 6 + difficulty;
	if (stage>9)
		max_animals = 7;
	end

	lucky_animal = rand(0, max_animals);

	if (mode==0)
		write_int(square8,28,45,4,offset quota2[0]);
		write_int(square8,28,71,4,offset quota2[1]);
		write_int(square8,28,97,4,offset quota2[2]);
		write_int(square8,28,123,4,offset quota2[3]);
		write_int(square8,28,149,4,offset quota2[4]);
		write_int(square8,28,175,4,offset quota2[5]);
		write_int(square8,28,201,4,offset quota2[6]);
		write_int(square8,28,227,4,offset quota2[7]);
	end


	if (mode>0)
		write_int(square8,28,45,4,offset quota[0]);
		write_int(square8,28,71,4,offset quota[1]);
		write_int(square8,28,97,4,offset quota[2]);
		write_int(square8,28,123,4,offset quota[3]);
		write_int(square8,28,149,4,offset quota[4]);
		write_int(square8,28,175,4,offset quota[5]);
		write_int(square8,28,201,4,offset quota[6]);
		write_int(square8,28,227,4,offset quota[7]);
	end


	write_int(square10,292,21,5,offset minutes);
	write(square10,296,19,4,":"); 
	write_int(square10,304,21,4,offset tenseconds);
	write_int(square10,313,21,4,offset seconds);

	write_int(square10,18,24,4,offset target);
	write_int(square10,295,50,4,offset stage);	
	write_int(square8,295,79,4,offset score);	
	write_int(square10,308,115,4,offset hints);		

	for(x=0;x<8;x++)
		for(y=0;y<8;y++)
			tiles[x][y].anim = 1;
		end
	end
	
	cursor = control(); 
	signal(cursor, s_sleep);
	lucky = luckyanimal(); 

	timebar=time_bar(mode); // <=== Fait planter la GP32 !?

	signal(timebar,s_freeze);
	// Après divers test, ce ne sont pas les signals sleep et wake_up de la timebar
	// et du curseur qui font tout planter :-/

	board=tile_display();
	stage=0;
	score=0;
	hints=3;

	for(a=0;a<8;a++)
		quota[a]=0;
	end

//play_song(game_song[rand(0,2)],-1);
 
	repeat
		stage++;
		lucky.x=348;
		put_screen(0,bg);

		if (mode==0)
			levelcomplete=0; 
 	
			for(a=0;a<8;a++)
				quota[a]=0; 
				mask[a]=0;
			end
	

			max_animals=6;
			if (stage>9)
				max_animals = 7;
			end
			lucky_animal = rand(0, max_animals);
	
			target = stage+2;
	
			for (a=0;a<max_animals+1;a++)
				quota2[a]=target; 
			end 
	
			timebar.x+=71;
			if (timebar.x>259)
				timebar.x=259;
			end  
	
			for(x=0;x<8;x++)
				for(y=0;y<8;y++)
					tiles[x][y].anim=1;
				end
			end
	
			map_put(0,message_board,30,79,79);
	
			tempmap=write_in_map(dusty21,"STAGE",4);
			map_put(0,message_board,tempmap,79,24);
			unload_map(0,tempmap);
			
			tempmap=write_in_map(dusty21,stage,4);
			map_put(0,message_board,tempmap,79,54);
			unload_map(0,tempmap); 
			
			tempmap=write_in_map(dusty14,"QUOTA: "+target,4);
			map_put(0,message_board,tempmap,79,82);
			unload_map(0,tempmap);
			
			tempmap=write_in_map(dusty10,"LUCKY",4);
			map_put(0,message_board,tempmap,79,106);
			unload_map(0,tempmap);
														
			map_put(0,message_board,116+lucky_animal,79,133);
			
			y=126;
			
			graph=message_board;
			for(x=-80;x<153;x+=25)
			frame;
			end
			x=153;

			delay=0;
			
			repeat
			delay++;
			frame;
		until(delay>45)

		for (x=153; x<460; x+=25)
			frame;
		end 
		graph = no_graph;
	end

if(mode==1)

map_put(0,message_board,30,79,79);
	
	tempmap=write_in_map(dusty14,"TIME",4);
	map_put(0,message_board,tempmap,79,15);
	unload_map(0,tempmap);
	
	tempmap=write_in_map(dusty14,"ATTACK",4);
	map_put(0,message_board,tempmap,79,35);
	unload_map(0,tempmap); 
	
	tempmap=write_in_map(dusty10,"SCORE",4);
	map_put(0,message_board,tempmap,79,53);
	unload_map(0,tempmap);
	
	tempmap=write_in_map(dusty10,"20,000 POINTS",4);
	map_put(0,message_board,tempmap,79,68);
	unload_map(0,tempmap);   
	
	tempmap=write_in_map(dusty10,"AS QUICKLY",4);
	map_put(0,message_board,tempmap,79,83);
	unload_map(0,tempmap);   
	
	tempmap=write_in_map(dusty10,"AS POSSIBLE",4);
	map_put(0,message_board,tempmap,79,98);
	unload_map(0,tempmap);
	                             
	tempmap=write_in_map(dusty10,"LUCKY",4);
	map_put(0,message_board,tempmap,79,120);
	unload_map(0,tempmap);
	                                                   
	                             
	map_put(0,message_board,116+lucky_animal,79,141);
	
	
	y=126;
	
	graph=message_board;
	for(x=-80;x<153;x+=25)
	frame;
	end
	x=153;

	delay=0;
	
	repeat
	delay++;
	frame;
	until(delay>45)

	for(x=153;x<460;x+=25)
	frame;
	end 
	graph=no_graph;

end

	if(mode==2)
	
		minutes=5;
		tenseconds=0;
		seconds=0;
		
		map_put(0,message_board,30,79,79);
			
			tempmap=write_in_map(dusty14,"SCORE",4);
			map_put(0,message_board,tempmap,79,15);
			unload_map(0,tempmap);
			
			tempmap=write_in_map(dusty14,"ATTACK",4);
			map_put(0,message_board,tempmap,79,35);
			unload_map(0,tempmap); 
			
			tempmap=write_in_map(dusty10,"SCORE AS MANY",4);
			map_put(0,message_board,tempmap,79,53);
			unload_map(0,tempmap);
			
			tempmap=write_in_map(dusty10,"POINTS AS",4);
			map_put(0,message_board,tempmap,79,68);
			unload_map(0,tempmap);   
			
			tempmap=write_in_map(dusty10,"POSSIBLE IN",4);
			map_put(0,message_board,tempmap,79,83);
			unload_map(0,tempmap);   
			
			tempmap=write_in_map(dusty10,"5 MINUTES",4);
			map_put(0,message_board,tempmap,79,98);
			unload_map(0,tempmap);
			                             
			tempmap=write_in_map(dusty10,"LUCKY",4);
			map_put(0,message_board,tempmap,79,120);
			unload_map(0,tempmap);
			                                                   
			                             
			map_put(0,message_board,116+lucky_animal,79,141);
			
			
			y=126;
			
			graph=message_board;
			for(x=-80;x<153;x+=25)
			frame;
			end
			x=153;
		
			delay=0;
			
			repeat
			delay++;
			frame;
			until(delay>45)
		
			for(x=153;x<460;x+=25)
			frame;
			end 
			graph=no_graph;
		
	end 



if(max_animals<7)xput(0,224,19,226,0,100,4,0);end
if(hints<=0)xput(0,225,294,113,0,100,4,0);end

new_board();

signal(cursor,s_wakeup);
signal(timebar,s_wakeup);


timer[3]=0;

repeat

if(exists(type no_more_moves))
	timer_store=timer[3];
	repeat
	frame;
	until(exists(type no_more_moves)==0)
	timer[3]=timer_store;
end


if(mode<>2)
	if(timer[3]=>100)seconds++;timer[3]-=100;end
	if(seconds>9)tenseconds++;seconds=0;end 
	if(tenseconds>5)minutes++;tenseconds=0;end
end  

if(mode==2)
	if(timer[3]=>100)seconds--;timer[3]-=100;end
	if(seconds<0)tenseconds--;seconds=9;end 
	if(tenseconds<0)minutes--;tenseconds=5;end
end

if(key(_enter) and keypressed==0)
		keypressed=1;
		graph=31;
		x=153;y=126;
		signal(timebar,s_freeze);
		signal(board,s_freeze);
		signal(cursor,s_freeze_tree);
		timer_store=timer[3];
		pause_song();
    repeat
    
    if(key(_backspace) and key(_tab))quit_to_title();end
       
    frame;
    until(keypressed==0 and key(_enter))
    resume_song();
    keypressed=1;
    graph=no_graph;
    signal(timebar,s_wakeup);
    signal(board,s_wakeup);
    signal(cursor,s_wakeup_tree); 
    timer[3]=timer_store;
end
 
 
			if(mode==0)
				target_reached=0;
				for(a=0;a<max_animals+1;a++)
					quota2[a]=target-quota[a];
					if(quota2[a]<=0)
					quota2[a]=0;
					if(mask[a]==0)xput(0,224,19,44+(a*26),0,100,4,0);mask[a]=1;end
					end
					target_reached+=quota2[a];
				end
				if(target_reached==0)levelcomplete=1;level_up();end
			end 
			 
			 
			 
			if(mode==0 and timebar.x<=45 and levelcomplete==0)
					levelcomplete=1;
					gameover=1;
     	end  
			      
			      
			      
						if(mode==1 and score>=20000)
								time_score=(((minutes*60)+(tenseconds*10)+seconds)*100)+timer[3];
								levelcomplete=1;
								gameover=1; 
						end
								        
										if(mode==2 and minutes==0 and tenseconds==0)
												timebar.x=60;
										end						     
								        
										if(mode==2 and minutes+tenseconds+seconds==0)
												levelcomplete=1;
												gameover=1;
										end  
						
						
						
								if(mode==0 and gameover==1)
								
									repeat
										target_reached=0;
												for(a=0;a<max_animals+1;a++)
													if(quota[a]>=target)target_reached++;end       /////////// double check incase target reached at last second
												end
										if(target_reached==max_animals+1)gameover=0;levelcomplete=1;level_up();end
										if(target_reached<max_animals+1 and timebar.x>45)gameover=0;levelcomplete=0;end										 
										frame;
									until((exists(type swap_tiles)==0 and exists(type special)==0) or gameover==0)
								end								
						
						
						
										
												
	 
						if(levelcomplete==1)
						signal(cursor,s_sleep);
						signal(timebar,s_freeze);
						
	
						
						repeat 
				    frame;
						until(exists(type swap_tiles)==0 and exists(type special)==0)
						

							
							if(gameover==1 and mode==0)
								check_moves(1); 
								for(delay=0;delay<30;delay++)
								frame;
								end
								
							end
							
							//if(mode==0 and gameover==0);end
							 
	                								
									for(xpos=0;xpos<8;xpos++)
										for(ypos=0;ypos<8;ypos++)
												tiles[xpos][ypos].anim=6;
                        tiles[xpos][ypos].wait=100;
										end
									end
								
								for(delay=0;delay<15;delay++)
								frame;
								end
							
							if(gameover==0)
// play_wav(win_sound, 0);
end
							if(gameover==1)
// play_wav(fall_sound, 0);
end
							
						  gravity=0;
							repeat
							
							for(xpos=0;xpos<8;xpos++)
								for(ypos=0;ypos<8;ypos++)
									if(tiles[xpos][ypos].number<8)tiles[xpos][ypos].anim=6;end
								tiles[xpos][ypos].wait=100;
								tiles[xpos][ypos].yoffset-=gravity;
								end
							end
							gravity++;
							if(gameover==0)lucky.x+=8;end
							
							frame;
							until(tiles[0][0].yoffset<=-265)
						  

						  
						end 
						    
						    
						    
						

 

frame;
until(levelcomplete==1 or gameover==1)
bg = rand(200,203); // Nombre de décors réduit
//bg=rand(200,209);
until(gameover==1)

tempmap=get_screen();
put_screen(0,tempmap);
unload_map(0,tempmap);
delete_text(all_text);
 
signal(cursor,s_kill);
signal(timebar,s_kill);
signal(board,s_kill); 
signal(lucky,s_kill);



if(mode==0)
//play_song(gameover_song,0);
word_drop("GAME OVER",60,162);
word_drop("SCORE",100,162); 
word_drop(score,130,162); 
end    

if(mode==1)
//play_song(goal_song,0);
text=(time_score/100)/60;
text=text+":";
text=text+((time_score/100)%60);
text=text+".";
if(time_score%100<10)text=text+"0";end
text=text+(time_score%100);

word_drop("!!GOAL!!",60,162);
word_drop("TIME",100,162); 
word_drop(text,130,162); 
end  

if(mode==2)
//play_song(goal_song,0);
word_drop("TIME UP",60,162);
word_drop("SCORE",100,162); 
word_drop(score,130,162); 
end 

timer[3]=0;

repeat
frame;
until(exists(type letter)==0)

repeat
frame;
until(key(_alt) or key(_z) or mouse.left or timer[3]>700)
stop_song();
if((score>hiscores[mode][difficulty][9].score and mode<>1) or (mode==1 and time_score<hiscores[mode][difficulty][9].time))
hiscore_entry(mode,difficulty);
else
title(1);
end

end



process level_up();

private
delay;

begin 

// play_wav(levelup_sound, 0);

	graph=805; 
	z=-512;
	
	x=153;
		for(y=280;y>125;y-=25) 
		frame;
		end 
	y=126;
							
		for(delay=0;delay<30;delay++)
		frame;
		end  
							
	x=153;
		for(y=126;y>-40;y-=25) 
		frame;
		end

end




process hiscore_entry(mode,difficulty)

private
pos; 
delay;

string lastname;
string defaultname;
string text;

int save_txt;

begin

//play_song(hiscore_song,-1);

transition(900,0);

repeat
frame;
until(exists(type transition_block)==0)


for(x=9;x>-1;x--)
		if(mode<>1 and score>hiscores[mode][difficulty][x].score)pos=x;end
		if(mode==1 and time_score<hiscores[mode][difficulty][x].time)pos=x;end
end 

for(x=9;x>pos;x--)
hiscores[mode][difficulty][x].score=hiscores[mode][difficulty][x-1].score;
hiscores[mode][difficulty][x].time=hiscores[mode][difficulty][x-1].time;
	for(y=0;y<6;y++)
	hiscores[mode][difficulty][x].name[y]=hiscores[mode][difficulty][x-1].name[y];
	end
end
 
text=pos+1;
text=text+") ";

	if(mode<>1)text=text+score;end 
	
		if(mode==1)
			text=text+(time_score/100)/60;
			text=text+":";
			text=text+((time_score/100)%60);
			text=text+".";
			if(time_score%100<10)text=text+"0";end
			text=text+(time_score%100);
	   end



word_drop(text,60,170);

if(mode<>1)word_drop("TOP 10 HISCORE",30,170);end 
if(mode==1)word_drop("TOP 10 TIME",30,170);end 

for(delay=0;delay<60;delay++)
frame;
end

defaultname="";
lastname="";
for(y=0;y<6;y++)
defaultname+=chr(options.default_name[y]);
lastname+=chr(options.last_name[y]);
end

if(options.name_entry==0)z=virtual_keyboard("","",6);end
if(options.name_entry==1)z=virtual_keyboard("",lastname,6);end
if(options.name_entry==2)z=virtual_keyboard("",defaultname,6);end

repeat
frame;
until(exists(z)==0) 

word_drop(input,120,170);

repeat
frame;
until(exists(type letter)==0)

for(y=0;y<6;y++)
hiscores[mode][difficulty][pos].name[y]=0;
options.last_name[y]=0;
end
 
for(y=0;y<len(input);y++)
		hiscores[mode][difficulty][pos].name[y]=asc(substr(input,y,1)); 
		options.last_name[y]=asc(substr(input,y,1));
end 

if(mode==1)hiscores[mode][difficulty][pos].time=time_score;end
if(mode<>1)hiscores[mode][difficulty][pos].score=score;end

save_txt = write(dusty10, 160, 120, 4, "Saving highscores...");
frame;
save("HISCORES", hiscores);
delete_text(save_txt);

save_txt = write(dusty10, 160, 120, 4, "Saving options, please wait...");
frame;
save("OPTIONS", options);
delete_text(save_txt);

fade_music_off(2000); 

repeat
frame;
until(is_playing_song()==0)

title(1);

end  




process word_drop(string text,int target_y,xoffset)

private
pos;

begin
x=xoffset-((len(text)*18)/2);

for(pos=0;pos<len(text);pos++)
	letter(substr(text,pos,1),x+pos*18,rand(-100,-20),target_y);
end



end
 
 
 
 
 
 
process letter(string text,int x,int y,int target_y)

Private
gravity;
temp;

begin

temp=write_in_map(dusty14,text,4);

graph=temp;

repeat 
gravity++;
if(gravity>16)gravity=16;end
y+=gravity; 
if(y>=target_y)y=target_y;gravity=gravity/1.5;gravity=-gravity;end
frame;
until(gravity>-2 and gravity<2 and y>target_y-1 and y<target_y+1)

put(0,temp,x,target_y);

unload_map(0,temp);

end





process control()

private
	tile_selected;
	anim;
	delay;
	move_delay;
	keypressed2;

begin
	//graph=50;
	no_click=0;
	z=-255;

	loop

		/// testing if(key(_space))no_more_moves();end
	 
		if (no_click==1)
			tile_selected=0;
		end

		if (keypressed==0)
			move_delay=0;
		end
		
		if (keypressed==1 and (key(_up) or key(_down) or key(_left) or key(_right)))
			move_delay++;
		end
		
		if (move_delay=>options.cursor_speed)
			keypressed=0;
			move_delay=0;
		end

		if (key(_alt)==0 and key(_z)==0)
			keypressed2=0;
		end

		if (keypressed2==0 and no_click==0 and (key(_alt) or key(_z)))
			if (tile_selected==0)
				tile_selected=1;
				if (tiles[tile1x][tile1y].number<8)
					// play_wav(blip_sound, 0);
				end
			else
				tile_selected=0;
			end
			
			keypressed2 = 1;
			
			if (tiles[tile1x][tile1y].number==8)
				tile_selected=0;
				special(tile1x, tile1y);
				no_click=1;
			end
		end
			
		if (tile_selected==0)
			if (key(_left) and keypressed==0)
				tile1x--;
				keypressed=1;
				// play_wav(blip2_sound, 0);
			end 
				
			if (key(_right) and keypressed==0)
				tile1x++;
				keypressed=1;
				// play_wav(blip2_sound, 0);
			end 
				
			if (key(_up) and keypressed==0)
				tile1y--;
				keypressed=1;
				// play_wav(blip2_sound, 0);
			end 
				
			if (key(_down) and keypressed==0)
				tile1y++;
				keypressed=1;
				// play_wav(blip2_sound, 0);
			end 
					
			if(tile1x<0)tile1x=7;end 
			if(tile1x>7)tile1x=0;end 
			if(tile1y<0)tile1y=7;end
			if(tile1y>7)tile1y=0;end
		end 
			
		if (tile_selected==1 and (key(_up) or key(_down) or key(_left) or key(_right))) 
			keypressed = 0;
			tile2x = tile1x;
			tile2y = tile1y;
		
			if (key(_left) and tile1x>0 and keypressed==0)
				tile2x--;
				keypressed = 1;
			end 
			if (key(_right) and tile1x<7 and keypressed==0)
				tile2x++;
				keypressed=1;
			end 
			if (key(_up) and tile1y>0 and keypressed==0)
				tile2y--;
				keypressed=1;
			end 
			if (key(_down) and tile1y<7 and keypressed==0)
				tile2y++;
				keypressed=1;
			end 
				
			swap_tiles (tile1x, tile1y, tile2x, tile2y);
			tile_selected = 0;
			no_click = 1;   
			keypressed = 1; ///////? prevents cursor moving when doing swap - may cause problems needs testing
					
		end


		if (((mouse.left and mouse.x>=269 and mouse.x<=319 and mouse.y>=101 and mouse.y<=126) or key(_control) or key(_x)) and no_click==0 and keypressed==0 and hints>0)
			// play_wav(hint_sound, 0);
			check_moves(1);
			hints--;
			keypressed=1;
			if (hints<=0)
				// xput(0,225,294,113,0,100,4,0);
				xput(0,225,294,113,0,100,0,0);
			end
		end
   

		if (no_click==0 and mouse.left and mouse.x>=45 and mouse.x<=260 and mouse.y>=18 and mouse.y<=233)
			tile2x=(mouse.x-45)/27;			
			tile2y=(mouse.y-18)/27;
				
			if (tile_selected==0 and keypressed==0)
				tile1x=tile2x;
				tile1y=tile2y;
				tile_selected=1;
				if(tiles[tile1x][tile1y].number<8)
          // play_wav(blip_sound, 0);
        end	
					
  			if (tiles[tile1x][tile1y].number==8 and no_click==0)
  				tile_selected=0;
  				special(tile1x,tile1y);
  				no_click=1;
  			end
			
        keypressed=1;
      end 
   			
  		if (tile_selected==1 and keypressed==0 and tile1x==tile2x and tile1y==tile2y)
  			tile_selected=0;
  			keypressed=1;
  		 end
  		
  		//keypressed=1;	

				
  		if (tile_selected==1)
  			if ((tile2x==tile1x+1 and tile2y==tile1y) or (tile2x==tile1x-1 and tile2y==tile1y) or (tile2x==tile1x and tile2y==tile1y+1) or (tile2x==tile1x and tile2y==tile1y-1))
  					
  				swap_tiles(tile1x,tile1y,tile2x,tile2y);
  				tile_selected=0;
  				no_click=1;
  				
  			else
  				if (tiles[tile1x][tile1y].number<8 and keypressed==0)
  					// play_wav(blip_sound, 0);
  				end
  				
  				tile1x=tile2x;
  				tile1y=tile2y;
  				tile_selected=1;
  				
  				if(tiles[tile1x][tile1y].number==8 and no_click==0)
  					tile_selected=0;
  					special(tile1x,tile1y);
  					no_click=1;
  				end
  									
  			end 
  		end
  		keypressed=1;
   			 	
    end 
   	
  	delay++;

  	if(delay>1)
  		delay=0;
  		anim++;
  	end

  	if (anim>3)
  		anim=0;
  	end 
  	 
  	graph = 50 + anim + (tile_selected * 4);
  	x = (tile1x * 27) + 58; 
  	y = (tile1y * 27) + 31;  		
  	frame;
  end
end


//-----------------------------------------------------------------------------


process special (tilex, tiley)

begin 
  // play_wav(special_sound, 0);

tiles[tilex][tiley].number=board.anim_frame;		  
//tiles[tilex][tiley].anim=2; 
//tiles[tilex][tiley].wait=10;  
		  
		for(x=0;x<8;x++)
 			for(y=0;y<8;y++)
 				if(tiles[x][y].number==board.anim_frame)
 				tiles[x][y].anim=2; 
			 	tiles[x][y].wait=10;
			 	score_display((x*27)+58,(y*27)+31,10,board.anim_frame-lucky_animal);
			 	
			 	end
			end
		end


busy=1;
		
repeat
frame;
until(busy==0)


drop_tiles();

repeat
frame;
until(exists(son)==0)

check_for_lines(0);

repeat
frame;
until(exists(son)==0) 

check_moves(0);

repeat
frame;
until(exists(son)==0)

if(available_moves==0)
no_more_moves();
end   

no_click=0;

end







process swap_tiles(tile1x,tile1y,tile2x,tile2y)

private
tile1x_old;
tile1y_old;
tile2x_old;
tile2y_old;
moved=0;
tile1;
tile2;

begin 

//repeat
//frame;
//until(key(_space)==0)

// play_wav(swap_sound, 0);

tiles[tile1x][tile1y].anim=1;
tiles[tile2x][tile2y].anim=1;

tile1=tile(-30,-30,tiles[tile1x][tile1y].number);   
tile2=tile(0,0,tiles[tile2x][tile2y].number);


		if(moved==0 and tile1x<tile2x)
		x=(tile1x*27)+58+13;
		y=(tile1y*27)+31;

			for (graph=60;graph<67;graph++) 
			get_real_point(1,offset tile1.x,offset tile1.y);
			get_real_point(2,offset tile2.x,offset tile2.y);
			frame;	
		  end
		end  
		
		if(moved==0 and tile2x<tile1x)
		x=(tile2x*27)+58+13;
		y=(tile1y*27)+31;

			for (graph=66;graph>59;graph--) 
			get_real_point(1,offset tile1.x,offset tile1.y);
			get_real_point(2,offset tile2.x,offset tile2.y);
			frame;	
		  end
		end
		
		if(moved==0 and tile1y<tile2y)
		x=(tile1x*27)+58;
		y=(tile1y*27)+31+13;

			for (graph=70;graph<77;graph++) 
			get_real_point(1,offset tile1.x,offset tile1.y);
			get_real_point(2,offset tile2.x,offset tile2.y);
			frame;	
		  end
		end
		
		if(moved==0 and tile2y<tile1y)
		x=(tile1x*27)+58;
		y=(tile2y*27)+31+13;

			for (graph=76;graph>69;graph--) 
			get_real_point(1,offset tile1.x,offset tile1.y);
			get_real_point(2,offset tile2.x,offset tile2.y);
			frame;	
		  end
		end
		

tiles[tile1x][tile1y].number=tile2.tile_number;
tiles[tile2x][tile2y].number=tile1.tile_number;
tiles[tile1x][tile1y].anim=0;
tiles[tile2x][tile2y].anim=0; 

frame;
signal(tile1,s_kill);
signal(tile2,s_kill);

check_for_lines(0);

repeat
frame;
until(exists(son)==0)



if(no_swap==0)
// play_wav(swap_sound, 0);
tiles[tile1x][tile1y].anim=1;
tiles[tile2x][tile2y].anim=1; 

tile1=tile(-30,-30,tiles[tile1x][tile1y].number);   
tile2=tile(-30,-30,tiles[tile2x][tile2y].number);

		if(moved==0 and tile1x<tile2x)
		x=(tile1x*27)+58+13;
		y=(tile1y*27)+31;

			for (graph=66;graph>59;graph--)
			get_real_point(2,offset tile1.x,offset tile1.y);
			get_real_point(1,offset tile2.x,offset tile2.y);
			frame;	
		  end
		end  
		
		if(moved==0 and tile2x<tile1x)
		x=(tile2x*27)+58+13;
		y=(tile1y*27)+31;

			for (graph=60;graph<67;graph++)  
			get_real_point(2,offset tile1.x,offset tile1.y);
			get_real_point(1,offset tile2.x,offset tile2.y);
			frame;	
		  end
		end
		
		if(moved==0 and tile1y<tile2y)
		x=(tile1x*27)+58;
		y=(tile1y*27)+31+13;

			for (graph=76;graph>69;graph--) 
			get_real_point(2,offset tile1.x,offset tile1.y);
			get_real_point(1,offset tile2.x,offset tile2.y);
			frame;	
		  end
		end
		
		if(moved==0 and tile2y<tile1y)
		x=(tile1x*27)+58;
		y=(tile2y*27)+31+13;

			for (graph=70;graph<77;graph++) 
			get_real_point(2,offset tile1.x,offset tile1.y);
			get_real_point(1,offset tile2.x,offset tile2.y);
			frame;	
		  end
		end
		

tiles[tile1x][tile1y].number=tile2.tile_number;
tiles[tile2x][tile2y].number=tile1.tile_number;
tiles[tile1x][tile1y].anim=0;
tiles[tile2x][tile2y].anim=0; 

frame;
signal(tile1,s_kill);
signal(tile2,s_kill);

end

repeat
frame;
until(exists(type check_for_lines)==0)
 

check_moves(0);

repeat
frame;
until(exists(son)==0)

if(available_moves==0)
no_more_moves();
	repeat
	frame;
	until(exists(type no_more_moves)==0);

end

no_click=0;

end




process check_for_lines(mode)

private

prev_number;
count;
combo;
a;

begin 
combo=1;

repeat
lines=0;


		for(y=0;y<8;y++)
		  count=0;
			for(x=1;x<8;x++)
			
			count++;
			prev_number=tiles[x-1][y].number;
			 	
			  	if(count>0 and tiles[x][y].number<>prev_number)
			  		if(count>2 and prev_number<8)
			  				for(a=x-count;a<x;a++)
			  				tiles[a][y].anim=2; 
			  				tiles[a][y].wait=10;
			  				//tiles[a][y].number=34;   ////// need to change
			  			 	end 
			  			 	score_display(((x*27)+58)-(((count+1)*27)/2),((y*27)+31),((count*count)*10)*combo,lucky_animal-prev_number);
			  			 	lines++;
			  	 	end
			  	 count=0;	
			  	end 
			  	
  		  	if(count>1 and x==7 and prev_number<8)
			  			for(a=x-count;a<x+1;a++)
			  			//tiles[a][y].number=34;    /////// need to change 
			  			tiles[a][y].anim=2;
			  			tiles[a][y].wait=10;
			  			end
			  		 	score_display(((x*27)+58)-(((count)*27)/2),((y*27)+31),(((count+1)*(count+1))*10)*combo,lucky_animal-prev_number);
			  		 	lines++; 
		  		end 
			      
			end
		end 
		
		
		for(x=0;x<8;x++)
		  count=0;
			for(y=1;y<8;y++)
			
			count++;
			prev_number=tiles[x][y-1].number;
			 	
			  	if(count>0 and tiles[x][y].number<>prev_number)
			  		if(count>2 and prev_number<8)
			  				for(a=y-count;a<y;a++)
			  				tiles[x][a].anim=2; 
			  				tiles[x][a].wait=10;
			  				//tiles[x][a].number=34;   ////// need to change
			  			 	end
			  			 	score_display(((x*27)+58),((y*27)+31)-(((count+1)*27)/2),((count*count)*10)*combo,lucky_animal-prev_number);
			  			 	lines++; 
			  	 	end
			  	 count=0;	
			  	end 
			  	
  		  	if(count>1 and y==7 and prev_number<8)
			  			for(a=y-count;a<y+1;a++)
			  			//tiles[x][a].number=34;    /////// need to change 
			  			tiles[x][a].anim=2;
			  			tiles[x][a].wait=10;
			  			end 
			  		 	score_display(((x*27)+58),((y*27)+31)-(((count)*27)/2),(((count+1)*(count+1))*10)*combo,lucky_animal-prev_number);
			  		 	lines++;
		  		end 
			      
			end
		end

combo++;

if(lines>0)
	father.no_swap=1;
	busy=1; 
	
		if(combo<=7)  
			// play_wav(match[combo-1], 0);
		else 
			// play_wav(match[6], 0);
		end
end


repeat
frame;
until(busy==0)


drop_tiles();

repeat
frame;
until(exists(son)==0)


until(lines==0)

  
end 





process drop_tiles() 
private
count;
a;

begin 


for(x=0;x<8;x++)
	count=0;
	for(y=7;y>-1;y--)
		
    	
		if(tiles[x][y].number>-1)
		   
		   if(count>0)
		   		tiles[x][y+count].number=tiles[x][y].number;
		   		tiles[x][y+count].yoffset=count*27; 
		   		tiles[x][y+count].anim=0;
		   		tiles[x][y].number=-1; 
		   		count--;
		   end
 		   
		end
	     
	  if(tiles[x][y].number==-1)
		count++;
		end    
	     
	end 
	
	if(count>0)
			for(a=0;a<count;a++)
				if(rand(0,special_odds)==1)
				tiles[x][a].number=8;
				else
			  tiles[x][a].number=rand(0,max_animals);
				end
				
				tiles[x][a].yoffset=count*27;
				tiles[x][a].anim=0;
			
			end
	end 

	
end

repeat

frame;

until(falling==0)


end






process check_moves(mode)

private
x2;
y2;
a;
tile1;
tile2;
tile1_available;
tile2_available;
count;
prev_number;

begin
available_moves=0;

for(y=0;y<8;y++)
	for(x=0;x<8;x++)
	 tiles[x][y].available=0;
	  
	  if(tiles[x][y].number==8)available_moves++;end
	 
	end
end

for(y=0;y<8;y++)
	for(x=0;x<7;x++)
	
	tile1=tiles[x][y].number;
	tile2=tiles[x+1][y].number;
	tile1_available=tiles[x][y].available;
	tile2_available=tiles[x+1][y].available;
	
	tiles[x][y].number=tile2;
	tiles[x+1][y].number=tile1; 
	tiles[x][y].available=tile2_available;
	tiles[x+1][y].available=tile1_available;
	
		  count=0;
			for(x2=1;x2<8;x2++)
			
			count++;
			prev_number=tiles[x2-1][y].number;
			 	
			  	if(count>0 and tiles[x2][y].number<>prev_number)
			  		if(count>2 and prev_number<8)
			  				for(a=x2-count;a<x2;a++)
			  				tiles[a][y].available=1;
			  				end 
			  			 	available_moves++;
			  	 	end
			  	 count=0;	
			  	end 
			  	
  		  	if(count>1 and x2==7 and prev_number<8)
			  			for(a=x2-count;a<x2+1;a++)
			 				tiles[a][y].available=1;
			  		 	end
			  		 	available_moves++; 
		  		end 
			      
			end 
			
			
			for(x2=x;x2<x+2;x2++)
		  count=0;
			for(y2=1;y2<8;y2++)
			
			count++;
			prev_number=tiles[x2][y2-1].number;
			 	
			  	if(count>0 and tiles[x2][y2].number<>prev_number)
			  		if(count>2 and prev_number<8)
			  				for(a=y2-count;a<y2;a++)
			  				tiles[x2][a].available=1; 
			  			 	end
			  			 	available_moves++; 
			  	 	end
			  	 count=0;	
			  	end 
			  	
  		  	if(count>1 and y2==7 and prev_number<8)
			  			for(a=y2-count;a<y2+1;a++)
			  			tiles[x2][a].available=1;
			  		 	end 
			  		 	available_moves++;
		  		end 
			      
				end
			end

	tiles[x][y].number=tile1;
	tiles[x+1][y].number=tile2;
	
	tile1_available=tiles[x][y].available;
	tile2_available=tiles[x+1][y].available;	
	
	tiles[x][y].available=tile2_available;
	tiles[x+1][y].available=tile1_available;	 
	
	
	end
end
	 

for(x=0;x<8;x++)
	for(y=0;y<7;y++)
	
	tile1=tiles[x][y].number;
	tile2=tiles[x][y+1].number;
	tile1_available=tiles[x][y].available;
	tile2_available=tiles[x][y+1].available;
	
	tiles[x][y].number=tile2;
	tiles[x][y+1].number=tile1; 
	tiles[x][y].available=tile2_available;
	tiles[x][y+1].available=tile1_available;
	
		  count=0;
			for(y2=1;y2<8;y2++)
			
			count++;
			prev_number=tiles[x][y2-1].number;
			 	
			  	if(count>0 and tiles[x][y2].number<>prev_number)
			  		if(count>2 and prev_number<8)
			  				for(a=y2-count;a<y2;a++)
			  				tiles[x][a].available=1; 
			  			 	end 
			  			 	available_moves++;
			  	 	end
			  	 count=0;	
			  	end 
			  	
  		  	if(count>1 and y2==7 and prev_number<8)
			  			for(a=y2-count;a<y2+1;a++)
			 				tiles[x][a].available=1;
			  		 	end
			  		 	available_moves++; 
		  		end 
			      
			end 
			
			
			for(y2=y;y2<y+2;y2++)
		  count=0;
			for(x2=1;x2<8;x2++)
			
			count++;
			prev_number=tiles[x2-1][y2].number;
			 	
			  	if(count>0 and tiles[x2][y2].number<>prev_number)
			  		if(count>2 and prev_number<8)
			  				for(a=x2-count;a<x2;a++)
			  				tiles[a][y2].available=1; 
			  			 	end
			  			 	available_moves++; 
			  	 	end
			  	 count=0;	
			  	end 
			  	
  		  	if(count>1 and x2==7 and prev_number<8)
			  			for(a=x2-count;a<x2+1;a++)
			  			tiles[a][y2].available=1;
			  		 	end 
			  		 	available_moves++;
		  		end 
			      
				end
			end

	tiles[x][y].number=tile1;
	tiles[x][y+1].number=tile2;
	
	tile1_available=tiles[x][y].available;
	tile2_available=tiles[x][y+1].available;	
	
	tiles[x][y].available=tile2_available;
	tiles[x][y+1].available=tile1_available;	 
	
	
	end
end

if(mode==1)
  for(x=0;x<8;x++)
  	for(y=0;y<8;y++)
  	  if(tiles[x][y].available==1);
  		tiles[x][y].anim=4;
    	tiles[x][y].direction=-1;
    	tiles[x][y].wait=3;
      end
    end
   end 
   
end




end





process new_board() 

private
tile_fail;

begin

repeat

	for(x=0;x<8;x++)
		for(y=0;y<8;y++)
		
			repeat
			if(rand(0,special_odds)==1)
				tile_number=8;
				else
			  tile_number=rand(0,max_animals);
			end
			 
		  tile_fail=0;
		  
				if(x>1)
					if(tiles[x-1][y].number==tile_number and tiles[x-2][y].number==tile_number)tile_fail=1;end
		    end 
		    
				if(y>1)
					if(tiles[x][y-1].number==tile_number and tiles[x][y-2].number==tile_number)tile_fail=1;end
		    end
		    
		  until(tile_fail==0)
			
			
			tiles[x][y].number=tile_number;
			tiles[x][y].anim=1;
			tiles[x][y].wait=0;
			tiles[x][y].yoffset=0;
			
		  
		end
  end
check_moves(0);     
until(available_moves>0)

for(y=0;y<8;y++)
	for(x=0;x<8;x++)
	tiles[x][y].anim=4;
	tiles[x][y].wait=1; 
	tiles[x][y].direction=1;
	tiles[x][y].scale=-2;
	end

frame;
end

end 






process tile_display()

private
xpos;
ypos;
delay;
jitterx;
jittery;



begin 
graph=tile_map;
x=153;
y=126;
priority=100;

loop
falling=0;
 map_clear(0,tile_map,0);
 delay++;
jitterx=0;
jittery=0;

 
 
 if(delay>2)
 anim_frame++;
 delay=0;
 end
 
 
 if(anim_frame>max_animals)anim_frame=0;end
 
 
		for(xpos=0;xpos<8;xpos++)
			for(ypos=0;ypos<8;ypos++)
			 
			 		if(timebar.x<=70)
 					jitterx=rand(-1,1);
 					jittery=rand(-1,1);
 					end
			
				
				if(tiles[xpos][ypos].anim==0 and tiles[xpos][ypos].number<8);
				map_put(0,tile_map,tiles[xpos][ypos].number+116,(xpos*27)+17+jitterx,(ypos*27)+17-tiles[xpos][ypos].yoffset+jittery);
				end 
				
				if(tiles[xpos][ypos].number==8 and tiles[xpos][ypos].anim==0)
					map_put(0,tile_map,148+anim_frame,(xpos*27)+17+jitterx,(ypos*27)+17-tiles[xpos][ypos].yoffset+jittery);
				end
				
				
				if(tiles[xpos][ypos].anim==2);
				map_put(0,tile_map,tiles[xpos][ypos].number+140,(xpos*27)+17,(ypos*27)+17-tiles[xpos][ypos].yoffset);
				tiles[xpos][ypos].wait--;
				
					if(tiles[xpos][ypos].wait<0)tiles[xpos][ypos].anim=3;tiles[xpos][ypos].wait=0;quota[tiles[xpos][ypos].number]++;end
				
				end
				
				if(tiles[xpos][ypos].anim==3);
				map_put(0,tile_map,156+tiles[xpos][ypos].wait,(xpos*27)+17,(ypos*27)+17);
				tiles[xpos][ypos].wait++;
				
					if(tiles[xpos][ypos].wait>12)tiles[xpos][ypos].anim=0;tiles[xpos][ypos].wait=0;busy=0;tiles[xpos][ypos].number=-1;end
				
				end
				
				if(tiles[xpos][ypos].anim==4);
						 map_put(0,tile_map,tiles[xpos][ypos].number+116+(tiles[xpos][ypos].scale*8),(xpos*27)+17,(ypos*27)+17);
						 tiles[xpos][ypos].scale+=tiles[xpos][ypos].direction;
						 if(tiles[xpos][ypos].scale>2)tiles[xpos][ypos].scale=1;tiles[xpos][ypos].direction=-1;tiles[xpos][ypos].wait--;end 
						 if(tiles[xpos][ypos].scale<-2)tiles[xpos][ypos].scale=-1;tiles[xpos][ypos].direction=1;end 
						 if(tiles[xpos][ypos].scale==0 and tiles[xpos][ypos].wait<=0)tiles[xpos][ypos].anim=0;tiles[xpos][ypos].wait=0;end
				end
				
				if(tiles[xpos][ypos].anim==5);
				map_put(0,tile_map,156+tiles[xpos][ypos].wait,(xpos*27)+17,(ypos*27)+17);
				tiles[xpos][ypos].wait--;
				
					if(tiles[xpos][ypos].wait<0)tiles[xpos][ypos].anim=4;tiles[xpos][ypos].wait=0;tiles[xpos][ypos].direction=1;tiles[xpos][ypos].scale=-2;busy=0;end
				
				end
				
				if(tiles[xpos][ypos].anim==6); ////anim when no moves available and endo of level
				map_put(0,tile_map,tiles[xpos][ypos].number+140,(xpos*27)+17,(ypos*27)+17-tiles[xpos][ypos].yoffset);
				tiles[xpos][ypos].wait--;
				
					if(tiles[xpos][ypos].wait<0)tiles[xpos][ypos].anim=3;tiles[xpos][ypos].wait=0;end
				
				end
				 
				
				if(tiles[xpos][ypos].yoffset>0)
						tiles[xpos][ypos].gravity+=2;
						tiles[xpos][ypos].yoffset-=tiles[xpos][ypos].gravity; 
						 	falling++;
							if(tiles[xpos][ypos].gravity>15)tiles[xpos][ypos].gravity=15;end
						
						 	if(tiles[xpos][ypos].yoffset<=0)tiles[xpos][ypos].yoffset=0;tiles[xpos][ypos].gravity=0;end
				end
				
				
				
			end
		end


frame;

end

end






process tile(x,y,tile_number)

begin
graph=tile_number+116;
z=-253;


loop

if(tile_number==8)graph=148+board.anim_frame;end 

frame;
end



end 
 
 
 
 
 
 
 
 
 
 
process time_bar(mode)

private
	int delay;


begin
	// region = 1;
	graph = 220;
	x = 259;
	y = 8;
	//alpha = 0;

	if (mode<>0)
		graph = no_graph;
	end

	//repeat
	//	alpha+=16;
	//	frame;
	//until(alpha>=255)
	//alpha = 255;
		 
	loop
		graph = 223;
		if (x>70)
			graph = 222;
		end 
		if (x>99)
			graph = 221;
		end 
		if (x>152)
			graph = 220;
		end 
		if(mode<>0)
			graph = no_graph;
		end

		delay = 25 - stage;

		if (delay<8) 
			delay=8;
		end

		if (timer[0]>delay and mode==0)
			timer[0]=0;
			x--;
		end  

		if (x>259)
			x=259;
		end

		if(x<45)
			x=45;
		end

		frame;
	 
	end  

end 












process no_more_moves()

private
delay;

begin 
// play_wav(no_moves_sound, 0);
//signal(cursor,s_freeze);
signal(timebar,s_freeze);
busy=1;
z=-512;

for(x=0;x<8;x++)
	for(y=0;y<8;y++)
	 	tiles[x][y].anim=6;
	 	tiles[x][y].wait=15;
	end
end 

repeat
frame;
until(busy==0) 
 
 
for(x=0;x<8;x++)
	for(y=0;y<8;y++)
	tiles[x][y].anim=1;
	end
end  

graph=32;
x=153;
for(y=-55;y<125;y+=25) 
frame;
end 
y=126;

repeat
delay++;
frame;
until(delay>45)  

x=153;
for(y=126;y<300;y+=25) 
frame;
end
graph=no_graph; 



new_board();

repeat

frame;

until(exists(son)==0)

signal(timebar,s_wakeup);





end 



process score_display(x,y,value,lucky)

private
delay;
temptext;

begin 

 		if(lucky==0)
		temptext=write(score_font,x,y,4,"2X "+value);
		score+=value*2;
		timer[1]=0;
		else
		temptext=write(score_font,x,y,4,value);
		score+=value;
		end 
		
		timebar.x+=value/10;
		if(timebar.x>259)timebar.x=259;end

repeat
delay++;
frame;
until(delay>25)
delete_text(temptext);

end 


process luckyanimal();

begin 
x=293;
y=184;
z=255;

loop

graph=250+(lucky_animal*2);
if(timer[1]<150)graph++;end
if(x>293)x-=4;end 
if(x<293)x=293;end


frame;

end

end 





process transition(map,mode)

private 
  spd;
  tx;
  ty;

begin 

x=0;y=0;

	if(mode==0)
			
			/*repeat  
		
			    
				 	for(spd=0;spd<20;spd++)
				 	transition_block(tx,ty,map);
				  tx-=20;ty+=20; 
				  
					  if(tx<0 or ty>220)
						  x+=20; 
						  	if(x>300)x=300;y+=20;end
						  tx=x;ty=y;
					  end	
					  
				  end    
			frame;	  
			until(y>=240)  */
			
	repeat
			for(spd=0;spd<2;spd++)
			
					repeat
					transition_block(tx,ty,map,0);
					tx-=20;ty+=20;
						
					until(tx<0 or ty>220)
					x+=20;tx=x;
					if(x>300)tx=300;y=x-300;end 
				  ty=y;
		        		
			end 
			frame;
	until(y>220)
	
	end  
		
		repeat
		frame;
		until(exists(type transition_block)==0)

	end  
 
 
 
process transition_block(x,y,map,mode) 

private
temp;

begin 
temp=new_map(20,20,16);
map_block_copy(0,temp,0,0,map,x,y,20,20,0);


	graph=temp;
	x+=10;y+=10;
	
if(mode==0)	
	size=0;
	
	repeat 
	size+=20;
	frame;
	until(size=>100) 
end
/*
if(mode==1)
	alpha=0;
	
	repeat 
	alpha+=64;
	frame;
	until(alpha=>255)
end
*/
put(0,temp,x,y);
unload_map(0,temp);


end

























process virtual_keyboard (string message, input, int length);

private
  key_value;
  max_char;
  key_layout;

  text_cursor;
  text_input;
  text_line1;
  text_line2;
  text_line3;
  text_line4;

  kb_cursor_x;
  kb_cursor_y;

  cursor_fade;
  blink; 
  move_delay;
  string curs;

begin
  x=160;

  z=-254;
  graph=kb_image[0]; 

  for(y=320;y>166;y=y-20)
  frame;
  end 
  y=166;


  keyboard_cursor();

  key_layout=0;


  text_input=write_string(dusty14,160,114,4,offset input);
  text_cursor=write_string(dusty14,160,116,3,offset curs);

  set_text_color(rgb(250,250,180));

  text_line1=write(tiny_font,12,106,3,message);
  text_line2=write(tiny_font,12,130,3,"MAXIMUM CHARACTERS: "+length);
  text_line3=write_var(tiny_font,212,130,5,max_char);
  text_line4=write(tiny_font,308,130,5,"CHARACTERS REMAINING");

  repeat

  if(keypressed==0)move_delay=0;end
  if(keypressed==1 and (key(_up) or key(_down) or key(_left) or key(_right)))move_delay++;end
  if(move_delay=>15)keypressed=0;move_delay=11;end

  delete_text(all_text);

  text_input=write(dusty14,160,110,4,input);

  set_text_color(rgb(250,250,180));

  text_line1=write(square8,12,106,3,message);
  text_line2=write(tiny_font,12,130,3,"MAXIMUM CHARACTERS: "+length);
  text_line3=write_var(tiny_font,212,130,5,max_char);
  text_line4=write(tiny_font,308,130,5,"CHARACTERS REMAINING");
  		
  graph=kb_image[key_layout];
  /*
  if(cursor_fade==0)son.alpha=son.alpha-40;end
  if(cursor_fade==1)son.alpha=son.alpha+40;end 
  if(son.alpha>255)son.alpha=255;cursor_fade=0;end
  if(son.alpha<20)son.alpha=100;cursor_fade=1;end
*/
  				
      if(blink<5)curs="_";end
      if(blink>=5)curs="";end
      if(len(input)=>length)curs="";end
      blink++;
      if(blink>9)blink=0;end 
      
      max_char=length-len(input);
      text_cursor=write(dusty14,160+(text_width(dusty14,input)/2),110,3,curs);
      //move_text(text_cursor,160+(text_width(dusty14,input)/2),115);
      key_value=0;
      
  		if(mouse.left==0 and key(_alt)==0 and key(_z)==0 and key(_backspace)==0 and key(_tab)==0 and key(_enter)==0 and key(_left)==0 and key(_right)==0 and key(_up)==0 and key(_down)==0)keypressed=0;end 
      
  		 
    	
  /////// the next section controls the joystick placement and movement.
  		 	
    	if(key(_left) and kb_cursor_y<3 and keypressed==0)kb_cursor_x--;keypressed=1;end	
    	if(key(_right) and kb_cursor_y<3 and keypressed==0)kb_cursor_x++;keypressed=1;end 
    	if(key(_up) and keypressed==0)kb_cursor_y--;keypressed=1;end	
    	if(key(_down) and kb_cursor_y<2 and keypressed==0)kb_cursor_y++;keypressed=1;end 
    	
    	//special conditions for bottom row
    		if(key(_down) and kb_cursor_y==2 and keypressed==0)
    			kb_cursor_y++;keypressed=1;
    				if(kb_cursor_x<3)kb_cursor_x=1;end
    				if(kb_cursor_x=>3 and kb_cursor_x<9)kb_cursor_x=5;end
    				if(kb_cursor_x>9)kb_cursor_x=11;end	
    		end 
    		
    		if(key(_left) and kb_cursor_y==3 and keypressed==0)
    			keypressed=1;
    				if(kb_cursor_x==5)kb_cursor_x=1;end
    				if(kb_cursor_x==9)kb_cursor_x=5;end  		
    				if(kb_cursor_x==11)kb_cursor_x=9;end
    		end  
    		
    		if(key(_right) and kb_cursor_y==3 and keypressed==0)
    			keypressed=1;
     				if(kb_cursor_x==9)kb_cursor_x=11;end
    				if(kb_cursor_x==5)kb_cursor_x=9;end  		
            if(kb_cursor_x==1)kb_cursor_x=5;end
    		end		
    		 
    	if(kb_cursor_y<0)kb_cursor_y=0;end
    	
    	
    	if(kb_cursor_y==0)
    		if(kb_cursor_x<0)kb_cursor_x=0;end
    		if(kb_cursor_x>12)kb_cursor_x=12;end
    	end
    	
    	if(kb_cursor_y>0 and kb_cursor_y<3)
    		if(kb_cursor_x<1)kb_cursor_x=1;end
    		if(kb_cursor_x>12)kb_cursor_x=12;end
    	end
    	
    	if(kb_cursor_y==2)
    		if(kb_cursor_x<2)kb_cursor_x=2;end
    	end 
    	
    	if(kb_cursor_y==3)
    		if(kb_cursor_x<1)kb_cursor_x=1;end
    		if(kb_cursor_x>11)kb_cursor_x=11;end
    	end
    	
    	son.y=(kb_cursor_y*24)+151;
    	
    	if(kb_cursor_y==0)son.graph=kb_cursor[0];son.x=(kb_cursor_x*24)+16;end
    	if(kb_cursor_y==1 and kb_cursor_x<10)son.graph=kb_cursor[0];son.x=(kb_cursor_x*24)+4;end
    	if(kb_cursor_y==1 and kb_cursor_x>=10)son.graph=kb_cursor[0];son.x=(kb_cursor_x*24)+16;end
  		if(kb_cursor_y==2 and kb_cursor_x<9)son.graph=kb_cursor[0];son.x=(kb_cursor_x*24)-8;end
  		if(kb_cursor_y==2 and kb_cursor_x==9)son.graph=kb_cursor[1];son.x=214;end
  		if(kb_cursor_y==2 and kb_cursor_x>=10)son.graph=kb_cursor[0];son.x=(kb_cursor_x*24)+16;end
  		if(kb_cursor_y==3 and kb_cursor_x==1)son.graph=kb_cursor[1];son.x=22;end 
  		if(kb_cursor_y==3 and kb_cursor_x==5)son.graph=kb_cursor[3];son.x=124;end 
  		if(kb_cursor_y==3 and kb_cursor_x==9)son.graph=kb_cursor[2];son.x=220;end
  		if(kb_cursor_y==3 and kb_cursor_x==11)son.graph=kb_cursor[0];son.x=280;end
  		
  		
  		if(mouse.left and keypressed==0)key_value=map_get_pixel(0,kb_map[key_layout],mouse.x,mouse.y);keypressed=1;end 
  		if((key(_alt) or key(_z)) and keypressed==0)key_value=map_get_pixel(0,kb_map[key_layout],son.x,son.y);keypressed=1;end
  		//if(key(_z) and keypressed==0)key_value=255;keypressed=1;end
  		if(key(_backspace) and keypressed==0)key_value=8;keypressed=1;end
  		if(key(_tab) and keypressed==0)key_value=32;keypressed=1;end
  		if(key(_enter) and keypressed==0)key_value=13;keypressed=1;end
  		
  		
  		if(key_value>31 and key_value<127 and len(input)<length)input=input+chr(key_value);
  			// play_wav(keyboard_sound, 0);
  		end
  		
  		
  			if(key_value==8)
  			// play_wav(keyboard_sound, 0);
  					if(len(input)>1)
  					input=substr(input,0,len(input)-1);
  					else
  					input="";
  					end
  			end 
  		
  		if(key_value==255)key_layout++;end
  		if(key_layout>1)key_layout=0;end
  			
  		
  	frame;  
  	
  until(key_value==13 or key_value==27)
  // play_wav(keyboard_sound, 0);

  delete_text(text_input);
  delete_text(text_cursor);
  delete_text(text_line1);
  delete_text(text_line2);
  delete_text(text_line3); 
  delete_text(text_line4);
  signal(son, s_kill);

  for(y=166;y<320;y=y+20)
  frame;
  end                        
                          
  if(key_value==13)father.input=input;end

end  


process keyboard_cursor()
private
begin 
  z=-255;
 	loop
		frame;
	end
end 




process quit_to_title();
begin
  signal(type game,s_kill);
  signal(type control,s_kill);
  signal(type special,s_kill);
  signal(type swap_tiles,s_kill);
  signal(type check_for_lines,s_kill);
  signal(type drop_tiles,s_kill);
  signal(type check_moves,s_kill);
  signal(type tile_display,s_kill);
  signal(type tile,s_kill); 
  signal(type time_bar,s_kill);
  signal(type no_more_moves,s_kill); 
  signal(type score_display,s_kill); 
  signal(type luckyanimal,s_kill);
  stop_song();
  title(1);
end