;							YM2610 ADPCM-B Codec
;
;**** PCM to ADPCM-B & ADPCM-B to PCM converters for NEO-GEO System ****
;ADPCM-B - 1 channel 1.8-55.5 KHz, 16 MB Sample ROM size, 256 B min size of sample, 16 MB max, compatable with YM2608 
;
;the commands line might look like this :
;1/ USAGE: ADPCM-B_Encode <InputFile.wav> -options <OutputFile.pcm>
;2/ USAGE: ADPCM-B_Decode <InputFile.pcm> -options <OutputFile.wav>
;
;http://www.raregame.ru/file/15/YM2610.pdf     YM2610 DATASHEET
;
; in the C source, there 's no 'DOS command line'.  Fred/FRONT
;----------------------------------------------------------------------------------------------------------------------------

#include <math.h>

static long stepsizeTable[ 16 ] =
{
	57, 57, 57, 57, 77,102,128,153,
	57, 57, 57, 57, 77,102,128,153
};

int YM2610_ADPCM-B_Encode( short *src , unsigned char *dest , int len )
{
	int lpc , flag;
	long i , dn , xn , stepSize;
	unsigned char adpcm;
	unsigned char adpcmPack;

	xn = 0;
	stepSize = 127;
	flag = 0;

	for( lpc = 0 ; lpc < len ; lpc++ )
	{
		dn = *src - xn;
		src++;

		i = ( abs( dn ) << 16 ) / ( stepSize << 14 );
		if( i > 7 ) i = 7;
		adpcm = ( unsigned char )i;

		i = ( adpcm * 2 + 1 ) * stepSize / 8;

		if( dn < 0 )
		{
			adpcm |= 0x8;
			xn -= i;
		}
		else
		{
			xn += i;
		}

		stepSize = ( stepsizeTable[ adpcm ] * stepSize ) / 64;

		if( stepSize < 127 )
			stepSize = 127;
		else if( stepSize > 24576 )
			stepSize = 24576;

		if( flag == 0 )
		{
			adpcmPack = ( adpcm << 4 ) ;
			flag = 1;
		}
		else
		{
			adpcmPack |= adpcm;
			*dest = adpcmPack;
			dest++;
			flag = 0;
		}
	}

	return 0;
}

int YM2610_ADPCM-B_Decode( unsigned char *src , short *dest , int len )
{
	int lpc , flag , shift , step;
	long i , xn , stepSize;
	long adpcm;

	xn = 0;
	stepSize = 127;
	flag = 0;
	shift = 4;
	step = 0;

	for( lpc = 0 ; lpc < len ; lpc++ )
{
		adpcm = ( *src >> shift ) & 0xf;

		i = ( ( adpcm & 7 ) * 2 + 1 ) * stepSize / 8;
		if( adpcm & 8 )
			xn -= i;
		else
			xn += i;

		if( xn > 32767 )
			xn = 32767;
		else if( xn < -32768 )
			xn = -32768;

		stepSize = stepSize * stepsizeTable[ adpcm ] / 64;

		if( stepSize < 127 )
			stepSize = 127;
		else if ( stepSize > 24576 )
			stepSize = 24576;

		*dest = ( short )xn;
		dest++;

		src += step;
		step = step ^ 1;
		shift = shift ^ 4;
	}
	return 0;
}