;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; The X numbers are shifted right by 13 before use
; These numbers are in units of 1/8192

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; The upper commented out numbers do this SciAm cover (almost)
;	XSTART		equ	$fffffa86
;	XINC		equ	1

;	XSTART		equ	((-1)<<13)
;	XINC		equ	(1<<9)

;	XSTART		equ	0
;	XINC		equ	(1<<7)

;	XSTART		equ	((-2)<<13)
;	XINC		equ	((10<<11)/WIDTH)


; The Y numbers are shifted right by 13 before use
; These numbers are in units of 1/8192

; The upper commented out numbers do this SciAm cover
;	YSTART		equ	$ffffde9a	
;	YINC		equ	1

;	YSTART		equ	((-1)<<13)
;	YINC		equ	(1<<9)

;	YSTART		equ	((-2)<<13)
;	YINC		equ	(1<<7)

;	YSTART		equ	((-19)<<9)
;	YINC		equ	((6<<12)/WIDTH)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; The most important thing in a Mandlebrot program is the inner loop
; The most important thing in a DSP program is to keep as much as possible
; in registers and as much of the rest in internal RAM
; First the inner loop:
; In order to handle both the Mandlebrot and Julia sets we make no assumptions
; about initial conditions.
; The basic loop is: (given xi, yi, cx, cy)
; temp=xi*yi
; sx=xi*xi
; sy=yi*yi
; yi=temp+temp+cy
; xi=sx-sy+cx
; count+=1
; interate until count>maxcount or sx+sy>4

; Note that the nubers used here are 3.13 fixed point
; For a Mandlebrot xi=yi=0 at the start always

; Assume that the following registers are already set up
;       movei   #MAXCNT,maxcnt
;       movei   #FOUR,four


	WIDTH		equ	640
	HEIGHT		equ	480
	
	XSTART		equ	((-2)<<13)
	XINC		equ	((10<<11)/WIDTH)
	
	YSTART		equ	((-19)<<9)
	YINC		equ	((6<<12)/WIDTH)

	.dsp

;	R0
	xi              .equr          R1
	yi              .equr          R2
	cx              .equr          R3
	cy              .equr          R4
	sx              .equr          R5
	sy              .equr          R6
	temp            .equr          R7
	count           .equr          R8
	maxcnt          .equr          R9
	four            .equr          R10
	inloop          .equr          R11
;	R12
;	R13
;	R14=A1
;	R15
;	R16
;	R17
; d2 = R18
; R19
; R20
; d1 = R21
;	R22
;   R23
	rinner          .equr          R24
	router          .equr          R25
;	R26=XINC
;	R27=YINC

mandDSP::
	.org     $f1b000

start_mandDSP::

	movei	#$20000+1,R14		; adresse de départ du bitmap +1
	movei	#YSTART,cy
	
	movei	#HEIGHT-1,R18

	movei	#inner,rinner	; adresse de la boucle point
	movei	#outer,router	; adresse de la boucle ligne
	
	movei   #loop,inloop	; adresse de la boucle itération
	movei   #(4<<13),four
	movei   #254,maxcnt
	movei	#XINC*2,R26
	movei	#YINC,R27

	movei	#256,R0			; essai reverse
	move	R0,count		; essai reverse
	
outer:

	movei	#XSTART+XINC,cx	; Initialize x position +1
	movei	#(WIDTH/2)-1,R21
;	moveq	#0,count
	
inner:

	
;	moveq	#0,count
	moveq	#0,yi			; valeur de départ
	moveq	#0,temp
	moveq	#0,xi			; valeur de départ
	
loop:
;	move    xi,temp
	imult   yi,temp         ; temp=xi*yi

	imult   xi,xi           ; xi=xi*xi

	imult   yi,yi           ; yi=yi*yi

	sharq   #13,xi          ; normalize all mult results
	sharq   #13,temp
	sharq   #13,yi

; The folowing code has been interleaved

	add     temp,temp       ; temp=temp+temp

	move    yi,sy           ; sy=yi*yi

	add     cy,temp         ; temp=temp+temp+cy

	move    xi,sx           ; sx=xi*xi

	move    temp,yi         ; yi=temp+temp+cy

	sub     sy,xi           ; xi=sx-sy

	add     cx,xi           ; xi=sx-sy+cx

	subq	#1,count
	jr		EQ,noloop
;	addq    #1,count
;	cmp     count,maxcnt
;	jr      MI,noloop       ; MI is branch count<maxcnt
;	nop						; optimisation, no need to "nop" here

	add     sx,sy
	cmp     sy,four

	jr      EQ,noloop
	nop
	jump    CC,(inloop)
	move    xi,temp
;	nop

noloop:

	storeb	count,(R14)

	add		R26,cx

	addq	#2,R14
	
	subq	#1,R21
	jump	PL,(rinner)
	move	R0,count
;	moveq	#0,count		; placé ici pour optimisation de la boucle inner

	subq	#1,R18
	jump	PL,(router)
	add		R27,cy
	
	nop
	nop
	; re fin 68000	
;BRAK !

;       NOTE: This halts the DSP
	movei   #0,R30
	movei   #$00f1a114,R31
	store   R30,(R31)

	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
end_mandDSP::

