;rockyone			 pour MI-3	    		 02/03/2017
;
;correction				  			 28.02.2018
;prise en charge des images SPU					 11.09.2019
;
;				Menu On / Off
;				-------------
;
; Attention: le dplacement est de deux lignes en haute rsolution.
;
; Restor	Buffer palettes SPU pour restoration  		19104 octets
; Display	Buffer paletes SPU affiches  l'cran		19104 octets
;
; Buf_menu   	Buffer contenant les data du menu haut et bas	2*3040+160
;
; Buf_ecr   	Adresse buffer image pour menu Off
;	    	
; Haut%   	= 0 quand le menu est en bas
;	  	= 1 quand le menu est en haut
;
; ON_OFF% 	= 0 pour off
;	  	= 1 pour on 
;
;				   	          d1     d2	  d3
; call  aff_menu( restor, display, buf_menu, buf_ecr, haut%, on_off%, spu%)
; -------------------------------------------------------------------------
;	      	  64	  68	   72        76	      80     82	      84
;
; Buffer menu "ON" avec ses 2 lignes de sparation
; 
; +0         ___________________________  Ligne 182|364 visible si menu bas 
;	    |
;           |      ---haut de l'cran---|
;line 3/6   | |----|----|---------|--   | Mis dans le buffer par le basic
;           | | FR | GB |         |     |      
;line 13/26 | |----|----|------------   |	
;	    |___bas de l'cran___	|		
;					|
;            ___________________________| Ligne 17|34 visible si menu haut
;					  
; Warning: nombre de ligne recouverte si menu haut 18 ou 35 
; '''''''''''''''''''''''''''''''''''''''''''''''''''''''''
;					  
; MENU OFF   ___________________________ 
; 
;				      '''Mis dans buffer par cette routine.
;             |----|----|---------|--   |       
;             | FR | GB |         |     |  Premiere et dernire ligne cran
;             |----|----|------------   |    du menu non recopi dans cette 
;				      '''    partie du buffer
;            ___________________________    
;      
;
; Le dplacement et de deux lignes en haute rsolution !
;
;------------------------------------------------------------------------
;a1     buffer pallette restor SPU
;a2	buffer palette display SPU
;a3	buffer menu         
;a4	buffer image pour menu_off          
;a4=a3	pour menu_on              
;a5	cran
;d3	alway spu flag  

		movem.l	d0-d7/a0-a6,-(sp)
		movem.l	64(sp),a1-a4          
		movea.l	$44e,a5		    	; Screen             
                                                    
		moveq.l	#17,d5              	; 18 lignes            

		movem.w	80(sp),d1-d3                      
		move.w	#96/8-1,d0	    	; 96 colors par ligne SPU

		tst.b	d2                              
		beq	menu_off                    
;----------------------------------------MENU ON--------------------------
;a3 a4 sources                                       
;a5 a6 cran                                        
                         
*		tst.b	d3 	          	; image.Spu ?   
*		beq.s	not_spu			; non

		move.w	#96/8-1,d0	    	; 96 couleurs par ligne SPU
		move.l	#$fff,d2		; Nouvelles couleurs SPU
not_spu:	moveq.l	#40/2-1,d6	    	; 40 LWords par ligne 
		
            	tst.b	d1                              
	    	beq.s	on_bas                          
;.......................................ON haut

h_no_spu:    	lea.l	19*160(a3),a3       ; Pointe fin zone menu on    
	    	lea.l	160(a5),a5	    ; Fin premiere ligne de l'ecran      
                     
		cmpi.b	#2,$44c		    ; haute resolution ?        
		bne.s	loop_h                                  
			                                          
		lea.l	-80(a3),a3	    	; Fin premiere ligne haute
		lea.l	-80(a5),a5	    	; resolution
            	moveq.l	#20/2-1,d6	    	;  "       "     "     "
	                                                        
loop_h:		movea.l	a3,a4		    	; buffer menu                    
		movea.l	a5,a6		    	; cran                         

		bsr.s	vsync		    	; + move d6,d7              
		beq.s	h_ligne		    	; non

		cmpi.w	#17,d5
		beq.s	h_ligne

		move.w	d0,d1		    	; 3 nouvelles palettes SPU 
h_black_pal:	move.l	d2,(a2)+		; pour afficher une ligne
		move.l	d2,(a2)+		; du menu
		dbra.w	d1,H_black_pal
                                                            
h_ligne:	move.l	-(a4),-(a6)         ; affiche un ligne du menu
		move.l	-(a4),-(a6)         ; puis 2,3,... sur l'ecran          
		dbra.w	d7,h_ligne                              
                                                            
		lea.l	160(a5),a5	    ; cran                     
		addi.w	#20,d6		    ; +1 ligne, +2 en haute rsol
                                                                
	    	dbra.w	d5,loop_h                                   
                                                                
		bra.s	end_prg                                     
;--------------------------------------- ON BAS -----------------------
on_bas:		lea.l	32000-160(a5),a5   

*		tst.b	d3			; image spu ?
*		beq.s	loop_b			; non

		lea.l	19104(a2),a2  		; fin des palette SPU     

loop_b:		movea.l	a3,a4		    	; source	            
		movea.l	a5,a6		    	; cran                 

		bsr.s	vsync		    	; + move d6,d7         
		beq.s	b_ligne

		move.w	d0,d1			; 3 Nouvelles palettes SPU
b_black_spu:	move.l	d2,-(a2)		; pour afficher une ligne
		move.l	d2,-(a2)		; du menu.
 		dbra.w	d1,b_black_spu

b_ligne:	move.l	(a4)+,(a6)+            	; aff menu sur cran
		move.l	(a4)+,(a6)+     
		dbra.w	d7,b_ligne                          
			                                        	
		lea.l	-160(a5),a5	    	; cran                     
		add.w	#20,d6		    	; + 1 ligne                    
		dbra.w	d5,loop_b                               
;-------------------------------------------------------------------------
end_prg: 	movem.l	(sp)+,d0-d7/a0-a6                           
		rts                                             
;-------------------------------------------------------------------------
vsync:		movem.l	d0-d2/a0-a2,-(sp)
		move.w	d6,d7		    	; Pour les 4 fonctions
    		move.w	#37,-(sp)	    	; Vsync
	    	trap	#14		    	; Xbios
		addq.l	#2,sp      
		movem.l	(sp)+,d0-d2/a0-a2   
		tst.w	d3  			; Image.spu ?
		rts                     
;---------------------------------------- MENU OFF------------------------
	 
menu_off:	lea.l	3040(a3),a3	; pointe buffer zone menu_off
		move.l	#680/2-1,d6	; 17 ou 34 lignes celon resolution.

		moveq.l	#18,d5	        
	    	tst.b	d1              ; quelle sens ?
		bne.s	haut_off        

;........................................ OFF BAS ........................
  		lea.l	29120(a5),a5		; ecran ligne 182 ou 364
		movea.l	a5,a6           	

		bsr	copy_menu		; dans zone off

		lea.l	29120(a4),a4		; buffer image

*		tst.w	d3			; image spu ?
*		beq.s	off_bas
		
		lea.l	181*96(a1),a1		; buffer restor  pal spu
		lea.l	181*96(a2),a2		; buffer display pal spu

off_bas:	moveq.l	#40/2-1,d2		; 40 long word

		bsr.s	vsync		
		beq.s	bas_pic

		move.w	d0,d1
b_restor:	move.l	(a1)+,(a2)+		; Restor 3 palettes spu
		move.l	(a1)+,(a2)+		; par ligne
		dbra.w	d1,b_restor		
                    
bas_pic:	move.l	(a4)+,(a6)+		; restaure 1 ou 2 ligne
		move.l	(a4)+,(a6)+		;  l'cran
		dbra.w	d2,bas_pic
                    
	    	subq.b	#1,d5           	; compteur ligne
    		beq.s	end_prg

	        movea.l	a3,a0			; Buffer menu off
		movea.l	a6,a5           	; Screen
move_bas:	move.l	(a0)+,(a5)+		; Recopy le menu une
		move.l	(a0)+,(a5)+		; ligne plus bas.
		dbra.w	d7,move_bas	
		
		subi.w	#20,d6
		bra.s	off_bas         
;........................................ OFF HAUT ........................
haut_off:	lea.l	160(a5),a5		; cran

		bsr.s	copy_menu		; dans zone "off"
		movea.l	a0,a3	
                              
    		lea.l	2880(a4),a4		; buffer image
	                		 
		cmpi.b	#2,$44c			; Haute resolution ?
	    	bne.s	not_hight		; non

		subq.b	#1,d5			; 17 line en haute resol !
		suba.w	#80,a3
	    	suba.w	#80,a4
    		suba.w	#80,a5
		sub.w	#10,d6			; ***

not_hight:
*		tst.w	d3
*		beq.s	off_haut
		
		lea.l	17*96(a1),a1		; buffer restor  pal spu	
		lea.l	17*96(a2),a2		; buffer display pal spu

off_haut:	moveq.l	#40/2-1,d2

		bsr	vsync			
		beq.s	pic_haut		; Not image.spu
		cmpi.b	#1,d5			; Not line 0 for image.spu
		beq.s	pic_haut

		move.w	d0,d1
h_restor:	move.l	-(a1),-(a2)		; palette spu
		move.l	-(a1),-(a2)
		dbra.w	d1,h_restor
                                        
pic_haut:	move.l	-(a4),-(a5)		; Restore une ou deux 
		move.l	-(a4),-(a5)		; ligne(s) de l'image
		dbra.w	d2,pic_haut	
	                                
		subq.b	#1,d5
		ble.s	end_haut		; for high resol

       		movea.l	a3,a0			; Buffer menu off
		movea.l	a5,a6			; Screen
move_haut:	move.l	-(a0),-(a6)		; Recopy le menu une 
		move.l	-(a0),-(a6)		; ligne plus haut
		dbra.w	d7,move_haut
		
		subi.w	#20,d6			; -1 ligne, -2 haute Resol.
  		bra.s	off_haut
                                
end_haut:	cmpi.b	#2,$44c			; high resol ?
		bne	end_prg             
         
		moveq.l	#19,d7          	; Premiere ligne cran         
high_rez:	move.l	-(a4),-(a5)     	; en haute rsolution.        
	    	dbra.w	d7,high_rez                             
    		bra 	end_prg                                     
;---------------------------------------------- copy_menu --------------
;
; Copy 17 lignes du menu visible  l'ecran dans la zone MENU OFF.
; Pas bessoin de la premire ligne du menu Haut.
;  "	"	"    denire ligne du menu bas.
;					 
copy_menu:  	move.l	#680/2-1,d2		; 17 * 40 word  	
		movea.l	a3,a0
copy_lw:	move.l	(a5)+,(a0)+
		move.l	(a5)+,(a0)+
		dbra.w	d2,copy_lw
		rts
;-------------------------------------------------------------------------
            end
;-------------------------------------------------------------------------