/* Send_obj.c
	 written 1997 42Bastian Schick

last change : 1997/17/02

Windows port by Zerosquare
*/

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <windows.h>
#include <assert.h>

/*
	Global var
*/


const char *COM = "COM1";
HANDLE SerialPort = INVALID_HANDLE_VALUE;


/*
	load file name, return address and length
*/
int load_game(char *name,BYTE **dest,ULONG *flen)
{
FILE *handle;

	if ( (handle = fopen(name,"rb")) == NULL)
		{printf("Can't open :%s !\n",name);
		 return FALSE;
		}

	fseek(handle,0L,SEEK_END);
	*flen = ftell(handle);
	fseek(handle,0L,SEEK_SET);

	if ( ( *dest = malloc(*flen) ) == NULL )
		 {printf("Can't allocate memory !\n");
			fclose(handle);
			return FALSE;
		 }
	fread(*dest,*flen,1,handle );
	fclose(handle);
	return TRUE;
}

/*
	open serial port
*/
BOOL OpenSerialPort(void)
{
    assert(SerialPort == INVALID_HANDLE_VALUE);

    {
        const size_t MaxLength = MAX_PATH + 1;
        char PortName[MaxLength];

        {
            const int Result = snprintf(PortName, MaxLength, "\\\\.\\%s", COM);

            if ((Result <= 0) || (((size_t)Result) >= MaxLength))
                return FALSE;

            if (PortName[strlen(PortName) - 1] == ':')
                PortName[strlen(PortName) - 1] = '\0';
        }

        SerialPort = CreateFile(PortName, GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, 0, NULL);
        if (SerialPort == INVALID_HANDLE_VALUE)
            return FALSE;
    }

    {
        DCB Dcb = {
            .DCBlength = sizeof(DCB)
        };

        if (!GetCommState(SerialPort, &Dcb))
            return FALSE;

        Dcb.BaudRate = 9600;
        Dcb.fBinary = TRUE;
        Dcb.fParity = TRUE;
        Dcb.fOutxCtsFlow = FALSE;
        Dcb.fOutxDsrFlow = FALSE;
        Dcb.fDtrControl = DTR_CONTROL_ENABLE;
        Dcb.fDsrSensitivity = FALSE;
        Dcb.fTXContinueOnXoff = TRUE;
        Dcb.fOutX = FALSE;
        Dcb.fInX = FALSE;
        Dcb.fErrorChar = FALSE;
        Dcb.fNull = FALSE;
        Dcb.fRtsControl = RTS_CONTROL_ENABLE;
        Dcb.fAbortOnError = FALSE;
        Dcb.ByteSize = 8;
        Dcb.Parity = EVENPARITY;
        Dcb.StopBits = ONESTOPBIT;

        if (!SetCommState(SerialPort, &Dcb))
            return FALSE;
    }

    {
        COMMTIMEOUTS CommTimeouts = {
            .ReadIntervalTimeout = 0,
            .ReadTotalTimeoutMultiplier = 0,
            .ReadTotalTimeoutConstant = 0,
            .WriteTotalTimeoutMultiplier = 0,
            .WriteTotalTimeoutConstant = 0
        };

        if (!SetCommTimeouts(SerialPort, &CommTimeouts))
            return FALSE;
    }

    if (!SetCommMask(SerialPort, 0))
        return FALSE;

    (void)ClearCommBreak(SerialPort);

    if (!PurgeComm(SerialPort, PURGE_RXCLEAR | PURGE_TXCLEAR))
        return FALSE;

    return TRUE;
}

/*
	close serial port
*/
BOOL CloseSerialPort(void)
{
    if (SerialPort == INVALID_HANDLE_VALUE)
        return TRUE;

    if (!FlushFileBuffers(SerialPort))
        return FALSE;

    if (!CloseHandle(SerialPort))
        return FALSE;

    SerialPort = INVALID_HANDLE_VALUE;

    return TRUE;
}

/*
	send one byte to serial port
*/
void SendByte(BYTE b)
{
    DWORD NumberOfBytesWritten;
    assert(WriteFile(SerialPort, &b, 1, &NumberOfBytesWritten, NULL));
    assert(NumberOfBytesWritten == 1);
}
/*
	check file and send it if it's BLL
*/
void WrtLynx(BYTE *prg,USHORT flen)
{
BYTE header_lo = *(prg+0), header_hi = *(prg+1);
BYTE slen_hi,slen_lo,start_hi,start_lo;

	if ( (header_hi == 0x08) && (header_lo == 0x80) )
		{
			start_hi = *(prg+2);
			start_lo = *(prg+3);

			slen_hi = *(prg+4);
			slen_lo = *(prg+5);
			flen    = (slen_hi<<8)|slen_lo;   /* get lentgh from header */
			prg += 10;
	}else if ( (header_hi == 0xFF) && (header_lo == 0xFF) ){                    /* C-compiler */
			start_hi = *(prg+3);
			start_lo = *(prg+2);
			flen -= 6;    /* assume code-length is file-lentgh - header */
			slen_hi  = flen >> 8;
			slen_lo  = flen & 0xff;
			prg  += 6;                               /* pass the header */

	}else{
			printf("No-BLL program !\n");
			return;
	}

	printf("Start %x Length %x\n",(unsigned int)((start_hi<<8)|start_lo),(unsigned int)flen);


	SendByte(0x81); SendByte('P');
	SendByte(start_hi);      SendByte(start_lo);
	SendByte(slen_hi^0xff);  SendByte(slen_lo^0xff);

	for ( ; flen ; flen--){
		if ( kbhit() ) break;
		SendByte(*prg++);
	}

}




/*
	----------------------
*/
int main(int argc,char *argv[])
{
BYTE *where;
ULONG len;


	if (argc < 2){
		printf("Usage : send_obj filename [serial_port]\n");
		exit(FALSE);
	}

	printf("SEND_OBJ Ver 1.3\n(c) 1997 42Bastian Schick\n");
	printf("Windows port by Zerosquare\n");

	if ( load_game(argv[1],&where,&len) ){
		if ( argc == 3 )
			COM = argv[2];

        if (!OpenSerialPort()){
		    printf("Can't open serial port :%s !\n",COM);
            exit(FALSE);
        }

		printf("Writing :%s\n",argv[1]);
		WrtLynx(where,(USHORT)len);

		(void)CloseSerialPort();
		free(where);
		exit(TRUE);
	}
}
