/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.ParallelPort;
import gnu.io.ParallelPortEvent;
import gnu.io.ParallelPortEventListener;
import gnu.io.PortInUseException;
import gnu.io.RXTXVersion;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;

final class LPRPort
extends ParallelPort {
    private static final boolean debug = false;
    private int fd;
    private final ParallelOutputStream out = new ParallelOutputStream();
    private final ParallelInputStream in = new ParallelInputStream();
    private int lprmode = 0;
    private int timeout = 0;
    private int threshold = 1;
    private ParallelPortEventListener PPEventListener;
    private MonitorThread monThread;

    private static native void Initialize();

    public LPRPort(String string) throws PortInUseException {
        this.fd = this.open(string);
        this.name = string;
    }

    private synchronized native int open(String var1) throws PortInUseException;

    public OutputStream getOutputStream() {
        return this.out;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public int getMode() {
        return this.lprmode;
    }

    public int setMode(int n) throws UnsupportedCommOperationException {
        try {
            this.setLPRMode(n);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            unsupportedCommOperationException.printStackTrace();
            return -1;
        }
        this.lprmode = n;
        return 0;
    }

    public void restart() {
        System.out.println("restart() is not implemented");
    }

    public void suspend() {
        System.out.println("suspend() is not implemented");
    }

    public native boolean setLPRMode(int var1) throws UnsupportedCommOperationException;

    public native boolean isPaperOut();

    public native boolean isPrinterBusy();

    public native boolean isPrinterError();

    public native boolean isPrinterSelected();

    public native boolean isPrinterTimedOut();

    private native void nativeClose();

    public synchronized void close() {
        if (this.fd < 0) {
            return;
        }
        this.nativeClose();
        super.close();
        this.removeEventListener();
        this.fd = 0;
        Runtime.getRuntime().gc();
    }

    public void enableReceiveFraming(int n) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException("Not supported");
    }

    public void disableReceiveFraming() {
    }

    public boolean isReceiveFramingEnabled() {
        return false;
    }

    public int getReceiveFramingByte() {
        return 0;
    }

    public void enableReceiveTimeout(int n) {
        this.timeout = n > 0 ? n : 0;
    }

    public void disableReceiveTimeout() {
        this.timeout = 0;
    }

    public boolean isReceiveTimeoutEnabled() {
        return this.timeout > 0;
    }

    public int getReceiveTimeout() {
        return this.timeout;
    }

    public void enableReceiveThreshold(int n) {
        this.threshold = n > 1 ? n : 1;
    }

    public void disableReceiveThreshold() {
        this.threshold = 1;
    }

    public int getReceiveThreshold() {
        return this.threshold;
    }

    public boolean isReceiveThresholdEnabled() {
        return this.threshold > 1;
    }

    public native void setInputBufferSize(int var1);

    public native int getInputBufferSize();

    public native void setOutputBufferSize(int var1);

    public native int getOutputBufferSize();

    public native int getOutputBufferFree();

    protected native void writeByte(int var1) throws IOException;

    protected native void writeArray(byte[] var1, int var2, int var3) throws IOException;

    protected native void drain() throws IOException;

    protected native int nativeavailable() throws IOException;

    protected native int readByte() throws IOException;

    protected native int readArray(byte[] var1, int var2, int var3) throws IOException;

    native void eventLoop();

    public boolean checkMonitorThread() {
        if (this.monThread != null) {
            return this.monThread.isInterrupted();
        }
        return true;
    }

    public synchronized boolean sendEvent(int n, boolean bl) {
        if (this.fd == 0 || this.PPEventListener == null || this.monThread == null) {
            return true;
        }
        switch (n) {
            case 2: {
                if (this.monThread.monBuffer) break;
                return false;
            }
            case 1: {
                if (this.monThread.monError) break;
                return false;
            }
            default: {
                System.err.println("unknown event:" + n);
                return false;
            }
        }
        ParallelPortEvent parallelPortEvent = new ParallelPortEvent(this, n, !bl, bl);
        if (this.PPEventListener != null) {
            this.PPEventListener.parallelEvent(parallelPortEvent);
        }
        if (this.fd == 0 || this.PPEventListener == null || this.monThread == null) {
            return true;
        }
        try {
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public synchronized void addEventListener(ParallelPortEventListener parallelPortEventListener) throws TooManyListenersException {
        if (this.PPEventListener != null) {
            throw new TooManyListenersException();
        }
        this.PPEventListener = parallelPortEventListener;
        this.monThread = new MonitorThread();
        this.monThread.setDaemon(true);
        this.monThread.start();
    }

    public synchronized void removeEventListener() {
        this.PPEventListener = null;
        if (this.monThread != null) {
            this.monThread.interrupt();
            this.monThread = null;
        }
    }

    public synchronized void notifyOnError(boolean bl) {
        System.out.println("notifyOnError is not implemented yet");
        this.monThread.monError = bl;
    }

    public synchronized void notifyOnBuffer(boolean bl) {
        System.out.println("notifyOnBuffer is not implemented yet");
        this.monThread.monBuffer = bl;
    }

    protected void finalize() {
        if (this.fd > 0) {
            this.close();
        }
    }

    static {
        RXTXVersion.loadLibrary("rxtxParallel");
        LPRPort.Initialize();
    }

    class MonitorThread
    extends Thread {
        private boolean monError = false;
        private boolean monBuffer = false;

        MonitorThread() {
        }

        public void run() {
            LPRPort.this.eventLoop();
            MonitorThread.yield();
        }
    }

    class ParallelInputStream
    extends InputStream {
        ParallelInputStream() {
        }

        public int read() throws IOException {
            if (LPRPort.this.fd == 0) {
                throw new IOException();
            }
            return LPRPort.this.readByte();
        }

        public int read(byte[] byArray) throws IOException {
            if (LPRPort.this.fd == 0) {
                throw new IOException();
            }
            return LPRPort.this.readArray(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (LPRPort.this.fd == 0) {
                throw new IOException();
            }
            return LPRPort.this.readArray(byArray, n, n2);
        }

        public int available() throws IOException {
            if (LPRPort.this.fd == 0) {
                throw new IOException();
            }
            return LPRPort.this.nativeavailable();
        }
    }

    class ParallelOutputStream
    extends OutputStream {
        ParallelOutputStream() {
        }

        public synchronized void write(int n) throws IOException {
            if (LPRPort.this.fd == 0) {
                throw new IOException();
            }
            LPRPort.this.writeByte(n);
        }

        public synchronized void write(byte[] byArray) throws IOException {
            if (LPRPort.this.fd == 0) {
                throw new IOException();
            }
            LPRPort.this.writeArray(byArray, 0, byArray.length);
        }

        public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
            if (LPRPort.this.fd == 0) {
                throw new IOException();
            }
            LPRPort.this.writeArray(byArray, n, n2);
        }

        public synchronized void flush() throws IOException {
            if (LPRPort.this.fd == 0) {
                throw new IOException();
            }
        }
    }
}

