/*-------------------------------------------------------------------------
|   RXTX License v 2.1 - LGPL v 2.1 + Linking Over Controlled Interface.
|   RXTX is a native interface to serial ports in java.
|   Copyright 1997-2007 by Trent Jarvi tjarvi@qbang.org and others who
|   actually wrote it.  See individual source files for more information.
|
|   A copy of the LGPL v 2.1 may be found at
|   http://www.gnu.org/licenses/lgpl.txt on March 4th 2007.  A copy is
|   here for your convenience.
|
|   This library is free software; you can redistribute it and/or
|   modify it under the terms of the GNU Lesser General Public
|   License as published by the Free Software Foundation; either
|   version 2.1 of the License, or (at your option) any later version.
|
|   This library is distributed in the hope that it will be useful,
|   but WITHOUT ANY WARRANTY; without even the implied warranty of
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
|   Lesser General Public License for more details.
|
|   An executable that contains no derivative of any portion of RXTX, but
|   is designed to work with RXTX by being dynamically linked with it,
|   is considered a "work that uses the Library" subject to the terms and
|   conditions of the GNU Lesser General Public License.
|
|   The following has been added to the RXTX License to remove
|   any confusion about linking to RXTX.   We want to allow in part what
|   section 5, paragraph 2 of the LGPL does not permit in the special
|   case of linking over a controlled interface.  The intent is to add a
|   Java Specification Request or standards body defined interface in the 
|   future as another exception but one is not currently available.
|
|   http://www.fsf.org/licenses/gpl-faq.html#LinkingOverControlledInterface
|
|   As a special exception, the copyright holders of RXTX give you
|   permission to link RXTX with independent modules that communicate with
|   RXTX solely through the Sun Microsytems CommAPI interface version 2,
|   regardless of the license terms of these independent modules, and to copy
|   and distribute the resulting combined work under terms of your choice,
|   provided that every copy of the combined work is accompanied by a complete
|   copy of the source code of RXTX (the version of RXTX used to produce the
|   combined work), being distributed under the terms of the GNU Lesser General
|   Public License plus this exception.  An independent module is a
|   module which is not derived from or based on RXTX.
|
|   Note that people who make modified versions of RXTX are not obligated
|   to grant this special exception for their modified versions; it is
|   their choice whether to do so.  The GNU Lesser General Public License
|   gives permission to release a modified version without this exception; this
|   exception also makes it possible to release a modified version which
|   carries forward this exception.
|
|   You should have received a copy of the GNU Lesser General Public
|   License along with this library; if not, write to the Free
|   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
|   All trademarks belong to their respective owners.
--------------------------------------------------------------------------*/

#ifndef _RXTX_GLOBALS_
#define _RXTX_GLOBALS_

#ifndef NULL
    #define NULL 0
#endif

/* gnu.io.CommPortIdentifier constants */
#define RXTX_PORT_SERIAL   1
#define RXTX_PORT_PARALLEL 2

/* gnu.io.ParallelPort constants */
#define RXTX_PARALLEL_MODE_ANY        0
#define RXTX_PARALLEL_MODE_SPP        1
#define RXTX_PARALLEL_MODE_PS2        2
#define RXTX_PARALLEL_MODE_EPP        3
#define RXTX_PARALLEL_MODE_ECP        4
#define RXTX_PARALLEL_MODE_NIBBLE    5

/* gnu.io.SerialPort constants */
#define RXTX_SERIAL_DATABITS_5                5
#define RXTX_SERIAL_DATABITS_6                6
#define RXTX_SERIAL_DATABITS_7                7
#define RXTX_SERIAL_DATABITS_8                8
#define RXTX_SERIAL_PARITY_NONE                0
#define RXTX_SERIAL_PARITY_ODD                1
#define RXTX_SERIAL_PARITY_EVEN                2
#define RXTX_SERIAL_PARITY_MARK                3
#define RXTX_SERIAL_PARITY_SPACE            4
#define RXTX_SERIAL_STOPBITS_1                1
#define RXTX_SERIAL_STOPBITS_2                2
#define RXTX_SERIAL_STOPBITS_1_5            3
#define RXTX_SERIAL_FLOWCONTROL_NONE        0
#define RXTX_SERIAL_FLOWCONTROL_RTSCTS_IN    1
#define RXTX_SERIAL_FLOWCONTROL_RTSCTS_OUT    2
#define RXTX_SERIAL_FLOWCONTROL_XONXOFF_IN    4
#define RXTX_SERIAL_FLOWCONTROL_XONXOFF_OUT    8

/* Misc settings */
#define RXTX_INCLUDE_SOFTWARE_LOOPBACKS
#define RXTX_INITIAL_BUFFER_SIZE 128
#define RXTX_NATIVE_VERSION "RXTX-Rewrite-Alpha"

#endif
