#include <lynx.h> 
#include <lynxlib.h> 
#include "c99.h"
#include "textout.h"
#include "vsync.h"
#include "boutons.h"
#include "comm.h"


/* LYNX-specific #defines: */ 
#define JOY_RIGHT		0x10 
#define JOY_LEFT		0x20 
#define JOY_DOWN		0x40 
#define JOY_UP			0x80 
 
#define BUTTON_OPTION1	0x08 
#define BUTTON_OPTION2	0x04 
#define BUTTON_INNER	0x02 
#define BUTTON_OUTER	0x01 
 
#define BUTTON_PAUSE	0x01 

struct _timer timerV at 0xfd10;

char SCREEN[8160]       at (MEMTOP-16320);
char RENDER[8160]       at (MEMTOP-8160);

char drawPending;
char pal[] = {
0x00,0x00,0x08,0x0F,0x0F,0x08,0x00,0x00,0x08,0x0F,0x08,0x00,0x0F,0x00,0x08,0x0F, //0G
0x00,0x0F,0x4F,0x0F,0x00,0xF0,0xF8,0x00,0x88,0x8F,0xFF,0xFF,0xFF,0x80,0x8F,0xFF  //BR
};

unsigned char x;
unsigned char y;

VBL() interrupt
{
    if (drawPending) {
        SwapBuffers();
        drawPending = 0;
    }
}


void Vsync() 
{
#asm
vretrace:
	lda $fd0a
	bne vretrace
#endasm
}

char WaitButton()
{
   char key;
   while ( (key = joystick) == 0);
   while ( joystick );
   return key;
}
void ComLynx_Init()
{
	//timer4.reload = 12;			/* 9600 bps */
	//timer4.control = 0x18;			/* Horloge 1 MHz, rechargement auto activ, timer activ */
	POKE(0xFD10,12);
	POKE(0xFD11,0x18);
	serctl = 0x5D;				/* Parit paire, mode collecteur ouvert, interruptions actives, reset des erreurs, break dsactiv */
	
	/* Effacement du buffer de rception */
	while (serctl & 0x40) 
	{
		unsigned char c;
		c = serdat;
	}
 
	InstallIRQ(4,SER); 
	EnableIRQ(4); 
}


/* Rception d'un octet */
unsigned char ComLynx_ReceptionOctet()
{
	while (!(serctl & 0x40));		/* Attend qu'un octet ait t reu */
	return serdat;				/* Retourne l'octet reu */
}


/* Envoi d'un octet */
void ComLynx_EnvoiOctet(octet)
unsigned char octet;
{
  DisableIRQ(4);
  POKE(0x10,0xFD80);
	serctl = 0x1D;				/* Parit paire, mode collecteur ouvert, interruptions dsactives, reset des erreurs, break dsactiv */
	while (!(serctl & 0x80));		/* Attend que l'metteur soit prt */
	serdat = octet;				/* Envoie l'octet */
	ComLynx_ReceptionOctet();		/* Comme Tx et Rx sont communs, chaque octet envoy est reu, on l'efface donc du buffer de rception */
	serctl = 0x5D;				/* Parit paire, mode collecteur ouvert, interruptions actives, reset des erreurs, break dsactiv */
 
	EnableIRQ(4); 
}


/* Envoi d'une chane de caractres */
void ComLynx_EnvoiChaine(chaine)
unsigned char *chaine;
{
	unsigned char c;
	while ((c = *(chaine)++) != '0') ComLynx_EnvoiOctet(c);
}

char main(){
	InitIRQ();
	CLI;
	SetBuffers(SCREEN, RENDER ,0);
	InstallIRQ(2,VBL);
	EnableIRQ(2);
	SetRGB(pal);
	drawPending=1;
	Vsync();

	x=0;
	y=0;

	ComLynx_Init();
	
	for(;;)
	{
		DrawFBox(0,0,160,102,0);
		DrawFBox(x,y,5,5,5);
		Vsync();
		drawPending = 1;

		{
			uint8_t BufMsgEmiss[Comm_TailleMessage];
			uint8_t BufMsgRecep[Comm_TailleMessage];
			uint8_t Boutons; 
			bool MessageRecu;
			
			Boutons = joystick;
			
			BufMsgEmiss[0] = (Boutons & JOY_LEFT)  ? 0x34 : 0x12;
			BufMsgEmiss[1] = (Boutons & JOY_RIGHT) ? 0x34 : 0x12;			
			BufMsgEmiss[2] = (Boutons & JOY_UP)    ? 0x34 : 0x12;
			BufMsgEmiss[3] = (Boutons & JOY_DOWN)  ? 0x34 : 0x12;
			
			if (Boutons != 0)
			{
				MessageRecu = Comm_TransferMsg(BufMsgEmiss, BufMsgRecep);
			}
			else
			{
				MessageRecu = Comm_TransferMsg(NULL, BufMsgRecep);
			}
			
			if (MessageRecu)
			{
				if ((BufMsgRecep[0] == 0x34) && (x >   0)) x--;
				if ((BufMsgRecep[1] == 0x34) && (x < 159)) x++;
				if ((BufMsgRecep[2] == 0x34) && (y >   0)) y--;
				if ((BufMsgRecep[3] == 0x34) && (y < 101)) y++;
			}			
		}
	}
}

