#include <lynx.h> 
#include <lynxlib.h> 
#include "c99.h"
#include "textout.h"
#include "vsync.h"
#include "boutons.h"
#include "commtest.h"

 
#define SCREEN 0xA000 

 
/* standard palette */  
char pal[] = { 
   0x00,0x00,0x08,0x00,0x00,0x08,0x08,0x08,0x04,0x00,0x0F,0x00,0x00,0x0F,0x0F,0x0F, 
   0x00,0x08,0x00,0x80,0x88,0x80,0x08,0x88,0x44,0x0F,0x00,0xF0,0xFF,0xF0,0x0F,0xFF 
}; 
 



/* Initialisation du ComLynx */
void ComLynx_Init()
{
	timer4.reload = 12;			/* 9600 bps */
	timer4.control = 0x18;			/* Horloge 1 MHz, rechargement auto activ, timer activ */
	serctl = 0x1D;				/* Parit paire, mode collecteur ouvert, interruptions dsactives, reset des erreurs, break dsactiv */
	
	/* Effacement du buffer de rception */
	while (serctl & 0x40) 
	{
		unsigned char c;
		c = serdat;
	}
}


/* Rception d'un octet */
unsigned char ComLynx_ReceptionOctet()
{
	while (!(serctl & 0x40));		/* Attend qu'un octet ait t reu */
	return serdat;				/* Retourne l'octet reu */
}


/* Envoi d'un octet */
void ComLynx_EnvoiOctet(octet)
unsigned char octet;
{
	while (!(serctl & 0x80));		/* Attend que l'metteur soit prt */
	serdat = octet;				/* Envoie l'octet */
	ComLynx_ReceptionOctet();		/* Comme Tx et Rx sont communs, chaque octet envoy est reu, on l'efface donc du buffer de rception */
}


/* Envoi d'une chane de caractres */
void ComLynx_EnvoiChaine(chaine)
unsigned char *chaine;
{
	unsigned char c;
	while ((c = *(chaine)++) != '0') ComLynx_EnvoiOctet(c);
}
 

void main(void)
{
#asm
   lda #$c        /* Vector space + ROM space --> FFFA-FFFF + FE00-FFF7 */ 
   sta $fff9      /* MAPCTL */ 
   cli 
#endasm 

    /* set up buffer : display buffer == render buffer, no collision buffer */
    SetBuffers(SCREEN, (char *)0, (char *)0);
 
    /* set the palette */
    SetRGB(pal);

    /* Clear the screen */
    DrawFBox(0, 0, 160, 102, 3);

	ComLynx_Init();
	
	{
		TextOut2(0 << 3, 0 << 3, 15, 3, "PARBIT :");
		TextOut2(0 << 3, 1 << 3, 15, 3, "RXBRK  :"); 		
		TextOut2(0 << 3, 2 << 3, 15, 3, "FRAMERR:");	
		TextOut2(0 << 3, 3 << 3, 15, 3, "OVERRUN:"); 	
		TextOut2(0 << 3, 4 << 3, 15, 3, "PARERR :"); 		
		TextOut2(0 << 3, 5 << 3, 15, 3, "TXEMPTY:"); 	
		TextOut2(0 << 3, 6 << 3, 15, 3, "RXRDY  :"); 		
		TextOut2(0 << 3, 7 << 3, 15, 3, "TXRDY  :"); 			
		
		for (;;)
		{
			/* Attente de la synchronisation verticale */
			VSync_Attente(1);
					
			/* Affichage des flags du registre SERCTL */
			{
				uint8_t i;
				uint8_t val_serctl;
				
				val_serctl = serctl;
				
				for (i = 0; i < 8; i++)
				{
					TextOut2(8 << 3, i << 3, 15, 3, ((val_serctl >> i) & 1) ? "1" : "0"); 			
				}
			}
			
			/* Gestion des actions des boutons */
			Boutons_MajEtats();
			switch (Boutons_Enfonc)
			{
				case Boutons_Haut: 	 ComLynx_EnvoiOctet(0x12); break;
				case Boutons_Gauche: ComLynx_EnvoiOctet(0x34); break;
				case Boutons_Droite: ComLynx_EnvoiOctet(0x56); break;
				case Boutons_Bas: 	 ComLynx_EnvoiOctet(0x78); break;
				case Boutons_Pause:	 Comm_RazErreurs();     break;
				case Boutons_A:
				{
					char Chaine[3];
					conv_hexa(serdat, Chaine);
					TextOut2( 0 << 3, 11 << 3, 15, 3, "Octet recu=$");
					TextOut2(12 << 3, 11 << 3, 15, 3, Chaine); 			
				}
				break;
			}				
		}
	}
	

	
	/* Test de la communication */
	Comm_Test();
}

 