/* Masques de boutons */
#define Boutons_A 		(1 << 0)
#define Boutons_B 		(1 << 1)
#define Boutons_Option2	(1 << 2)
#define Boutons_Option1 (1 << 3)
#define Boutons_Droite	(1 << 4)
#define Boutons_Gauche	(1 << 5)
#define Boutons_Bas		(1 << 6)
#define Boutons_Haut	(1 << 7)
#define Boutons_Pause	(1 << 8)


uint16_t Boutons_Etats  = 0;	/* États des boutons (enfoncés ou non) */
uint16_t Boutons_Enfonc = 0;	/* Boutons nouvellement enfoncés */
uint16_t Boutons_Relach = 0;	/* Boutons nouvellement relâchés */


/* Mise à jour des états des boutons */
void Boutons_MajEtats(void)
{
	static uint16_t EtatsPrec = 0;
	uint8_t ChgtEtats;
	
	Boutons_Etats  = (((uint16_t)joystick) << 0) | (((uint16_t)(switches & (1 << 0))) << 8);
	ChgtEtats      = Boutons_Etats ^ EtatsPrec;
	Boutons_Enfonc = ChgtEtats & Boutons_Etats;
	Boutons_Relach = ChgtEtats & (~Boutons_Etats);
	EtatsPrec      = Boutons_Etats;
}
