/* Masque des bits du registre SERCTL */
#define	PAREVEN 	(1 << 0)
#define TXBRK 		(1 << 1)
#define TXOPEN  	(1 << 2)
#define RESETERR	(1 << 3)
#define PAREN		(1 << 4)
#define	RXINTEN		(1 << 6)
#define	TXINTEN		(1 << 7)
#define PARBIT		(1 << 0)
#define	RXBRK 		(1 << 1)
#define	FRAMERR 	(1 << 2)
#define	OVERRUN 	(1 << 3)
#define PARERR 		(1 << 4)
#define	TXEMPTY 	(1 << 5)
#define	RXRDY 		(1 << 6)
#define	TXRDY 		(1 << 7)


uint8_t		Comm_ValSERCTL = 0x00;					/* Dernière valeur écrite dans SERCTL */


void conv_hexa(valeur, chaine)
uint8_t valeur;
char *chaine;
{
    uint8_t x;
    
    x = valeur >> 4;
    *(chaine++) = (x >= 10) ? (x - 10 + 'A') : (x + '0');
    x = valeur & 0xF;
    *(chaine++) = (x >= 10) ? (x - 10 + 'A') : (x + '0');
    *(chaine++) = '\0';
}


/* Écriture des bits du registre SERCTL */
/* BitsOn est le masque de bits à activer, BitsOff le masque des bits à désactiver */
void Comm_DefBitsSERCTL(BitsOn, BitsOff)
uint8_t BitsOn;
uint8_t BitsOff;
{
	Comm_ValSERCTL |= BitsOn;
	Comm_ValSERCTL &= ~BitsOff;
	serctl = Comm_ValSERCTL;
}


/* Remise à zéro des indicateurs d'erreur de communication */
void Comm_RazErreurs(void)
{
	serctl = Comm_ValSERCTL | RESETERR;
}


/* Initialisation de la communication */
void Comm_Init(void)
{
	/* 9600 bps */
	/* Horloge 1 MHz, rechargement auto activé, timer activé */
	/* Parité paire, mode collecteur ouvert, interruptions désactivées, reset des erreurs, break désactivé */
	timer4.reload = 12;			
	timer4.control = 0x18;		

	
	Comm_ValSERCTL = 0x5D;				/* Parité paire, mode collecteur ouvert, interruptions activées, reset des erreurs, break désactivé */
	serctl = Comm_ValSERCTL;
	
	//Comm_DefBitsSERCTL(TXOPEN | PAREN | PAREVEN, TXINTEN | RXINTEN | TXBRK | RESETERR);
		
	/* Remise à zéro des indicateurs d'erreur de communication */	
	//Comm_RazErreurs();
	
	/* Effacement du buffer de réception */
	while (serctl & RXRDY) 
	{
		unsigned char c;
		c = serdat;
	}
}


/* Envoi d'un octet sur le port série */
void Comm_EnvoiOctet(Octet)
uint8_t Octet;
{
	while (!(serctl & TXRDY));
	serdat = Octet;
}


/* Test de la communication */
void Comm_Test(void)
{
	uint8_t Compteur;
	Compteur = 0;
	
	/* Initialisation de la communication */
	Comm_Init();

	TextOut2(0 << 3, 0 << 3, 15, 3, "PARBIT :");
	TextOut2(0 << 3, 1 << 3, 15, 3, "RXBRK  :"); 		
	TextOut2(0 << 3, 2 << 3, 15, 3, "FRAMERR:");	
	TextOut2(0 << 3, 3 << 3, 15, 3, "OVERRUN:"); 	
	TextOut2(0 << 3, 4 << 3, 15, 3, "PARERR :"); 		
	TextOut2(0 << 3, 5 << 3, 15, 3, "TXEMPTY:"); 	
	TextOut2(0 << 3, 6 << 3, 15, 3, "RXRDY  :"); 		
	TextOut2(0 << 3, 7 << 3, 15, 3, "TXRDY  :"); 			
	
	for (;;)
	{
		/* Attente de la synchronisation verticale */
		VSync_Attente(1);
				
		/* Affichage des flags du registre SERCTL */
		{
			uint8_t i;
			uint8_t val_serctl;
			
			val_serctl = serctl;
			
			for (i = 0; i < 8; i++)
			{
				TextOut2(8 << 3, i << 3, 15, 3, ((val_serctl >> i) & 1) ? "1" : "0"); 			
			}
		}
		
		/* Gestion des actions des boutons */
		Boutons_MajEtats();
		switch (Boutons_Enfonc)
		{
			case Boutons_Haut: 	 Comm_EnvoiOctet(0x12); break;
			case Boutons_Gauche: Comm_EnvoiOctet(0x34); break;
			case Boutons_Droite: Comm_EnvoiOctet(0x56); break;
			case Boutons_Bas: 	 Comm_EnvoiOctet(0x78); break;
			case Boutons_Pause:	 Comm_RazErreurs();     break;
			case Boutons_A:
			{
				char Chaine[3];
				conv_hexa(serdat, Chaine);
				TextOut2( 0 << 3, 11 << 3, 15, 3, "Octet recu=$");
				TextOut2(12 << 3, 11 << 3, 15, 3, Chaine); 			
			}
			break;
		}				
	}
}
