#asm 
 
 
;********************************************* 
;** Writes a text at a given pixel-postion  ** 
;********************************************* 
;** 19.08.1997 Matthias Domin               ** 
;** 20.08.1997 modified by 42Bastian Schick ** 
;** 27.11.1997 call to DrawSprite directly  ** 
;** 14.06.1998 Changed to use 8*8 charset   ** 
;********************************************* 
 
; 
; C: void TextOut2(int x,int y,char forecol, char backcol, char *pText) 
; C: void TextOut2Ext(int x,int y,char forecol, char backcol, char *pText, int stretchx, int stretchy) 
; 
; exported functions,labels: 
                global _TextOut2 
                global _TextOut2Ext 
                 
; imported functions/labels 
		xref popax 
                xref DrawSprite 
 
;>ptr1    =     $8C 
;>ptr2    =     $8E 
;>ptr3    =     $90 
;>tmp1    =     $92 
;>tmp2    =     $93 
;>tmp3    =     $94 
;>tmp4    =     $95 
 
_TextOut2Ext: 
                ; get stretch-factor 
                jsr popax 
                sta text2scbstretchy    ;  lo 
                stx text2scbstretchy+1  ;  hi 
 
                jsr popax 
                sta text2scbstretchx    ;  lo 
                stx text2scbstretchx+1  ;  hi 
                bra TextOutGoOn 
_TextOut2: 
                ldx #1 
                stz text2scbstretchy    ;  lo 
                stx text2scbstretchy+1  ;  hi 
 
                stz text2scbstretchx    ;  lo 
                stx text2scbstretchx+1  ;  hi 
TextOutGoOn 
                ; get string pointer 
                jsr popax 
                sta ptr1                ;  lo 
                stx ptr1+1              ;  hi 
 
                ; get background color   
                jsr popax       ; if backcolor != 0, set sprite to be opaque, else set it transparent 
 
                stz text2scb 
                and #$f 
                sta tmp1 
                bne spritemode_ok 
                lda #4 
                sta text2scb 
spritemode_ok 
 
                jsr popax       ; get forecolor 
                asl A 
                asl A 
                asl A 
                asl A 
                ora tmp1 
                sta text2scbcolor 
 
                ; get y 
                jsr popax        
                sta text2scby 
                stx text2scby+1 
 
                ; get x 
                jsr popax 
                sta text2scbx 
                stx text2scbx+1 
 
******** 42BS ** 
                ldy #-1 
string_loop     iny 
                lda (ptr1),y 
                bne string_loop 
**************** 
               cpy #20 
               bmi store_stringlen 
               ldy #20 
store_stringlen 
               sty tmp4         ; text_len 
               bne text_ok 
               rts              ; no text => ende 
text_ok: 
               iny 
               iny 
               sty tmp3         ; text_off 
 
                ldy #8-1        ; 8 pixel lines per character 
                ldx #0 
                clc 
text_prep1: 
                lda tmp3        ; text_off 
                sta text2buffer,x 
 
                txa 
                adc tmp3        ; text_off 
                tax 
 
                lda #$ff 
                sta text2buffer-1,x 
 
                dey 
                bpl text_prep1 
 
                stz text2buffer,x 
**************** 
 
 
 
                stz tmp2 
;>                ldy #0 
                iny 
text_outloop 
                lda (ptr1),y             ; while (*ptr) { z= *ptr 
                ;beq  text_out 
                ; not needed, because we now use         while (len--) 
                sty tmp1 
 
                sec                             
                sbc #32 
 
;;                sta ptr3        ; start calculating the char-data-address 
                stz ptr3  ;; Nur noch mal 8 
                stz ptr3+1 
 
                asl A           ; 1. shift  ; no carry 
 
                asl A 
                rol ptr3+1      ; 2. shift  ; perhaps carry 
 
                asl A 
                rol ptr3+1      ; 3. shift (C = 0 because 8*96 < $FFFF) 
; here:    (A :p tr3+1) = 8*ptr3 
 
 
;;                adc ptr3 
;;                bcc no_c1 
;;                inc ptr3+1 
                sta ptr3 ;; nur noch mal 8 
;;no_c1: 
;;  ; and now:  (A :p tr3+1) = 9*ptr3 
;;                asl ptr3        ; <96 => C = 0 
;; 
;;                adc ptr3 
;;                sta ptr3 
;;                bcc no_c2 
;;                inc ptr3+1 
                clc             ; clear Carry 
no_c2: 
 
************** 
 
                ; now we have the offset, add the base-address to it: 
                lda ptr3 
                adc #<_char8_8 
                sta ptr3 
                lda ptr3+1 
                adc #>_char8_8 
                sta ptr3+1 
                ; this was:      chptr = &charset[z-32][0]; 
 
; and now copy the 8 bytes of that char 
 
               ldx tmp2 
               inx 
               stx tmp2 
 
               ; draw char from top to bottom, reading char-data from offset 8-1 to offset 0 
               ldy #8-1 
text_char 
               lda (ptr3),y         ; *chptr 
               sta text2buffer,x    ;textbuf[y*(1+len+1)+1+x] 
 
               txa 
               adc tmp3         ; text_off 
               tax 
 
               dey 
               bpl text_char 
 
                ; goto next char              
                ldy tmp1 
                iny 
                dec tmp4        ;text_len 
                bne text_outloop 
 
text_out 
                ldax #text2scb 
;>                jsr pushax 
                jmp DrawSprite 
 
text2scb: 
                dc.b $00,$90,$20 
                dc.w 0,text2buffer 
text2scbx: 
                dc.w 0 
text2scby: 
                dc.w 0 
text2scbstretchx: 
                dc.w $100 
text2scbstretchy: 
                dc.w $100 
text2scbcolor: 
                dc.b 0 
 
text2buffer:  ; 8 rows with (one offset-byte plus 20 character bytes plus one fill-byte) plus one 0-offset-byte 
               ds 8*(1+20+1)+1 
                
***** The Font 
***** 96 characters from ASCII 32 to 127 
***** 8 pixels wide, 8 pixels high 
***** bit value 0 = foreground, bit value 1 = background / transparent 
_char8_8: 
; Grobuchstaben (aus Charset 0) 
            dc.b $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF  ;32 
            dc.b $FF, $E7, $FF, $FF, $E7, $E7, $E7, $E7  ;33 
            dc.b $FF, $FF, $FF, $FF, $FF, $99, $99, $99  ;34 
            dc.b $FF, $99, $99, $00, $99, $00, $99, $99  ;35 
            dc.b $FF, $E7, $83, $F9, $C3, $9F, $C1, $E7  ;36 
            dc.b $FF, $B9, $99, $CF, $E7, $F3, $99, $9D  ;37 
            dc.b $FF, $C0, $99, $98, $C7, $C3, $99, $C3  ;38 
            dc.b $FF, $FF, $FF, $FF, $FF, $E7, $F3, $F9  ;39 
            dc.b $FF, $F3, $E7, $CF, $CF, $CF, $E7, $F3  ;40 
            dc.b $FF, $CF, $E7, $F3, $F3, $F3, $E7, $CF  ;41 
            dc.b $FF, $FF, $99, $C3, $00, $C3, $99, $FF  ;42 
            dc.b $FF, $FF, $E7, $E7, $81, $E7, $E7, $FF  ;43 
            dc.b $CF, $E7, $E7, $FF, $FF, $FF, $FF, $FF  ;44 
            dc.b $FF, $FF, $FF, $FF, $81, $FF, $FF, $FF  ;45 
            dc.b $FF, $E7, $E7, $FF, $FF, $FF, $FF, $FF  ;46 
            dc.b $FF, $9F, $CF, $E7, $F3, $F9, $FC, $FF  ;47 
            dc.b $FF, $C3, $99, $99, $89, $91, $99, $C3  ;48 
            dc.b $FF, $81, $E7, $E7, $E7, $C7, $E7, $E7  ;49 
            dc.b $FF, $81, $9F, $CF, $F3, $F9, $99, $C3  ;50 
            dc.b $FF, $C3, $99, $F9, $E3, $F9, $99, $C3  ;51 
            dc.b $FF, $F9, $F9, $80, $99, $E1, $F1, $F9  ;52 
            dc.b $FF, $C3, $99, $F9, $F9, $83, $9F, $81  ;53 
            dc.b $FF, $C3, $99, $99, $83, $9F, $99, $C3  ;54 
            dc.b $FF, $E7, $E7, $E7, $E7, $F3, $99, $81  ;55 
            dc.b $FF, $C3, $99, $99, $C3, $99, $99, $C3  ;56 
            dc.b $FF, $C3, $99, $F9, $C1, $99, $99, $C3  ;57 
            dc.b $FF, $FF, $E7, $FF, $FF, $E7, $FF, $FF  ;58 
            dc.b $CF, $E7, $E7, $FF, $FF, $E7, $FF, $FF  ;59 
            dc.b $FF, $F1, $E7, $CF, $9F, $CF, $E7, $F1  ;60 
            dc.b $FF, $FF, $FF, $81, $FF, $81, $FF, $FF  ;61 
            dc.b $FF, $8F, $E7, $F3, $F9, $F3, $E7, $8F  ;62 
            dc.b $FF, $E7, $FF, $E7, $F3, $F9, $99, $C3  ;63 
 
 
            dc.b $FF, $C3, $9D, $9F, $91, $91, $99, $C3  ;0 
            dc.b $FF, $99, $99, $99, $81, $99, $C3, $E7  ;1 
            dc.b $FF, $83, $99, $99, $83, $99, $99, $83  ;2 
            dc.b $FF, $C3, $99, $9F, $9F, $9F, $99, $C3  ;3 
            dc.b $FF, $87, $93, $99, $99, $99, $93, $87  ;4 
            dc.b $FF, $81, $9F, $9F, $87, $9F, $9F, $81  ;5 
            dc.b $FF, $9F, $9F, $9F, $87, $9F, $9F, $81  ;6 
            dc.b $FF, $C3, $99, $99, $91, $9F, $99, $C3  ;7 
            dc.b $FF, $99, $99, $99, $81, $99, $99, $99  ;8 
            dc.b $FF, $C3, $E7, $E7, $E7, $E7, $E7, $C3  ;9 
            dc.b $FF, $C7, $93, $F3, $F3, $F3, $F3, $E1  ;10 
            dc.b $FF, $99, $93, $87, $8F, $87, $93, $99  ;11 
            dc.b $FF, $81, $9F, $9F, $9F, $9F, $9F, $9F  ;12 
            dc.b $FF, $9C, $9C, $9C, $94, $80, $88, $9C  ;13 
            dc.b $FF, $99, $99, $91, $81, $81, $89, $99  ;14 
            dc.b $FF, $C3, $99, $99, $99, $99, $99, $C3  ;15 
            dc.b $FF, $9F, $9F, $9F, $83, $99, $99, $83  ;16 
            dc.b $FF, $F1, $C3, $99, $99, $99, $99, $C3  ;17 
            dc.b $FF, $99, $93, $87, $83, $99, $99, $83  ;18 
            dc.b $FF, $C3, $99, $F9, $C3, $9F, $99, $C3  ;19 
            dc.b $FF, $E7, $E7, $E7, $E7, $E7, $E7, $81  ;20 
            dc.b $FF, $C3, $99, $99, $99, $99, $99, $99  ;21 
            dc.b $FF, $E7, $C3, $99, $99, $99, $99, $99  ;22 
            dc.b $FF, $9C, $88, $80, $94, $9C, $9C, $9C  ;23 
            dc.b $FF, $99, $99, $C3, $E7, $C3, $99, $99  ;24 
            dc.b $FF, $E7, $E7, $E7, $C3, $99, $99, $99  ;25 
            dc.b $FF, $81, $9F, $CF, $E7, $F3, $F9, $81  ;26 
            dc.b $FF, $C3, $CF, $CF, $CF, $CF, $CF, $C3  ;27 
            dc.b $FF, $03, $9D, $CF, $83, $CF, $ED, $F3  ;28 
            dc.b $FF, $C3, $F3, $F3, $F3, $F3, $F3, $C3  ;29 
            dc.b $E7, $E7, $E7, $E7, $81, $C3, $E7, $FF  ;30 
            dc.b $FF, $EF, $CF, $80, $80, $CF, $EF, $FF  ;31 
 
 
; Kleinbuchstaben (aus Charset 1): 
            dc.b $FF, $C3, $9D, $9F, $91, $91, $99, $C3  ;224 
            dc.b $FF, $C1, $99, $C1, $F9, $C3, $FF, $FF  ;225 
            dc.b $FF, $83, $99, $99, $83, $9F, $9F, $FF  ;226 
            dc.b $FF, $C3, $9F, $9F, $9F, $C3, $FF, $FF  ;227 
            dc.b $FF, $C1, $99, $99, $C1, $F9, $F9, $FF  ;228 
            dc.b $FF, $C3, $9F, $81, $99, $C3, $FF, $FF  ;229 
            dc.b $FF, $E7, $E7, $E7, $C1, $E7, $F1, $FF  ;230 
            dc.b $83, $F9, $C1, $99, $99, $C1, $FF, $FF  ;231 
            dc.b $FF, $99, $99, $99, $83, $9F, $9F, $FF  ;232 
            dc.b $FF, $C3, $E7, $E7, $C7, $FF, $E7, $FF  ;233 
            dc.b $C3, $F9, $F9, $F9, $F9, $FF, $F9, $FF  ;234 
            dc.b $FF, $99, $93, $87, $93, $9F, $9F, $FF  ;235 
            dc.b $FF, $C3, $E7, $E7, $E7, $E7, $C7, $FF  ;236 
            dc.b $FF, $9C, $94, $80, $80, $99, $FF, $FF  ;237 
            dc.b $FF, $99, $99, $99, $99, $83, $FF, $FF  ;238 
            dc.b $FF, $C3, $99, $99, $99, $C3, $FF, $FF  ;239 
            dc.b $9F, $9F, $83, $99, $99, $83, $FF, $FF  ;240 
            dc.b $F9, $F9, $C1, $99, $99, $C1, $FF, $FF  ;241 
            dc.b $FF, $9F, $9F, $9F, $99, $83, $FF, $FF  ;242 
            dc.b $FF, $83, $F9, $C3, $9F, $C1, $FF, $FF  ;243 
            dc.b $FF, $F1, $E7, $E7, $E7, $81, $E7, $FF  ;244 
            dc.b $FF, $C1, $99, $99, $99, $99, $FF, $FF  ;245 
            dc.b $FF, $E7, $C3, $99, $99, $99, $FF, $FF  ;246 
            dc.b $FF, $C9, $C1, $80, $94, $9C, $FF, $FF  ;247 
            dc.b $FF, $99, $C3, $E7, $C3, $99, $FF, $FF  ;248 
            dc.b $87, $F3, $C1, $99, $99, $99, $FF, $FF  ;249 
            dc.b $FF, $81, $CF, $E7, $F3, $81, $FF, $FF  ;250 
            dc.b $FF, $C3, $CF, $CF, $CF, $CF, $CF, $C3  ;251 
            dc.b $FF, $03, $9D, $CF, $83, $CF, $ED, $F3  ;252 
            dc.b $FF, $C3, $F3, $F3, $F3, $F3, $F3, $C3  ;253 
            dc.b $E7, $E7, $E7, $E7, $81, $C3, $E7, $FF  ;254 
            dc.b $FF, $EF, $CF, $80, $80, $CF, $EF, $FF  ;255 
#endasm
