#define include_gbaMapRoutines	1
#define include_gbaDrawMaskSprite	1
#define include_gbaDrawInvertedSprite	1
#define include_gbaCollision	1

// -----------------------------------------------------------------------------
// -------------------------------| GBAlib v2.0 |-------------------------------
// ------------------------| published in January 2009 |------------------------
// ---------------------------| by Martin BOUSQUET |----------------------------
// ------------------------| martin.bousquet@hotmail.fr|------------------------
// ----------------------------| on www.ticalc.org |----------------------------
// -----------------------| C port by deeph in May 2013 |-----------------------
// -----------------------------------------------------------------------------

#define backBuffer	saferam1
#define frontBuffer	graph_mem
#define screenHeight	8
#define screenWidth	12
#define screenOffsetY	0
#define screenOffsetX	0
#define backOrigin	backBuffer+screenOffsetX+(12*screenOffsetY)
#define frontOrigin	frontBuffer+screenOffsetX+(12*screenOffsetY)
#define GBA_NOCLIP_SPRITE	0
#define GBA_CLIP_SPRITE	1

#asm
mapAddr:
	defw 0

tileAddr:
	defw 0

mapHeight:
	defw 0

mapWidth:
	defw 0

scrollY:
	defw 0
	
scrollX:
	defw 0

offsetX:
	defb 0

offsetY:
	defb 0

offsetX2:
	defb 0

pixelMask:
	defb 0

saveByte:
	defb 0

saveByte2:
	defb 0

#if include_gbaMapRoutines == 1
;-------------------------
; GBA H||IZONTAL SCROLLS |
;-------------------------

gbaScrollHorizontal:
	push de
	ld bc,(scrollX)
	add hl,bc
	ld de,(scrollY)
	ld a,(mapWidth)
	call hl_plus_axde
	pop de
	ld bc,gbaScrollHorizontal_next
	push bc
	push hl
	call findTile
	ld bc,(offsetY)
	ld b,0
	add hl,bc
	ld a,(offsetY)
	sub 8
	neg
	jr Col1xa_loop

gbaScrollHorizontal_next:
	ld b,7

gbaScrollHorizontal_loop:
	push bc
	ld a,8
	call Col1xa
	pop bc
	djnz gbaScrollHorizontal_loop
	ld a,(offsetY)
	or a
	ret z

Col1xa:
	push hl
	call findTile	;  de and a unchanged

Col1xa_loop:
	push af
	ld a,(offsetX)
	and (hl)
	ex de,hl
	jr z,Pixel_white
	ld a,(pixelMask)
	or (hl)
	ld (hl),a

Pixel_white:
	ld bc,12
	add hl,bc
	ex de,hl
	inc hl
	pop af
	dec a
	jr nz,Col1xa_loop
	pop hl
	ld bc,(mapWidth)
	add hl,bc
	ret

;-----------------------
; GBA VERTICAL SCROLLS |
;-----------------------

gbaScrollVertical:
	push de
	ld de,(scrollX)
	add hl,de
	ld a,(mapWidth)
	ld de,(scrollY)
	call hl_plus_axde
	pop de
	ld b,screenWidth+1

gbaScrollVertical_loop:
	push bc
	push hl
	call findTile
	ld bc,(offsetY)
	ld b,0
	add hl,bc
	ld a,(hl)
	ld (de),a
	inc de
	pop hl
	inc hl
	pop bc
	djnz gbaScrollVertical_loop
	dec de
	ex de,hl
	ld a,(offsetX2)
	or a
	ret z

gbaScrollVertical_loop2:	
	push hl
	sla (hl)
	dec hl
	rl (hl)
	dec hl
#if screenWidth > 1
	rl (hl)
	dec hl
#if screenWidth > 2
	rl (hl)
	dec hl
#if screenWidth > 3
	rl (hl)
	dec hl
#if screenWidth > 4
	rl (hl)
	dec hl
#if screenWidth > 5
	rl (hl)
	dec hl
#if screenWidth > 6
	rl (hl)
	dec hl
#if screenWidth > 7
	rl (hl)
	dec hl
#if screenWidth > 8
	rl (hl)
	dec hl
#if screenWidth > 9
	rl (hl)
	dec hl
#if screenWidth > 10
	rl (hl)
	dec hl
#if screenWidth > 11
	rl (hl)
	dec hl
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
	pop hl
	dec a
	jr nz,gbaScrollVertical_loop2
	ret

;-------------------------------------------------------------------------;
;----------------------| GBA SPRITE ROUTINES |----------------------------;
;-------------------------------------------------------------------------;

findTile:
	ld l,(hl)
	ld h,0
	ld bc,(tileAddr)
	add hl,hl
	add hl,hl
	add hl,hl
	add hl,bc
	ret
#endif

#if include_gbaDrawMaskSprite == 1 || include_gbaDrawInvertedSprite == 1
findPixel:
	ld hl,frontOrigin
	ld a,b
	and @111
	srl b
	srl b
	srl b
	ld d,0
	ld e,b
	add hl,de
	ld e,c
	ex de,hl
	add hl,hl
	add hl,hl
	ld b,h
	ld c,l
	add hl,hl
	add hl,bc
	add hl,de
	ret

gbaClipSprite:
	ld a,127
	cp b
	ret c
	ld a,screenWidth
	sub d
	add a,a
	add a,a
	add a,a
	sub b
	ret c
	ld a,c
	bit 7,a
	jr z,gbaClipSprite_next
	neg
	cp e
	ccf
	ret c
	add a,a
	push de
	ld e,d
	ld d,0
	call hl_plus_axde
	pop de
	or a
	ret

gbaClipSprite_next:
	ld a,screenHeight
	add a,a
	add a,a
	add a,a
	dec a
	sub c
	ret c
	inc a
	cp e
	ret nc
	ld e,a
	or a
	ret
#endif

;-------------------------------------------------------------------------;
;---------------------| GBA USEFUL ROUTINES |-----------------------------;
;-------------------------------------------------------------------------;

hl_plus_axde:
	ld b,8

hlplusaxde_loop:
	srl a
	jr nc,hlplusaxde_next
	add hl,de

hlplusaxde_next:
	sla e	; multiply de with 2
	rl d
	djnz hlplusaxde_loop
	ret

;-------------------------------------------------------------------------;
;------------------------| OTHER ROUTINES |-------------------------------;
;-------------------------------------------------------------------------;

return_false:
	ld hl,0
	ret

return_true:
	ld hl,1
	ret

#if include_gbaDrawMaskSprite == 1 || include_gbaDrawInvertedSprite == 1
gbaGetSpriteParameters:
	ld a,(hl)
	push af
	inc hl
	inc hl
	push hl
	inc hl
	inc hl
	ld e,(hl)
	inc hl
	inc hl
	ld d,(hl)
	inc hl
	inc hl
	ld c,(hl)
	inc hl
	inc hl
	ld b,(hl)
	pop hl
	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a
	pop af
	or a
	call nz,gbaClipSprite
	ret
#endif
#endasm

#if include_gbaMapRoutines == 1
char gbaInitMap(unsigned char scrollX, unsigned char scrollY, unsigned char mapWidth, unsigned char mapHeight, unsigned char *tileAddr, unsigned char *mapAddr);
char gbaInitMap(unsigned char scrollX, unsigned char scrollY, unsigned char mapWidth, unsigned char mapHeight, unsigned char *tileAddr, unsigned char *mapAddr){
#asm
	ld hl,2
	add hl,sp
	push hl
	ld de,mapAddr
	ld bc,12
	ldir
	pop hl
	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a	; hl = *mapAddr

gbaInitMap:
	ld de,(scrollX)
	add hl,de
	ld de,(scrollY)
	ld a,(mapWidth)
	call hl_plus_axde
	ld (offsetX2),a
	ld (offsetY),a
	ld (offsetX),a
	set 7,a
	ld (offsetX),a
	ld de,backOrigin
	ld b,screenWidth

gbaInitMap_row:
	ld c,screenHeight
	push de
	push hl

gbaInitMap_col:
	push bc
	push hl
	call findTile
	ld a,8

draw8x8:
	ld b,(hl)
	inc hl
	ex de,hl
	ld (hl),b
	ld bc,12
	add hl,bc
	ex de,hl
	dec a
	jr nz,draw8x8
	pop hl
	ld bc,(mapWidth)
	add hl,bc
	pop bc
	dec c
	jr nz,gbaInitMap_col
	pop hl
	inc hl
	pop de
	inc de
	djnz gbaInitMap_row
#endasm
}

void gbaRestoreMap(void);
void gbaRestoreMap(void){
#asm
gbaRestoreMap:
	ld hl,backOrigin
	ld de,frontOrigin
#if screenWidth == 12
	ld bc,screenWidth*8*screenHeight
	ldir
#else
	ld b,8*screenHeight	
gbaRestoreMap_loop:
	push bc
#if screenWidth < 7
	push de
	push hl
	ld bc,screenWidth
	ldir
	ld bc,12
	pop hl
	add hl,bc
	ex de,hl
	pop add hl,bc
	ex de,hl
#else
	ld bc,screenWidth
	ldir
	inc hl
	inc de
#if screenWidth < 11
	inc hl
	inc de
#elif screenWidth < 10
	inc hl
	inc de
#elif screenWidth < 9
	inc hl
	inc de
#elif screenWidth < 8
	inc hl
	inc de
#endif
	pop bc
	djnz gbaRestoreMap_loop	
#endif
#endif
#endasm
}

void gbaScrollRight(void);
void gbaScrollRight(void){
#asm
gbaScrollRight:
	ld a,(mapWidth)
	ld hl,scrollX
	sub (hl)
	cp screenWidth+1
	jp c,return_false
	ld hl,backOrigin+screenWidth-1
	ld b,8*screenHeight

gbaScrollRight_loop:
	sla (hl)
	dec hl
#if screenWidth > 1
	rl (hl)
	dec hl
#if screenWidth > 2
	rl (hl)
	dec hl
#if screenWidth > 3
	rl (hl)
	dec hl
#if screenWidth > 4
	rl (hl)
	dec hl
#if screenWidth > 5
	rl (hl)
	dec hl
#if screenWidth > 6
	rl (hl)
	dec hl
#if screenWidth > 7
	rl (hl)
	dec hl
#if screenWidth > 8
	rl (hl)
	dec hl
#if screenWidth > 9
	rl (hl)
	dec hl
#if screenWidth > 10
	rl (hl)
	dec hl
#if screenWidth > 11
	rl (hl)
	dec hl
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
	ld de,screenWidth+12
	add hl,de
	djnz gbaScrollRight_loop
	ld a,@00000001
	ld (pixelMask),a
	ld de,backOrigin+screenWidth-1
	ld hl,(mapAddr)
	ld bc,screenWidth
	add hl,bc
	call gbaScrollHorizontal
	ld a,(offsetX2)
	inc a
	and @111
	ld (offsetX2),a
	ld a,(offsetX)
	srl a
	ld (offsetX),a
	ret nc
	ld a,@10000000
	ld (offsetX),a
	ld hl,scrollX
	inc (hl)
	or a
	ld hl,1
#endasm
}

void gbaScrollLeft(void);
void gbaScrollLeft(void){
#asm
gbaScrollLeft:
	ld a,(offsetX)
	cp @10000000
	jr nz,gbaScrollLeft_ok
	ld a,(scrollX)
	sub 1
	jp c,return_false

gbaScrollLeft_ok:
	ld a,(offsetX2)
	dec a
	and @111
	ld (offsetX2),a
	ld a,(offsetX)
	add a,a
	jr nc,gbaScrollLeft_next
	ld a,@00000001
	ld hl,scrollX
	dec (hl)

gbaScrollLeft_next:
	ld (offsetX),a
	ld hl,backOrigin
	ld b,8*screenHeight

gbaScrollLeft_loop:
	srl (hl)
	inc hl
#if screenWidth > 1
	rr (hl)
	inc hl
#if screenWidth > 2
	rr (hl)
	inc hl
#if screenWidth > 3
	rr (hl)
	inc hl
#if screenWidth > 4
	rr (hl)
	inc hl
#if screenWidth > 5
	rr (hl)
	inc hl
#if screenWidth > 6
	rr (hl)
	inc hl
#if screenWidth > 7
	rr (hl)
	inc hl
#if screenWidth > 8
	rr (hl)
	inc hl
#if screenWidth > 9
	rr (hl)
	inc hl
#if screenWidth > 10
	rr (hl)
	inc hl
#if screenWidth > 11
	rr (hl)
	inc hl
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#if screenWidth < 9
	ld de,12-screenWidth
	add hl,de
#else
#if screenWidth < 12
	inc hl
#if screenWidth < 11
	inc hl
#if screenWidth < 10
	inc hl
#endif
#endif
#endif
#endif
	djnz gbaScrollLeft_loop
	ld a,@10000000
	ld (pixelMask),a
	ld hl,(mapAddr)
	ld de,backOrigin
	call gbaScrollHorizontal
	or a
	ld hl,1
#endasm
}

void gbaScrollUp(void);
void gbaScrollUp(void){
#asm
gbaScrollUp:
	ld a,(offsetY)
	or a
	jr nz,gbaScrollUp_ok
	ld a,(scrollY)
	sub 1
	jp c,return_false

gbaScrollUp_ok:
	ld a,(offsetY)
	dec a
	and @111
	ld (offsetY),a
	cp 7
	jr nz,gbaScrollUp_next
	ld hl,scrollY
	dec (hl)

gbaScrollUp_next:
	ld de,backOrigin+screenWidth-1+(12*(8*screenHeight-1))
	ld hl,backOrigin+screenWidth-1+(12*(8*screenHeight-2))
#if screenWidth == 12
	ld bc,8*screenHeight*screenWidth
	lddr
#else
	ld b,8*screenHeight

gbaScrollUp_loop:
	push bc
	ld bc,screenWidth
#if screenWidth < 7
	push hl
	push de
	lddr
	pop hl
	ld bc,-12
	add hl,bc
	ex de,hl
	pop hl
	add hl,bc
#else
	lddr
	dec hl
	dec de
#if screenWidth < 11
	dec hl
	dec de
#if screenWidth < 10
	dec hl
	dec de
#if screenWidth < 9
	dec hl
	dec de
#if screenWidth < 8
	dec hl
	dec de
#endif
#endif
#endif
#endif
#endif
	pop bc
	djnz gbaScrollUp_loop
#endif
	ld a,(backOrigin+screenWidth)
	ld (saveByte),a
	ld hl,(mapAddr)
	ld de,backOrigin
	call gbaScrollVertical
	ld a,(saveByte)
	ld (hl),a
	ld hl,1
#endasm
}

void gbaScrollDown(void);
void gbaScrollDown(void){
#asm
gbaScrollDown:
	ld a,(mapHeight)
	ld hl,scrollY
	sub (hl)
	cp screenHeight+1
	jp c,return_false
	ld de,backOrigin
	ld hl,backOrigin+12
#if screenWidth == 12
	ld bc,8*screenWidth*screenHeight
	ldir
#else
	ld b,8*screenHeight

gbaScrollDown_loop:
	push bc
	ld bc,screenWidth
#if screenWidth < 8
	push hl
	push de
	ldir
	pop hl
	ld bc,12
	add hl,bc
	ex de,hl
	pop hl
	add hl,bc
#else
	ldir
	inc hl
	inc de
#if screenWidth < 11
	inc hl
	inc de
#if screenWidth < 10
	inc hl
	inc de
#if screenWidth < 9
	inc hl
	inc de
#endif
#endif
#endif
#endif
	pop bc
	djnz gbaScrollDown_loop
#endif
	ld a,(de)
	ld (saveByte2),a
	ld hl,-12
	add hl,de
	push hl
	ld hl,(mapAddr)
	ld de,(mapWidth)
	ld a,screenHeight
	call hl_plus_axde
	pop de
	call gbaScrollVertical
	ld a,(saveByte2)
	ld (hl),a
	ld a,(offsetY)
	inc a
	and @111
	ld (offsetY),a
	jp nz,return_true
	ld hl,scrollY
	inc (hl)
	or a
	ld hl,1
#endasm
}
#endif

#if include_gbaDrawMaskSprite == 1 || include_gbaDrawInvertedSprite == 1
char gbaDrawMaskSprite(unsigned char x, unsigned char y, unsigned char width, unsigned char height, unsigned char *sprite, unsigned char is_clipped);
char gbaDrawMaskSprite(unsigned char x, unsigned char y, unsigned char width, unsigned char height, unsigned char *sprite, unsigned char is_clipped){
#asm
	ld hl,2
	add hl,sp
	call gbaGetSpriteParameters
	jp c,return_false

gbaDrawMaskSprite:
	push hl
	push de
	call findPixel
	pop bc
	ex de,hl
	pop hl

gbaDrawMaskSprite_col:
	push bc
	push de

gbaDrawMaskSprite_row:
	push bc
	ld b,(hl)
	ld c,@11111111
	inc hl
	push hl
	push af
	push af
	ld a,(hl)

gbaInvertedOpcode:
	nop
	nop
	ld h,a
	ld l,0
	pop af
	or a
	jr z,gbaDrawMaskSprite_next

gbaDrawMaskSprite_shift:
	scf
	rr b
	rr c
	srl h
	rr l
	dec a
	jr nz,gbaDrawMaskSprite_shift

gbaDrawMaskSprite_next:
	ex de,hl
	ld a,(hl)
	and b
	or d
	ld (hl),a
	inc hl
	ld a,(hl)
	and c
	or e
	ld (hl),a
	ex de,hl
	pop af
	pop hl
	inc hl
	pop bc
	djnz gbaDrawMaskSprite_row
	ex de,hl
	pop hl
	ld bc,12
	add hl,bc
	ex de,hl
	pop bc
	dec c
	jr nz,gbaDrawMaskSprite_col
#endasm
}
#endif

#if include_gbaDrawInvertedSprite == 1
char gbaDrawInvertedSprite(unsigned char x, unsigned char y, unsigned char width, unsigned char height, unsigned char *sprite, unsigned char is_clipped);
char gbaDrawInvertedSprite(unsigned char x, unsigned char y, unsigned char width, unsigned char height, unsigned char *sprite, unsigned char is_clipped){
#asm
	ld hl,2
	add hl,sp
	call gbaGetSpriteParameters
	jp c,return_false

gbaDrawInvertedSprite:
	push hl
	ld hl,gbaInvertedOpcode
	ld (hl),$2f			; opcode for 'cpl'
	inc hl
	ld (hl),$a8			; opcode for 'xor b'
	pop hl
	call gbaDrawMaskSprite
	ld hl,gbaInvertedOpcode
	ld (hl),0
	inc hl
	ld (hl),0
#endasm
}
#endif

#if include_gbaCollision == 1
char gbaCollision(unsigned char x, unsigned char y);
char gbaCollision(unsigned char x, unsigned char y){
#asm
	ld hl,2
	add hl,sp
	ld c,(hl)
	inc hl
	inc hl
	ld b,(hl)

gbaCollision:
	ld hl,(mapAddr)
	ld de,(scrollX)
	add hl,de
	ld a,(offsetX2)
	add a,b
	sra a
	sra a
	sra a
	ld e,a
	ld d,0
	bit 7,a
	jr z,gbaCollision_next
	dec d

gbaCollision_next:
	add hl,de
	ld a,(offsetY)
	add a,c
	sra a
	sra a
	sra a
	ld b,0
	ld c,a
	bit 7,a
	jr z,gbaCollision_next2
	dec b

gbaCollision_next2:
	ex de,hl
	ld hl,(scrollY)
	add hl,bc
	ex de,hl
	ld a,(mapWidth)
	call hl_plus_axde
	ld l,(hl)
	ld h,0
#endasm
}
#endif