#pragma string name C TEST

#include <..\dev\ti83p.h>
#include <..\dev\tiroutines.h>
//#include <..\dev\gbalib2.h>

#define bcall(romcall);	asm("rst rbr_call\ndefw "#romcall);

#include <..\dev\sprites\title.h>
#include <..\dev\sprites\map.h>
#include <..\dev\sprites\map_player.h>

#define START	0
#define LOAD	1
#define QUIT	2

extern char text_menu[];
#asm
._text_menu
	defm "Nouveau"&NEWL&"Continuer"&NEWL&"Quitter"&0
#endasm

extern char text_intro[];
#asm
._text_intro
	defm "Vous viviez tranquillement"&NEWL&"en dehors de la soci"&0x96&"t"&0x96&NEWL&"jusqu'au jour o"&0xaf&" vous"&NEWL&"d"&0x96&"couvrez qu'on vous a"&NEWL&"vol"&0x96&"..."&BRK&NEWL&"Vous d"&0x96&"cidez alors de"&NEWL&"partir "&0x8f&" la recherche"&NEWL&"des voleurs."&BRK&0
#endasm
// j'en suis l  essayer de faire afficher la 2nde partie du message (aprs le BRK)

extern char text_castle[];
#asm
._text_castle
	defm "Garde :"&NEWL&"Passez votre chemin sale"&NEWL&"manant !"&BRK&0
#endasm

void main_menu(void);
char draw_cursor(unsigned char x, unsigned char y);
char handle_map(unsigned char player_x, unsigned char player_y);
char update_map(unsigned char player_x, unsigned char player_y);
char draw_player(unsigned char old_player_x, unsigned char old_player_y, unsigned char player_x, unsigned char player_y);
char check_place(unsigned char player_x, unsigned char player_y);

int main(){
	unsigned char player_x = 1, player_y = 1;
	switch(main_menu()){
		case START:	// start
			rectangle_filled(0, 0, 96, 64, RECT_FILL_BLACK);
			rectangle_filled(1, 1, 94, 62, RECT_FILL_WHITE);
			text(2, 1, text_intro, TEXT_TYPE, 5);
			handle_map(player_x, player_y);
			break;
		case LOAD: // load
			break;
	}
}

void main_menu(void){
	unsigned char cursor_y = 0, key = 0;
	ionLargeSprite(5, 0, 11, 26, title);
	rectangle_filled(28, 33, 40, 21, RECT_FILL_BLACK);
	rectangle_filled(29, 34, 38, 19, RECT_FILL_WHITE);
	text(34, 34, text_menu, TEXT_NOTYPE, 0);
	ionFastCopy();
	while(key != skey_2nd){
		draw_cursor(30, 34+cursor_y*6);
		key = getkey();
		switch(key){
			case skey_up:
				if(cursor_y > START){
					ionFastCopy();
					cursor_y-=1;
				}
				break;
			case skey_down:
				if(cursor_y < QUIT){
					ionFastCopy();
					cursor_y+=1;
				}
				break;
		}
	}
	return cursor_y;
}

char draw_cursor(unsigned char x, unsigned char y){
#asm
	res textwrite,(iy+sgrflags)	; reset some flag to write only to the screen (not the graph buffer)
	ld hl,2
	add hl,sp
	ld b,(hl)	; get y from the parameters (stack)
	inc hl
	inc hl
	ld c,(hl)	; get x
	ld (pencol),bc
	ld a,5
	rst rbr_call
	defw _vputmap	; write the cursor character
	set textwrite,(iy+sgrflags)	; set the flag to write on the gbuf
#endasm
}

char handle_map(unsigned char player_x, unsigned char player_y){
	unsigned char key = 0;
	update_map(player_x, player_y);
	while(key != dkey_clear){
		switch(direct_input(dkey_group_1)){
			case dkey_up:
				if((getpixel(player_x, player_y-1) == PIXEL_OFF) && (getpixel(player_x+1, player_y-1) == PIXEL_OFF) && (getpixel(player_x+2, player_y-1) == PIXEL_OFF)){
					draw_player(player_x, player_y, player_x, player_y-=1);
				}else{
					check_place(player_x+1, player_y-1);
					update_map(player_x, player_y);
				}
				break;
			case dkey_right:
				if((getpixel(player_x+3, player_y) == PIXEL_OFF) && (getpixel(player_x+3, player_y+1) == PIXEL_OFF) && (getpixel(player_x+3, player_y+2) == PIXEL_OFF)){
					draw_player(player_x, player_y, player_x+=1, player_y);
				}else{
					check_place(player_x+3, player_y+1);
					update_map(player_x, player_y);
				}
				break;
			case dkey_left:
				if((getpixel(player_x-1, player_y) == PIXEL_OFF) && (getpixel(player_x-1, player_y+1) == PIXEL_OFF) && (getpixel(player_x-1, player_y+2) == PIXEL_OFF)){
					draw_player(player_x, player_y, player_x-=1, player_y);
				}else{
					check_place(player_x-1, player_y+1);
					update_map(player_x, player_y);
				}
				break;
			case dkey_down:
				if((getpixel(player_x, player_y+3) == PIXEL_OFF) && (getpixel(player_x+1, player_y+3) == PIXEL_OFF) && (getpixel(player_x+2, player_y+3) == PIXEL_OFF)){
					draw_player(player_x, player_y, player_x, player_y+=1);
				}else{
					check_place(player_x+1, player_y+3);
					update_map(player_x, player_y);
				}
				break;
		}
		key = direct_input(dkey_group_2);
	}
}

char update_map(unsigned char player_x, unsigned char player_y){
	bcall(_cleargbuf);
	ionLargeSprite(0, 0, 12, 64, map);
	ionPutSprite(player_x, player_y, 3, map_player);
	ionFastCopy();
}

char draw_player(unsigned char old_player_x, unsigned char old_player_y, unsigned char player_x, unsigned char player_y){
	ionPutSprite(old_player_x, old_player_y, 3, map_player);	// clear the player's sprite
	ionPutSprite(player_x, player_y, 3, map_player);	// and re-draw it to its new place
	ionFastCopy();
}

char check_place(unsigned char player_x, unsigned char player_y){
	if(player_x > 5 && player_x < 19 && player_y > 4 && player_y < 31){
		// TOWER
	}else if(player_x > 25 && player_x < 58 && player_y > 3 && player_y < 36){
		// CASTLE
		rectangle_filled(0, 37, 96, 27, RECT_FILL_BLACK);
		rectangle_filled(1, 38, 94, 25, RECT_FILL_WHITE);
		text(2, 38, text_castle, TEXT_TYPE, 5);
	}else if(player_x > 57 && player_x < 95 && player_y > 0 && player_y < 25){
		// VOLCANO
	}else if(player_x > 29 && player_x < 49 && player_y > 39 && player_y < 54){
		// TOWN
	}else if(player_x > 59 && player_x < 95 && player_y > 32 && player_y < 63){
		if(player_x > 83 && player_x < 94 && player_y > 52 && player_y < 62){
			// HOUSE
		}else{
			// FOREST
		}
	}
}
