#define include_delay	1
#define include_ionPutSprite	1
#define include_ionLargeSprite	1
#define include_ionFastCopy	1
#define include_direct_input	1
#define include_getkey	1
#define include_getpixel	1
#define include_rectangle_filled	1
#define include_text	1

#if include_delay == 1
char __FASTCALL__ delay(unsigned char delay);
char __FASTCALL__ delay(unsigned char delay){
#asm
	ld a,(hl)
	ld b,a
	ei

delay_loop:
	halt
	djnz delay_loop
	di
#endasm
}
#endif

#if include_ionPutSprite == 1
char ionPutSprite(unsigned char x, unsigned char y, unsigned char height, unsigned char *sprite);
char ionPutSprite(unsigned char x, unsigned char y, unsigned char height, unsigned char *sprite){
#asm
	ld hl,2
	add hl,sp
	ld e,(hl)
	inc hl
	ld d,(hl)
	push de
	pop ix
	inc hl
	ld b,(hl)
	inc hl
	inc hl
	ld c,(hl)
	inc hl
	inc hl
	ld a,(hl)
	ld l,c

;-----> Draw a sprite
; b=size of sprite
; l=y
; a=x
; ix holds pointer
ionPutSprite:
	ld e,l
	ld h,$00
	ld d,h
	add hl,de
	add hl,de
	add hl,hl
	add hl,hl
	ld e,a
	and $07
	ld c,a
	srl e
	srl e
	srl e
	add hl,de
	ld de,gbuf
	add hl,de

ionPutSpriteLoop1:
	ld d,(ix)
	ld e,$00
	ld a,c
	or a
	jr z,ionPutSpriteSkip1

ionPutSpriteLoop2:
	srl d
	rr e
	dec a
	jr nz,ionPutSpriteLoop2

ionPutSpriteSkip1:
	ld a,(hl)
	xor d
	ld (hl),a
	inc hl
	ld a,(hl)
	xor e
	ld (hl),a
	ld de,$0b
	add hl,de
	inc ix
	djnz ionPutSpriteLoop1
#endasm
}
#endif

#if include_ionLargeSprite == 1
char ionLargeSprite(unsigned char x, unsigned char y, unsigned char width, unsigned char height, unsigned char *sprite);
char ionLargeSprite(unsigned char x, unsigned char y, unsigned char width, unsigned char height, unsigned char *sprite){
#asm
	ld hl,2
	add hl,sp
	ld e,(hl)
	inc hl
	ld d,(hl)
	push de
	pop ix
	inc hl
	ld b,(hl)
	inc hl
	inc hl
	ld c,(hl)
	inc hl
	inc hl
	push hl
	inc hl
	inc hl
	ld a,(hl)
	pop hl
	ld l,(hl)

;-----> Draw a picture
;Input:	ix->sprite
;	a=x
;	l=y
;	b=height	(in pixels)
;	c=width		(in bytes, e.g. 2 would be 16)
;Output: nothing
ionLargeSprite:
	di
	ex af,af
	ld a,c
	push af
	ex af,af
	ld e,l
	ld h,0
	ld d,h
	add hl,de
	add hl,de
	add hl,hl
	add hl,hl
	ld e,a
	and $07
	ld c,a
	srl e
	srl e
	srl e
	add hl,de
	ld de,gbuf
	add hl,de

ionLargeSpriteLoop1:
	push hl

ionLargeSpriteLoop2:
	ld d,(ix)
	ld e,0
	ld a,c
	or a
	jr z,ionLargeSpriteSkip1

ionLargeSpriteLoop3:
	srl d
	rr e
	dec a
	jr nz,ionLargeSpriteLoop3

ionLargeSpriteSkip1:
	ld a,(hl)
	xor d
	ld (hl),a
	inc hl
	ld a,(hl)
	xor e
	ld (hl),a
	inc ix
	ex af,af
	dec a
	push af
	ex af,af
	pop af
	jr nz,ionLargeSpriteLoop2
	pop hl
	pop af
	push af
	ex af,af
	ld de,$0c
	add hl,de
	djnz ionLargeSpriteLoop1
	pop af
#endasm
}
#endif

#if include_ionFastCopy == 1 || include_text == 1
void ionFastCopy(void);
void ionFastCopy(void){
#asm
;-----> Copy the gbuf to the screen (fast)
;Input:	nothing
;Output:graph buffer is copied to the screen
ionFastCopy:
	di
	ld a,$80
	out (plcdcmd),a
	ld hl,gbuf-12-(-(12*64)+1)
	ld a,$20
	ld c,a
	inc hl
	dec hl

ionFastCopyAgain:
	ld b,64
	inc c
	ld de,-(12*64)+1
	out (plcdcmd),a
	add hl,de
	ld de,10

ionFastCopyLoop:
	add hl,de
	inc hl
	inc hl
	inc de
	ld a,(hl)
	out (plcddata),a
	dec de
	djnz ionFastCopyLoop
	ld a,c
	cp $2b+1
	jr nz,ionFastCopyAgain
#endasm
}
#endif

#if include_direct_input == 1
char __FASTCALL__ direct_input(unsigned char keygroup);
char __FASTCALL__ direct_input(unsigned char keygroup){
#asm
	ld a,l	; a = keygroup
	out (pkey),a
	in a,(pkey)
	ld h,0
	ld l,a		; hl is the return parameter
#endasm
}
#endif

#if include_getkey == 1
void getkey(void);
void getkey(void){
#asm
getkey_loop:
	rst rbr_call
	defw _getcsc
	or a
	jr z,getkey_loop
	ld h,0
	ld l,a
#endasm
}
#endif

#if include_getpixel == 1
#define PIXEL_ON	1
#define PIXEL_OFF	0
char getpixel(unsigned char x, unsigned char y);
char getpixel(unsigned char x, unsigned char y){
#asm
	ld hl,2
	add hl,sp
	ld e,(hl)	; e=y
	inc hl
	inc hl
	ld a,(hl)	; a=x
	ld l,e

getpixel:
	ld h,0
	ld d,h
	ld e,l
	add hl,hl
	add hl,de
	add hl,hl
	add hl,hl
	ld e,a
	srl e
	srl e
	srl e
	add hl,de
	ld de,plotsscreen
	add hl,de
	and 7
	ld b,a
	ld a,$80
	jr z,testpixel

getpixel_loop:
	rrca
	djnz getpixel_loop

testpixel:
	and (hl)
	or a
	jr nz,getpixel_quit
	ld hl,0

getpixel_quit:
#endasm
}
#endif

#if include_rectangle_filled == 1
#define RECT_FILL_WHITE	0
#define RECT_FILL_BLACK	1
#define RECT_FILL_XOR	2

char rectangle_filled(unsigned char x, unsigned char y, unsigned char width, unsigned char height, unsigned char color);
char rectangle_filled(unsigned char x, unsigned char y, unsigned char width, unsigned char height, unsigned char color){
#asm
; Rectangle filled routine by chickendude

#define GBUF_LSB	$40
#define GBUF_MSB	$93

	ld hl,2
	add hl,sp
	push hl
	inc hl
	inc hl
	ld b,(hl)
	inc hl
	inc hl
	ld c,(hl)
	inc hl
	inc hl
	ld e,(hl)
	inc hl
	inc hl
	ld d,(hl)
	pop hl
	ld a,(hl)
	cp 2
	jr z,rectangle_filled_xor
	or a
	jr nz,rectangle_filled_solid

;b = height
;c = width
;d = starting x
;e = starting y

rectangle_filled_white:
	call rectangle_filled_solid

rectangle_filled_xor:
	ld a,$ae		;xor (hl)
	jr rectangle_filled2

rectangle_filled_solid:
	ld a,$b6		;or (hl)

rectangle_filled2:
	push de
	push bc
	ld (or_xor),a	;use smc for xor/solid fill
	ld a,d			;starting x
	and $7			;what bit do we start on?
	ex af,af
	ld a,d			;starting x
	ld l,e			;ld hl,e
	ld h,0			; ..
	ld d,h			;set d = 0
	add hl,de		;starting y * 12
	add hl,de		;x3
	add hl,hl		;x6
	add hl,hl		;x12
	rra				;a = x coord / 8
	rra				;
	rra				;
	and @00011111	;starting x/8 (starting byte in gbuf)
	add a,GBUF_LSB
	ld e,a			;
	ld d,GBUF_MSB	;
	add hl,de		;hl = offset in gbuf
	ex af,af
	ld d,a
	ld a,@10000000
	jr z,rectangle_filled4

rectangle_filled3:
	rra
	dec d
	jr nz,rectangle_filled3

rectangle_filled4:
	ld e,12

rectangle_loop_x:
	push af
	push bc
	push hl
	ld c,a

rectangle_loop_y:

or_xor:
	or (hl)			;smc will modify this to or/xor
	ld (hl),a
	ld a,c
	add hl,de
	djnz rectangle_loop_y
	pop hl
	pop bc
	pop af
	rrca
	jr nc,rectangle_filled5
	inc hl

rectangle_filled5:
	dec c
	jr nz,rectangle_loop_x

rectangle_end:
	pop bc
	pop de
#endasm
}
#endif

#if include_text == 1
#asm
#define TEXT_NOTYPE	0
#define TEXT_TYPE	1
#define NEWX	$ff
#define NEWY	$fe
#define NEWXY	$fd
#define NEWL	$fc
#define BRK	$fb
text_wait:
	defb 0
text_typing_speed:
	defb 0
default_col:
	defb 0
#endasm
char text(unsigned char x, unsigned char y, unsigned char *text, unsigned char is_typed, unsigned char typing_speed);
char text(unsigned char x, unsigned char y, unsigned char *text, unsigned char is_typed, unsigned char typing_speed){
#asm
; Text routine by chickendude
;	$00		= end of a dialogue or end of a menu option
;NEWX	($ff)	= new X coordinate
;NEWY	($fe)	= new Y coordinate
;NEWXY	($fd)	= new XY coordinates
;NEWL	($fc)	= new line
;BRK	($fb)	= pause
	ld hl,2
	add hl,sp
	set textwrite,(iy+sgrflags)
	ld a,(hl)
	ld (text_typing_speed),a
	inc hl
	inc hl
	ld a,(hl)
	ld (text_wait),a
	inc hl
	inc hl
	push hl
	inc hl
	inc hl
	ld d,(hl)
	inc hl
	inc hl
	ld e,(hl)
	pop hl
	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a

text_start:
	ld (pencol),de
	ld a,e
	ld (default_col),a

text_loop:
	ld de,(pencol)
	ld a,(hl)
	or a
	jp z,ionFastCopy
	cp BRK
	jr c,not_special
	ld bc,text_loop
	push bc
	push hl
	ld hl,text_routine_table
	cpl
	add a,a
	ld c,a
	ld b,0
	add hl,bc
	ld c,(hl)
	inc hl
	ld b,(hl)
	pop hl			;hl = adress in the string
	push bc			;bc = routine adress where we want to jump
	ret

not_special:
	push de
	push ix
	rst rbr_call
	defw _vputmap
	pop ix
	pop de
	ld a,(text_wait)	;= 0 if no delay, != 0 else
	or a
	call nz,text_delay
	inc hl
	jr text_loop

text_delay:
	di
	exx
	ld a,dkey_group_6	;check ALPHA to skip text typing
	out (pkey),a
	in a,(pkey)
	bit 7,a
	jr nz,text_delay_skip
	xor a
	ld (text_wait),a

text_delay_skip:
	ld a,(text_typing_speed)
	ld b,a

text_delay_loop:
	push bc
	call nc,ionFastCopy
	pop bc
	djnz text_delay_loop
	exx
	ret

text_routine_table:
	defw text_new_x
	defw text_new_y
	defw text_new_x_y
	defw text_new_line
	defw text_pause

text_new_x:
	inc hl
	ld e,(hl)
	ld (pencol),de
	inc hl
	ret

text_new_x_y:
	call text_new_x

text_new_y:
	inc hl
	ld d,(hl)
	ld (pencol),de
	inc hl
	ret

text_new_line:
	ld a,d
	add a,6	;penrow+6
	ld d,a
	ld a,(default_col)
	ld e,a
	ld (pencol),de
	inc hl
	ld a,(hl)
	ret

text_pause:
	pop bc			;clear stack
	push hl
	call ionFastCopy

text_pause_loop:
	ei
	halt
	di
	ld a,dkey_group_7	;check 2nd
	out (pkey),a
	in a,(pkey)
	bit 5,a
	jr nz,text_pause_loop

load_next_text:
	ld hl,text_wait
	inc (hl)
	in a,(pkey)
	inc a
	jr nz,load_next_text
	pop hl
	inc hl					;skip BRK
	ret
#endasm
}
#endif