zshell_hook:
	.db $83 ; used by os for hook safety check (add a,e can be used too)
	or a
	jr z,zshell_hook_start  ; we just want to handle prgm, not TI-Basic functions

zshell_hook_return_z:
	xor a
	ret

zshell_hook_start:
	ld hl,(basic_start)	; what's on homescreen
	ld a,(hl)
	cp tprog
	jr nz,zshell_hook_return_z	; if it don't start with "prgm", we don't care
	rst rmov9toop1	; we put "prgmANYTHING" into op1
	ld hl,op1
	ld (hl),progobj	; then replace "prgm" token with the program type (progobj)
	bcall(_chkfindsym)	; so we can find its datas
	ex de,hl	; cause of _getbytepaged parameters
	ld a,e_undefined
	bjumpc(_jerror)	; if not found, throw an "undefined error"
	call get_byte	; else start to read it
	ld e,a
	call get_byte	; first two bytes are length of the program
	jr c,zshell_hook_return_nz	; if empty, don't parse
	ld d,a
	dec de
	dec de	; we don't count the first two bytes (t2bytetok/texttok+tasmcmp/tasm84ccmp) into the program length
	ld (program_length_count),de
	call get_byte	; skip t2bytetok/texttok
	call get_byte
	cp tasmcmp
	jr z,zshell_hook_execute_prgm
	;cp tzshellprgm
	;ld hl,zshell_txt
	;jr z,zshell_hook_execute_prgm
	jr zshell_hook_return_z	; TI-Basic program

zshell_hook_execute_prgm:
	; todo : skip zshell things
	ld a,b
	or a
	call nz,zshell_hook_unarchive
	; todo : relocate non archived prgm before launch

simpleWay:
	; create space at progstart to load the program
	push hl	; hl = first byte of prog data
	push de	; de = prog length-2
	ex de,hl	;hl = prog size
	ld de,progstart	; $9d95
	bcall(_insertmem)	; insert hl bytes to progstart
	pop bc	; bc = size of program
	pop hl	; hl = first byte of program data
	push bc	; save size of program
	add hl,bc	; we've inserted bc bytes ;)
	ldir	; de = progstart
	call progstart	; run the program
	; now delete that memory
	pop de	; de = number of bytes to delete
	ld hl,progstart	; hl = where to delete them from
	bcall(_delmem)
	ret

zshell_hook_unarchive:
	push hl
	ld hl,(program_length_count)
	push bc
	bcall(_enoughmem)
	pop bc
	pop hl
	ld a,e_memory
	bjumpc(_jerror)
	ld a,b
	ld de,progstart
	ld bc,(program_length_count)
	bcall(_flashtoram)
	ret

zshell_hook_return_nz:
	or $80  ; reset zero flag, the parser can't continue to parse the variable
	ret