#include "graphics.h"

#include "JAGUAR.H"
#include "game.h"

#define NBR_BITMAP_TITLE 2

#define NBR_BITMAPS 1

#define MAX_PLANKTON  32
#define PLK_HDIST 32768
#define PLK_VDIST 8192
#define MINE_TRIGGER_SQDIST 25600 
#define MAX_DEPTH -53248

#define MAX_OBJECT  61

#define START_MINE  0
#define END_MINE    19
#define START_TORPEDO 20
#define END_TORPEDO 22
#define START_BAD_TORPEDO 23
#define END_BAD_TORPEDO 26
#define START_SEEKER 27
#define END_SEEKER  36
#define START_TRANSPORT 37
#define END_TRANSPORT 46
#define START_DRONE 47
#define END_DRONE 59
#define PLAYER_SHIP 60

#define MAX_OBJ_CAMCOL  37


#define PLAYAREA_MASK 0x3FFFF
#define PLAYAERA_WIDTH  131072
#define PLAYAERA_DEPTH_MASK 0x7FFF
#define PLAYAERA_HALFDEPTH_MASK 0x3FFF
#define PLAYAERA_DEPTH  -32768

#define SHIP_DAMMAGE 10
#define SHIP_SHIELD  100
#define SHIP_MAXSPEED 24

#define MINE_DAMMAGE 34
#define MINE_SHIELD 1
#define TORPEDO_DAMMAGE 30
#define TORPEDO_SHIELD  1
#define TORPEDO_LIFE    120
#define TRANSPORT_DAMMAGE 2
#define TRANSPORT_SHIELD  100
#define DRONE_DAMMAGE 2
#define DRONE_SHIELD  60
#define BADTORPEDO_SHIELD 1
#define BADTORPEDO_DAMMAGE 10
#define BADTORPEDO_LIFE 60


#define NB_LEVELS 2

extern int gpucodesize;
extern int dspcodesize;

short* ptsintab= &sintab;

static int pad = 0;
static int systemType = 0;
static int frameTime = 0;
static TTriangle tri[3];
static TTriangle otri[1];
static TTriangle* ptrtriclipped[400];
static TTriangle* ptrtriclipped2[400];
static TObjTrans plkTrans[MAX_PLANKTON];
static TLevel level[NB_LEVELS];


void LevelIntro(TLevel* level);

void CheckCamBoundaries(TObjTrans* cam, TShip* ship);
void GenerateMines(TObjTrans* objTrans, int n); 
void GeneratePlankton(TObjTrans* trans, TObjTrans* cam);
void GenerateTorpedo(TObjTrans* objTrans, TObjTrans* cam);
void GenerateTransports(TObjTrans* objTrans, int n);
void GenerateDrones(TObjTrans* objTrans, int n);

int PlanktonMove(void* ptlogic, TObjTrans* cam, int res, TTriangle** ptr);
void TransportMove(TObjTrans* thisObj);
int DroneMove(TObjTrans* thisObj, TObjTrans* cam, TShip* ship, TObjTrans* objtrans);

int MainLoop()
{
  int i;
  int levelselect = 0;
  int voxres = 0;
  
  /* Levels definition */
  level[0].nbmines = 0;
  level[0].nbtransports = 5;
  level[0].nbdrones = 0;
  level[0].minesObjective = 0;
  level[0].transportsObjective = 3;
  level[0].message = "Destroy transports";  
  level[0].showObj = &TransportObj;
  
  level[1].nbmines = 0;
  level[1].nbtransports = 0;
  level[1].nbdrones = 3;
  level[1].minesObjective = 0;
  level[1].transportsObjective = 0;
  level[1].dronesObjective = 1;
  level[1].message = "Destroy drones";  
  level[1].showObj = &DroneObj;
  
  systemType = GetSystemType();
  if(systemType)  /* NTSC */
  {
    frameTime = 267;
  }
  else
  {
    frameTime = 320;
  }
  
  for(;;)
  {
    int levelsuccess = 0;
    levelselect = MenuLoop();
    SetVoiceVol(0, 31, 31);
    SetVoiceStep(0,256);
    SetVoice(0,0,0,0);
    voxres = DSPsync();
    do
    {    
      LevelIntro(&level[levelselect]);
      levelsuccess = GameLoop(&level[levelselect]);
      for(i=0; i<3; i++)
      {
        SetVoiceVol(i, 30, 30);
        SetVoiceStep(i,256);
        SetVoice(i,0,0,0);
        voxres = DSPsync();
      }
      if(levelsuccess)
      {
        levelselect++;
        if(levelselect>=NB_LEVELS)
        {
          levelsuccess = 0;
        }
      }
    }
    while(levelsuccess);
  }
  return 0;
}

int MenuLoop()
{
static CBitmap bitmaps[NBR_BITMAP_TITLE];
static CBitmapArray array;
static char listbuff[DLSIZE(NBR_BITMAP_TITLE)+32];

static char* messages[2];

  unsigned char* ptlogic,* ptphysic;  
	void * ptlist;
	int gpures = 0;
	int voxres = 0;
	int frame = 0;  
  int lastmessageframe = 0;   
  int messageselect = 0;
  int fin = 0;
  int res2 = 0;
  int nextres = 0;
  int sinstep = 512;
  int render = 1;
  unsigned short* ptTest = (unsigned short*)0xAA1F0;/*&AStrangerDeathsound;*/
  
  TObjTrans objTrans;
  TObjTrans cam;
  
  int i;
  
  srand(0);
  
	ptlist = ALIGN32(listbuff);

#pragma dontwarn 80	
	ptphysic = &vidmem;
	ptlogic = &vidmem+(FBW*FBH);
#pragma popwarn
	
	LoadCLUT(&palette, 256);
  
	SetModeClock(RGB16|PWIDTH4);
	
	MakeBitmap8b(&bitmaps[0], ptphysic, 00, 0, FBW, FBH, 0);
	/*MakeBitmap8b(&bitmaps[1], &title, 0, 16, FBW, 94, O_TRANS);*/
  MakeBitmap(&bitmaps[1], ptTest, 0, 0, FBW, 192, 0);
  InitBitmapArray(&array, ptlist, &bitmaps[0], 2);	
  ActiveBitmapArray = &array;
  
  messages[0] = "Code & design by DrTypo";
  messages[1] = "Music by Paul Flint and Cadmium";
  messages[2] = "Press A to start";
  
  cam.x = 0;
  cam.y = 0;
  cam.z = 0;
  cam.angley = 0;
  cam.explode = 0; 
  
  objTrans.x = 0;
  objTrans.y = -2<<10;
  objTrans.z = 9<<10;
  objTrans.angley = 0;
  objTrans.explode = 0;
    
  SetVoiceVol(0, 30, 30);
  SetVoiceStep(0,256);
  SetVoice(0, (char*)(&AStrangerDeathsound)+44, (char*)(&AStrangerDeathsound)+44, (char*)(&AStrangerDeathsoundend)-2);
  voxres = DSPsync();
  
  GeneratePlankton(plkTrans, &cam);
  
	while(!fin)
	{
    unsigned char* ptrtmp;   
    short* ptsintab = &sintab; 
    int res = 0;
    int i = 0;
    TTriangle** ptrRasterTri;
    TTriangle** ptrTransformTri;
    int endtimer8KHz = 0;
    
    WaitVBL();
    
    Memset64(ptlogic, 0x3D3D3D3D, 0x3D3D3D3D, FBW*FBH);
   
    nTriAdd = 0;
    
    timer8KHz = 0;

    if(frame&0x1)
    {
      ptrRasterTri = ptrtriclipped2;
      ptrTransformTri = ptrtriclipped;
      ptTriAdd = &trisAdd;
    }
    else
    {  
      ptrRasterTri = ptrtriclipped;
      ptrTransformTri = ptrtriclipped2;
      ptTriAdd = &trisAdd2;
    }
            
    Raster(ptlogic, ptrRasterTri, nextres);
    
  /*  ptrTransformTri = ptrtriclipped;
    ptTriAdd = &trisAdd;*/
    
    if(render)
    {
      res = PlanktonMove(ptlogic, &cam, res, ptrTransformTri);
    
      objTrans.y = (-5<<9) + (ptsintab[sinstep&2047]>>4);
      sinstep+=16;
      /*objTrans.angley = (objTrans.angley+16) & 2047;*/
     
      TransformDSP(ptlogic, &PlayerShipObj, &cam, &objTrans, &ptrTransformTri[res]);    
      res += DSPsync();
    }
        
    
    
  /*  Raster(ptlogic, ptrTransformTri, res);*/
    res2 = GPUsync2();
    
    nextres = res;
    
    endtimer8KHz = timer8KHz;
    
    ReadJoypads();
    
    if( (joy1edge & (1<<FIRE_A))
      &&(joy1cur & (1<<FIRE_A)) )
    {
      fin = 1;
    }
    
    if( (joy1edge & (1<<FIRE_B))
      &&(joy1cur & (1<<FIRE_B)) )
    {
      render = (render == 1)? 0 : 1; 
    }
    
    if(joy1cur & (1<<JOY_DOWN))
    {     
      ptTest+=320;   
    }
    else if(joy1cur & (1<<JOY_UP))
    {
      ptTest-=320;    
    }
    
    if(frame>lastmessageframe+3*50)
  	{
      lastmessageframe = frame;
      messageselect++;
      if(messageselect>2) messageselect = 0;             
    }
    
    LibDrawInit(ptlogic, WID320|PIXEL8, 200);
    SelectFont(&font8x8_8f, 8, 8);
    SetBlitMode(XADDPIX);
    SetTransparency(1);
		DrawText(40,120, messages[messageselect]);
    DrawHexD(8,192,(int)ptTest,6);
    
    WaitFrame(frameTime-5);
        
   	ptrtmp = ptlogic;
    ptlogic = ptphysic;
    ptphysic = ptrtmp;
    bitmaps[0].addr = ptphysic;
    bitmaps[1].addr = ptTest;
    frame++;		
  }
  
  return 0;
}

void LevelIntro(TLevel* level)
{
static CBitmap bitmaps[NBR_BITMAPS];
static CBitmapArray array;

static char listbuff[DLSIZE(NBR_BITMAPS)+32];
  unsigned char* ptlogic,* ptphysic;  
	void * ptlist;
	int gpures = 0;
	int frame = 0;     
  int fin = 0;
  int res2 = 0;
  int nextres = 0;  
  TObjTrans objTrans;
  TObjTrans cam;  
      
  int i;
  
  srand(0);

	ptlist = ALIGN32(listbuff);

#pragma dontwarn 80	
	ptphysic = &vidmem;
	ptlogic = &vidmem+(FBW*FBH);
#pragma popwarn
	
	LoadCLUT(&palette, 256);
  
	SetModeClock(RGB16|PWIDTH4);
	
	MakeBitmap8b(&bitmaps[0], ptphysic, 00, 0, FBW, FBH, 0);
  InitBitmapArray(&array, ptlist, &bitmaps[0], 1);	
  ActiveBitmapArray = &array;

  cam.x = 0;
  cam.y = 0;
  cam.z = 0;
  cam.angley = 0;
  cam.explode = 0;
  
  objTrans.x = 0;
  objTrans.y = -2<<10;
  objTrans.z = 8<<10;
  objTrans.angley = 0;
  objTrans.explode = 0;
  
  GeneratePlankton(plkTrans, &cam);
  
  while(!fin)
	{
    unsigned char* ptrtmp;   
    short* ptsintab = &sintab; 
    int res = 0;
    int i = 0;
    TTriangle** ptrRasterTri;
    TTriangle** ptrTransformTri;
    
    WaitVBL();
    
    Memset64(ptlogic, 0x32323232, 0x32323232, FBW*FBH);
   
    nTriAdd = 0;
    
    timer8KHz = 0;

    if(frame&0x1)
    {
      ptrRasterTri = ptrtriclipped2;
      ptrTransformTri = ptrtriclipped;
      ptTriAdd = &trisAdd;
    }
    else
    {  
      ptrRasterTri = ptrtriclipped;
      ptrTransformTri = ptrtriclipped2;
      ptTriAdd = &trisAdd2;
    }
            
    Raster(ptlogic, ptrRasterTri, nextres);
    
    res = PlanktonMove(ptlogic, &cam, res, ptrTransformTri);
    
    TransformDSP(ptlogic, level->showObj, &cam, &objTrans, &ptrTransformTri[res]);    
    res += DSPsync();
        
    objTrans.angley = (objTrans.angley+16) & 2047;
     
    res2 = GPUsync2();
    
    nextres = res;
    
    ReadJoypads();
    
    if( (joy1edge & (1<<FIRE_A))
      &&(joy1cur & (1<<FIRE_A)) )
    {
      fin = 1;
    }
    
    LibDrawInit(ptlogic, WID320|PIXEL8, 200);
    SelectFont(&font8x8_8f, 8, 8);
    SetBlitMode(XADDPIX);
    SetTransparency(1);
		DrawText(40,64,"Mission objective:");
		DrawText(40,80, level->message);
    
    WaitFrame(frameTime-5);
    
   	ptrtmp = ptlogic;
    ptlogic = ptphysic;
    ptphysic = ptrtmp;
    bitmaps[0].addr = ptphysic;
    	
    frame++;		
  }
   
}

int GameLoop(TLevel* level)
{
static CBitmap bitmaps[NBR_BITMAPS];
static CBitmapArray array;

static char listbuff[DLSIZE(NBR_BITMAPS)+32];
  unsigned char* ptlogic,* ptphysic;  
	void * ptlist;
	int gpures = 0;
	int frame = 0;     
  int fin = 0;
  int gameover = 0;
  int res2 = 0;
  int nextres = 0;  
  TObjTrans objTrans[MAX_OBJECT];
  TObjTrans cam;
  TShip ship;
  TBinObj* ptobj;
  
  int i;
  
  srand(0);

	ptlist = ALIGN32(listbuff);

#pragma dontwarn 80	
	ptphysic = &vidmem;
	ptlogic = &vidmem+(FBW*FBH);
#pragma popwarn
	
	LoadCLUT(&palette, 256);
  
	SetModeClock(RGB16|PWIDTH4);
	
	MakeBitmap8b(&bitmaps[0], ptphysic, 00, 0, FBW, FBH, 0);
	/*MakeBitmap(&bitmaps[1], &TestBitmap, 160, 0, 160, 100, 0);*/
  InitBitmapArray(&array, ptlist, &bitmaps[0], 1);	
  ActiveBitmapArray = &array;

  cam.x = 0;
  cam.y = 0;
  cam.z = 0;
  cam.angley = 0;
  cam.explode = 0;  
  cam.maxY = 1024;
  cam.minY = -1024;
  cam.sqrad = 9216;
  cam.objtype = ECam;
  cam.dammage = SHIP_DAMMAGE;
  cam.shield = SHIP_SHIELD;
  
  ship.sonarenabled = 1;
  ship.sonarbeep = 0;
  ship.sonarstep = 0;
  ship.toodeep = 0;
  ship.speed = 0;
  ship.compass = 0;
  
  /* Clear obj array */
  for(i=0; i<MAX_OBJECT; i++)
  {
    objTrans[i].objtype = ENone;
    objTrans[i].objdata = NULL;
    objTrans[i].sonX = 0;
    objTrans[i].sonZ = 0;
  }
    
  GenerateMines(objTrans, level->nbmines);
  GenerateTransports(objTrans, level->nbtransports);
  GeneratePlankton(plkTrans, &cam);
  GenerateDrones(objTrans, level->nbdrones);

  while(!fin)
	{
    unsigned char* ptrtmp;   
    short* ptsintab = &sintab; 
    int res = 0;
    int colres = 0;   
    int voxres = 0; 
    int endtimer8KHz = 0;
    int i = 0;
    TTriangle** ptrRasterTri;
    TTriangle** ptrTransformTri;
    int depthcol = 50-(cam.y>>12);
    int fillcol;
    int scal = 0;
    
    WaitVBL();
    timer8KHz = 0;
    
    if(depthcol>63) depthcol=63;
    if(depthcol<50) depthcol=50;
    fillcol = depthcol | depthcol<<8 | depthcol<<16 | depthcol<<24;
    
    Memset64(ptlogic, fillcol, fillcol, FBW*FBH);
    
    nTriAdd = 0;
    
    if(frame&0x1)
    {
      ptrRasterTri = ptrtriclipped2;
      ptrTransformTri = ptrtriclipped;
      ptTriAdd = &trisAdd;
    }
    else
    {  
      ptrRasterTri = ptrtriclipped;
      ptrTransformTri = ptrtriclipped2;
      ptTriAdd = &trisAdd2;
    }
            
    Raster(ptlogic, ptrRasterTri, nextres);
   
    res = PlanktonMove(ptlogic, &cam, res, ptrTransformTri);  
    
    for(i=0; i<MAX_OBJECT; i++)
    {
      int objtype = objTrans[i].objtype; 
      if(objtype> ENone)
      {
        TObjTrans* thisObj;
        thisObj = &objTrans[i];
        TransformDSP(ptlogic, thisObj->objdata, &cam, thisObj, &ptrTransformTri[res]);    
        res += DSPsync();
        
        // Move patterns
        switch(objtype)
        {
        case EMine:
          thisObj->angley += 8;
          thisObj->angley &= 2047;
          break;
        case ETorpedo:          
          thisObj->x += thisObj->dx;
          thisObj->z += thisObj->dz;
          thisObj->step++;
          if(thisObj->step>TORPEDO_LIFE)
          {
           thisObj->objtype = ENone; 
          }
          else
          {          
            CollisionDSP(thisObj, objTrans, MAX_OBJECT, EBadTorpedo);
            colres = DSPsync();
            if(colres)
            {
              SetVoiceVol(2, 31, 31);
              SetVoiceStep(2,128);
              SetVoice(2, (char*)0, (char*)(&explodesound)+44, (char*)(&explodesoundend)-2);   
              voxres = DSPsync();
            }
          }
          break;
        case ETransport:
          TransportMove(thisObj);
          break;
        case EDrone:
          if(cam.shield>0)
          {
            objTrans[PLAYER_SHIP].x = cam.x;
            objTrans[PLAYER_SHIP].y = cam.y;
            objTrans[PLAYER_SHIP].z = cam.z;
          }
          objTrans[PLAYER_SHIP].shield = cam.shield;
          scal = DroneMove(thisObj, &objTrans[PLAYER_SHIP], &ship, objTrans);
          break;
        case EBadTorpedo:          
          thisObj->x += thisObj->dx;
          thisObj->z += thisObj->dz;
          thisObj->step++;
          if(thisObj->step>BADTORPEDO_LIFE)
          {
           thisObj->objtype = ENone; 
          }
          break;
        }
      }
    }
    
    CollisionDSP(&cam, objTrans, MAX_OBJ_CAMCOL, ETorpedo);
    colres = DSPsync();
    cam.shield = 100;
    if(colres)
    {
      if(cam.shield > 0)
      {
        SetVoiceVol(2, 31, 31);
        SetVoiceStep(2,128);
        SetVoice(2, (char*)0, (char*)(&metalsound)+44, (char*)(&metalsoundend)-2);
        voxres = DSPsync();
       }   
    }
    
    if((cam.shield<=0)&&(gameover==0))
    {
      gameover = 1;
      objTrans[PLAYER_SHIP].x = cam.x;
      objTrans[PLAYER_SHIP].y = cam.y;
      objTrans[PLAYER_SHIP].z = cam.z;
      objTrans[PLAYER_SHIP].angley = (1024-cam.angley)&2047;
      int dx = ptsintab[(cam.angley)&2047];
      int dz = ptsintab[(cam.angley+512)&2047];
      cam.x -= (dx<<4);
      cam.z -= (dz<<4);
      cam.y += 1024;
      objTrans[PLAYER_SHIP].objtype = EExplode;
      objTrans[PLAYER_SHIP].objdata = &PlayerShipObj;
      ship.sonarenabled = 0;
      SetVoice(1, (char*)0, (char*)0, (char*)0);
      voxres = DSPsync();
      SetVoiceVol(2, 31, 31);
      SetVoiceStep(2,128);
      SetVoice(2, (char*)0, (char*)(&explodesound)+44, (char*)(&explodesoundend)-2);   
      voxres = DSPsync();
    }
    
    /* Explosion */
    for(i=0; i<MAX_OBJECT; i++)
    {
      int explduration = 30;
      if(i==PLAYER_SHIP) explduration = 60;
      TObjTrans* tstExpl = &objTrans[i];
      if(tstExpl->objtype == EExplode)
      {
        tstExpl->explode++;
        if(tstExpl->explode > explduration)
        {
          tstExpl->objtype = ENone;
        }
      }
    }
 
    /*SortTriDSP(ptrTransformTri, res);
    DSPsync();*/
               
    res2 = GPUsync2();
    
    nextres = res;
    
    if(ship.sonarenabled)
    {
      if(ship.sonarbeep==0)
      {
        SetVoiceVol(0, 31, 31);
        SetVoiceStep(0,96);
        SetVoice(0, (char*)0, (char*)(&sonar2sound)+44, (char*)(&sonar2soundend)-2);
        voxres = DSPsync();
      }
      DrawSonar(ptlogic, &cam, objTrans, MAX_OBJECT, ship.sonarstep);
      GPUsync2();
      
      ship.sonarstep++;
      if(ship.sonarstep>20) ship.sonarstep=0;
      ship.sonarbeep++;
      if(ship.sonarbeep>60) ship.sonarbeep=0;
    }
           
    ReadJoypads();
    
    if(gameover==0)
    {
      if(joy1cur & (1<<FIRE_C))
      {
        if(joy1cur & (1<<JOY_LEFT))
        {     
          int dx = ptsintab[(cam.angley)&2047];
          int dz = ptsintab[(cam.angley+512)&2047];
          cam.x -= dz>>2;
          cam.z -= -dx>>2;
        }
        else if(joy1cur & (1<<JOY_RIGHT))
        {     
          int dx = ptsintab[(cam.angley)&2047];
          int dz = ptsintab[(cam.angley+512)&2047];
          cam.x += dz>>2;
          cam.z += -dx>>2;
        }
        
        if(joy1cur & (1<<JOY_UP))
        {
          cam.y += 256;              
        }
        else if(joy1cur & (1<<JOY_DOWN)) 
        {    
          cam.y -= 256;        
        }
      }
      else
      {
        if(joy1cur & (1<<JOY_LEFT))
        {     
          cam.angley -= 16;
          cam.angley &= 2047;
          int dx = ptsintab[(cam.angley)&2047];
          int dz = ptsintab[(cam.angley+512)&2047];
          cam.dx = (ship.speed*dx)>>6;
          cam.dz = (ship.speed*dz)>>6;   
        }
        else if(joy1cur & (1<<JOY_RIGHT))
        {     
          cam.angley += 16;
          cam.angley &= 2047;
          int dx = ptsintab[(cam.angley)&2047];
          int dz = ptsintab[(cam.angley+512)&2047];
          cam.dx = (ship.speed*dx)>>6;
          cam.dz = (ship.speed*dz)>>6;
        } 
         
        if(joy1cur & (1<<JOY_UP))
        {
          int dx = ptsintab[(cam.angley)&2047];
          int dz = ptsintab[(cam.angley+512)&2047];
          ship.speed++;
          if(ship.speed>SHIP_MAXSPEED) ship.speed = SHIP_MAXSPEED;
          cam.dx = (ship.speed*dx)>>6;
          cam.dz = (ship.speed*dz)>>6;      
        }
        else if(joy1cur & (1<<JOY_DOWN)) 
        {    
          int dx = ptsintab[(cam.angley)&2047];
          int dz = ptsintab[(cam.angley+512)&2047];
          ship.speed--;
          if(ship.speed<-SHIP_MAXSPEED) ship.speed = -SHIP_MAXSPEED;
          cam.dx = (ship.speed*dx)>>6;
          cam.dz = (ship.speed*dz)>>6;         
        }
      }
      
      cam.x += cam.dx;
      cam.z += cam.dz;
      ship.compass = (cam.angley*360)>>11;
         
      CheckCamBoundaries(&cam, &ship);
      
      if( (joy1edge & (1<<FIRE_B))
      &&(joy1cur & (1<<FIRE_B)) )
      {
        GenerateTorpedo(objTrans, &cam);
      }
      
      if( (joy1edge & (1<<KEY_0))
      &&(joy1cur & (1<<KEY_0)) )
      {     
      }  
      
      if( (joy1edge & (1<<KEY_1))
      &&(joy1cur & (1<<KEY_1)) )
      {
        if(ship.sonarenabled) ship.sonarenabled = 0;
        else ship.sonarenabled = 1;
      }
      
      if( (joy1edge & (1<<KEY_2))
      &&(joy1cur & (1<<KEY_2)) )
      {
      }
      
      if( (joy1edge & (1<<KEY_3))
      &&(joy1cur & (1<<KEY_3)) )
      {
      }
    }

    /*endtimer8KHz = timer8KHz;*/

    LibDrawInit(ptlogic, WID320|PIXEL8, 200);
    SelectFont(&font8x8_8f, 8, 8);
    SetBlitMode(XADDPIX);
    SetTransparency(1);
		DrawDec(8,8,scal,6);
		DrawDec(8,16,cam.shield,4);	      
    DrawDec(148,16,ship.compass,3);
    DrawDec(76,96,ship.speed,2);
    
    WaitFrame(frameTime-5);
    endtimer8KHz = timer8KHz;
    DrawDec(8,24,endtimer8KHz,6);
    	  
		ptrtmp = ptlogic;
    ptlogic = ptphysic;
    ptphysic = ptrtmp;
    bitmaps[0].addr = ptphysic;
    	
    frame++;		
	}
	
	return 0;
}

void CheckCamBoundaries(TObjTrans* cam, TShip* ship)
{  
  int voxres = 0;
static int pressure = 0;
  if(cam->x > PLAYAERA_WIDTH) cam->x = PLAYAERA_WIDTH;
  if(cam->x < -PLAYAERA_WIDTH) cam->x = -PLAYAERA_WIDTH;
  if(cam->z > PLAYAERA_WIDTH) cam->z = PLAYAERA_WIDTH;
  if(cam->z < -PLAYAERA_WIDTH) cam->z = -PLAYAERA_WIDTH;
  if(cam->y>0) cam->y = 0;
  if(cam->y<MAX_DEPTH) cam->y = MAX_DEPTH;
  if(cam->y<(PLAYAERA_DEPTH-2048))
  {
    if(ship->toodeep == 0)
    {
      ship->toodeep = 1;
      SetVoiceVol(1, 31, 31);
      SetVoiceStep(1,128);
      SetVoice(1, (char*)(&crunchsound)+44, (char*)(&crunchsound)+44, (char*)(&crunchsoundend)-2);
      voxres = DSPsync();
    }
    
    pressure++;
    if(pressure>15) 
    {
      pressure = 0;
      cam->shield--;
    } 
    if(cam->shield<0) cam->shield = 0;
  }
  else if(ship->toodeep == 1)
  {
    ship->toodeep = 0;    
    SetVoice(1, (char*)0, (char*)0, (char*)0);
    voxres = DSPsync();
  }
}

void GeneratePlankton(TObjTrans* trans, TObjTrans* cam)
{
  int i;
  for(i=0; i<MAX_PLANKTON; i++)
  {
    trans[i].x = (rand()&0xFFFF) - PLK_HDIST + cam->x;
    trans[i].z = (rand()&0xFFFF) - PLK_HDIST + cam->z;
    trans[i].y = (rand()&0x3FFF) - PLK_VDIST + cam->y;
    trans[i].angley = (1024-cam->angley) & 2047;
    trans[i].explode = 0;     
  }
}

void GenerateMines(TObjTrans* objTrans, int n)
{
  int i;
  TBinObj* ptobj;
  n--;
  if(n<=0) return;  
  if(START_MINE+n>END_MINE)
  {
    n = END_MINE-START_MINE;
  }
  for(i=START_MINE; i<=START_MINE+n; i++)
  {
    ptobj = &MineObj;
    objTrans[i].x = (rand()&PLAYAREA_MASK) - PLAYAERA_WIDTH;
    objTrans[i].y = -(rand() & PLAYAERA_DEPTH_MASK);
    objTrans[i].z = (rand()&PLAYAREA_MASK) - PLAYAERA_WIDTH;
    objTrans[i].angley = 0;
    objTrans[i].explode = 0;
    objTrans[i].maxY = ptobj->maxY;
    objTrans[i].minY = ptobj->minY;
    objTrans[i].sqrad = ptobj->sqrad+MINE_TRIGGER_SQDIST;
    objTrans[i].objtype = EMine;
    objTrans[i].objdata = ptobj;
    objTrans[i].dammage = MINE_DAMMAGE;
    objTrans[i].shield = MINE_SHIELD;
  }
}

void GenerateTorpedo(TObjTrans* objTrans, TObjTrans* cam)
{
  int i;
  int voxres = 0;
  TBinObj* ptobj;
  for(i=START_TORPEDO; i<=END_TORPEDO; i++)
  {
    if(objTrans[i].objtype == ENone)
    {
      int angley;
      ptobj = &TorpedoObj;
      objTrans[i].x = cam->x;
      objTrans[i].y = cam->y;
      objTrans[i].z = cam->z;
      objTrans[i].angley = angley = (1024-cam->angley) & 2047;
      objTrans[i].explode = 0;
      objTrans[i].maxY = ptobj->maxY;
      objTrans[i].minY = ptobj->minY;
      objTrans[i].sqrad = ptobj->sqrad;
      objTrans[i].objtype = ETorpedo;
      objTrans[i].objdata = ptobj;
      objTrans[i].dammage = TORPEDO_DAMMAGE;
      objTrans[i].shield = TORPEDO_SHIELD;
      int dx = ptsintab[(angley)&2047];
      int dz = ptsintab[(angley-512)&2047];
      objTrans[i].dx = (dx+dx+dx)>>2;
      objTrans[i].dz = (dz+dz+dz)>>2; 
      objTrans[i].step = 0;
      SetVoiceVol(2, 31, 31);
      SetVoiceStep(2,128);
      SetVoice(2, (char*)0, (char*)(&torpedosound)+44, (char*)(&torpedosoundend)-2);
      voxres = DSPsync();   
      break;
    }
  }   
}

void GenerateTransports(TObjTrans* objTrans, int n)
{
  int i;
  TBinObj* ptobj;  
  int angley;
  
  n--;
  if(n<=0) return;  
  if(START_TRANSPORT+n>END_TRANSPORT)
  {
    n = END_TRANSPORT-START_TRANSPORT;
  }
  
  ptobj = &TransportObj;
  
  for(i=START_TRANSPORT; i<=START_TRANSPORT+n; i++)
  {    
    objTrans[i].x = (rand()&PLAYAREA_MASK) - PLAYAERA_WIDTH;
    objTrans[i].y = -(rand() & PLAYAERA_HALFDEPTH_MASK);
    objTrans[i].z = (rand()&PLAYAREA_MASK) - PLAYAERA_WIDTH;
    objTrans[i].angley = angley = (256+(rand()&0x3)*512) & 2047;
    objTrans[i].explode = 0;
    objTrans[i].maxY = ptobj->maxY;
    objTrans[i].minY = ptobj->minY;
    objTrans[i].sqrad = ptobj->sqrad;
    objTrans[i].objtype = ETransport;
    objTrans[i].objdata = ptobj;
    objTrans[i].dammage = TRANSPORT_DAMMAGE;
    objTrans[i].shield = TRANSPORT_SHIELD;
    int dx = ptsintab[(angley)&2047];
    int dz = ptsintab[(angley-512)&2047];
    objTrans[i].dx = dx>>3;
    objTrans[i].dz = dz>>3; 
    objTrans[i].step = 0;    
  }
}

void GenerateDrones(TObjTrans* objTrans, int n)
{
  int i;
  TBinObj* ptobj;  
  int angley;
  
  n--;
  if(n<0) return;  
  if(START_DRONE+n>END_DRONE)
  {
    n = END_DRONE-START_DRONE;
  }
  
  ptobj = &DroneObj;
  
  for(i=START_DRONE; i<=START_DRONE+n; i++)
  {    
    objTrans[i].x = (rand()&PLAYAREA_MASK) - PLAYAERA_WIDTH;
    objTrans[i].y = -(rand() & PLAYAERA_DEPTH_MASK);
    objTrans[i].z = (rand()&PLAYAREA_MASK) - PLAYAERA_WIDTH;
    objTrans[i].angley = angley = (256+(rand()&0x3)*512) & 2047;
    objTrans[i].explode = 0;
    objTrans[i].maxY = ptobj->maxY;
    objTrans[i].minY = ptobj->minY;
    objTrans[i].sqrad = ptobj->sqrad;
    objTrans[i].objtype = EDrone;
    objTrans[i].objdata = ptobj;
    objTrans[i].dammage = DRONE_DAMMAGE;
    objTrans[i].shield = DRONE_SHIELD;
    objTrans[i].dx = 0;
    objTrans[i].dz = 0; 
    objTrans[i].step = 0;     
    objTrans[i].state = EIdle;
  }  
}

void TransportMove(TObjTrans* thisObj)
{
  int angley;
  thisObj->x += thisObj->dx;
  thisObj->z += thisObj->dz;
  if( (thisObj->x < -PLAYAERA_WIDTH)
      ||(thisObj->x > PLAYAERA_WIDTH)
      ||(thisObj->z < -PLAYAERA_WIDTH)
      ||(thisObj->z > PLAYAERA_WIDTH)
      )
  {
    thisObj->x -= thisObj->dx;
    thisObj->z -= thisObj->dz;
    thisObj->angley = angley = (thisObj->angley+512)&2047;
    int dx = ptsintab[(angley)&2047];
    int dz = ptsintab[(angley-512)&2047];
    thisObj->dx = dx>>3;
    thisObj->dz = dz>>3; 
  }
}

int PlanktonMove(void* ptlogic, TObjTrans* cam, int res, TTriangle** ptrTransformTri)
{
static  int sinstep = 0;
  int i;
  for(i=0; i<MAX_PLANKTON; i++)
  {
    plkTrans[i].y += ptsintab[sinstep&2047]>>3;
    sinstep+=2;
    plkTrans[i].angley = (1024-cam->angley)&2047;
    TransformDSP(ptlogic, (void*)&PlanctonObj, cam, &plkTrans[i],&ptrTransformTri[res]);    
    res += DSPsync();
    if(plkTrans[i].x > cam->x+PLK_HDIST)
    {
      plkTrans[i].x = cam->x-PLK_HDIST+1024;
      plkTrans[i].z = (rand()&0xFFFF) - PLK_HDIST + cam->z;
      plkTrans[i].y = (rand()&0x3FFF) - PLK_VDIST + cam->y;                         
    }
    else if(plkTrans[i].x < cam->x-PLK_HDIST)
    {
      plkTrans[i].x = cam->x+PLK_HDIST-1024;
      plkTrans[i].z = (rand()&0xFFFF) - PLK_HDIST + cam->z;
      plkTrans[i].y = (rand()&0x3FFF) - PLK_VDIST + cam->y;                
    }
    else if(plkTrans[i].z > cam->z+PLK_HDIST)
    {
      plkTrans[i].x = (rand()&0xFFFF) - PLK_HDIST + cam->x;
      plkTrans[i].z = cam->z-PLK_HDIST+1024;        
      plkTrans[i].y = (rand()&0x3FFF) - PLK_VDIST + cam->y;        
    }
    else if(plkTrans[i].z < cam->z-PLK_HDIST)
    {
      plkTrans[i].x = (rand()&0xFFFF) - PLK_HDIST + cam->x;
      plkTrans[i].z = cam->z+PLK_HDIST-1024;        
      plkTrans[i].y = (rand()&0x3FFF) - PLK_VDIST + cam->y;         
    }  
    else if(plkTrans[i].y > cam->y+PLK_VDIST)
    {
      plkTrans[i].x = (rand()&0xFFFF) - PLK_HDIST + cam->x;
      plkTrans[i].z = (rand()&0xFFFF) - PLK_HDIST + cam->z;
      plkTrans[i].y = cam->y-PLK_VDIST+1024; 
    }  
    else if(plkTrans[i].y < cam->y-PLK_VDIST)
    {
      plkTrans[i].x = (rand()&0xFFFF) - PLK_HDIST + cam->x;
      plkTrans[i].z = (rand()&0xFFFF) - PLK_HDIST + cam->z;
      plkTrans[i].y = cam->y+PLK_VDIST-1024;
    }
  }  
  return res;
}

int DroneMove(TObjTrans* thisObj, TObjTrans* player, TShip* ship, TObjTrans* objTrans)
{
  int i;
  int scal = 0;
  int range = 50<<10;
  if(ship->sonarenabled) range = 120<<10;
  switch(thisObj->state)
  {
  case EIdle:
    {
      int tx = (player->x - thisObj->x);
      int tz = (player->z - thisObj->z);
      if(tx<0) tx=-tx;
      if(tz<0) tz=-tz;
      if((tx<range)&&(tz<range)&&(player->shield>0))
      {
        thisObj->state = EAttack;
        thisObj->step = 0;        
      }
    }
    break;
  case EAttack:
    {
      int angley = thisObj->angley;
      int tx = (player->x - thisObj->x);
      int tz = (player->z - thisObj->z);
      int abstx = tx>0?tx:-tx;
      int abstz = tz>0?tz:-tz;
      if((abstx>range)||(abstz>range))
      {
        thisObj->state = EIdle;
        thisObj->step = 0;        
        return 0;
      }
      if((abstx<10<<10)&&(abstz<10<<10))
      {
        thisObj->state = EAvoid;
        thisObj->step = 0;        
        return 0;
      }
      tx>>=6;
      tz>>=6;
      int dx = ptsintab[(angley)&2047];
      int dz = ptsintab[(angley-512)&2047];
      int sx = ptsintab[(angley+512)&2047];
      int sz = ptsintab[(angley)&2047];
      scal = tx*sx+tz*sz;
      if(scal >= 0) thisObj->angley+=16;
      if(scal < 0) thisObj->angley-=16;
      thisObj->angley &= 2047;
      thisObj->x+=dx>>2;
      thisObj->z+=dz>>2;
      if(player->y>thisObj->y) thisObj->y += 128;
      if(player->y<thisObj->y) thisObj->y -= 128;
      thisObj->step++;
      if(scal<0) scal =-scal;
      int dy = thisObj->y - player->y;
      if(dy<0) dy = -dy;
      if((scal<20000)&&(abstx<30<<10)&&(abstz<30<<10)&&(dy<256)&&((thisObj->step&0xF)==0))
      {          
        for(i=START_BAD_TORPEDO; i<=START_BAD_TORPEDO+END_BAD_TORPEDO; i++)
        {
          if(objTrans[i].objtype == ENone)
          {
            objTrans[i].objtype = EBadTorpedo;
            objTrans[i].objdata = &RedTorpedoObj;
            objTrans[i].x = thisObj->x;
            objTrans[i].y = thisObj->y;
            objTrans[i].z = thisObj->z;
            objTrans[i].angley = thisObj->angley;
            objTrans[i].explode = 0;
            TBinObj* objData = &RedTorpedoObj;
            objTrans[i].maxY = objData->maxY;
            objTrans[i].minY = objData->minY;
            objTrans[i].sqrad = objData->sqrad;
            objTrans[i].step = 0;
            objTrans[i].dammage = BADTORPEDO_DAMMAGE;
            objTrans[i].shield = BADTORPEDO_SHIELD;
            int dxt = ptsintab[(angley)&2047];
            int dzt = ptsintab[(angley-512)&2047];
            objTrans[i].dx = (dxt+dxt+dxt)>>2;
            objTrans[i].dz = (dzt+dzt+dzt)>>2;            
            break;
          }
        }
      }
    }
    break;
  case EAvoid:
    {
      int angley = thisObj->angley;
      int tx = (player->x - thisObj->x)>>6;
      int tz = (player->z - thisObj->z)>>6;
      int dx = ptsintab[(angley)&2047];
      int dz = ptsintab[(angley-512)&2047];
      int sx = ptsintab[(angley+512)&2047];
      int sz = ptsintab[(angley)&2047];
      scal = tx*sx+tz*sz;
      if(scal > 0) thisObj->angley-=16;
      if(scal < 0) thisObj->angley+=16;
      thisObj->angley &= 2047;
      thisObj->x+=dx>>2;
      thisObj->z+=dz>>2;
      thisObj->step++;
      if(thisObj->step>96)
      {
        thisObj->state = EIdle;
        thisObj->step = 0;
        
      }
    }
    break;
  }
  return scal;
}
