/**********************************/
/*  L Y N X                       */ 
/*  Vince Attack                  */ 
/*  Frederic Descharmes           */
/*  Octobre 2020                  */
/**********************************/
 
#include <stdlib.h>
#include <lynx.h>
#include <lynxlib.h>
#include "LoadFileTo.h"
#include "audio\audio.h"
#include "fonte.h"
#include "fontev.h"
#include "inc\fond.pal"
#include "inc\end.pal"

/* LYNX-specific #defines: */
#define JOY_RIGHT		0x10
#define JOY_LEFT		0x20
#define JOY_DOWN		0x40
#define JOY_UP			0x80

#define BUTTON_OPTION1	0x08
#define BUTTON_OPTION2	0x04
#define BUTTON_INNER	0x02
#define BUTTON_OUTER	0x01

#define BUTTON_PAUSE	0x01

#define SCBPAL(a)   (*(uint *)((a)+19))

#define MAX_BLAGUES  5

char SCREEN[8160]       at (0xfff8-16320);
char RENDER[8160]       at (0xfff8-8160);


char fond[4500];
char ptPen[350];
char barreB[550];

extern char score[];
extern char curseur[];
extern char fedora[];
extern char spgodzil[];
extern char zsquare[];
extern char point[];
extern char vide[];

extern char s000000[];
extern char s000001[];
extern char s000002[];
extern char s000003[];
extern char s000004[];
extern char s000005[];

extern char ex000000[];
extern char ex001000[];
extern char ex002000[];
extern char ex003000[];
extern char ex004000[];
extern char ex005000[];
extern char ex006000[];
extern char ex007000[];
extern char ex008000[];
extern char ex009000[];
char *explosion[11]={0,ex009000,ex008000,ex007000,ex006000,ex005000,ex004000,ex003000,ex002000,ex001000,ex000000};

char rr[10][150];
char ll[10][150];

extern char SCBf[];
#asm         
_SCBf     dc.b $c0,$10,$20
          dc.w 0,0
          dc.w 0,0,$100,$103
          dc.b $01,$23,$45,$67,$89,$Ab,$cd,$ef
#endasm
extern char SCB1[];
#asm         
_SCB1     dc.b $c7,$10,$20
          dc.w 0,0
          dc.w 0,0,$100,$100
          dc.b $01,$23,$45,$67,$89,$AB,$CD,$eF
#endasm
extern char SCBt[];
#asm         
_SCBt     dc.b $c7,$10,$20
          dc.w 0,0
          dc.w 0,0,$100,$103
          dc.b $01,$23,$45,$67,$89,$AB,$CD,$eF
#endasm
extern char SCBtf[];
#asm         
_SCBtf    dc.b $c7,$10,$20
          dc.w 0,0
          dc.w 0,0,$100,$103
          dc.b $11,$23,$45,$67,$89,$AB,$CD,$eF
#endasm

extern char SCBpile0[];
extern char SCBpile1[];
extern char SCBpile2[];
#asm         
_SCBpile0 dc.b $c7,$10,$20
          dc.w _SCBpile1,0
          dc.w 50,85,$100,$100
          dc.b $01,$23,$45,$67,$89,$AB,$CD,$eF
_SCBpile1 dc.b $c7,$10,$20
          dc.w _SCBpile2,0
          dc.w 70,85,$100,$100
          dc.b $01,$23,$45,$67,$89,$AB,$CD,$eF
_SCBpile2 dc.b $c7,$10,$20
          dc.w 0,0
          dc.w 90,85,$100,$100
          dc.b $01,$23,$45,$67,$89,$AB,$CD,$eF
#endasm

// SCB est un tableau de 5 sprites de 11 octets chacun
char SCB[5][11];
extern char spr0[11];
extern char SCBligne[1];

#asm
_SCBligne:
          dc.b $c1, $10, $20
          dc.w _SCB          ; PTR_NEXT pointe vers le 1 sprite visible (SCB[0])
          dc.w _vide         ; PTR_DATA pointe vers un sprite "inexistant"
          dc.w 200, 200      ; x,y -> on affiche en dehors de l écran
          dc.w $100, $100    ; pas de zoom
          dc.b $01, $23, $45, $67, $89, $ab, $cd, $ef

_spr0:    dc.b $c7, $08, $00 
          dc.w 0, _vide
          dc.w 200, 0
#endasm


unsigned char niveau[10][5];
unsigned char grille[10][5];
unsigned char SFX[10][5];
unsigned char BKPniveau[10][5];

char ligne[5];
int choix, chrono, BKPchrono, fin, test;
int decalage, BKPdecalage;
char vitesseChrono,BKPvitesseChrono;
int scoreJeu,oldscore,BKPscore;
int i,j,k,x,y,BKPx,BKPy;
int r;
int jauge[7],BKPjauge[7];
int KK, BKPKK, squalyl, godzil, godzilI, godzilJ;
char premierKK, bruni, chuteBruni, tempBruni[7],chutePenpen, folco,succes,zerosquare;
char effet, inner;
char pile[3],BKPpile[3];
char tileset, BKPtileset;
char flagChute;

char couleur[7] = {1,11,5,7,13,15,3};
char txtFedora[250] = 
"Installation de Fedora 40.2812 en cours.^Desarmement du 65C02.....^Configuration du noyau......^Reeducation de Suzy et Mickey...........^Interconnexion des bus et des trams...^Rebootez la console pour redemarrer.&";
char txtBlague[600]; 

extern void LoadFileTo();

// assembler vertical retrace syncronisation routine
void Vsync() 
{
#asm
vretrace:
	lda $fd0a
	bne vretrace
#endasm
}

void AfficheSCB(ix, iy, iCTL0, idata, iSCB)
int ix, iy,iCTL0
char *idata
char *iSCB
{
   SCBX(iSCB) = ix;
   SCBY(iSCB) = iy;
   SCBCTL0(iSCB) = iCTL0;
   SCBDATA(iSCB) = idata;
   DrawSprite(iSCB);
}

void Aff5ch(c, x, y, col)
int c;
unsigned char x, y, col;
{
        AffCarV(c/10000+16,x,y,col);
        AffCarV((c%10000)/1000+16,x,y+4,col);
        AffCarV((c%1000)/100+16,x,y+8,col);
        AffCarV((c%100)/10+16,x,y+12,col);
        AffCarV((c%10)+16,x,y+16,col);      
}


void AffCar(c,xx,yy,col)
int xx,yy,c;
char col;
{
   SCBPAL(SCBtf)=col;
   AfficheSCB(xx,yy,192,f[c],SCBtf);
}

void AffCarV(c,xx,yy,col)
int xx,yy,c;
char col;
{
   SCBPAL(SCBt)=col;
   AfficheSCB(xx,yy,199,v[c],SCBt);
}

int AffPave(max)
int max;
{
   int a,xt,yt;

   xt=0;
   yt=0;
   i=0;

   while ((txtFedora[i] != '&') && (i < max))
   {
      if (txtFedora[i] == '^')
      {
            xt=0;
            yt+=8;
      }
      else if (txtFedora[i] > 31)
      {
         a = txtFedora[i] - ' ';
         AffCar(a,xt,yt,9);
         xt+=4;
      }
      i++;
   }
   if (txtFedora[i] == '&')
      return 10000;
   else
      return max+1;
}

void AffBlague()
{
   int a,xt,yt;

   xt=153;
   yt=1;
   a = random()%MAX_BLAGUES;

   for (i=0;i<600;i++)
      txtBlague[i] = 0;
   LoadFileTo(72+a,txtBlague);
   i=0;

   while (txtBlague[i] != 0)
   {
      if (txtBlague[i] == 13)
      {
            yt=1;
            xt-=7;
      }
      else if (txtBlague[i] > 31)
      {
         a = txtBlague[i] - ' ';
         AffCarV(a,xt,yt,9);
         yt+=4;
      }
      i++;
   }
}
/*********************/
/* wait for a button */
/*********************/
void WaitButton()
{
   while (joystick);
   while (joystick != BUTTON_OUTER)
	   Audio_Play();
   while (joystick);
}


void loadLevel()
{

   SCBNEXT(SCBligne) = &SCB[0][0];
   for (i = 0; i < 5; i++)
   {
      bcopy(&spr0[0], &SCB[i][0], 11);  // src, dest, count
      SCBY(&SCB[i][0]) = 1+(i<<4);
      SCBNEXT(&SCB[i][0]) = &SCB[i+1][0];
   }
   SCBNEXT(&SCB[4][0]) = 0;

   x = 0;
   y = 9;
   for (i=0;i<10;i++)
      for (j=0;j<5;j++)
      {
         niveau[i][j] = 0;
         SFX[i][j] = 0;
         ligne[j] = (random())%6+1;
      }   
   for (k=0;k<7-choix*2;k++)
      nouvelleLigne();
}

void nouvelleLigne()
{
   for (j=0;j<5;j++)
      if (niveau[0][j] > 0)
         fin = 0;

   for (i=0;i<9;i++)
      for (j=0;j<5;j++)
      {
         niveau[i][j] = niveau[i+1][j];
      }   
   for (j=0;j<5;j++)
   {
      niveau[9][j] = ligne[j];
      ligne[j] = (random())%6+1;
   }   
      
   chrono = 160;
   decalage = 0;
}

void chuteGrille()
{
   char e;
   flagChute=0;
   for (i=8;i>=0;i--)
   {
      for (j=0;j<5;j++)
      {
         e = niveau[i][j]%100;
         if ((e > 0) && (e < 7))
         {
            if (niveau[i+1][j] == 0)
            {
               niveau[i+1][j] = 100+e;
               niveau[i][j] = 0;
               flagChute=1;
            }
            else
            {
               niveau[i][j] = e;
            }       
         }
         else if (e == 7)
         {
            if ((niveau[i+1][j] == 0) && (niveau[i+1][j+1] == 0))
            {
               niveau[i+1][j]   =  7;
               niveau[i+1][j+1] = niveau[i][j+1] + 10*chutePenpen;
               niveau[i][j]     = niveau[i-1][j] + 10*chutePenpen;
               niveau[i][j+1]   = niveau[i-1][j+1] + 10*chutePenpen;
               niveau[i-1][j]   =  0;
               niveau[i-1][j+1] =  0;
               flagChute=1;
            }
            else
            {
               chutePenpen = 1;
               if (niveau[i][j+1] > 30)
               {
                  niveau[i-1][j]   = 1+(random()%6);
                  niveau[i-1][j+1] = 1+(random()%6);
                  niveau[i][j]     = 1+(random()%6);
                  niveau[i][j+1]   = 1+(random()%6);                  
                  SFX[i-1][j]   = 10;
                  SFX[i-1][j+1] = 10;
                  SFX[i][j]     = 10;
                  SFX[i][j+1]   = 10;                  
                  flagChute=1;
               }
            }            
         }
         else if (e == 8)
         {
            for (k=0;k<5;k++)
            {
               if (niveau[i+1][k] != 0)
                  k = 10;
            }
            if (k < 10)
            {
               for (k=0;k<5;k++)
               {
                  niveau[i+1][k] = niveau[i][k];
                  if ((k > 1) && (chuteBruni == 1))
                     niveau[i+1][k] += 10;              
                  niveau[i][k] = 0;
                  flagChute=1;
               }
            }
            else
            {
               chuteBruni = 1;
               if (niveau[i][2] > 30)
               {
                  for (k=0;k<5;k++)
                  {
                     SFX[i][k] = 8;
                     niveau[i][k] = 1+(random()%6);
                     flagChute=1;
                  }
               }
            }            
         }
      }  
   } 
   for (j=0;j<5;j++)
   {
      e = niveau[9][j]%100;
      if ((e > 0) && (e < 7))
         niveau[9][j] = e;     
   }
}

void addPile(v)
char v;
{
   if (choix != 3)      // pas d'effets en mode Easy
   {
      if (pile[0] == 0)
      {
         pile[0]=v;
         SCBDATA(SCBpile0) = rr[v-1];
      }
      else if (pile[1] == 0)
      {
         pile[1]=v;
         SCBDATA(SCBpile1) = rr[v-1];
      }
      else if (pile[2] == 0)
      {
         pile[2]=v;
         SCBDATA(SCBpile2) = rr[v-1];
      }
      else 
      {
         pile[0] = pile [1];
         pile[1] = pile [2];
         pile[2] = v;
         SCBDATA(SCBpile0) = rr[pile[0]-1];
         SCBDATA(SCBpile1) = rr[pile[1]-1];
         SCBDATA(SCBpile2) = rr[v-1];
      }
   }
}

void testGrille()
{
   bcopy(&niveau[0][0], &grille[0][0], 50);

   oldscore = scoreJeu;

   for (i=0;i<10;i++)
   {
      for (j=0;j<5;j++)
      {
         r = grille[i][j];
         if ((j<3) && (r > 0) && (r < 7))
         {
            if ((r == grille[i][j+1]) && (r == grille[i][j+2]))
            {
               scoreJeu+=5*r;
               jauge[r]++;
               niveau[i][j]   = 0;
               niveau[i][j+1] = 0;
               niveau[i][j+2] = 0;
               SFX[i][j]   =  8;
               SFX[i][j+1] =  8;
               SFX[i][j+2] =  8;
               if ((r==1) && (KK == 20000))
                  addPile(9);
               if ((r==6) && (folco == 2))
                  addPile(9);
               if (choix == 1)
               {
                  if (scoreJeu > 100)
                  {
                     if (scoreJeu%100 == 0)
                        addPile(7);
                     if ((scoreJeu < 1000) && (scoreJeu%111 == 0))
                        addPile(7);
                     else if ((scoreJeu < 10000) && (scoreJeu%1111 == 0))
                        addPile(7);
                  }
               }
            }
         }
         if ((i<8) && (r > 0) && (r < 7))
         {
            if ((r == grille[i+1][j]) && (r == grille[i+2][j]))
            {
               scoreJeu+=3*r;
               jauge[r]++;
               niveau[i][j]   = 0;
               niveau[i+1][j] = 0;
               niveau[i+2][j] = 0;
               SFX[i][j]   =  8;
               SFX[i+1][j] =  8;
               SFX[i+2][j] =  8;
               if ((r==1) && (KK == 20000))
                  addPile(9);
               if ((r==6) && (folco == 2))
                  addPile(9);
               if (choix == 1)
               {
                  if (scoreJeu > 100)
                  {
                     if (scoreJeu%100 == 0)
                        addPile(7);
                     if ((scoreJeu < 1000) && (scoreJeu%111 == 0))
                        addPile(7);
                     else if ((scoreJeu < 10000) && (scoreJeu%1111 == 0))
                        addPile(7);
                  }
               }
            }
         }
      } 
   }

   if (choix == 2)
   {
      if ((scoreJeu/100) > (oldscore/100))
         addPile(7);
   }

}


void loadTileSet(numero)
char numero;
{
   tileset = numero;
   if ((numero == 0) && (zerosquare == 1))
      LoadFileTo(6,fond);
   else
      LoadFileTo(3+numero,fond);
   for (i=0;i<9;i++)
   {
      LoadFileTo(12+18*(numero)+i,rr[i]);
      LoadFileTo(21+18*(numero)+i,ll[i]);
   }
   LoadFileTo(66+numero,ptPen);
   LoadFileTo(69+numero,barreB);
}

char attack()
{
   loadTileSet(0);
   fin = 1;
   SCBX(SCBf) = 0;
   SCBY(SCBf) = 0;
   SCBDATA(SCBf) = fond;
   decalage = 0;
   KK = 0;
      // = 0        => valeur initiale
      // < 10000    => installation Fedora en cours
      // = 20000    => mode Fedora en cours
      // = 15000    => mode normal
   premierKK = 0;
   squalyl = 0;
   godzil = 0;
   godzilJ = 0;
   folco = 0;
   bruni = 0;
   chuteBruni = 0;
   chutePenpen = 0;
   vitesseChrono=2;
   zerosquare = 0;

   SCBDATA(SCBpile0) = vide;
   SCBDATA(SCBpile1) = vide;
   SCBDATA(SCBpile2) = vide;
   for (i=0;i<3;i++)
      pile[i]=0;


   for (i=0;i<7;i++)
   {
      jauge[i]=0;
      tempBruni[i]=0;
   }

   while (fin > 0)
   {
      if (KK == 10000)           // Reboot pour switch en Fedora mode
      {
         if ((joystick & BUTTON_OPTION1) && (switches & BUTTON_PAUSE))
         {
            while (switches & BUTTON_PAUSE);
            KK = 20000;
            loadTileSet(1);
          }
      }
      else if (effet == 5)       // Blague de Vince
      {
         effet = 0;
         DrawFBox(0,0,160,102,1);
         AffBlague();
         Vsync();
         SwapBuffers();
         WaitButton();
      }
      else
      {
         DrawSprite(SCBf);
         if (decalage == 0)
         {
            if (pile[0] > 0)
            {
               succes = 0;
               switch (pile[0])
               {
                  case 1:           
                     if (choix == 1)      // Fedora Mode
                     {
                        if (premierKK == 0)
                        {
                           KK = 1;
                           premierKK = 1;
                        }
                        else
                           KK=10000;
                     }
                     else                 // fait apparaitre une ligne de blocs en haut
                     {
                        for (j=0;j<5;j++)
                        {
                           if (niveau[0][j] == 0)
                              niveau[0][j] = (random())%6+1;     
                        }
                     }
                     
                     succes = 1;
                     break;
                  case 2:                 // Squalyl : copie ligne du bas sur future ligne
                     squalyl = 80;
                     succes = 1;
                     break;
                  case 3:                 // Godzil mode
                     succes = 1;
                     godzil=240;
                     godzilJ=1+(random()%4);
                     break;
                  case 4:                 // Zeph mode : 2 blocs chutent sur 1 bloc identique
                     for (i=0;i<5;i++)
                     {
                        k = (random())%5;
                        if ((niveau[0][k] == 0) && (niveau[1][k] == 0))
                        {
                           for (j=2;j<10;j++)
                           {
                              if (niveau[j][k] > 0)
                              {
                                 if (niveau[j][k] < 7)
                                    j = 15;
                                 else
                                    j = 20;
                              }
                           }
                           if ((j > 10) && (j < 20))
                              i = 10;
                        }
                     }
                     if (i > 10)
                     {
                        for (j=2;j<10;j++)
                        {
                           if (niveau[j][k] > 0)
                           {
                              niveau[0][k]=niveau[j][k];
                              niveau[1][k]=niveau[j][k];
                              j = 10;
                           }
                        }
                     }
                     succes = 1;
                     break;
                  case 5:           
                     if (choix == 1)      // yn Vince mode : affiche une blague
                        effet = 5;
                     else                 // détruit tous les blocs d'un même type
                     {
                        k = (random())%6+1;
                        for (i=0;i<10;i++)
                        {
                           for (j=0;j<5;j++)
                           {
                              if ((niveau[i][j])%10 == k)
                              {
                                 niveau[i][j] = 0;
                                 SFX[i][j]   = 8;
                              }
                           }
                        }
                     }
                     succes = 1;
                     break;
                  case 6:                 // Folco mode : passage en mode affichage niveaux de gris
                     folco = 2;
                     loadTileSet(2);
                     succes = 1;
                     break;
                  case 7:                 // Penpen mode : affichage 'un bloc 2x2
                     k=random()%4;
                     chutePenpen = 0;
                     if ((niveau[0][k] == 0) && (niveau[0][k+1] == 0) && (niveau[1][k] == 0) && (niveau[1][k+1] == 0))
                     {
                        niveau[1][k]   =  7;
                        niveau[1][k+1] = 17;
                        niveau[0][k]   = 17;
                        niveau[0][k+1] = 17;
                        succes = 1;
                     }
                     break;
                  case 8:                 // Brunni mode : barre Brunni
                     for (j=0;j<5;j++)
                        if (niveau[0][j] > 0)
                           j=10;
                     
                     if (j<10)                           
                     {
                        if (vitesseChrono < 10)
                           vitesseChrono++;
//                           vitesseChrono = vitesseChrono<<1;
                        niveau[0][0] = 8;
                        for (j=1;j<5;j++)
                           niveau[0][j] = 18;
                        succes = 1;
                     }
                     break;
                  case 9:                 // Normal mode : retour à la normale
                     folco = 0;
                     KK=15000;
                     loadTileSet(0);
                     succes = 1;
                     break;
               }
               if (succes == 1)
               {
                  flagChute = 1;
                  pile[0] = pile [1];
                  pile[1] = pile [2];
                  pile[2] = 0;
                  if (pile[0] > 0)
                     SCBDATA(SCBpile0) = rr[pile[0]-1];
                  else
                     SCBDATA(SCBpile0) = vide;
                  if (pile[1] > 0)
                     SCBDATA(SCBpile1) = rr[pile[1]-1];
                  else
                     SCBDATA(SCBpile1) = vide;
                  SCBDATA(SCBpile2) = vide;
               }
            }      
         }
         else
         {
            DrawSprite(SCBpile0);
         }    

         for (i=0;i<10;i++)
         {
            k = 144-(i<<4) + decalage;
            for (j=0;j<5;j++)
            {
               r = niveau[i][j]%100;
               SCBX(&SCB[j][0]) = k;
               if ((r > 0) && (r < 10))
               {
                  switch (r)
                  {
                     case 7 :
                        SCBDATA(&SCB[j][0]) = ptPen;
                        break;
                     case 8 :
                        SCBDATA(&SCB[j][0]) = barreB;
                        break;
                     default :                           
                        SCBDATA(&SCB[j][0]) = rr[r-1];
                  }
               }
               else
               {
                  SCBDATA(&SCB[j][0]) = vide;
               }
               
               r = SFX[i][j];
               SCBX(SCB1) = k;
               if (r > 0)
               {
                  SFX[i][j]--;
                  if (KK != 20000) 
                  {
                     SCBY(SCB1) = 1+(j<<4);
                     SCBDATA(SCB1) = explosion[r];
                     DrawSprite(SCB1);
                  }
               }
            }
            DrawSprite(SCBligne);            
         }

         SCBX(SCB1) = 144-(y<<4) + decalage;
         SCBY(SCB1) = 1+(x<<4);
         SCBDATA(SCB1) = curseur;
         DrawSprite(SCB1);

         k=decalage-16;
         for (j=0;j<5;j++)
         {
            r = ligne[j]-1;
            SCBX(&SCB[j][0]) = k;
            SCBDATA(&SCB[j][0]) = ll[r];
            if (squalyl == 72-(j<<4))
            {
               if (niveau[9][j] > 0)
                  ligne[j] = niveau[9][j];
               if (j == 4)
                  squalyl = 0;
            }
         }
         DrawSprite(SCBligne);            

         if (choix != 3)
         {
            for (i=1;i<7;i++)
            {
               DrawFBox(1,81+3*i,jauge[i]<<2,2,couleur[i]);
               if (tempBruni[i] == 1)
                  DrawFBox(25,81+3*i,2,2,couleur[i]);
            }

            if ((KK > 0) & (KK < 10000))
               KK=AffPave(KK);
            
            if ((squalyl > 0) && (squalyl < 100))
            {
                  SCBY(SCB1) = (80-squalyl);
                  SCBX(SCB1) =  0;
                  SCBDATA(SCB1) = s000004;
                  DrawSprite(SCB1);
                  squalyl-=4;
            }
            if (godzil > 0)
            {
                  SCBX(SCB1) =  godzil;
                  SCBY(SCB1) = godzilJ<<4;
                  SCBDATA(SCB1) = spgodzil;
                  godzil-=4;
                  if ((godzil<160) && ((godzil%16)==0))
                  {
                     godzilI = 10 - (godzil>>4);
                     k = niveau[godzilI][godzilJ];
                     if ((k<10) && (niveau[godzilI][godzilJ-1] < 10))
                     {
                        niveau[godzilI][godzilJ] = niveau[godzilI][godzilJ-1];
                        niveau[godzilI][godzilJ-1] = k;
                     }
                  }
                  DrawSprite(SCB1);
            }
         }
                              
         if (flagChute == 1)
         {
            chuteGrille();
         }
         if (decalage%8 == 1)
         {
            testGrille();
            flagChute = 1;
         }
                     
         chrono-=vitesseChrono;
         decalage = (160-chrono)/10;      
         if (chrono <= 0)
         {
            nouvelleLigne();
            if (y > 0)
               y--;
            if (fin == 0)
            {
               if (zerosquare == 1)
               {
                  fin = 1;    // sauve la partie 1 fois
                  SCBX(SCB1)=80;
                  SCBY(SCB1)=51;
                  SCBDATA(SCB1)=zsquare;
                  k=1;
                  for (i=256;i<4096;i+=k)
                  {
                     SCBHS(SCB1) = i;
                     SCBVS(SCB1) = i;
                     DrawSprite(SCB1);
                     Vsync();
                     SwapBuffers();
                     Audio_Play();
                     if (k<32)
                        k++;
                  }
                  SCBHS(SCB1) = 256;
                  SCBVS(SCB1) = 256;

                  flagChute = 1;
                  zerosquare = 2;
                  loadTileSet(BKPtileset);
                  decalage = BKPdecalage;
                  vitesseChrono = BKPvitesseChrono;
                  chrono = BKPchrono;
                  scoreJeu = BKPscore;
                  KK = BKPKK;
                  x=BKPx;
                  y=BKPy;
                  bcopy(&BKPjauge[0],&jauge[0],7);
                  bcopy(&BKPniveau[0][0], &niveau[0][0], 50);
                  bcopy(&BKPpile[0],&pile[0],3);
                  if (pile[0] > 0)
                     SCBDATA(SCBpile0) = rr[pile[0]-1];
                  else
                     SCBDATA(SCBpile0) = vide;
                  if (pile[1] > 0)
                     SCBDATA(SCBpile1) = rr[pile[1]-1];
                  else
                     SCBDATA(SCBpile1) = vide;
                  if (pile[2] > 0)
                     SCBDATA(SCBpile2) = rr[pile[2]-1];
                  else
                     SCBDATA(SCBpile2) = vide;
               }
               else
               {
                  SCBY(SCB1) = 68;
                  SCBX(SCB1) = 137;
                  SCBDATA(SCB1) = score;
                  for (inner=16;inner>=0;inner--)
                  {
                     DrawSprite(SCBf);
                     for (i=9;i>=0;i--)
                     {
                        k = (9-i)*inner-(16-inner);
                        for (j=0;j<5;j++)
                        {
                           r = niveau[i][j]%100;
                           SCBX(&SCB[j][0]) = k;
                           if ((r > 0) && (r < 10))
                           {
                              switch (r)
                              {
                                 case 7 :
                                    SCBDATA(&SCB[j][0]) = ptPen;
                                    break;
                                 case 8 :
                                    SCBDATA(&SCB[j][0]) = barreB;
                                    break;
                                 default :                           
                                    SCBDATA(&SCB[j][0]) = rr[r-1];
                              }
                           }
                           else
                           {
                              SCBDATA(&SCB[j][0]) = vide;
                           }
                        }
                        DrawSprite(SCBligne);            
                     }
                     DrawSprite(SCB1);
                     Aff5ch(scoreJeu,141,76,9);
                     Vsync();
                     SwapBuffers();
                     Audio_Play();
                  }
               }
            }
         }

         bruni = 0;
         for (i=1;i<7;i++)
         {
            bruni += tempBruni[i];
            if (jauge[i] >= 5)
            {
               addPile(i);
               tempBruni[i] = 1;
               jauge[i] = 0;
            }
         }
         if (bruni == 6)
         {
            addPile(8);
            chuteBruni = 0;
            for (j=1;j<7;j++)
               tempBruni[j] = 0;
         }

         
         if ((joystick & JOY_DOWN) && (x<3))
            x++;
         if ((joystick & JOY_UP) && (x>0))
            x--;
         if ((joystick & JOY_LEFT) && (y<9))
            y++;
         if ((joystick & JOY_RIGHT) && (y>0))
            y--;

         if ((joystick & BUTTON_OUTER))
         {
            chrono -= 10;
            decalage = (160-chrono)/10;
            if (decalage<0)
               decalage=0;
         }
            
         if ((joystick & BUTTON_INNER) && (inner == 0))
         {
            r = niveau[y][x];
            if ((r<7) && (niveau[y][x+1]<7))
            {
               niveau[y][x] = niveau[y][x+1];
               niveau[y][x+1] = r;
               flagChute = 1;
            }
            inner = 1;
         }
         if (!(joystick & BUTTON_INNER) && (inner == 1))
            inner = 0;

         if ((joystick & BUTTON_OPTION1) && (zerosquare == 0))
         {
            zerosquare = 1;
            if (tileset == 0)
               LoadFileTo(6,fond);
            BKPdecalage = decalage;
            BKPvitesseChrono = vitesseChrono;
            BKPchrono = chrono;
            BKPscore = scoreJeu;
            BKPKK = KK;
            BKPx=x;
            BKPy=y;
            BKPtileset = tileset;
            bcopy(&jauge[0],&BKPjauge[0],7);
            bcopy(&niveau[0][0], &BKPniveau[0][0], 50);
            bcopy(&pile[0],&BKPpile[0],3);
         }
         
         if (switches & BUTTON_PAUSE)
         {
            while (switches & BUTTON_PAUSE);
            LoadFileTo(9,fond);
            DrawSprite(SCBf);
            Vsync();
            SwapBuffers();
            while (!joystick)
               Audio_Play;
            loadTileSet(tileset);
         }

         SCBY(SCB1) = 68;
         SCBX(SCB1) = 137;
         SCBDATA(SCB1) = score;
         DrawSprite(SCB1);
         Aff5ch(scoreJeu,141,76,9);

         if (KK == 10000)
         {
            SCBX(SCB1) = 100;
            SCBY(SCB1) = 8;
            SCBDATA(SCB1) = fedora;
            DrawSprite(SCB1);
         }
         Vsync();
         SwapBuffers();
		   Audio_Play();
      }
   }

   WaitButton();
   LoadFileTo(11,fond);
   DrawSprite(SCBf);
   Aff5ch(scoreJeu,10,50,9);
   Vsync();
   SetRGB(pal_end);
   SwapBuffers();
   WaitButton();
}


void credits()
{
   fin=0;
   LoadFileTo(10,fond);
   while (fin == 0)
   {
      DrawSprite(SCBf);

      Vsync();
      SwapBuffers();

      while(!joystick)
         r=random();               

      if (joystick & BUTTON_INNER)
         fin=1;
      if (joystick & BUTTON_OUTER)
         fin=1;
      while(joystick);
   }
}

void Menu()
{
   fin=0;
   LoadFileTo(2,fond);
   SCBX(SCBf) = 0;
   SCBY(SCBf) = 0;
   SCBDATA(SCBf) = fond;
   SetRGB(pal);
   while (fin == 0)
   {
      DrawSprite(SCBf);

      AfficheSCB(21+22*choix,1,199,point,SCB1);

      Vsync();
      SwapBuffers();

      while(!joystick)
         r=random();               
      if (joystick & JOY_RIGHT)
         choix = (choix+1)%4;
      if (joystick & JOY_LEFT)
         choix = (choix+3)%4;

      if (joystick & BUTTON_INNER)
         fin=1;
      if (joystick & BUTTON_OUTER)
         fin=1;
      while(joystick);
   }
}

/**************************************************************************
**                                                                       **
**                                                                       **
**************************************************************************/
main() 
{
   InitIRQ();
   Audio_Init();
   CLI;

   SetBuffers(SCREEN, RENDER,0);

   choix = 1;
   for (;;)
   {
      Menu();
      if (choix == 0)
         credits();
      else
      {
         scoreJeu = 0;
         loadLevel();
         attack();
      }
   }
}
