/*
    Megadrive/Genesis - SGDK 094 - 03/06/2013
    Source Principal

    OPTIMISATION : il faut rgler la vitesse des boulettes, voir ligne 420 --> static void enemybullet(u16 xen,u16 yen, u16 xplay,u16 yplay, u16 nb)

    problem :
    Plus la cible est proche du canon, et plus la vitesse du tir ennemi est lente
    Plus la cible est loigne du canon, et plus la vitesse du tir ennemi est rapide

    objectif :
    Je souhaite une vitesse constante des tirs ennemis.

    recommandation de stef :

    Il faut normaliser ton vecteur de mouvement de tir.

    fix16 div;
    u16 factor

    factor = 2;
    if (xmov > ymov) div = ymov >> factor;
    else div = xmov >> factor;

    ymov = fix16Div(ymov, div);
    xmov = fix16Div(xmov, div);

    cela devrait te donner une vitesse constante. Si tu veux modifier cette vitesse, il te suffit de modifier la valeur de factor (entre 1 et 8)

    ligne 700 je ralentis les tirs ennemis (systeme D) c'est provisoire si le problme est rsolus

*/

#include <genesis.h>

//chiffre0:
const u32 spchiffre0[8]=
{
	0x00111100,	// Tile #16
	0x01888810,
	0x18811881,
	0x18811881,
	0x18811881,
	0x18811881,
	0x01888810,
	0x00111100
};

//chiffre1:
const u32 spchiffre1[8]=
{
	0x00111000,	// Tile #17
	0x01888100,
	0x00188100,
	0x00188100,
	0x00188100,
	0x00188100,
	0x00188100,
	0x00011000
};

//chiffre2:
const u32 spchiffre2[8]=
{
	0x01111100,	// Tile #18
	0x18888810,
	0x01111881,
	0x01888881,
	0x18888110,
	0x18811110,
	0x18888881,
	0x01111110
};

//chiffre3:
const u32 spchiffre3[8]=
{
	0x01111100,	// Tile #19
	0x18888810,
	0x01111881,
	0x01888810,
	0x01111881,
	0x01111881,
	0x18888810,
	0x01111100
};

//chiffre4:
const u32 spchiffre4[8]=
{
	0x01111100,	// Tile #20
	0x11888810,
	0x18818810,
	0x18818810,
	0x18818810,
	0x18888881,
	0x01118810,
	0x00001100
};

//chiffre5:
const u32 spchiffre5[8]=
{
	0x01111100,	// Tile #21
	0x18888810,
	0x18811100,
	0x18888810,
	0x01118810,
	0x01118810,
	0x18888100,
	0x01111000
};

//chiffre6:
const u32 spchiffre6[8]=
{
	0x00111110,	// Tile #22
	0x01888881,
	0x18811110,
	0x18888811,
	0x18811881,
	0x18811881,
	0x01888811,
	0x00111110
};

//chiffre7:
const u32 spchiffre7[8]=
{
	0x01111110,	// Tile #23
	0x18888881,
	0x01111881,
	0x00018810,
	0x00018810,
	0x00188100,
	0x00188100,
	0x00011000
};

//chiffre8:
const u32 spchiffre8[8]=
{
	0x00111100,	// Tile #24
	0x01888810,
	0x18811881,
	0x01888810,
	0x18811881,
	0x18811881,
	0x01888810,
	0x00111100
};

//chiffre9:
const u32 spchiffre9[8]=
{
	0x01111100,	// Tile #25
	0x11888810,
	0x18811881,
	0x18811881,
	0x11888881,
	0x01111881,
	0x18888810,
	0x01111100
};

// 3 sprites, format bmp, mis dans le dossier data :
struct genresSprites
{
		u16 *pal; 		//pointer to pal data
		u32 **sprites;		//pointer to sprites data
		u16 count;		//nb sprites
		u16 width;		//width of each sprite in pixels
		u16 height;		//height of each sprite in pixels
		u16 size; 		//since we use width/height in pixel, useful info on sprite size
						//TODO : size is not SGDK compliant, you need to use size>>8
						//		will be fixed in coming release
};
extern struct genresSprites spcanon;
extern struct genresSprites spbille;
extern struct genresSprites spcible;

// position sprites en Vram:
#define chif0   21  // 8x8 pixels soit 1 tile.
#define chif1   22
#define chif2   23
#define chif3   24
#define chif4   25
#define chif5   26
#define chif6   27
#define chif7   28
#define chif8   29
#define chif9   30

#define vrcible    31 // 16x16 pixels soit 2x2 tiles = 4 tiles
#define vrbille    35 // 8x8 pixels soit 1 tile.
#define vrcanon    36 // 8x8 pixels soit 1 tile.

#define MAXBULLET 8 // 8 boulettes ennemis orientable vers le player
typedef struct
{
    s16 posx;
    s16 posy;
    s16 movx;
    s16 movy;
    u16 flags;
    u16 hori;
    u16 vert;
    u16 dx,dy;
    u16 err;
    u16 tpv;
    u16 tph;
    u16 tpvm;
    u16 tphm;
    u16 cpta;
} bullet_;

bullet_ bullets[MAXBULLET];


int main( )
{


// *******************************************************************************************************************************************
// sprites:

    VDP_setPalette(PAL2, spbille.pal); // get the palette

	SpriteDef mySprite1;
	SpriteDef mySprite2;
	SpriteDef mySprite3;

	SpriteDef mySprite4;
	SpriteDef mySprite5;
	SpriteDef mySprite6;

	SpriteDef mySprite7;
	SpriteDef mySprite8;
	SpriteDef mySprite9;
	SpriteDef mySprite10;

    SpriteDef splayer;
    SpriteDef stir1;
    SpriteDef stir2;
    SpriteDef stir3;
    SpriteDef stir4;
    SpriteDef stir5;
    SpriteDef stir6;
    SpriteDef stir7;
    SpriteDef stir8;
    SpriteDef scanon;
	//load the tile in VRAM (check it using GensKMod CPU>Debug>Genesis>VDP)
    VDP_loadTileData( (const u32 *)spchiffre0, chif0, 1, 0);
    VDP_loadTileData( (const u32 *)spchiffre1, chif1, 1, 0);
    VDP_loadTileData( (const u32 *)spchiffre2, chif2, 1, 0);
    VDP_loadTileData( (const u32 *)spchiffre3, chif3, 1, 0);
    VDP_loadTileData( (const u32 *)spchiffre4, chif4, 1, 0);
    VDP_loadTileData( (const u32 *)spchiffre5, chif5, 1, 0);
    VDP_loadTileData( (const u32 *)spchiffre6, chif6, 1, 0);
    VDP_loadTileData( (const u32 *)spchiffre7, chif7, 1, 0);
    VDP_loadTileData( (const u32 *)spchiffre8, chif8, 1, 0);
    VDP_loadTileData( (const u32 *)spchiffre9, chif9, 1, 0);

    VDP_loadTileData( spcanon.sprites[0], vrcanon, 4, 0);
    VDP_loadTileData( spcible.sprites[0], vrcible, 4, 0);
    VDP_loadTileData( spbille.sprites[0], vrbille, 1, 0);

	VDP_resetSprites(); //optional, but take the use to



    // position X et Y, taille, palette et link des sprites :

    // Sprite score unit (1)
	mySprite1.posx = 56;mySprite1.posy = 0;
	mySprite1.size = SPRITE_SIZE(1,1);  //  a sprite 1x1 using 1 tile (8x8 pixels)
	mySprite1.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0, 1);//chif0);
	mySprite1.link  = 1;
	VDP_setSpriteP(0, &mySprite1);
    // Sprite score dizaine (1)
	mySprite2.posx = 48;mySprite2.posy = 0;
	mySprite2.size = SPRITE_SIZE(1,1);  //  a sprite 1x1 using 1 tile (8x8 pixels)
	mySprite2.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0, 1);
	mySprite2.link  = 2;
	VDP_setSpriteP(1, &mySprite2);
    // Sprite score centaine (1)
	mySprite3.posx = 40;mySprite3.posy = 0;
	mySprite3.size = SPRITE_SIZE(1,1);  //  a sprite 1x1 using 1 tile (8x8 pixels)
	mySprite3.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0, 1);
	mySprite3.link  = 3;
	VDP_setSpriteP(2, &mySprite3);

    // Sprite score unit (1)
	mySprite4.posx = 56;mySprite4.posy = 20;
	mySprite4.size = SPRITE_SIZE(1,1);  //  a sprite 1x1 using 1 tile (8x8 pixels)
	mySprite4.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0, 1);
	mySprite4.link  = 4;
	VDP_setSpriteP(3, &mySprite4);
    // Sprite score dizaine (1)
	mySprite5.posx = 48;mySprite5.posy = 20;
	mySprite5.size = SPRITE_SIZE(1,1);  //  a sprite 1x1 using 1 tile (8x8 pixels)
	mySprite5.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0, 1);//chif0);
	mySprite5.link  = 5;
	VDP_setSpriteP(4, &mySprite5);
    // Sprite score centaine (1)
	mySprite6.posx = 40;mySprite6.posy = 20;
	mySprite6.size = SPRITE_SIZE(1,1);  //  a sprite 1x1 using 1 tile (8x8 pixels)
	mySprite6.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0, 1);
	mySprite6.link  = 6;
	VDP_setSpriteP(5, &mySprite6);

    // Sprite score unit (1)
	mySprite7.posx = 56;mySprite7.posy = 60;
	mySprite7.size = SPRITE_SIZE(1,1);  //  a sprite 1x1 using 1 tile (8x8 pixels)
	mySprite7.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0, 1);
	mySprite7.link  = 7;
	VDP_setSpriteP(6, &mySprite7);
    // Sprite score dizaine (1)
	mySprite8.posx = 48;mySprite8.posy = 60;
	mySprite8.size = SPRITE_SIZE(1,1);  //  a sprite 1x1 using 1 tile (8x8 pixels)
	mySprite8.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0, 1);
	mySprite8.link  = 8;
	VDP_setSpriteP(7, &mySprite8);
    // Sprite score centaine (1)
	mySprite9.posx = 40;mySprite9.posy = 60;
	mySprite9.size = SPRITE_SIZE(1,1);  //  a sprite 1x1 using 1 tile (8x8 pixels)
	mySprite9.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0, 1);
	mySprite9.link  = 9;
	VDP_setSpriteP(8, &mySprite9);
    // Sprite score millier (1)
	mySprite10.posx = 32;mySprite10.posy = 60;
	mySprite10.size = SPRITE_SIZE(1,1);  //  a sprite 1x1 using 1 tile (8x8 pixels)
	mySprite10.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0, 1);
	mySprite10.link  = 10;
	VDP_setSpriteP(9, &mySprite10);

	// Sprite player cible 16x16 pixels (4)
	splayer.posx = 160;splayer.posy = 200;
	splayer.size = SPRITE_SIZE(2,2);
	splayer.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0,vrcible);
	splayer.link  = 11;
	VDP_setSpriteP(10, &splayer);

	// Sprite tir1 bille 8x8 pixels (1)
	stir1.posx = 0;stir1.posy = 300;
	stir1.size = SPRITE_SIZE(1,1);
	stir1.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0,vrbille);
	stir1.link  = 12;
	VDP_setSpriteP(11, &stir1);
	// Sprite tir2 bille  8x8 pixels (1)
	stir2.posx = 0;stir2.posy = 300;
	stir2.size = SPRITE_SIZE(1,1);
	stir2.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0,vrbille);
	stir2.link  = 13;
	VDP_setSpriteP(12, &stir2);
	// Sprite tir3 bille  8x8 pixels (1)
	stir3.posx = 0;stir3.posy = 300;
	stir3.size = SPRITE_SIZE(1,1);
	stir3.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0,vrbille);
	stir3.link  = 14;
	VDP_setSpriteP(13, &stir3);
	// Sprite tir4 bille  8x8 pixels (1)
	stir4.posx = 0;stir4.posy = 300;
	stir4.size = SPRITE_SIZE(1,1);
	stir4.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0,vrbille);
	stir4.link  = 15;
	VDP_setSpriteP(14, &stir4);
	// Sprite tir5 bille  8x8 pixels (1)
	stir5.posx = 0;stir5.posy = 300;
	stir5.size = SPRITE_SIZE(1,1);
	stir5.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0,vrbille);
	stir5.link  = 16;
	VDP_setSpriteP(15, &stir5);
	// Sprite tir6 bille  8x8 pixels (1)
	stir6.posx = 0;stir6.posy = 300;
	stir6.size = SPRITE_SIZE(1,1);
	stir6.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0,vrbille);
	stir6.link  = 17;
	VDP_setSpriteP(16, &stir6);
	// Sprite tir6 bille  8x8 pixels (1)
	stir7.posx = 0;stir7.posy = 300;
	stir7.size = SPRITE_SIZE(1,1);
	stir7.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0,vrbille);
	stir7.link  = 18;
	VDP_setSpriteP(17, &stir7);
	// Sprite tir6 bille  8x8 pixels (1)
	stir8.posx = 0;stir8.posy = 300;
	stir8.size = SPRITE_SIZE(1,1);
	stir8.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0,vrbille);
	stir8.link  = 19;
	VDP_setSpriteP(18, &stir8);

	// Sprite tir6 bille  8x8 pixels (1)
	scanon.posx = 0;scanon.posy = 0;
	scanon.size = SPRITE_SIZE(1,1);
	scanon.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0,vrcanon);
	scanon.link  = 20;
	VDP_setSpriteP(19, &scanon);


	VDP_updateSprites();

// *******************************************************************************************************************************************
// variables globales
//#define u8      unsigned char
//#define u16     unsigned short
//#define u32     unsigned long

    u16 xshp;u16 yshp;u16 xliv;u16 yliv;
    u16 unite;u16 dizaine;u16 centaine;u16 millier;
    u16 datest;u16 dbtest; // variable de test debug
    u16 gsblip;u16 gspause;
    u16 value; // pour le joypad
    u16 cptx;u16 cpty;u16 cpti;
    u16 tcontact;
    u16 lcha;u16 lchb;u16 permut;

/* *********************************************************************************************************************************************

    Il faut normaliser ton vecteur de mouvement de tir.

    fix16 div;
    u16 factor

    factor = 2;
    if (xmov > ymov) div = ymov >> factor;
    else div = xmov >> factor;

    ymov = fix16Div(ymov, div);
    xmov = fix16Div(xmov, div);

    cela devrait te donner une vitesse constante. Si tu veux modifier cette vitesse, il te suffit de modifier la valeur de factor (entre 1 et 8)

*/

    s16 xmov;s16 ymov;

    static void enemybullet(u16 xen,u16 yen, u16 xplay,u16 yplay, u16 nb)
    {
    bullets[nb].flags = 1;
    bullets[nb].posx = xen;
    bullets[nb].posy = yen;

        //xen += intToFix16(16);
        //yen += intToFix16(5);

        //xmov = (xplay-xen)>>6;
        //xmov = (xplay-xen)>>2; //  marche un peu !
        xmov = (xplay-xen)>>1;

        if ((xmov < FIX16(0.1)) && (xmov > FIX16(-0.1)))
        {
            if (xmov > FIX16(0))    {
                xmov = FIX16(0.1);

                }
            else
                {xmov = FIX16(-0.1);
                }
        }


        //ymov = (yplay-yen)>>6;
        //ymov = (yplay-yen)>>2; //  marche un peu !!
        ymov = (yplay-yen)>>1;

        if ((ymov < FIX16(0.1)) && (ymov > FIX16(-0.1)))
        {
            if (ymov > FIX16(0))    {
                ymov = FIX16(0.1);}
            else
                {ymov = FIX16(-0.1);
                }
        }

    bullets[nb].movx = xmov>>2; // /8
    bullets[nb].movy = ymov>>2; // /8
    }


// ******************************************************************************************************************************************
    cptx=0;cpty=0;cpti=0;tcontact=0;
    xshp=160;yshp=200;
    datest=0;dbtest=0;
    gsblip=5;gspause=0;
    lcha=0;lchb=0;
    xliv=160;yliv=112;
    permut=0;



    // *****************************
    // **** Boucle principale ****** || &&
    // *****************************

/* test*/
		for(cpti=0 ; cpti < MAXBULLET; cpti++) // de 0  5 doit 6 tests
			{
            bullets[cpti].posy = 300;
			}


	while(1)
	{
    // Test manuel avec votre belle joypad ergonomique...
    value = JOY_readJoypad(JOY_1); // valeur du joypad joueur 1

    VDP_drawText("BUTTON A : Fire", 12, 10);VDP_drawText("BUTTON B : permuter cible/canon", 4, 20);

	gsblip-=1; // economie ressource machine --> certaines des conditions n'ont pas besoin d'tre lu par la LYNX  chaque boucle.
	if (gsblip==1)//5)//1)//yscrolla
		{
        gsblip=5;


            if (value & BUTTON_START)
                {
                if (gspause==0)
                    {
                    gspause=1;
                    }
                if (gspause==2) gspause=3;
                }
            if (!(value & BUTTON_START))
                {
                if (gspause==1) gspause=2;
                if (gspause==3)
                    {
                    gspause=0;
                    }
                }




		if (lcha==1)
			{
			if (!(value & BUTTON_A))				{lcha=0;}
            }
		if (lchb==1)
			{
			if (!(value & BUTTON_B))				{lchb=0;}
            }

		//dbtest = bullets[1].posx;//bullets[1].dx;
        dbtest = bullets[0].tpvm;

        unite = dbtest % 10;// unit
        dizaine = dbtest / 10 % 10;// dizaine
        centaine = dbtest / 100 % 10;// centaine

		mySprite1.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0, 21+unite);//chif0);
		VDP_setSpriteP(0, &mySprite1);

		mySprite2.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0, 21+dizaine);//chif0);
		VDP_setSpriteP(1, &mySprite2);

		mySprite3.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0, 21+centaine);//chif0);
		VDP_setSpriteP(2, &mySprite3);


// *****************************************************************
		//dbtest = bullets[3].flags;
		//dbtest = bullets[0].err;
		//dbtest = bullets[1].posy;//bullets[1].dy;
        dbtest = bullets[0].tphm;

        unite = dbtest % 10;// unit
        dizaine = dbtest / 10 % 10;// dizaine
        centaine = dbtest / 100 % 10;// centaine

		mySprite4.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0, 21+unite);//chif0);
		VDP_setSpriteP(3, &mySprite4);

		mySprite5.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0, 21+dizaine);//chif0);
		VDP_setSpriteP(4, &mySprite5);

		mySprite6.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0, 21+centaine);//chif0);
		VDP_setSpriteP(5, &mySprite6);


// ****************************************************************
		dbtest = bullets[7].movx;//bullets[0].err;

        unite = dbtest % 10;// unit
        dizaine = dbtest / 10 % 10;// dizaine
        centaine = dbtest / 100 % 10;// centaine
        millier = dbtest / 1000 % 10;// millier

		mySprite7.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0, 21+unite);//chif0);
		VDP_setSpriteP(6, &mySprite7);

		mySprite8.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0, 21+dizaine);//chif0);
		VDP_setSpriteP(7, &mySprite8);

		mySprite9.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0, 21+centaine);//chif0);
		VDP_setSpriteP(8, &mySprite9);

		mySprite10.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0, 21+millier);//chif0);
		VDP_setSpriteP(9, &mySprite10);

        }

    if (lchb==0)
        {
        if (value & BUTTON_B) // selection : soit dplacement cible, soit dplacement canon
            {
            lchb=1;
            permut+=1;
            if (permut==2)      permut=0;

            }
        }
    if (permut==0)
        {
        if (value & BUTTON_UP)
            {
            if (yshp>0)        yshp-=2;
            }
        if (value & BUTTON_DOWN)
            {
            if (yshp<207)        yshp+=2;
            }
        if (value & BUTTON_RIGHT)
            {
            if (xshp<303)        xshp+=2;
            }
        if (value & BUTTON_LEFT)
            {
            if (xshp>0)        xshp-=2;
            }
        }
    else
        {
        if (value & BUTTON_UP)
            {
            if (yliv>0)        yliv-=1;
            }
        if (value & BUTTON_DOWN)
            {
            if (yliv<207)        yliv+=1;
            }
        if (value & BUTTON_RIGHT)
            {
            if (xliv<303)        xliv+=1;
            }
        if (value & BUTTON_LEFT)
            {
            if (xliv>0)        xliv-=1;
            }
        }

	splayer.posx = xshp;splayer.posy = yshp;
    VDP_setSpriteP(10, &splayer);

    if (lcha==0)
        {

            cpti = MAXBULLET;
            while(cpti--)
            //for(cpti=0 ; cpti < MAXBULLET; cpti++) // de 0  5 doit 6 tests
                {
                if (bullets[cpti].flags == 0)
                    {
                    if (value & BUTTON_A) // ordre de fabrication d'un tir ennemi
                        {
                        lcha=1;
                        // mise  zro des variables :
                        bullets[cpti].hori = 0;bullets[cpti].vert = 0;
                        bullets[cpti].dx=0;bullets[cpti].dy=0;
                        bullets[cpti].tpv=0;bullets[cpti].tpvm=0;bullets[cpti].tph=0;bullets[cpti].tphm=0;
                        bullets[cpti].posy = 300;
                        bullets[cpti].cpta = 0;


                        enemybullet(xliv,yliv ,xshp+8,yshp+8, cpti); // ordre de fabrication d'un tir ennemi


                        cpti=0; // attention ici, car il faut sortir de la boucle, pour ne pas rpter l'ordre pour toutes le boulettes ennemis !
                        }
                    }
                }

        }




if (gspause==0)
    {
    cpti = MAXBULLET;
    while(cpti--)
    //for(cpti=0 ; cpti < MAXBULLET; cpti++) // de 0  7 doit 8 tests
        {
        if (bullets[cpti].flags==1)
            {
            bullets[cpti].tpv += 1; // je ralentis les tirs ennemis (systeme D) c'est provisoire si le problme est rsolus
            if (bullets[cpti].tpv > 2) // on ralentis un peu les tirs ennemis...
                {
                bullets[cpti].tpv=0;
                bullets[cpti].posx += bullets[cpti].movx;
                bullets[cpti].posy += bullets[cpti].movy;

                // si boulette sort de l'cran, alors...
                if ((bullets[cpti].posx>320) || (bullets[cpti].posx<3)) {bullets[cpti].flags=9;}
                if ((bullets[cpti].posy<3) || (bullets[cpti].posy>220)) {bullets[cpti].flags=9;}
                }
			}
        if (bullets[cpti].flags==9) // ...fin de la boulette, remise  zro.
			{
            bullets[cpti].flags=0;
            bullets[cpti].posy = 300;
			}

        }


    }
        stir1.posx = bullets[0].posx;stir1.posy = bullets[0].posy;VDP_setSpriteP(11, &stir1);
        stir2.posx = bullets[1].posx;stir2.posy = bullets[1].posy;VDP_setSpriteP(12, &stir2);
        stir3.posx = bullets[2].posx;stir3.posy = bullets[2].posy;VDP_setSpriteP(13, &stir3);
        stir4.posx = bullets[3].posx;stir4.posy = bullets[3].posy;VDP_setSpriteP(14, &stir4);
        stir5.posx = bullets[4].posx;stir5.posy = bullets[4].posy;VDP_setSpriteP(15, &stir5);
        stir6.posx = bullets[5].posx;stir6.posy = bullets[5].posy;VDP_setSpriteP(16, &stir6);
        stir7.posx = bullets[6].posx;stir7.posy = bullets[6].posy;VDP_setSpriteP(17, &stir7);
        stir8.posx = bullets[7].posx;stir8.posy = bullets[7].posy;VDP_setSpriteP(18, &stir8);

    scanon.posx=xliv;scanon.posy=yliv;VDP_setSpriteP(19, &scanon);

	VDP_updateSprites();
	VDP_waitVSync();
	}
	return 0;
}

