#include <stdio.h>
#include <stdlib.h>
#include <inttypes.h>
#include <math.h>
#include "SDL.h"


#define t_image         64
#define shift_image     6
#define masque_image    (t_image - 1)


SDL_Surface *ecran, *image;


void GenereImage()
{
    int32_t x, y;
    int32_t u, v, i, j;
    uint32_t *p;
    static double angle = 0.0;
    static double zoom = 1.0;
    static double senszoom = 1;

    i = (int32_t)(cos(angle) * (1.0 / zoom) * 65536.0);
    j = (int32_t)(-sin(angle) * (1.0 / zoom) * 65536.0);
    u = (t_image / 2) - ((ecran->w * i / 2) - (ecran->h * j / 2));
    v = (t_image / 2) - ((ecran->w * j / 2) + (ecran->h * i / 2));

    
    p = (uint32_t *)ecran->pixels;
    for (y = 0; y < ecran->h; y++)
    {
        uint32_t u2 = u, v2 = v;

        for (x = 0; x < ecran->w; x++)
        {
            u &= (masque_image << 16) | 0xFFFF;
            v &= (masque_image << 16) | 0xFFFF;

            *p++ = ((uint32_t *)image->pixels)[((v >> 16) << shift_image) | (u >> 16)];

            u += i;
            v += j;
        }

        u = u2 - j;
        v = v2 + i;
    }


    angle += 0.05; while (angle > 6.28319) angle -= 6.28319;
    zoom += 0.05 * senszoom;
    if (zoom < 0.5) zoom = 0.5, senszoom = +1;
    if (zoom > 4.0) zoom = 4.0, senszoom = -1;
}


int main(int argc, char *argv[])
{
    int fin = 0;

    SDL_Init(SDL_INIT_VIDEO);
    atexit(SDL_Quit) == 0;
    ecran = SDL_SetVideoMode(1280, 960, 32, SDL_HWSURFACE | SDL_DOUBLEBUF);
    
    {
        SDL_Surface *tmp = SDL_LoadBMP("boo.bmp");
        image = SDL_ConvertSurface(tmp, ecran->format, SDL_SWSURFACE);
        SDL_FreeSurface(tmp);
    }

    while (!fin)
    {
        SDL_Event event;

        SDL_LockSurface(ecran);
        GenereImage();
        SDL_UnlockSurface(ecran);
        SDL_Flip(ecran);

        if (SDL_PollEvent(&event))
        {
            switch (event.type)
            {
                case SDL_QUIT:
                fin = 1;
                break;
            }
        }
    }
  
    SDL_FreeSurface(image);

    return 0;
}
