unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls, Grids, Math, Menus;

type
  TForm1 = class(TForm)
    StringGrid1: TStringGrid;
    Image1: TImage;
    edtEdgeWeight: TEdit;
    Label1: TLabel;
    GroupBox1: TGroupBox;
    chkBidirectional: TCheckBox;
    btnHelp: TButton;
    btnClear: TButton;
    Memo1: TMemo;
    chkShortestPath: TCheckBox;
    Label2: TLabel;
    lblLength: TLabel;
    chkGeo: TCheckBox;
    Label3: TLabel;
    Label4: TLabel;
    constructor Create(AOwner: TComponent) ; override;
    procedure redrawGraph();
    procedure addNode(x,y: integer);
    procedure removeNode(i: integer);  
    procedure addEdge(id1,id2: integer);
    procedure removeEdge(id1,id2: integer);
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
    Shift: TShiftState; X, Y: Integer);
    procedure Image1MouseUp(Sender: TObject; Button: TMouseButton;
    Shift: TShiftState; X, Y: Integer);
    procedure Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure btnHelpClick(Sender: TObject);
    procedure btnClearClick(Sender: TObject);
    procedure Beenden1Click(Sender: TObject);
    procedure showAdjList();
    procedure findShortestPath(src: integer; dst: integer);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

type
  Node = record
    x,y:integer;
  end;
  tNodePointer = ^tNodeElement;
  tEdgePointer = ^tEdgeElement;
  tNodeElement = record
    Name: string;
    firstEdge: tEdgePointer;
    nextNode: tNodePointer;
  end;
  tEdgeElement = record
    name: string;
    gewicht: integer;
    nextEdge: tEdgePointer;
  end;

const radius = 20;

var
  nodes: array[0..500] of Node;
  adjmat: array[0..500,0..500] of integer;
  nodeNr: integer;  // Anzahl der Knoten
  sourceNode: integer; // Startknoten fr Kantenziehen
  anker: tNodePointer;


function distance(x1,y1,x2,y2: integer): integer;
begin
  result := floor(sqrt((x1-x2)*(x1-x2)+(y1-y2)*(y1-y2)));
end;

constructor TForm1.Create(AOwner: TComponent);
begin                                   
  inherited Create(AOwner);
  image1.Canvas.brush.color := clWhite;
  image1.Canvas.FillRect(Canvas.ClipRect);
end;

function sgn (a : real) : real;
begin
  if a < 0  then  sgn := -1
            else  sgn :=  1;
end;

function atan2 (y, x : real) : real;
begin
  if x > 0       then  atan2 := arctan (y/x)
  else if x < 0  then  atan2 := arctan (y/x) + pi
  else                 atan2 := pi/2 * sgn (y);
end;

procedure CreateAdjList;
var i,j: integer;
  NewNode: tNodePointer;
  NewEdge: tEdgePointer;
begin
  NewNode := anker;
  for i := 0 to NodeNr - 1 do
  begin
    if i>0 then
    begin
      NewNode^.nextNode := new(tNodePointer);
      NewNode := NewNode^.nextNode;
    end;
    NewNode^.Name := IntToStr(i);
    NewNode^.firstEdge := Nil;
    NewNode^.nextNode := Nil;
    NewEdge := NewNode^.firstEdge;
    for j := 0 to NodeNr - 1 do
      if adjmat[i,j]<>0 then
      begin
        if NewNode^.firstEdge = Nil then
        begin
          NewNode.firstEdge := new(tEdgePointer);
          NewEdge := NewNode^.firstEdge;
        end
        else
        begin
          NewEdge^.nextEdge := new(TEdgePointer);
          NewEdge := NewEdge^.nextEdge;
        end;
        NewEdge^.Name := IntToStr(j);
        NewEdge^.gewicht := adjmat[i,j];
        NewEdge^.nextEdge := nil;
      end;
  end;
end;

procedure TForm1.redrawGraph();
var
  i,j,xn,yn: integer; angle: Real;
begin
  with image1.Canvas do
  begin
    brush.color := clWhite;
    FillRect(Canvas.ClipRect);
    for j := 0 to nodeNr - 1 do
      for i := 0 to nodeNr - 1 do
        if adjmat[i,j] > 0 then
        begin
          brush.color := clBlue;
          moveto(nodes[i].x,nodes[i].y);
          lineto(nodes[j].x,nodes[j].y);
          angle := atan2((nodes[j].y - nodes[i].y),(nodes[j].x - nodes[i].x));
          xn := floor(nodes[j].x - cos(angle) * radius);
          yn := floor(nodes[j].y - sin(angle) * radius);
          Ellipse(xn-6,yn-6, xn+6,yn+6);
          brush.color := clWhite;
          xn := floor(nodes[i].x + cos(angle) * distance(nodes[i].x,nodes[i].y,nodes[j].x,nodes[j].y) / 2);
          yn := floor(nodes[i].y + sin(angle) * distance(nodes[i].x,nodes[i].y,nodes[j].x,nodes[j].y) / 2);
          TextOut(xn,yn,inttostr(adjmat[i,j]));
        end;
    brush.color := clWhite;
    for i := 0 to nodeNr - 1 do
    begin
      Ellipse(nodes[i].x-radius,nodes[i].y-radius,
        nodes[i].x+radius,nodes[i].y+radius);
      TextOut(nodes[i].x,nodes[i].y,inttostr(i));
    end;
  end;
  with stringgrid1 do
  begin
    colcount := nodeNr + 1;
    rowcount := nodeNr + 1;
    for i := 0 to nodeNr - 1 do
      Cells[i+1,0] := inttostr(i);
    for i := 0 to nodeNr - 1 do
      Cells[0,i+1] := inttostr(i);
    for i := 0 to nodeNr - 1 do
      for j := 0 to nodeNr - 1 do
        Cells[i+1,j+1] := inttostr(adjmat[i,j]);
  end;
  showAdjList();
end;

procedure TForm1.addNode(x,y: integer);
var i: integer;
begin
  for i := 0 to nodeNr - 1 do
    begin
      if distance(nodes[i].x, nodes[i].y, x, y) < 2*radius then
        exit;
    end;
  nodes[nodeNr].x := x;
  nodes[nodeNr].y := y;
  for i := 0 to nodeNr do
  begin
    adjmat[nodeNr,i] := 0;
    adjmat[i,nodeNr] := 0;
  end;
  inc(nodeNr);
  redrawGraph();
end;

procedure TForm1.Beenden1Click(Sender: TObject);
begin
  close;
end;

procedure TForm1.btnClearClick(Sender: TObject);
begin
  nodeNr := 0;
  redrawGraph();
end;

procedure TForm1.btnHelpClick(Sender: TObject);
begin
  Messagebox(Self.Handle, 'Platzieren der Knoten mit linkem Mausklick, Ziehen der Kanten mit linker Maustaste, Entfernen jeweils mit rechter Maustaste.', 'Bedienung', MB_ICONINFORMATION);
  Messagebox(Self.Handle, 'Fr Pfadsuche Anfangs- auf Endknoten ziehen (mit linker Maustaste).', 'Bedienung', MB_ICONINFORMATION);
end;

procedure TForm1.removeNode(i: integer);
var j,k: integer;
begin
  { remove column i }
  for j := 0 to nodeNr - 1 do
  begin
    for k := i to nodeNr - 2 do
      adjmat[j,k] := adjmat[j,k+1];
  end;

  { remove row i }
  for j := i to nodeNr - 2 do
  begin
    nodes[j] := nodes[j+1];
    for k := 0 to nodeNr - 2 do
      adjmat[j,k] := adjmat[j+1,k];
  end;
  dec(nodeNr);
  redrawGraph();
  exit;
end;        

procedure TForm1.showAdjList();
var zeile: string;
  NewNode: tNodePointer;
  NewEdge: tEdgePointer;
begin
  CreateAdjList;
  NewNode := anker;
  Memo1.Clear;
  while NewNode <> Nil do
  begin
    zeile := NewNode^.name+': ';
    NewEdge := NewNode^.firstEdge;
    while NewEdge<>Nil do
    begin
      zeile:=zeile+NewEdge^.name+' ('+IntToStr(NewEdge^.gewicht)+'), ';
      NewEdge := NewEdge^.nextEdge;
    end;
    Memo1.Lines.Add(zeile);
    NewNode := NewNode^.nextNode;
  end;
end;

function findNodeAt(x,y: integer): integer;
var i: integer;
begin
  for i := 0 to nodeNr - 1 do
    begin
      if distance(nodes[i].x, nodes[i].y, x, y) < radius then
      begin
        result := i;
        exit;
      end;
    end;
    result := -1;
end;

procedure TForm1.Image1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var nodeId: integer;
begin
  nodeId := findNodeAt(x,y);
  if (button = mbLeft) and (nodeId = -1) then
    addNode(x,y)
  else
    sourceNode := nodeId
end;

procedure TForm1.Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if sourceNode <> -1 then
  begin                               
    redrawGraph();     
    image1.Canvas.brush.color := clBlack;
    image1.Canvas.moveto(nodes[sourceNode].x,nodes[sourceNode].y);
    image1.Canvas.lineto(x,y);
    image1.Canvas.brush.color := clGreen;
    image1.Canvas.Ellipse(x-6,y-6,x+6,y+6);
  end;
end;

procedure TForm1.addEdge(id1,id2: integer);
var dist: integer;
begin
  if chkGeo.Checked then
    dist := distance(nodes[id1].x, nodes[id1].y, nodes[id2].x, nodes[id2].y)
  else
    dist := strtoint(edtEdgeWeight.text);
  adjmat[id1,id2] := dist;
  if chkBidirectional.Checked then
    adjmat[id2,id1] := dist;
  redrawGraph();
end;

procedure TForm1.removeEdge(id1,id2: integer);
begin
  adjmat[id1,id2] := 0;
  if chkBidirectional.Checked then
    adjmat[id2,id1] := 0;
  redrawGraph();
end;

procedure TForm1.Image1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var nodeId: integer;
begin
  if sourceNode <> -1 then
  begin
    nodeId := findNodeAt(x,y);
    if nodeId = -1 then exit;
    if chkShortestPath.Checked then begin
      findShortestPath(sourceNode, nodeId);
    end else begin
      case button of
        mbLeft:
          if sourceNode <> nodeId then
            addEdge(sourceNode, nodeId);
        mbRight:
          if sourceNode = nodeId then
            removeNode(nodeId)
          else
            removeEdge(sourceNode, nodeId);
      end;
    end;
    sourceNode := -1;
  end;
end;

type OrderedNode = record
    nodeId: integer;
    parent: integer;
    dist: integer;
    visited: boolean;
  end;

procedure TForm1.findShortestPath(src: integer; dst: integer);
var list: array[0..500] of OrderedNode;
i, j, tmpdist: integer;
begin
  for i := 0 to nodeNr - 1 do begin
    list[i].nodeId := i;
    list[i].parent := -1;
    list[i].dist := maxint;
    list[i].visited := false;
  end;
  list[src].dist := 0;
  while true do begin
    tmpdist := maxint;
    i := -1;
    for j := 0 to nodeNr - 1 do
      if (list[j].dist < tmpdist) and (not list[j].visited) then begin
        tmpdist := list[j].dist;
        i := j;
      end;
    if i = -1 then break;
    for j := 0 to nodeNr - 1 do begin
      if adjmat[list[i].nodeId][list[j].nodeId] > 0 then begin
        tmpdist := list[i].dist +
          adjmat[list[i].nodeId][list[j].nodeId];
        if tmpdist < list[j].dist then begin
          list[j].dist := tmpdist;
          list[j].parent := list[i].nodeId;
        end;
      end;
    end;
    list[i].visited := true;
  end;
  if list[dst].dist = maxint then begin
    lblLength.Caption := '0';
    exit
  end;
  lblLength.Caption := inttostr(list[dst].dist);
  redrawGraph();
  with image1.Canvas do
  begin
    brush.color := clGreen;
    i := dst;
    repeat
      Ellipse(nodes[list[i].nodeId].x-radius,nodes[list[i].nodeId].y-radius,
        nodes[list[i].nodeId].x+radius,nodes[list[i].nodeId].y+radius);
      TextOut(nodes[list[i].nodeId].x,nodes[list[i].nodeId].y,inttostr(list[i].nodeId));
      i := list[i].parent;
    until i = -1;
  end;
end;

initialization
nodeNr := 0;
sourceNode := -1;
anker := new(TNodePointer);

end.
