
	.include "jaguar.inc"

	.text

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;	.extern	Mandle		; Do mandelbrot picture...
	.extern	start_mandGPU
	.extern	end_mandGPU
	.extern	mandGPU

	.extern Init640x480

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

bitmap_addr		.equ	$20000	; Buffer in main memory
BM_WIDTH		.equ	640	; Bitmap width in pixels
BM_HEIGHT		.equ	480	; Bitmap height in pixels
BM_DEPTH		.equ	8	; 8 bits per pixel
BM_PHRASES		.equ	((BM_WIDTH*BM_DEPTH)/64)	; phrase = 64 bits
BM_OFFSET	  	.equ    (2*8)	; Two Phrases = offset to bitmap object


	move.l  #$70007,G_END		; big-endian mode
	move.l  #$70007,D_END
	move.w  #$FFFF,VI       	; disable video interrupts

	move.l  #INITSTACK,a7   	; Setup a stack

	move.l	#bitmap_addr, a0
	jsr		Init640x480

; Copy over the GPU program

	move.l	#mandGPU,a0		; Get the address of the GPU code
	move.l	#start_mandGPU,a1	; Get destination address
	move.l	#end_mandGPU,d0		; and calculate length of GPU code
	sub.l	#start_mandGPU,d0
	asr.l	#2,d0			; divide by 4 since we're copying longs
.loop:
	move.l	(a0)+,(a1)+	; actually copy the code...
	dbra	d0,.loop

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Copy the palette into the chip

	move.l	#256,d0
	move.l	#CLUT,a0
	move.l	#cry_data,a1

.cloop:
	move.w	(a1)+,(a0)+
	dbra	d0,.cloop

;	bsr	clearpic

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Draw the fractal, then just bail out to an illegal instruction...

	move.l	#G_RAM,G_PC		; GPU Program counter gets $00f03000

	move.l	#$1,G_CTRL		; Set the GPU going
;	jsr	Mandle
prout:
	bra.s 	prout



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Use the blitter to clear the bitmap for our fractal picture...
; Just set up enough Blitter stuff to do a block draw.  Set A1_FLAGS to:
;
;	Contiguous data
;	16 bit per pixel
;	width of 56 pixels
;	add increment
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

clearpic:
	move.l	#PITCH1|PIXEL8|WID256|XADDPIX,d0
	move.l	d0,A1_FLAGS

; Point A1BASE to the data

	move.l	#$20000,d0
	move.l	d0,A1_BASE

; Set the pixel point to 0,0

	move.w	#0,d0			; y
	swap	d0
	move.w	#0,d0			; x
	move.l	d0,A1_PIXEL

; Set up the step size to -256 in x, 1 in y
; The x step requires that the pixel pointer by 

	move.w	#1,d0			; y
	swap	d0
	move.w	#(-256),d0		; x
	move.l	d0,A1_STEP

	move.l	#0,A1_CLIP

; Set up Counters register to 256 in x write long to clear upper
; 256 in y, or in y as a word

	move.w	#200,d0			; y
	swap	d0
	move.w	#256,d0			; x
	move.l	d0,B_COUNT

; Put some data in the blitter for it to write.

	move.l	#0,d0
	move.l	d0,B_PATD	
	move.l	#0,d0
	move.l	d0,B_PATD+4

; Now Turn IT ON !!!!!!!!!!!!!

; NO SOURCE DATA, NO OUTER LOOP, Turn on pattern data, Allow outer loop update

	move.l	#PATDSEL|UPDA1,d0
	move.l	d0,B_CMD
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	.data

; This file has a label cry_data that has, in 68k format the top level
; of cry for 8 bits
        
	.include "cry.pal"

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	.phrase
	.bss
	.dphrase
