    include "jaguar.inc"  

	.text
    .68000  
	.noclear


RelogeObjet:
    movem.l     d0-d5, -(sp)
    move.l      #24, d5
    move.l      0(a0), d1
    move.l      4(a0), d2
    move.l      d1, d3
    move.l      d2, d4
    and.l       #$FFFFF800, d3
    and.l       #$FFFFFF, d4
    and.l       #$7FF, d1
    lsl.l       #8, d1
    lsr.l       d5, d2
    or.l        d2, d1
    lsr.l       #3, d0
    add.l       d1, d0
    and.l       #$7FFFF, d0
    move.l      d0, d1
    lsr.l       #8, d0
    or.l        d0, d3
    lsl.l       d5, d1
    or.l        d1, d4
    move.l      d3, 0(a0)
    move.l      d4, 4(a0)
    movem.l     (sp)+, d0-d5
    rts


InitVideoEntrelacee:
    movem.l     d0, -(sp)

    move.w      #$FFFF, VI

    move.w      CONFIG, d0
    andi.w      #16, d0
    bne         InitVideoEntrelacee_60Hz

InitVideoEntrelacee_50Hz:
    move.w	      #0, HC   
	move.w	      #1, VC    
    move.w      #624, VP
    move.w      #614, VEB   
    move.w      #619, VS    
    move.w        #4, VEE   
    move.w       #40, VBE  
    move.w      #614, VBB
    move.w      #850, HP    
    move.w      #1749, HS   
    move.w      #787, HEQ   
    move.w      #600, HVS   
    move.w      #1709, HBB  
    move.w      #153, HBE   
    bra         InitVideoEntrelacee_Fin       

InitVideoEntrelacee_60Hz:
    move.w	      #0, HC   
	move.w	      #1, VC    
    move.w      #524, VP
    move.w      #512, VEB   
    move.w      #518, VS   
    move.w        #5, VEE  
    move.w       #30, VBE 
    move.w      #512, VBB  
    move.w      #844, HP         
    move.w      #1743, HS  
    move.w      #780, HEQ   
    move.w      #595, HVS   
    move.w      #1697, HBB  
    move.w      #118, HBE

InitVideoEntrelacee_Fin:
    movem.l     (sp)+, d0
    rts

.globl Init640x480	
Init640x480:
    movem.l     d0/a0, -(sp)
	
	move.l		a0, Vid_Buffer

    jsr         InitVideoEntrelacee

    move.w      CONFIG, d0
    andi.w      #16, d0
    bne         Init640x480_60Hz

Init640x480_50Hz:
    move.l      #204, Vid_HDB1
    move.l      #204, Vid_HDB2
    move.l      #1657, Vid_HDE
    move.l      #85, Vid_VDB
    move.l      #565, Vid_VDE
    bra         Init640x480_Fin

Init640x480_60Hz:
    move.l      #178, Vid_HDB1
    move.l      #178, Vid_HDB2
    move.l      #1637, Vid_HDE
    move.l      #31, Vid_VDB
    move.l      #511, Vid_VDE

Init640x480_Fin:
    move.l      Vid_VDE, d0
    addq.l      #1, d0
    bclr.l      #0, d0
    move.w      d0, Vid_VI_FinA
    bset.l      #0, d0
    move.w      d0, Vid_VI_FinB

    move.l      Vid_HDB1, d0
    move.w      d0, HDB1
    move.l      Vid_HDB2, d0
    move.w      d0, HDB2
    move.l      Vid_HDE, d0
    move.w      d0, HDE
    move.l      Vid_VDB, d0
    move.w      d0, VDB
    move.l      Vid_VDE, d0
    move.w      d0, VDE

    move.w      #$02C1, VMODE
	
    move.l      Vid_VDB, d0
    lsl.l       #3, d0
    or.l        d0, obj_branch_top + 4
    or.l        d0, obj_buffer + 4
    move.l      Vid_VDE, d0
    lsl.l       #3, d0
    or.l        d0, obj_branch_bottom + 4

    move.l      #Liste_obj, d0
    move.l      #obj_branch_top, a0
    jsr         RelogeObjet
    move.l      #obj_branch_bottom, a0
    jsr         RelogeObjet
    move.l      #obj_buffer, a0
    jsr         RelogeObjet

    move.w      #$FFFF, VI
    move.w      #$0000, INT1
    move.l      #IntVBL, LEVEL0           
    move.w      sr, d0
    and.w       #$F8FF, d0        
    move.w      d0, sr               
    move.w      #(C_VIDENA | C_VIDCLR), INT1
    move.w      Vid_VI_FinA, VI

    movem.l     (sp)+, d0/a0
    rts


IntVBL:               
    movem.l     d0, -(sp)

    move.w      VC, d0
    btst.l      #11, d0
    bne.s       IntVBL_FinB

IntVBL_FinA:
    move.w      Vid_VI_FinB, VI
	move.l		Vid_Buffer, d0
	add.l		#(640 * 1), d0
    bra.s       IntVBL_Fin

IntVBL_FinB:
    move.w      Vid_VI_FinA, VI
	move.l		Vid_Buffer, d0
                          
IntVBL_Fin:
    lsl.l       #8, d0
    and.l       #$7FF, obj_buffer + 0
    or.l        d0, obj_buffer + 0
    and.l       #$FFF00000, obj_buffer + 4
    or.l        #(240 << 14), obj_buffer + 4

    move.l      #Liste_obj, d0
	swap		d0
    move.l      d0, OLP

    move.w      #(C_VIDENA | C_VIDCLR), INT1
    move.w      #0, INT2

    movem.l     (sp)+, d0
    rte




    DATA

.dphrase
Liste_obj:
obj_branch_top:
    dc.l        ((obj_stop - Liste_obj)>>(3+8))
    dc.l        (((obj_stop - Liste_obj)>>(3))<<(24)) | (1<<14) | (0<<3) | (BRANCHOBJ)

.phrase
obj_branch_bottom:
    dc.l        ((obj_stop - Liste_obj)>>(3+8))
    dc.l        (((obj_stop - Liste_obj)>>(3))<<(24)) | (2<<14) | (0<<3) | (BRANCHOBJ)

.dphrase
obj_buffer:
    dc.l        (((obj_stop - Liste_obj)>>(3+8))& %11111111111)
    dc.l        (((obj_stop - Liste_obj)>>(3))<<(24)) | ((0)<<3)
	
    dc.l        ((640*1)/8)>>4          
    dc.l        (((640*1)/8)<<28) | (((640*2)/8)<<18) | (1<<15) | ((3)<<12) | ((0))

.phrase
obj_stop:
	dc.l		0
	dc.l		4

           
    BSS
    .even
Vid_VI_FinA:    ds.w  1
Vid_VI_FinB:    ds.w  1  
        
    .long
Vid_HDB1:       ds.l  1
Vid_HDB2:       ds.l  1
Vid_HDE:        ds.l  1
Vid_VDB:        ds.l  1
Vid_VDE:        ds.l  1
Vid_Buffer:		ds.l  1


    .end

