package environment;

import com.haxepunk.Entity;
import com.haxepunk.HXP;
import com.haxepunk.Scene;
import com.haxepunk.graphics.Stamp;
import com.haxepunk.graphics.Text;
import com.haxepunk.masks.Grid;
import com.haxepunk.utils.Draw;

import display.BendTransform;

import entities.Collectable;

import openfl.geom.Matrix;

import sys.io.File;

class Level extends Entity
{
	static private var typeString:Array<String> = ["block", "collectable", "checkpoint", "enemy"];
	static public var TILE_SIZE:Int = 64;
	private var map:PKTilemap;
	private var hitmap:Grid;
	private var triggers:Array<Trigger>;
	private var data:{width:Int, height:Int, data:Array<Dynamic>};
	
	public function new()
	{
		super();
		
		triggers = new Array<Trigger>();
		type = "level";
	}
	
    public function init(path:String, _scene:Scene)
	{
		data = haxe.Json.parse(File.getContent(path));
		map = new PKTilemap("graphics/tileset.png", data.width * TILE_SIZE, data.height * TILE_SIZE, TILE_SIZE, TILE_SIZE);
		graphic = map;
		hitmap = new Grid(map.width, map.height, TILE_SIZE, TILE_SIZE);
		mask = hitmap;
		x = HXP.halfWidth - map.width / 2;
		reset(0, _scene);
		width = map.width;
		var m = -1.;
		for(d in data.data)
			m = Math.max(m, d.y);
		height = Std.int((m + 1) * TILE_SIZE);
	}
	
	override public function update()
	{
		super.update();
		for(t in triggers)
		{
			t.update(scene);
			if(t.triggered)
				triggers.remove(t);
		}
	}
	
	public function reset(_y:Float, _scene:Scene)
	{
		for(d in cast(data.data, Array<Dynamic>))
		{
			if(d.y * TILE_SIZE >= _y)
			{
				if(d.block == 0)
				{
					map.setTile(d.x, d.y, 0);
					hitmap.setTile(d.x, d.y, true);
				}
				switch(typeString[d.block])
				{
					case "collectable":
						_scene.add(new Collectable(x + d.x * TILE_SIZE, y + d.y * TILE_SIZE));
					case "checkpoint":
						triggers.push(new Trigger(d, MainScene.setCheckpoint));
				}
			}
		}
		for(t in triggers)
			if(t.y > y) t.triggered = false;
	}
	
	private function disp()
	{
		for(i in 0 ... map.columns)
		{
			var s = "";
			for(j in 0 ... map.rows)
			{
				s += Std.string(map.getTile(i, j));
			}
			trace(s);
		}
	}
}
