package environment;

import com.haxepunk.HXP;
import com.haxepunk.Scene;

typedef TCB = Float -> Float -> Dynamic -> Scene -> Void;

// Special block in a tilemap that executes a callback when entering the screen
// Uses Level.TILE_SIZE
class Trigger
{
	public var triggered:Bool;
	private var cb:TCB;
	private var cbdata:Dynamic;
	public var x:Float;
	public var y:Float;
	
    public function new(_cbdata:Dynamic, _cb:TCB)
	{
		cbdata = _cbdata;
		cb = _cb;
		x = (cbdata.x + 0.5) * Level.TILE_SIZE;
		y = (cbdata.y + 0.5) * Level.TILE_SIZE;
		triggered = false;
	}
	
	public function update(scene:Scene)
	{
		if(!triggered && Utils.isVisible(x, y, Level.TILE_SIZE, Level.TILE_SIZE))
		{
			triggered = true;
			cb(x, y, cbdata, scene);
		}
	}
}