import com.haxepunk.Scene;
import com.haxepunk.HXP;
import com.haxepunk.graphics.Stamp;
import com.haxepunk.utils.Draw;

import display.BendTransform;
import display.DiscreteBezier;
import entities.Player;
import environment.Level;

import openfl.geom.Matrix;

class MainScene extends PKScene
{
	static public var LEVEL_SPEED = 12;
	
	private var level:Level;
	private var player:Player;
	static private var checkpoint:{x:Float, y:Float, orientation:Bool, score:Int};
	static public var score:Int;
	static private var camOffX : Float;
	static private var camOffY : Float;
	static private var skipStabilize : Bool;
	static public var alive : Bool;
	static public var resurrect : Bool;
	private var scrollState : Float;
	private var camStartBackY : Float;
	static public var deltaTime : Float;
	
	override public function begin()
	{
		add(level = new Level());
		level.init("levels/bettermap.json", this);
		add(player = new Player(HXP.halfWidth, HXP.halfHeight));
		score = 0;
		camOffX = 0;
		camOffY = 0;
		skipStabilize = false;
		alive = true;
		resurrect = false;
		scrollState = 0;
		checkpoint = {x:HXP.halfWidth, y:HXP.halfHeight, orientation:true, score:0};
		// BendTransform.init(500, [{x:0., y:0.}, {x:0., y:1.}, {x:1., y:1.}, {x:1., y:2.}], level);
		// BendTransform.init(500, [{x:0., y:0.}, {x:0.,y:1.}], level);
		BendTransform.init(500, [{x:0., y:0.}, {x:2.,y:0.},{x:0., y:1.}, {x:1., y:1.}, {x:1., y:2.}], level);
		// HXP.camera.y = -HXP.halfHeight;
	}
	
	override public function update()
	{
		deltaTime = Utils.dt();
		super.update();
		handleShake();
		if (alive)
			HXP.camera.y += LEVEL_SPEED*deltaTime;
		HXP.camera.y += camOffY;
		HXP.camera.x += camOffX;
		HXP.screen.angle = haxe.Timer.stamp();
		
		if(!Utils.isVisible(player.x, player.y, player.width, player.height) || !alive)
			loadCheckpoint();
	}
	
	static public function cameraShake(magX:Float,magY:Float) : Void
	{
		camOffX += magX;
		camOffY += magY;
		skipStabilize = true;
	}
	
	private function handleShake() : Void 
	{
		if (!skipStabilize)
		{
			HXP.camera.x -= camOffX;
			HXP.camera.y -= camOffY;
		}
		
		skipStabilize = false;
		
		if (Math.abs(camOffX) > .2) 
			camOffX *= -.7;
		else
			camOffX = 0;
		
		if (Math.abs(camOffY) > .2) 
			camOffY *= -.7;
		else
			camOffY = 0;
	}
	
	public function loadCheckpoint()
	{
		if (alive) {
			scrollState = 0;
			alive = false;
			camStartBackY = HXP.camera.y;
		}
		
		if (HXP.camera.y > checkpoint.y-HXP.halfHeight && !alive) 
		{ 
			scrollState += .015 * deltaTime;
			var move : Float = camStartBackY-Math.abs(camStartBackY-(checkpoint.y-HXP.height))*Math.sin(scrollState);
			HXP.camera.y = move;
		} 
		else 
		{
			HXP.camera.y = checkpoint.y - HXP.halfHeight;
			player.x = checkpoint.x + (checkpoint.orientation ? 1 : -1) * player.width;
			player.y = checkpoint.y;
			score = checkpoint.score;
			level.reset(checkpoint.y,this);
			alive = true;
		}
	}
	
	static public function setCheckpoint(x:Float, y:Float, d:Dynamic, _:Scene)
	{
		checkpoint.y = y;
		checkpoint.orientation = d.orientation;
		checkpoint.score = score;
	}
}
