import com.haxepunk.HXP;
import com.haxepunk.RenderMode;
import com.haxepunk.Scene;
import com.haxepunk.graphics.atlas.AtlasData;

import display.BendTransform;

import openfl.geom.Matrix;

class PKScene extends Scene
{
	override public function render()
	{
		if (HXP.renderMode == RenderMode.HARDWARE)
			AtlasData.startScene(this);

		// render the entities in order of depth
		for (layer in _layerList)
		{
			if (!layerVisible(layer)) continue;
			for (e in _layers.get(layer))
			{
				if (e.visible) e.render();
				// Have special behaviour for the level Entity
				if(e.type == "level" && HXP.renderMode == RenderMode.HARDWARE)
				{
					AtlasData.active = null;
					Main.bendBuffer.fillRect(Main.bendBuffer.rect, 0);
					Main.bendBuffer.draw(sprite, new Matrix(1, 0, 0, 1, Main.bendBuffer.width / 2 - HXP.halfWidth, Main.bendBuffer.height / 2 - HXP.halfHeight));
					AtlasData.startScene(this);
					BendTransform.apply(this);
				}
			}
		}

		if (HXP.renderMode == RenderMode.HARDWARE)
			AtlasData.active = null; // forces the last active atlas to flush
	}
}