# -*- coding: utf-8 -*-

import numpy as np
import matplotlib.pyplot as plt

def dbezier(a, b, c, d, t):
    return 3 * (b - a) * (1 - t)**2 + 3 * (c - b) * 2 * t * (1 - t) + 3 * (d - c) * t ** 2

def norme(v):
    return np.sqrt(v[0] ** 2 + v[1] ** 2)

X = np.linspace(0, 1, 100)
Y = []
for x in X:
    Y.append(norme(dbezier(np.array([0, 0]), np.array([0, 1]), np.array([1, 1]), np.array([1, 0]), x)))
plt.plot(X, Y)
plt.show()
