package entities;

import com.haxepunk.Entity;
import com.haxepunk.HXP;
import com.haxepunk.graphics.Spritemap;
import com.haxepunk.utils.Draw;
import com.haxepunk.utils.Input;
import com.haxepunk.utils.Key;

class Player extends PKEntity
{
	// Physics vars
	static private var GRAVITY:Float = 1.0;
	static private var SPEED:Float = 8;
	static private var JUMP_SPEED:Float = 60;
	static private var ACCEL:Float = 3.0;
	static private var DECEL:Float = 1.5;
	private var dx:Float;
	private var dy:Float;
	private var grounded:Bool;
	private var direction:Int; // -1 is left, 1 is right
	
	// GP
	private var skidding:Bool;
	private var jumping:Bool;
	private var skidPeriod:Float;
	static private var SKID_TIME:Int = 30;
	static private var SKID_SPEED:Float = .12;
	
	// Other
	private var s:Spritemap;
	private var camOffX : Float;
	private var camOffY : Float;
	
	
    public function new(_x:Float = 0, _y:Float = 0)
    {
        super(_x, _y);
		s = new Spritemap("graphics/player.png", 32, 32);
		img = s;
		graphic = img;
		s.centerOrigin();
		setHitboxTo(s);
		centerOrigin();
		
		dx = 0;
		dy = 0;
		grounded = false;
		direction = 1;
		skidding = false;
		skidPeriod = 0;
		
		s.add("running", [0]);
		s.add("skidding", [1]);
		s.play("running");
    }
	
	private function movement () : Void 
	{
		grounded = false;
		
		if(controller("down"))
			dy = Math.min(dy + ACCEL, SPEED);
		else
			decelDY();
		if(controller("up"))			
			dy = Math.max(dy - ACCEL, -MainScene.LEVEL_SPEED);
		else
			decelDY();
				
		// When skidding
		if (skidPeriod > 0 && skidding) { 
			skidPeriod-=MainScene.deltaTime;
			dy = (skidPeriod*3-SKID_TIME) * SKID_SPEED;
		}
		else 
		{
			skidding = false;
			skidPeriod = 0;
		}
		
		dx += GRAVITY * direction;
		moveBy(dx * MainScene.deltaTime, (dy + MainScene.LEVEL_SPEED) * MainScene.deltaTime, ["level","collectable"], true);
		
		if(grounded) // collision happened this frame
		{
			if(controllerPressed("right"))
			{
				if(direction < 0)
				{
					dx = JUMP_SPEED;
					jumping = true;
					skidding = false;
					//MainScene.cameraShake(-8,0);
				}
				else 
				{
					skidPeriod = skidding ? skidPeriod : SKID_TIME;
					skidding = true;
				}
			}
			if(controllerPressed("left"))
			{
				if(direction > 0)
				{
					dx = -JUMP_SPEED;
					jumping = true;
					skidding = false;
					//MainScene.cameraShake(8,0);
				}
				else 
				{
					skidPeriod = skidding ? skidPeriod : SKID_TIME;
					skidding = true;
				}
			}
		}
		
		if(dx != 0)
			direction = (dx > 0 ? 1 : -1);
		
		s.flipped = direction < 0;
		s.play(skidding ? "skidding" : "running");
	}
	
	override public function update()
	{
		if (MainScene.alive) 
		{
			movement();
		}
	}
	
	private function decelDY()
	{
		if(dy > 0)
			dy = Math.max(dy - DECEL, 0);
		else
			dy = Math.min(dy + DECEL, 0);
	}
	
	override public function moveCollideX(e:Entity) : Bool
	{
		if(e.type == "level")
		{
			dx = 0;
			grounded = true;
			if (jumping)
				MainScene.cameraShake(18*-direction,3);
			jumping = false;
			return true;
		}
		else if(e.type == "collectable")
		{
			var c = cast(e, Collectable);
			c.pickup();
		}
		return false;
	}
	
	override public function moveCollideY(e:Entity) : Bool
	{
		if(e.type == "collectable")
		{
			var c = cast(e, Collectable);
			c.pickup();
		}
		else if(e.type == "breakable")
		{
			// break the thing
		}
		return e.type == "level";
	}
	
	private function controller (butt:String) : Bool 
	{
		switch (butt) {
			case "left":
				return Input.check(Key.LEFT) || Input.check(Key.A);
			case "right":
				return Input.check(Key.RIGHT) || Input.check(Key.D);
			case "up":
				return Input.check(Key.UP) || Input.check(Key.W);
			case "down":
				return Input.check(Key.DOWN) || Input.check(Key.S);
		}
		
		return false;
	}
	
	private function controllerPressed (butt:String) : Bool 
	{
		switch (butt) {
			case "left":
				return Input.pressed(Key.LEFT) || Input.pressed(Key.A);
			case "right":
				return Input.pressed(Key.RIGHT) || Input.pressed(Key.D);
			case "up":
				return Input.pressed(Key.UP) || Input.pressed(Key.W);
			case "down":
				return Input.pressed(Key.DOWN) || Input.pressed(Key.S);
		}
		
		return false;
	}
}