package environment;

import com.haxepunk.HXP;
import com.haxepunk.graphics.Tilemap;

import openfl.geom.Point;

class PKTilemap extends Tilemap
{
	override public function renderAtlas(layer:Int, point:Point, camera:Point)
	{
		// determine drawing location
		_point.x = point.x + x - camera.x * scrollX;
		_point.y = point.y + y - camera.y * scrollY;

		var scalex:Float = HXP.screen.fullScaleX,
			scaley:Float = HXP.screen.fullScaleY,
			tw:Int = Std.int(tileWidth),
			th:Int = Std.int(tileHeight);

		var scx = scale * scaleX,
			scy = scale * scaleY;
		
		// The change here is that we draw to the boundaries of Main.bendBuffer instead if HXP.screen
		// ##############################
		// determine start and end tiles to draw (optimization)
		var startx = Math.floor( ((HXP.width - Main.bendBuffer.width) / 2 -_point.x) / (tw * scx)),
			starty = Math.floor( ((HXP.height - Main.bendBuffer.height) / 2 -_point.y) / (th * scy)),
			destx = startx + 1 + Math.ceil(Main.bendBuffer.width / (tw * scx)),
			desty = starty + 1 + Math.ceil(Main.bendBuffer.height / (th * scy));
		// var startx = 0, starty = 0, destx = _columns, desty = _rows;
		// ##############################

		// nothing will render if we're completely off screen
		if (startx > _columns || starty > _rows || destx < 0 || desty < 0)
			return;

		// clamp values to boundaries
		if (startx < 0) startx = 0;
		if (destx > _columns) destx = _columns;
		if (starty < 0) starty = 0;
		if (desty > _rows) desty = _rows;

		var wx:Float, sx:Float = (_point.x + startx * tw * scx) * scalex,
			wy:Float = (_point.y + starty * th * scy) * scaley,
			stepx:Float = tw * scx * scalex,
			stepy:Float = th * scy * scaley,
			tile:Int = 0;

		for (y in starty...desty)
		{
			wx = sx;
			// ensure no vertical overlap between this and next tile
			scy = (Math.floor(wy+stepy) - Math.floor(wy)) / tileHeight;

			for (x in startx...destx)
			{
				tile = _map[y % _rows][x % _columns];
				if (tile >= 0)
				{
					// ensure no horizontal overlap between this and next tile
					scx = (Math.floor(wx+stepx) - Math.floor(wx)) / tileWidth;

					updateTileRect(tile);
					_atlas.prepareTile(_tile, Math.floor(wx), Math.floor(wy), layer, scx, scy, 0, _red, _green, _blue, alpha, smooth);
				}
				wx += stepx;
			}
			wy += stepy;
		}
	}

}