import com.haxepunk.Entity;
import com.haxepunk.graphics.Image;
import com.haxepunk.utils.Draw;

import display.BendTransform;

// Pass-through class to mark entities that should be bended.
// Every entity that is part of the actual game must extend PKEntity
// This includes tilemaps and enemies but does not include UI elements.
class PKEntity extends Entity
{
	public var img:Image;
	
	override public function render()
	{
		var ox = x, oy = y;
		var f = BendTransform.applyEntity(this);
		x = f.x; y = f.y;
		if(img != null)
			img.angle = f.angle;
		super.render();
		Draw.rect(Std.int(x - 1), Std.int(y - 1), 2, 2, 0xff0000);
		x = ox;
		y = oy;
	}
}