zshell_hook:
	.db $83 ; used by os for hook safety check (add a,e can be used too)
	or a
	jr z,zshell_hook_start  ; we just want to handle prgm, not TI-Basic functions

zshell_hook_return_z:
	xor a
	ret

zshell_hook_start:
	ld hl,(basic_start)	; what's on homescreen
	ld a,(hl)
	cp tprog
	jr nz,zshell_hook_return_z

zshell_hook_continue:
	rst rmov9toop1
	ld hl,op1
	ld (hl),progobj
	bcall(_chkfindsym)
	ex de,hl	; cause of _getbytepaged parameters
	ld a,e_undefined
	bjumpc(_jerror)
	ld a,b	; b = 0 if in ram, else flash page #
	or a
	ld a,e_archived	; temporary
	bjumpnz(_jerror)

zshell_hook_read_data:
	inc hl
	call get_byte
	ld e,a
	call get_byte
	ld d,a	; de now contains the size of the program
	ld (program_size_count),de
	call get_byte
	ret c	; the program is empty
	cp tasmprgm
	ld hl,asm_unsquished_txt
	jr z,zshell_hook_next
	;cp tzshellprgm
	;ld hl,zshell_txt
	;jr z,zshell_hook_next
	ld hl,basic_txt

zshell_hook_next:
	call iputs

zshell_hook_return_nz:
	or $80  ; reset zero flag, the parser can't continue to parse the variable
	ret

asm_unsquished_txt:
	.db "ASM unsquished",0

zshell_txt:
	.db "zSHELL",0

basic_txt:
	.db "TI-Basic (?)",0