#include <SPI.h>
#include <Gamebuino.h>
#include "ascii_table.h"

extern const byte PROGMEM ascii_width_table[];
extern const byte PROGMEM ascii_table[];

extern const byte font3x5[];

Gamebuino gb;

void setup(){
  gb.begin();

  gb.display.setFont(font3x5);

  byte char_ = 0;
  while(1){
    if(gb.update()){
      char_ += -gb.buttons.repeat(BTN_LEFT, 1)+gb.buttons.repeat(BTN_RIGHT, 1);
      draw_char(0, 0, char_);
    }
  }
}

void loop(){
}

void draw_char(int x, int y, byte char_num){
  byte width;
  int i = 0, char_offset = 0, width_offset = char_num;
  do{
    width = pgm_read_byte(ascii_width_table+i*2+1);
    char_offset += CHAR_HEIGHT*width*pgm_read_byte(ascii_width_table+i*2);
    width_offset -= pgm_read_byte(ascii_width_table+i*2);
    i++;
  }while(width_offset >= 0);
  char_offset += CHAR_HEIGHT*width*width_offset;
  for(i = char_offset; i < char_offset+CHAR_HEIGHT*width; i++){
    if(pgm_read_byte(ascii_table+i/8)&(B10000000>>(i%8))){
      gb.display.drawPixel(x+i%width,y+(i-char_offset)/width);
    }
  }


  gb.display.cursorX = 10;
  gb.display.cursorY = 0;
  gb.display.print(char_num);
  gb.display.cursorX = 30;
  gb.display.cursorY = 0;
  gb.display.print(width);

}
