﻿#LINE_LENGTH = 20
CompilerIf #PB_Compiler_OS = #PB_OS_Windows
  #Path_separator = "\"
CompilerElse
  #Path_separator = "/"
CompilerEndIf

EnableExplicit

If OpenConsole() = 0
  MessageRequester("OpenConsole() error","Unable to open the console.",0)
  End
EndIf

Define i.l
Global str1$
For i = 1 To 25
  str1$ = str1$ + Chr(205)
Next
ConsoleTitle ("Chars converter")
EnableGraphicalConsole(1)
PrintN(Chr(201)+str1$+Chr(187))
PrintN(Chr(186)+" Chars converter - deeph "+Chr(186))
PrintN(Chr(200)+str1$+Chr(188))
PrintN("")

If CreateFile(0, "ascii_table.h")
  Define *buffer = AllocateMemory(1024)
  If ExamineDirectory(0, GetCurrentDirectory()+"char"+#Path_separator, "*.bmp")
    Define buffer_index.l = 0, i.l = 0, bin.s = "%", width_index.l = 0, width_rle_length.b = 0, width.b
    While NextDirectoryEntry(0)
      If LoadImage(0, GetCurrentDirectory()+"char"+#Path_separator+DirectoryEntryName(0))
        If StartDrawing(ImageOutput(0))
          If Not buffer_index
            WriteStringN(0, "#define CHAR_HEIGHT "+Str(ImageHeight(0)))
            WriteStringN(0, "")
            WriteStringN(0, "const byte PROGMEM ascii_width_table[]={")
            WriteString(0, "  ")
            width = ImageWidth(0)
          EndIf
          Define y.l, x.l
          For y = 0 To ImageHeight(0)-1
            For x = 0 To ImageWidth(0)-1
              bin+Str(Bool(Not Point(x, y)))
              If i = 7
                PokeB(*buffer+buffer_index, Val(bin))
                bin = "%"
                buffer_index+1
              EndIf
              i+1
              i*Bool(i<8)
            Next x
          Next y
          If ImageWidth(0) <> width Or width_rle_length = 255
            width_index+1
            If Not width_index%(#LINE_LENGTH/2)
              WriteString(0, ",")
              WriteStringN(0, "0x"+LCase(RSet(Hex(width_rle_length), 2, "0"))+",0x"+LCase(RSet(Hex(width), 2, "0"))+",")
              WriteString(0, "  ")
            Else
              If (width_index-1)%(#LINE_LENGTH/2)
                WriteString(0, ",")
              EndIf
              WriteString(0, "0x"+LCase(RSet(Hex(width_rle_length), 2, "0"))+",0x"+LCase(RSet(Hex(width), 2, "0")))
            EndIf
            width_rle_length = 0
            width = ImageWidth(0)
          EndIf
          width_rle_length+1
          StopDrawing()
        EndIf
      EndIf
    Wend
    WriteStringN(0, " };")
    WriteStringN(0, "")
    ReAllocateMemory(*buffer, buffer_index)
    WriteStringN(0, "const byte PROGMEM ascii_table[]={")
    WriteString(0, "  ")
    For i = 1 To MemorySize(*buffer)+1
      buffer_index = PeekB(*buffer+i-1)
      buffer_index+256*Bool(Not buffer_index > 0)
      WriteString(0, "0x"+LCase(RSet(Hex(buffer_index), 2, "0")))
      If i <> MemorySize(*buffer)+1
        If Not i%#LINE_LENGTH
          WriteStringN(0, ",")
          WriteString(0, "  ")
        Else
          WriteString(0, ",")
        EndIf
      EndIf
    Next
    WriteStringN(0, " };")
    FinishDirectory(0)
    PrintN("ascii_table.h correctly generated.")
    Input()
  Else
    PrintN("Error : unable open the char folder.")
    Input()
  EndIf
  CloseFile(0)
Else
  PrintN("Error : unable to create the output file.")
  Input()
EndIf
End
; IDE Options = PureBasic 5.30 (Windows - x86)
; CursorPosition = 68
; FirstLine = 33
; EnableXP
; Executable = converter.exe
; CompileSourceDirectory