<?php

define ('DIRECTORY',	'data');

function	getError ($code)
{
	switch ($code)
	{
		case '500':
			return 'server failure, file may be too big (errno 500)';

		case 'io':
			return 'could not send data, file too big or time limit exceeded';

		case 'security':
			return 'security exception';

		default:
			return 'unknown failure';
	}
}

if (isset ($_POST['id']) && is_numeric ($_POST['id']))
{
	$id = $_POST['id'];

	if (isset ($_POST['error']) && $_POST['error'])
		$msg = 'Upload error: ' . getError ($_POST['error']);
	else if (!file_exists (DIRECTORY . '/' . $id . '.file') ||
	         !file_exists (DIRECTORY . '/' . $id . '.name') ||
	         !($name = file_get_contents (DIRECTORY . '/' . $id . '.name')))
		$msg = 'Upload error: could not read uploaded file';
	else
	{
		@unlink (DIRECTORY . '/' . $id . '.name');
		@rename (DIRECTORY . '/' . $id . '.file', DIRECTORY . '/' . $name) or unlink (DIRECTORY . '/' . $id . '.file');

		$msg = 'File uploaded: <a href="' . urlencode (DIRECTORY . '/' . $name) . '">' . htmlentities ($name) . '</a>';
	}
}
else
	$msg = 'No file selected';

$id = mt_rand (100000, 999999);

?>

<html>
	<head>
		<title>Upload</title>
		<script language="JavaScript">
		<!--
			function	uploadStatus (type, file)
			{
				var	item = document.getElementById ('label');

				if (type == 'select')
					item.innerHTML = '&bull; File selected: ' + file;
				else if (type == 'start')
					item.innerHTML = '&bull; Uploading...';
			}

			function	uploadSubmit (error)
			{
				if (error != null)
					document.getElementById ('error').value = error;

				document.getElementById ('upload').submit ();
			}
		-->
		</script>
	</head>
	<body style="background-color: #CCDBEA;">
		<p id="label" style="font-family:verdana; font-size:10px;">&bull; <?php echo $msg; ?></p>
		<form action="" id="upload" method="post">
			<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,29,0" width="320" height="24">
				<param name="movie" value="upload.swf?id=<?php echo $id; ?>&url=upload.php&tb=Browse&tu=Upload" />
				<param name="quality" value="high" />
				<embed src="upload.swf?id=<?php echo $id; ?>&url=upload.php&tb=Browse&tu=Upload" quality="high" pluginspage="http://www.macromedia.com/go/getflashplayer" type="application/x-shockwave-flash" width="320" height="24"></embed>
			</object>
			<input id="error" name="error" type="hidden" />
			<input name="id" type="hidden" value="<?php echo $id; ?>" />
		</form>
	</body>
</html>
