// C Source File
// Created 29.06.2008; 14:42:32

#include "standart.h"
#include "fileio.h"
#include "game.h"

Clock clock;

void ResetClock() {
	clock.running = clock.counter = clock.seconds = clock.minutes = 0;
	clock.updated = 1;
}

inline void StartClock() {
	clock.running = 1;
}

/*
const unsigned char _player[] = { 0x60, 0xF0, 0xF0, 0x60};
const unsigned char _lsd[]    = { 0x78, 0x94, 0x94, 0xA4, 0xA4, 0x78};
const unsigned char _cop[]  = { 0xB4, 0x78, 0xCC, 0xCC, 0x78, 0xB4};
*/

const unsigned char _player[] = {
	0b01100000,
	0b11110000,
	0b11110000,
	0b01100000,
};
const unsigned char _lsd[] = {
	0b01111000,
	0b10010100,
	0b10010100,
	0b10100100,
	0b10100100,
	0b01111000,
};
const unsigned char _cop[] = {
	0b10110100,
	0b01111000,
	0b11001100,
	0b11001100,
	0b01111000,
	0b10110100,
};


const Sprite playerSprite = {_player, 4, 4};
const Sprite lsdSprite    = {_lsd,    6, 6};
const Sprite copSprite  = {_cop,  6, 6};

Player player;

Lsd lsd;

Cop cops[MAX_COPS];

Spike spikes[MAX_SPIKES];
unsigned short spikeNr;

GameState gameState;



/*inline unsigned char RectCollideWithPoint(Axis x0, Axis y0, unsigned char w0, unsigned char h0, Axis x1, Axis y1) {
	return (x1 >= x0 && x1 < x0 + w0 && y1 >= y0 && y1 < y0 + h0);
}

inline unsigned char RectCollideWithRect(Axis x0, Axis y0, unsigned char w0, unsigned char h0, Axis x1, Axis y1, unsigned char w1, unsigned char h1) {
	return (x0 < x1 + w1 && x1 < x0 + w0 && y0 < y1 + h1 && y1 < y0 + h0);
}*/

inline unsigned char RectCollideWithPoint(Position p0, unsigned char w0, unsigned char h0, Position p1) {
	return (p1.x >= p0.x && p1.x < p0.x + w0 && p1.y >= p0.y && p1.y < p0.y + h0);
}

inline unsigned char RectCollideWithRect(Position p0, unsigned char w0, unsigned char h0, Position p1, unsigned char w1, unsigned char h1) {
	return (p0.x < p1.x + w1 && p1.x < p0.x + w0 && p0.y < p1.y + h1 && p1.y < p0.y + h0);
}

typedef struct {
	Axis x0, y0, x1, y1;
} Field;

//	the outer bounds of the field area
Field field = {1,1,LCD_WIDTH-2,LCD_HEIGHT-2-8};

Position Spike_PositionAtStep(const Spike *spike, unsigned char step) {
	//Spike w;
	Position pos = spike->pos;
	char vx = spike->vx, vy = spike->vy;
	unsigned char i;
	for(i = 0; i < step; ++i) {
		/*if(pos.x + vx < field.x0) {
			vx = -vx;
		} else if(pos.x + vx > field.x1) {
			vx = -vx;
		}*/
		if(pos.x + vx < field.x0 || pos.x + vx > field.x1) {
			vx = -vx;
		}
		if(pos.y + vy < field.y0 || pos.y + vy > field.y1) {
			vy = -vy;
		}
		
		pos.x += /*spike->*/vx;
		pos.y += /*spike->*/vy;
		/*if(!RectCollideWithPoint((Position){field.x0, field.y0}, field.x1 - field.x0, field.y1 - field.y0, (Position){pos.x, pos.y})) {
			
		}*/
		/*if(pos.x < field.x0) {
			pos.x -= vx;
			vx = -vx;
		}*/
	}
	return pos;
}

void HandleSpikes() {
	Position pos;
	unsigned /*char*/short i;
	for(i = 0; i < /*MAX_SPIKES*/spikeNr; ++i) {
		if(spikes[i].active) {
			if(spikes[i].pos.x + spikes[i].vx < field.x0 || spikes[i].pos.x + spikes[i].vx > field.x1) {
				spikes[i].vx = -spikes[i].vx;
			}
			if(spikes[i].pos.y + spikes[i].vy < field.y0 || spikes[i].pos.y + spikes[i].vy > field.y1) {
				spikes[i].vy = -spikes[i].vy;
			}
			spikes[i].pos.x += spikes[i].vx;
			spikes[i].pos.y += spikes[i].vy;
			//spikes[i].pos = Spike_PositionAtStep(&spikes[i], 1);
			unsigned char step;
			for(step = 0; step < spikes[i].length; ++step) {
				pos = Spike_PositionAtStep(&spikes[i], step);
				EXT_SETPIX(ScreenBuffer, pos.x, pos.y);
				
				//	check for collision every 4 steps
				if(!(step & (4 - 1))) {
					if(RectCollideWithPoint(player.pos, playerSprite.width, playerSprite.height, pos)) {
						gameState = GAME_STATE_LOST;
					}
				}
			}
		}
	}
}

void NewSpike() {
	unsigned /*char*/short i;
	/*for(i = 0; spikes[i].active; ++i);
	//	no more space
	if(i == MAX_SPIKES) {
		return;
	}*/
	i = spikeNr++;
	spikes[i].active = 1;
	do {
		spikes[i].pos.x = random(field.x1 - field.x0) + field.x0;
		spikes[i].pos.y = random(field.y1 - field.y0) + field.y0;
	} while(RectCollideWithPoint((Position){player.pos.x - SPIKE_PLAYER_MIN_DIST, player.pos.y - SPIKE_PLAYER_MIN_DIST},
		 SPIKE_PLAYER_MIN_DIST << 1, SPIKE_PLAYER_MIN_DIST << 1, spikes[i].pos));
	if(prefs.spikeMovement == SPIKE_MOVEMENT_HORZ_AND_VERT) {
		(random(2) ? spikes[i].vx : spikes[i].vy) = (random(2) ? 1 : -1);
	} else {	//SPIKE_MOVEMENT_ALL_DIRECTIONS
		do {
			spikes[i].vx = random(3) - 1;
			spikes[i].vy = random(3) - 1;
		} while(!spikes[i].vx && !spikes[i].vy);
	}
	//spikes[i].length = SPIKE_MIN_LENGTH + random(SPIKE_MAX_LENGTH - SPIKE_MIN_LENGTH + 1);
	spikes[i].length = prefs.spikeMinLength + random(prefs.spikeMaxLength - prefs.spikeMinLength + 1);
}

void HandlePlayer() {
	unsigned char left;
	unsigned char right;
	unsigned char up;
	unsigned char down;
	BEGIN_KEYTEST
		left  = _keytest_optimized(RR_LEFT);
		right = _keytest_optimized(RR_RIGHT);
		up    = _keytest_optimized(RR_UP);
		down  = _keytest_optimized(RR_DOWN);
		if(_keytest_optimized(RR_HAND)) {
			WaitKeyReleased();
			unsigned char i, collide;
			do {
				player.pos.x = random(field.x1 - field.x0 + 1 - playerSprite.width) + field.x0;
				player.pos.y = random(field.y1 - field.y0 + 1 - playerSprite.height) + field.y0;
				collide = 0;
				for(i = 0; i < prefs.copNr; ++i) {
					/*if((collide = RectCollideWithRect((Position){cops[i].pos.x - COP_PLAYER_MIN_DIST, cops[i].pos.y - COP_PLAYER_MIN_DIST},
				 		COP_PLAYER_MIN_DIST << 1, COP_PLAYER_MIN_DIST << 1, player.pos, playerSprite.width, playerSprite.height))) {*/
					if((collide = RectCollideWithRect(cops[i].pos, copSprite.width, copSprite.height, player.pos, playerSprite.width, playerSprite.height))) {
						break;
					}
				}
			} while(collide);
		}
	END_KEYTEST
	if(left ^ right) {
		if(left) {
			player.pos.x--;
		} else {
			player.pos.x++;
		}
	}
	if(up ^ down) {
		if(up) {
			player.pos.y--;
		} else {
			player.pos.y++;
		}
	}
	if(player.pos.x < field.x0) {
		player.pos.x = field.x0;
	} else if(player.pos.x + playerSprite.width > field.x1 + 1) {
		player.pos.x = field.x1 + 1 - playerSprite.width;
	}
	if(player.pos.y < field.y0) {
		player.pos.y = field.y0;
	} else if(player.pos.y + playerSprite.height > field.y1 + 1) {
		player.pos.y = field.y1 + 1 - playerSprite.height;
	}
	Sprite8_XOR_R(player.pos.x, player.pos.y, playerSprite.height, playerSprite.data, ScreenBuffer);
}

void PlaceLsd() {
	do {
		lsd.pos.x = random(field.x1 - field.x0 + 1 - lsdSprite.width) + field.x0;
		lsd.pos.y = random(field.y1 - field.y0 + 1 - lsdSprite.height) + field.y0;
	} while(RectCollideWithRect((Position){player.pos.x - LSD_PLAYER_MIN_DIST, player.pos.y - LSD_PLAYER_MIN_DIST},
		 LSD_PLAYER_MIN_DIST << 1, LSD_PLAYER_MIN_DIST << 1, lsd.pos, lsdSprite.width, lsdSprite.height));
}

void HandleLsd() {
	if(RectCollideWithRect(player.pos, playerSprite.width, playerSprite.height, lsd.pos, lsdSprite.width, lsdSprite.height)) {
		/*
		PlaceLsd();
		++player.lsdNr;
		unsigned char i;
		for(i = 0; i < DIFFICULTY; ++i) {
			NewSpike();
		}
		*/
		gameState = GAME_STATE_NEXT_LEVEL;
	}
	Sprite8_XOR_R(lsd.pos.x, lsd.pos.y, lsdSprite.height, lsdSprite.data, ScreenBuffer);
}

void HandleCops() {
	unsigned char i;
	for(i = 0; i < prefs.copNr; ++i) {
		if(!cops[i].moveWaitCounter--) {
			//cops[i].moveWaitCounter = COP_MOVE_WAIT;
			cops[i].moveWaitCounter = prefs.copMoveWait;
			if(player.pos.x + (playerSprite.width >> 1) > cops[i].pos.x + (copSprite.width >> 1)) {
				++cops[i].pos.x;
			} else if(player.pos.x + (playerSprite.width >> 1) < cops[i].pos.x + (copSprite.width >> 1)) {
				--cops[i].pos.x;
			}
			if(player.pos.y + (playerSprite.height >> 1) > cops[i].pos.y + (copSprite.height >> 1)) {
				++cops[i].pos.y;
			} else if(player.pos.y + (playerSprite.height >> 1) < cops[i].pos.y + (copSprite.height >> 1)) {
				--cops[i].pos.y;
			}
			
			//	randomize a bit ;)
			/*if(!random(COP_RANDOM_STEP)) {
				++cops[i].pos.x;
			} else {
				--cops[i].pos.x;
			}
			if(!random(COP_RANDOM_STEP)) {
				++cops[i].pos.y;
			} else {
				--cops[i].pos.y;
			}*/
			if(!random(COP_RANDOM_STEP)) {
				if(!random(2)) {
					if(!random(2)) {
						++cops[i].pos.x;
					} else {
						--cops[i].pos.x;
					}
				} else {
					if(!random(2)) {
						++cops[i].pos.y;
					} else {
						--cops[i].pos.y;
					}
				}
			}
			
			//	we need to test against field boundaries
			//	because of hte randomization and the different sprite sizes (cop and player)
			if(cops[i].pos.x < field.x0) {
				cops[i].pos.x = field.x0;
			} else if(cops[i].pos.x + copSprite.width > field.x1 + 1) {
				cops[i].pos.x = field.x1 + 1 - copSprite.width;
			}
			if(cops[i].pos.y < field.y0) {
				cops[i].pos.y = field.y0;
			} else if(cops[i].pos.y + copSprite.height > field.y1 + 1) {
				cops[i].pos.y = field.y1 + 1 - copSprite.height;
			}
		}
		if(RectCollideWithRect(player.pos, playerSprite.width, playerSprite.height, cops[i].pos, copSprite.width, copSprite.height)) {
			gameState = GAME_STATE_LOST;
		}
		Sprite8_OR_R(cops[i].pos.x, cops[i].pos.y, copSprite.height, copSprite.data, ScreenBuffer);
	}
}

void ResetGameState() {
	player.pos.x = (LCD_WIDTH - playerSprite.width) >> 1;
	player.pos.y = (LCD_HEIGHT - playerSprite.height) >> 1;
	player.lsdNr = 0;
	
	unsigned char i;
	for(i = 0; i < prefs.copNr; ++i) {
		//cops[i].pos.x = 0;
		//cops[i].pos.y = 0;
		do {
			cops[i].pos.x = random(field.x1 - field.x0 + 1 - copSprite.width) + field.x0;
			cops[i].pos.y = random(field.y1 - field.y0 + 1 - copSprite.height) + field.y0;
		} while(RectCollideWithRect((Position){player.pos.x - COP_PLAYER_MIN_DIST, player.pos.y - COP_PLAYER_MIN_DIST},
			 COP_PLAYER_MIN_DIST << 1, COP_PLAYER_MIN_DIST << 1, cops[i].pos, copSprite.width, copSprite.height));
		cops[i].moveWaitCounter = 0;
	}
	
	memset(spikes, 0, MAX_SPIKES * sizeof(*spikes));
	spikeNr = 0;
	
	ResetClock();
	//clock.running = 1;
	StartClock();
	
	gameState = GAME_STATE_RUNNING;
}

void Game() {
	saveAutoInts(&saveInt1, &saveInt5);
	static char lsdNrStr[] = "Collected Lsds:    ";
	static char timeStr[] = "Time: 00:00";
	
	/*
	player.pos.x = (LCD_WIDTH - playerSprite.width) >> 1;
	player.pos.y = (LCD_HEIGHT - playerSprite.height) >> 1;
	player.lsdNr = 0;
	cop.pos.x = 0;
	cop.pos.y = 0;
	cop.moveWaitCounter = 0;
	memset(spikes, 0, MAX_SPIKES * sizeof(*spikes));
	gameState = GAME_STATE_RUNNING;
	*/
	unsigned char i;
	ResetGameState();
	while(gameState == GAME_STATE_RUNNING) {
		/*memset(spikes, 0, MAX_SPIKES * sizeof(*spikes));
		PlaceLsd();*/
		PlaceLsd();
		for(i = 0; i < /*DIFFICULTY*/prefs.spikeFactor; ++i) {
			NewSpike();
		}
		while(gameState == GAME_STATE_RUNNING) {
			if(_keytest(RR_MINUS)) {
				OSContrastDn();
			} 
			if(_keytest(RR_PLUS)) {
				OSContrastUp();
			}
			
			HandleTeacherKeys();
			
			if(_keytest(RR_ESC) || Error == FAST_QUIT) {
				gameState = GAME_STATE_ABORTED;
			}
			
			if(_keytest(RR_APPS)) {
				DrawStr((LCD_WIDTH - DrawStrWidth("Pause", F_8x10)) >> 1, (LCD_HEIGHT - 10) >> 1, "Pause", A_XOR);
				WaitKeyReleased();
				while(!_keytest(RR_APPS));
				while(_keytest(RR_APPS));
			}
			
			//	draw everything...
			
			FastClearScreen_R(ScreenBuffer);
			//FastOutlineRect_R(ScreenBuffer,0,0,LCD_WIDTH-1,LCD_HEIGHT-1,A_OR);
			FastOutlineRect_R(ScreenBuffer,field.x0-1,field.y0-1,field.x1+1,field.y1+1,A_OR);
			
			HandleSpikes();
			
			HandlePlayer();
			
			HandleLsd();
			
			HandleCops();
			
			itoa_ushort_10(lsdNrStr + 16, player.lsdNr);
			FS_DrawString(0, LCD_HEIGHT - 8 + 1, lsdNrStr, ScreenBuffer, F_6x8);
			
			if(clock.updated) {
				clock.updated = 0;
				itoa_ushort_10_extended(timeStr + 6, (unsigned short)clock.minutes, 2, 1);
				timeStr[8] = ':';
				//itoa_ushort_10(timeStr + 9, (unsigned short)clock.seconds);
				itoa_ushort_10_extended(timeStr + 9, (unsigned short)clock.seconds, 2, 1);
			}
			FS_DrawString(/*DrawStrWidth(lsdNrStr, F_6x8) + 30*/LCD_WIDTH - DrawStrWidth(timeStr, F_6x8),
				 LCD_HEIGHT - 8 + 1, timeStr, ScreenBuffer, F_6x8);
			
			Display();
			
			SlowDown(/*500*/prefs.gameDelay);
			
			/*
			#ifdef DEBUG
				SlowDown(100);
			#endif
			*/
		}
		if(gameState == GAME_STATE_NEXT_LEVEL) {
			++player.lsdNr;
			//WaitKey();
			gameState = GAME_STATE_RUNNING;
		} else if(gameState == GAME_STATE_LOST) {
			FastFilledRect_Draw_R(LCD_MEM,
				(LCD_WIDTH - DrawStrWidth("Game Over!", F_8x10) - 10) >> 1,
				(LCD_HEIGHT - 10 - 10) >> 1,
				((LCD_WIDTH - DrawStrWidth("Game Over!", F_8x10) - 10) >> 1) + DrawStrWidth("Game Over!", F_8x10) + 10 - 1,
				((LCD_HEIGHT - 10 - 10) >> 1) + 10 + 10 - 1);
			FontSetSys(F_8x10);
			DrawStr((LCD_WIDTH - DrawStrWidth("Game Over!", F_8x10)) >> 1, (LCD_HEIGHT - 10) >> 1, "Game Over!", A_XOR);
			/*
			unsigned char x = (LCD_WIDTH - DrawStrWidth("Game Over!", F_8x10)) >> 1;
			unsigned char y = (LCD_HEIGHT - 10) >> 1;
			FastFilledRect_Draw_R(LCD_MEM,
				x - 5,
				y - 5,
				x + DrawStrWidth("Game Over!", F_8x10) + 5 - 1,
				y + 10 + 5 - 1);
			FontSetSys(F_8x10);
			DrawStr(x, y, "Game Over!", A_XOR);
			*/
			FastInvertRect240_R(LCD_MEM,0,LCD_HEIGHT);
			SlowDown(10000);
			FastInvertRect240_R(LCD_MEM,0,LCD_HEIGHT);
			SlowDown(10000);
			FastInvertRect240_R(LCD_MEM,0,LCD_HEIGHT);
			WaitKey();
			
			if(player.lsdNr <= hiscores[MAX_HISCORES-1].score) {
				ResetGameState();
			}
		}
	}
	WaitKeyReleased();
	restoreAutoInts(saveInt1, saveInt5);
	
	//	get new hiscore
	if(player.lsdNr > hiscores[MAX_HISCORES-1].score) {
		//	clear screen
		FastClearScreen_R(LCD_MEM);
		
		//search rank
		for(i = 0; i < MAX_HISCORES; ++i) {
			if(player.lsdNr > hiscores[i].score) {
				break;
			}
		}
		
		//shift the table part below the ranking down 
		unsigned char j;
		for(j = MAX_HISCORES - 1; j > i; --j) {
			hiscores[j].score = hiscores[j-1].score;
			strncpy(hiscores[j].name, hiscores[j-1].name, MAX_NAME_LENGTH);
		}
		
		hiscores[i].score = player.lsdNr;
		//GetUserName(hiscores[i].name);
		
		HANDLE dlg;
		if((dlg = DialogNewSimple(140,40)) == H_NULL) {
			Error = ERR_MEM;
			return;
		}
		DialogAddTitle(dlg,"New Hiscore!",BT_OK,BT_NONE);
		DialogAddRequest(dlg,5,15,"Your Name:",0,MAX_NAME_LENGTH,11);
		do {
			hiscores[i].name[0] = '\0';
		} while(DialogDo(dlg,CENTER,CENTER,hiscores[i].name,NULL) != KEY_ENTER);
		HeapFree(dlg);
		
		Highscores();
	}
}