// C Source File
// Created 29.06.2008; 14:41:38

#include "standart.h"

void Off(void) {
	off();
	pokeIO(0x600003,255);
}

void SlowDown(unsigned short delay) {
	unsigned short temp;
	while(delay) {
		--delay;
		//pokeIO(0x600005,0b11111);
		temp = random(delay);
		//HandleTeacherKeys();
	}
}

unsigned char IsKeyPressed() {
	return !!_rowread(0);
}

void WaitKeyReleased() {
	while(IsKeyPressed());
}

void WaitKey(void) {
	//WaitKeyReleased();
	while(!IsKeyPressed());
	WaitKeyReleased();
}

void HandleTeacherKeys(void) {
	if(_keytest(RR_CLEAR)) {
		if(_keytest(RR_2ND)) {
			Off();
		} else if(_keytest(RR_DIAMOND)) {
			Error = FAST_QUIT;
		}	else {
			FastCopyScreen_R(LcdBuffer, LCD_MEM);
			//	erase busy indicator :)
			FastFillRect_R(LCD_MEM,LCD_WIDTH-20,LCD_HEIGHT-6,LCD_WIDTH-1,LCD_HEIGHT-1,COLOR_WHITE);
			//	erase the command line ( -> 'program()' not visible if it's started this way)
			FastFillRect_R(LCD_MEM,0,LCD_HEIGHT-6-2-10,LCD_WIDTH-1,LCD_HEIGHT-6-2,COLOR_WHITE);
			while(_keytest(RR_CLEAR));
			while(!_keytest(RR_CLEAR) && Error == ERR_NONE) {
				if(_keytest(RR_2ND)) Off();
				if(_keytest(RR_DIAMOND)) {
					Error = FAST_QUIT;
				}
			}
			while(_keytest(RR_CLEAR));
		}
	}
	#ifdef DEBUG
		else if(_keytest(RR_Q)) {
			while(_rowread(0));
			while(!_rowread(0));
	}
	#endif
}

inline void Display(void) {
	FastCopyScreen_R(ScreenBuffer, LCD_MEM);
}